/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.CommonException;
import com.glavsoft.exceptions.ProtocolException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.ClipboardController;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.client.FramebufferUpdateRequestMessage;
import com.glavsoft.rfb.client.SetPixelFormatMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.DecodersContainer;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.RichCursorDecoder;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Reader;
import com.glavsoft.viewer.Viewer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class ReceiverTask
implements Runnable {
    private static final byte FRAMEBUFFER_UPDATE = 0;
    private static final byte SET_COLOR_MAP_ENTRIES = 1;
    private static final byte BELL = 2;
    private static final byte SERVER_CUT_TEXT = 3;
    private static Logger logger = Logger.getLogger("com.glavsoft.rfb.protocol.ReceiverTask");
    private final Reader reader;
    private volatile boolean isRunning = false;
    private Renderer renderer;
    private final IRepaintController repaintController;
    private final ClipboardController clipboardController;
    private final DecodersContainer decoders;
    private FramebufferUpdateRequestMessage fullscreenFbUpdateIncrementalRequest;
    private final ProtocolContext context;
    private PixelFormat pixelFormat;
    private boolean needSendPixelFormat;
    private static long lastUpdateSent = System.currentTimeMillis();
    private static long delayBetweenUpdates = 500L;
    private static Timer timer = new Timer();

    public ReceiverTask(Reader reader, IRepaintController repaintController, ClipboardController clipboardController, DecodersContainer decoders, ProtocolContext context) {
        this.reader = reader;
        this.repaintController = repaintController;
        this.clipboardController = clipboardController;
        this.context = context;
        this.decoders = decoders;
        this.renderer = repaintController.createRenderer(reader, context.getFbWidth(), context.getFbHeight(), context.getPixelFormat());
        this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(0, 0, context.getFbWidth(), context.getFbHeight(), true);
    }

    @Override
    public void run() {
        this.isRunning = true;
        block11: while (this.isRunning) {
            try {
                byte messageId = this.reader.readByte();
                switch (messageId) {
                    case 0: {
                        this.framebufferUpdateMessage();
                        continue block11;
                    }
                    case 1: {
                        logger.severe("Server message SetColorMapEntries is not implemented. Skip.");
                        this.setColorMapEntries();
                        continue block11;
                    }
                    case 2: {
                        logger.fine("Server message: Bell");
                        System.out.print("\u00007");
                        System.out.flush();
                        continue block11;
                    }
                    case 3: {
                        logger.fine("Server message: CutText (3)");
                        this.serverCutText();
                        continue block11;
                    }
                }
                logger.severe("Unsupported server message. Id = " + messageId);
            }
            catch (TransportException e) {
                logger.severe("Close session: " + e.getMessage());
                if (this.isRunning) {
                    this.context.cleanUpSession("Connection closed.");
                }
                this.stopTask();
            }
            catch (ProtocolException e) {
                logger.severe(e.getMessage());
                if (this.isRunning) {
                    this.context.cleanUpSession(e.getMessage() + "\nConnection closed.");
                }
                this.stopTask();
            }
            catch (CommonException e) {
                logger.severe(e.getMessage());
                if (this.isRunning) {
                    this.context.cleanUpSession("Connection closed.");
                }
                this.stopTask();
            }
            catch (Throwable te) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                te.printStackTrace(pw);
                if (this.isRunning) {
                    this.context.cleanUpSession(te.getMessage() + "\n" + sw.toString());
                }
                this.stopTask();
            }
        }
    }

    private void setColorMapEntries() throws TransportException {
        this.reader.readByte();
        this.reader.readUInt16();
        int length = this.reader.readUInt16();
        while (length-- > 0) {
            this.reader.readUInt16();
            this.reader.readUInt16();
            this.reader.readUInt16();
        }
    }

    private void serverCutText() throws TransportException {
        this.reader.readByte();
        this.reader.readInt16();
        int length = this.reader.readInt32() & Integer.MAX_VALUE;
        this.clipboardController.updateSystemClipboard(this.reader.readBytes(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void framebufferUpdateMessage() throws CommonException {
        Object rect;
        this.reader.readByte();
        int numberOfRectangles = this.reader.readUInt16();
        while (numberOfRectangles-- > 0) {
            rect = new FramebufferUpdateRectangle();
            ((FramebufferUpdateRectangle)rect).fill(this.reader);
            Decoder decoder = this.decoders.getDecoderByType(((FramebufferUpdateRectangle)rect).getEncodingType());
            logger.finest(((FramebufferUpdateRectangle)rect).toString() + (0 == numberOfRectangles ? "\n---" : ""));
            if (decoder != null) {
                decoder.decode(this.reader, this.renderer, (FramebufferUpdateRectangle)rect);
                this.repaintController.repaintBitmap((FramebufferUpdateRectangle)rect);
                continue;
            }
            if (((FramebufferUpdateRectangle)rect).getEncodingType() == EncodingType.RICH_CURSOR) {
                RichCursorDecoder.getInstance().decode(this.reader, this.renderer, (FramebufferUpdateRectangle)rect);
                this.repaintController.repaintCursor();
                continue;
            }
            if (((FramebufferUpdateRectangle)rect).getEncodingType() == EncodingType.CURSOR_POS) {
                this.renderer.decodeCursorPosition((FramebufferUpdateRectangle)rect);
                this.repaintController.repaintCursor();
                continue;
            }
            if (((FramebufferUpdateRectangle)rect).getEncodingType() == EncodingType.DESKTOP_SIZE) {
                this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(0, 0, ((FramebufferUpdateRectangle)rect).width, ((FramebufferUpdateRectangle)rect).height, true);
                Renderer renderer = this.renderer;
                synchronized (renderer) {
                    this.renderer = this.repaintController.createRenderer(this.reader, ((FramebufferUpdateRectangle)rect).width, ((FramebufferUpdateRectangle)rect).height, this.context.getPixelFormat());
                }
                this.context.sendMessage(new FramebufferUpdateRequestMessage(0, 0, ((FramebufferUpdateRectangle)rect).width, ((FramebufferUpdateRectangle)rect).height, false));
                continue;
            }
            throw new CommonException("Unprocessed encoding: " + ((FramebufferUpdateRectangle)rect).toString());
        }
        rect = this;
        synchronized (rect) {
            if (this.needSendPixelFormat) {
                this.needSendPixelFormat = false;
                this.context.setPixelFormat(this.pixelFormat);
                this.context.sendMessage(new SetPixelFormatMessage(this.pixelFormat));
                logger.fine("sent: " + this.pixelFormat);
                this.context.sendRefreshMessage();
                logger.fine("sent: nonincremental fb update");
            } else {
                this.context.sendMessage(this.fullscreenFbUpdateIncrementalRequest);
            }
        }
        long delay = delayBetweenUpdates - (System.currentTimeMillis() - lastUpdateSent);
        if (delay < 0L) {
            delay = 0L;
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - lastUpdateSent > delayBetweenUpdates) {
                    Viewer.sendUpdateViaSerial();
                    lastUpdateSent = System.currentTimeMillis();
                }
            }
        }, delay);
    }

    public synchronized void queueUpdatePixelFormat(PixelFormat pf) {
        this.pixelFormat = pf;
        this.needSendPixelFormat = true;
    }

    public void stopTask() {
        this.isRunning = false;
    }
}

