.TH ACCIRC 1 "02 Jun 2013"
.SH NAME
accirc \- The accidental ncurses irc client
.SH SYNOPSIS
\fBaccirc\fP [ --help | --version ]
.SH DESCRIPTION
\fBaccirc\fP starts ncurses; functionality is available from there; config is read from ~/.config/accirc/config.rc ; logs are stored in ~/.local/share/accirc/logs/
.SS Options
.TP
\fB--help\fP
tells you to read this man page
.TP
\fB--version\fP
outputs the version of this software, in the form <major int>.<minor int>; major counts redesigns, minor counts updates; for both, even numbers are stable, odd numbers are unstable/testing
.SS Commands
.TP
\fB\\\fP
escapes the first character of the input string (in case you want a literal : or /)
.TP
\fB:\fP
sends raw data to the current server (if there is one)
.TP
\fB/connect\fP \fIhost\fP \fIport\fP
connects to an irc server at <host> on port <port>
.TP
\fB/exit\fP [ message ]
sends a QUIT to every irc server you're connected to
.TP
\fB/cli_escape\fP \fInew\fP
changes the client command escape character to <new>, if possible
.TP
\fB/ser_escape\fP \fInew\fP
changes the server raw data escape character to <new>, if possible
.TP
\fB/alias\fP \fItrigger\fP \fIsubstitution\fP
registers an alias; when the client escape is used with the trigger the trigger will be substituted for whatever substitution is specified; for example "/alias part :part" would allow you to use /part in place of :part, note this is a direct text substitution and does no additional handling
.TP
\fB/time_format\fP \fInew_format\fP
sets the time format for viewing (the clock and timestamps on messages in ncurses); note that logs always use unix timestamps, and ignore this formatting
.TP
\fB/reconnect\fP
reconnect to the currently selected server if connection is lost for any reason
.TP
\fB/no_reconnect\fP
don't reconnect to the currently selected server
.TP
\fB/log\fP
keep logs for the currently selected server (this is the default)
.TP
\fB/no_log\fP
don't keep logs for the currently selected server
.TP
\fB/sl\fP
sets active server one left of current server
.TP
\fB/sr\fP
sets active server one right of current server
.TP
\fB/cl\fP
sets active channel one left of current channel
.TP
\fB/cr\fP
sets active channel one right of current channel
.TP
\fB/me\fP
sends CTCP ACTION message
.TP
\fB/r\fP
replies (by privmsg) to the last user we recieved a PM from on the currently selected server; if we have never gotten a PM, the default nick to reply to is the null string ""; parsing in some server implementations may treat this strangely, but it's out of my hands, the client will act as intended and send a "privmsg nick :msg" to the server
.TP
\fB/sleep\fP \fIseconds\fP
sleeps a given number of seconds
.TP
\fB/usleep\fP \fImicroseconds\fP
sleeps a given number of microseconds
.TP
\fB/comment\fP
ignore this line, a comment (for an rc file)
.TP
\fB/autojoin\fP \fIchannel\fP
join this channel on the current server as soon as we can (for an rc file)
.TP
\fB/autoident\fP \fIpassword\fP
auth for this nick on the current server as soon as we can (for an rc file)
.TP
\fB/fallback_nick\fP \fInick\fP
set this as the backup nick if the nick specified is taken; if this nick is also taken _ is appended until one is unclaimed or we run out of characters allowed in the nick (for an rc file)
.TP
\fB/rejoin_on_kick\fP
for channels on current server, rejoin when kicked
.TP
\fB/no_rejoin_on_kick\fP
for channels on current server, don't rejoin when kicked
.SS "Key Bindings"
.TP
\fBf1 or alt+left\fP
channel left (see /cl)
.TP
\fBf2 or alt+right\fP
channel right (see /cr)
.TP
\fBf3 or alt+up\fP
server left (see /sl)
.TP
\fBf4 or alt+down\fP
server right (see /sr)
.TP
\fBf5 or alt+tab\fP
literal tab character (f5 left for backwards compatibility, alt+tab is recommended)
.TP
\fBf6\fP
0x01 character, since screen intercepts literal ^A (for manually sending CTCP messages other than ACTION); displays as a bold \\ in input area
.TP
\fBf7\fP
0x03 character for sending MIRC colors (MIRC color support is still experimental, and requires compilation with -D MIRC_COLOR); displays as a bold \^ in input area
.TP
\fB<tab>\fP
complete a nickname based on nicks in current channel
.TP
\fBPgUp\fP
scroll up one line in the channel scrollback, if possible
.TP
\fBPgDn\fP
scroll down one line in the channel scrollback, if possible
.TP
\fBUp\fP
scroll up one line in the input history, if possible
.TP
\fBDown\fP
scroll down one line in the input history, if possible
.SH FILES
.TP
\fC~/.config/accirc/config.rc\fR
The startup file to run
.TP
\fC~/.local/share/accirc/logs/\fR
The location of all logs from all servers
.TP
\fC~/.local/share/accirc/error_log.txt\fR
A log of any errors that couldn't be output through ncurses
.SH "EXAMPLE RC FILE
.TP
\fB~/.config/accirc/config.rc\fR
/comment set aliases and time for common preference, then connect to a server and join a channel

/alias quit /exit

/time_format %Y-%m-%d %R:%S

/connect daemonic.foonetic.net 6667

:nick accirc_user

:user 1 2 3 4

/autojoin #faid3.0

/comment some error handling just in case the desired nick is unavailable or connection gets lost, etc.

/fallback_nick accirc_user

/reconnect

/rejoin_on_kick

.SH "SEE ALSO"
ncurses(3) strftime(3)
.SH BUGS
MIRC colors don't work under screen; auto-reconnecting on drop is unreliable; flicker occurs frequently, since the clock updates every second (this is less noticable in screen or tmux for some reason)
.SH WWW
http://somegenericsite.dyndns.org/index.php?p=code

