#!/bin/sh
export LC_ALL="en_US.UTF-8"

PROC_KEYPAD="/proc/keypad"
PROC_FIVEWAY="/proc/fiveway"
test -e $PROC_KEYPAD && echo unlock > $PROC_KEYPAD
test -e $PROC_FIVEWAY && echo unlock > $PROC_FIVEWAY

# we're always starting from our working directory
cd /mnt/onboard/.kobo/koreader/


# export trained OCR data directory
export TESSDATA_PREFIX="data"

# export dict directory
export STARDICT_DATA_DIR="data/dict"




# bind-mount system fonts
if ! grep /mnt/onboard/.kobo/koreader/fonts/host /proc/mounts; then
	#mount -o bind /usr/local/Trolltech/QtEmbedded-4.6.2-arm/lib/fonts /mnt/onboard/.kobo/koreader/fonts/host
        mount -o bind /mnt/onboard/fonts/ /mnt/onboard/.kobo/koreader/fonts/host   
fi


# stop nickel
#killall -STOP nickel

kill -9 `pidof nickel`


#configure framebuffer
./framebuffer_configure

# finally call reader
./reader.lua "$1" 2> crash.log

# unmount system fonts
if grep /mnt/onboard/.kobo/koreader/fonts/host /proc/mounts; then
	umount /mnt/onboard/.kobo/koreader/fonts/host
fi

killall -CONT nickel
sleep 1s
# press "Home" button to see the main screen
echo -e '\xaa\x03\x00\x00\xFD\x4E\x01\x00\x01\x00\x66\x00\x01\x00\x00\x00\xAA\x03\x00\x00\xEA\xC2\x03\x00\x01\x00\x66\x00\x00\x00\x00\x00' > /dev/input/event0










