/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentTyper;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.OptionArgumentsSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionMethodSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionUtils;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.TypedArguments;
import uk.co.flamingpenguin.jewel.cli.TypedArgumentsImpl;
import uk.co.flamingpenguin.jewel.cli.UnparsedSpecificationImpl;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilder;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilderImpl;
import uk.co.flamingpenguin.jewel.cli.ValueFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentTyperImpl<O>
implements ArgumentTyper<O> {
    private final ValidationErrorBuilder m_validationErrorBuilder = new ValidationErrorBuilderImpl();
    private final OptionsSpecification<O> m_specification;

    public ArgumentTyperImpl(OptionsSpecification<O> specification) {
        this.m_specification = specification;
    }

    @Override
    public TypedArguments typeArguments(ArgumentCollection validatedArguments) throws ArgumentValidationException {
        TypedArgumentsImpl typedArguments = this.typeParsedArguments(validatedArguments);
        this.typeUnparsedArguments(validatedArguments, typedArguments);
        this.m_validationErrorBuilder.validate();
        return typedArguments;
    }

    private void typeUnparsedArguments(ArgumentCollection validatedArguments, TypedArgumentsImpl typedArguments) {
        if (this.m_specification.hasUnparsedSpecification() && !validatedArguments.getUnparsed().isEmpty()) {
            UnparsedSpecificationImpl specification = this.m_specification.getUnparsedSpecification();
            typedArguments.setUnparsedValue(this.getValue(validatedArguments.getUnparsed(), specification));
        }
    }

    private TypedArgumentsImpl typeParsedArguments(ArgumentCollection validatedArguments) {
        TypedArgumentsImpl typedArguments = new TypedArgumentsImpl();
        for (OptionMethodSpecification optionSpecification : this.m_specification) {
            if (!validatedArguments.containsAny(OptionUtils.getAllNames(optionSpecification)) && !optionSpecification.hasDefaultValue()) continue;
            Object value = optionSpecification.hasValue() ? this.getValue(validatedArguments, optionSpecification) : Boolean.TRUE;
            typedArguments.add(optionSpecification, value);
        }
        return typedArguments;
    }

    private Object getValue(ArgumentCollection arguments, OptionSpecification specification) {
        List<String> allNames = OptionUtils.getAllNames(specification);
        List<String> values = arguments.containsAny(allNames) ? arguments.getValues(allNames) : specification.getDefaultValue();
        return this.getValue(values, (OptionArgumentsSpecification)specification);
    }

    private Object getValue(List<String> values, OptionArgumentsSpecification specification) {
        try {
            Class<?> type = specification.getType();
            ArrayList<Object> result = new ArrayList<Object>();
            for (String value : values) {
                if (type.isEnum()) {
                    result.add(Enum.valueOf(type, value));
                    continue;
                }
                if (type.isPrimitive()) {
                    if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                        result.add(Character.valueOf(value.charAt(0)));
                        continue;
                    }
                    if (type.equals(Byte.TYPE) || type.equals(Short.class)) {
                        result.add(Byte.parseByte(value));
                        continue;
                    }
                    if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                        result.add(Short.parseShort(value));
                        continue;
                    }
                    if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                        result.add(Integer.parseInt(value));
                        continue;
                    }
                    if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                        result.add(Long.parseLong(value));
                        continue;
                    }
                    if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                        result.add(Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                        result.add(Double.parseDouble(value));
                        continue;
                    }
                    throw new UnsupportedOperationException(String.format("Method (%s) return type not supported for reading argument values", type));
                }
                if (type.equals(Character.class)) {
                    if (value.length() == 1) {
                        result.add(Character.valueOf(value.charAt(0)));
                        continue;
                    }
                    throw new ValueFormatException(String.format("value is not a character (%s)", value));
                }
                Constructor<?> constructor = type.getConstructor(String.class);
                result.add(constructor.newInstance(value));
            }
            if (specification.isMultiValued()) {
                return result;
            }
            return result.get(0);
        }
        catch (NumberFormatException e) {
            this.m_validationErrorBuilder.invalidValueForType(specification, this.unsupportedNumberFormatMessage(e));
        }
        catch (NoSuchMethodException e) {
            this.m_validationErrorBuilder.unableToConstructType(specification, e.getMessage());
        }
        catch (InstantiationException e) {
            this.m_validationErrorBuilder.unableToConstructType(specification, e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.m_validationErrorBuilder.unableToConstructType(specification, e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NumberFormatException) {
                this.m_validationErrorBuilder.invalidValueForType(specification, this.unsupportedNumberFormatMessage((NumberFormatException)cause));
            } else {
                this.m_validationErrorBuilder.invalidValueForType(specification, cause.getMessage());
            }
        }
        catch (ValueFormatException e) {
            this.m_validationErrorBuilder.invalidValueForType(specification, e.getMessage());
        }
        return null;
    }

    private String unsupportedNumberFormatMessage(NumberFormatException e1) {
        return "Unsupported number format: " + e1.getMessage();
    }
}

