#!/bin/sh

#
# Dump internal firmware on uSD
#
if [ -e /dev/mmcblk1p1 ]; then
  # mount uSD (umount first just in case udevd has already mounted it in readonly)
  umount /mnt/sd
	dosfsck -a -w /dev/mmcblk1p1
  mount -t vfat -o iocharset=utf8 /dev/mmcblk1p1 /mnt/sd

  if [ -e /mnt/sd/KoboDump ]; then
    # mount / as readonly and unmount internal FAT
    mount -o remount,noatime,nodiratime,ro /dev/mmcblk0p1 /
    umount /mnt/onboard

    # test uSD: if mount failed, /mnt/sd/.123sdcheck123 can't be created since / is readonly
    touch /mnt/sd/KoboDump/.123sdcheck123
    if [ -e /mnt/sd/KoboDump/.123sdcheck123 ]; then
      rm -rf /mnt/sd/KoboDump/.123sdcheck123
      # dump...
      dd if=/dev/mmcblk0 of=/mnt/sd/KoboDump/dump.img bs=512
      # rename KoboDump to avoid (improbable) loops
      mv /mnt/sd/KoboDump /mnt/sd/KoboDumpDone
    fi
    # restore mounted devices as expected
    mount -o remount,noatime,nodiratime,rw /dev/mmcblk0p1 /
    mount -t vfat -o iocharset=utf8 /dev/mmcblk0p3 /mnt/onboard
  fi
  umount /mnt/sd
fi

if [ -e /mnt/onboard/.kobo/manifest.md5sum ]; then 
	cd /mnt/onboard/.kobo
	md5sum -c manifest.md5sum
	if [ $? != 0 ]; then
		rm -rf manifest.md5sum
		exit 1;
	fi
	rm -rf manifest.md5sum
	cd /
fi

PLATFORM=freescale
if [ `dd if=/dev/mmcblk0 bs=512 skip=1024 count=1 | grep -c "HW CONFIG"` == 1 ]; then
	PLATFORM=ntx508
fi

UBOOT=/mnt/onboard/.kobo/upgrade/$PLATFORM/u-boot.bin
KERNEL=/mnt/onboard/.kobo/upgrade/$PLATFORM/uImage
if [ $PLATFORM == ntx508 ]; then
        PCB=`ntx_hwconfig -s -p /dev/mmcblk0 PCB`
        RAM=`ntx_hwconfig -s -p /dev/mmcblk0 RAMType`
	RAM_SIZE=`ntx_hwconfig -s -p /dev/mmcblk0 RamSize`
	RAM_SIZE=`echo $RAM_SIZE | awk '{print $RAM_SIZE-MB}'`
        NEW_UBOOT=/mnt/onboard/.kobo/upgrade/$PLATFORM/u-boot_mddr_$RAM_SIZE-$PCB-$RAM.bin
        NEW_KERNEL=/mnt/onboard/.kobo/upgrade/$PLATFORM/uImage-$PCB
	[ -e $NEW_UBOOT ] && UBOOT=$NEW_UBOOT
	[ -e $NEW_KERNEL ] && KERNEL=$NEW_KERNEL
fi

WAVEFORM=/mnt/onboard/.kobo/upgrade/waveform

[ ! -e $UBOOT ] && UBOOT=/mnt/onboard/.kobo/upgrade/u-boot.bin
[ ! -e $KERNEL ] && KERNEL=/mnt/onboard/.kobo/upgrade/uImage

echo your platform is $PLATFORM
echo $UBOOT
echo $KERNEL

/etc/init.d/upgrade-generic.sh $UBOOT $WAVEFORM $KERNEL mmcblk0

exit $?
