#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <unistd.h>
#include <string>
#include <gtk/gtk.h>
#include "../KindleLib/ShakeWindow.h"
#include "FSModel.h"
#include "timer.h"

#define KE_VERSION "1.5"
#define EDITOR "/mnt/us/extensions/leafpad/bin/leafpad"
#define TERMINAL "/mnt/us/extensions/kterm/bin/kterm"

using namespace std;

ShakeWindow *win;
GtkWidget *lstFiles, *txtPath;
FilesModel *fs;
Timer timer; string lastSel;
const char* imageFormats = "bmp;png;gif;ico;jpg;jpeg;wmf;tga";

void UpdateButtons()
{
    bool sel = fs->IsItemSelected();
    win->Enable("btnExecute", sel);
}

void DirUp(GtkWidget *widget, gpointer data)
{
    chdir("..");
    fs->UpdateList();
}

void PgUp(GtkWidget *widget, gpointer data)
{
    fs->UpdatePgUp();
}

void PgDn(GtkWidget *widget, gpointer data)
{
    fs->UpdatePgDn();
}

void CopyToKindle(GtkWidget *widget, gpointer data)
{
    if (!fs->IsItemSelected())
        return;
    FileItem sel = fs->GetSelectedItem();
    string original = GetCurrentDir();
    CopyPath(original+"/"+sel.name, string("/mnt/us/documents/")+sel.name);
    fs->UpdateList();
    win->MessageBox("Transfered to Documents.");
}

void ShowAbout(GtkWidget *widget, gpointer data)
{
  GtkWidget *dialog = gtk_about_dialog_new();
  gtk_about_dialog_set_name(GTK_ABOUT_DIALOG(dialog), "KindleExplorer");
  gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(dialog), KE_VERSION);
  gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(dialog), "Developer: anakod");
  gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(dialog), "Fast and simple file explorer.\n\nhttp://66bit.ru");
  gtk_window_set_title(GTK_WINDOW(dialog), "L:A_N:Explorer:About");
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}

void on_changed(GtkWidget *widget, gpointer label)
{
    UpdateButtons();
}

gboolean ListCkicked(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    if (!fs->IsItemSelected())
        return FALSE;

    FileItem sel = fs->GetSelectedItem();

    if (!timer.IsStarted() || timer.GetDuration() > 0.7 || lastSel != sel.name)
    {
        timer.Start();
        lastSel = sel.name;
        return FALSE;
    }
    timer.Start();

    if (sel.dir)
    {
        chdir(sel.name.c_str());
        fs->UpdateList();
    }

    return TRUE;
}

void AdaptSize()
{
    gint screenWidth = gdk_screen_get_width(gdk_screen_get_default());
    gint size = screenWidth / 12;
    if (size < 62) // for small screens downsize buttons
    {
        vector<GtkWidget*> buttons = win->FindWidgetsByType("GtkButton");
        for(vector<GtkWidget*>::iterator it = buttons.begin(); it != buttons.end(); it++)
            win->ResizeWidget(*it, size, size);
    }
}

int main (int argc, char **argv)
{
    ShakeWindow::Initialize();
    ShakeWindow::SetDefaultTitle("L:A_N:application_FileExplorer:Window");
    win = new ShakeWindow();
    win->Load(GetResFile("MainWindow.glade"), true);
    win->SetCloseButton("btnClose");
    lstFiles = win->GetWidget("lstFiles");
    txtPath = win->GetWidget("txtPath");
    fs = new FilesModel();
    fs->Assign(lstFiles, txtPath);

    chdir("/mnt/us/books");
    fs->UpdateList();

    win->OnClick("btnDirUp", DirUp);
    win->OnClick("btnPgUp", PgUp);
    win->OnClick("btnPgDn", PgDn);
    win->OnClick("btnExecute", CopyToKindle);
    win->OnClick("btnAbout", ShowAbout);

    AdaptSize();

    g_signal_connect(gtk_tree_view_get_selection(GTK_TREE_VIEW(lstFiles)), "changed", G_CALLBACK(on_changed), NULL);
    g_signal_connect(G_OBJECT(lstFiles), "button_release_event", (GtkSignalFunc)ListCkicked, NULL);

    UpdateButtons();
    win->Show();

    gtk_main();

    delete fs;
    return 0;
}
