#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <unistd.h>
#include <string>
#include <gtk/gtk.h>
#include "../KindleLib/ShakeWindow.h"
#include "FileData.h"

enum
{
    COL_ICON = 0,
    COL_NAME,
    COL_AGE,
    COL_IS_DIR,
    NUM_COLS
};

class FilesModel
{
public:
    void Assign(GtkWidget *view, GtkWidget *pth)
    {
        tree = view;
        path = pth;
        CreateColumns();
    }

    void CreateColumns()
    {
        GtkCellRenderer *renderer;
        /* --- Column --- */
        GtkTreeViewColumn *col = gtk_tree_view_column_new();
        gtk_tree_view_column_set_title(col, "Title");

        renderer = gtk_cell_renderer_text_new();
        gtk_tree_view_column_pack_start(col, renderer, TRUE);
        gtk_tree_view_column_set_attributes(col, renderer, "text", COL_NAME, NULL);

        gtk_tree_view_append_column(GTK_TREE_VIEW(tree), col);
        UpdateList();

        adj = gtk_tree_view_get_vadjustment(GTK_TREE_VIEW(tree));
    }

    GtkTreeModel *GetModel()
    {
        return model;
    }

    void UpdateList()
    {
        model = CreateFilesModel();
        gtk_tree_view_set_model(GTK_TREE_VIEW(tree), model);
        g_object_unref(model);

        char cur[2048];
        GetCurrentDir(cur, sizeof(cur));
        gtk_entry_set_text(GTK_ENTRY(path), cur);
        gtk_entry_select_region(GTK_ENTRY(path), 0, 0);
        gtk_entry_set_position(GTK_ENTRY(path), strlen(cur) - 1);
    }

    void UpdatePgDn()
    {
      gdouble v;
      v = adj->value + adj->page_size;
      if (v > adj->upper) {
        v = adj->lower;
      }
      gtk_adjustment_set_value(adj, v);
      gtk_adjustment_value_changed(adj);
    }
		
    void UpdatePgUp()
    {
      gdouble v;
      v = adj->value - adj->page_size;
      if (v < adj->lower) {
        v = adj->upper - adj->page_size;
      }
      gtk_adjustment_set_value(adj, v);
      gtk_adjustment_value_changed(adj);
    }
		
    bool IsItemSelected()
    {
        GtkTreeIter iter;
        GtkTreeModel *mdl;

        return gtk_tree_selection_get_selected(GTK_TREE_SELECTION(gtk_tree_view_get_selection(GTK_TREE_VIEW(tree))), &mdl, &iter);
    }

    FileItem GetSelectedItem()
    {
        GtkTreeIter iter;
        char *name;
        gboolean dir;
        FileItem result;
        GtkTreeModel *mdl;

        gtk_tree_selection_get_selected(GTK_TREE_SELECTION(gtk_tree_view_get_selection(GTK_TREE_VIEW(tree))), &mdl, &iter);
        {
            gtk_tree_model_get(mdl, &iter, COL_NAME, &name, COL_IS_DIR, &dir, -1);
            result.name = name;
            result.dir = dir;
            g_free(name);
        }
        return result;
    }

private:
    GtkTreeModel *CreateFilesModel()
    {
        GtkListStore *store;
        GtkTreeIter iter;
        store = gtk_list_store_new(NUM_COLS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_BOOLEAN);
        gtk_tree_sortable_set_default_sort_func (GTK_TREE_SORTABLE(store), NULL, NULL, NULL);
        gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE(store), GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
        vector<FileItem> files = GetFiles();
        for(vector<FileItem>::iterator it = files.begin(); it != files.end(); ++it)
        {
            gtk_list_store_append(store, &iter);
            gtk_list_store_set(store, &iter, COL_ICON, NULL, COL_NAME, it->name.c_str(), COL_AGE, 51, COL_IS_DIR, it->dir, -1);
        }

        return GTK_TREE_MODEL (store);
    }

private:
    GtkWidget *tree;
    GtkWidget *path;
    GtkTreeModel *model;
    GdkPixbuf* file;
    GdkPixbuf* folder;
    GtkAdjustment *adj;
};
