#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <linux/fb.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include "mxcfb.h" // see ref  mx50_evk_rd3_linux.pdf from freescale in L2.6.35_11.04.01_ER_docs.tar.gz

typedef struct  {
	int fbfd;
	struct fb_var_screeninfo vinfo;
	struct fb_fix_screeninfo finfo;
	// mapped frame buffer address
	unsigned short int *fb; // 16 bit ie two pixels should prob change
	size_t fb_size; 
} fbdev;


int main()
{
	
	fbdev *fb;
	fb = malloc(sizeof(*fb));

	// Open the file for reading and writing
	if ((fb->fbfd = open("/dev/fb0", O_RDWR)) == -1) {
		printf("Error opening fb device");	
	}

	// Figure out the size of the screen in bytes
	fb->fb_size = fb->vinfo.xres_virtual * fb->vinfo.yres_virtual * fb->vinfo.bits_per_pixel / 8;

	// Map the device to memory
	fb->fb = mmap(0, fb->fb_size, PROT_READ | PROT_WRITE, MAP_SHARED,fb->fbfd, 0);

	// Setup Update region struct
	struct mxcfb_update_data region; //see mxfb.h
	int marker = 1;
	region.update_marker = marker; /* Marker used when waiting for completion */
	region.update_region.top = 0;
	region.update_region.left = 0;
	region.update_region.width = 1024;
	region.update_region.height = 758;
	region.waveform_mode = WAVEFORM_MODE_AUTO;/* Waveform mode for update */
	region.update_mode = UPDATE_MODE_PARTIAL ; /* Update mode selection (partial/full) */
	region.temp = TEMP_USE_AMBIENT;
	region.flags = EPDC_FLAG_ENABLE_INVERSION ; /* Select options for the current update */

	ioctl(fb->fbfd , MXCFB_SEND_UPDATE, &region);

	return 0;
}
