/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.OfficeDocument;
import writer2latex.xmerge.OfficeZip;

public class EmbeddedXMLObject
extends EmbeddedObject {
    protected Document contentDOM = null;
    protected Document settingsDOM = null;
    protected Document stylesDOM = null;
    private DocumentBuilder builder = null;

    public EmbeddedXMLObject(String name, String type) {
        super(name, type);
    }

    EmbeddedXMLObject(String name, String type, OfficeZip source) {
        super(name, type, source);
    }

    public Document getContentDOM() throws SAXException, IOException {
        if (this.contentDOM == null) {
            this.contentDOM = this.getNamedDOM("content.xml");
        }
        return this.contentDOM;
    }

    public void setContentDOM(Document content) {
        this.contentDOM = content;
        this.hasChanged = true;
    }

    public Document getSettingsDOM() throws SAXException, IOException {
        if (this.settingsDOM == null) {
            this.settingsDOM = this.getNamedDOM("settings.xml");
        }
        return this.settingsDOM;
    }

    public void setSettingsDOM(Document settings) {
        this.settingsDOM = settings;
        this.hasChanged = true;
    }

    public Document getStylesDOM() throws SAXException, IOException {
        if (this.stylesDOM == null) {
            this.stylesDOM = this.getNamedDOM("styles.xml");
        }
        return this.stylesDOM;
    }

    public void setStylesDOM(Document styles) {
        this.stylesDOM = styles;
        this.hasChanged = true;
    }

    private Document getNamedDOM(String name) throws SAXException, IOException {
        if (this.zipFile == null) {
            return null;
        }
        try {
            byte[] data;
            if (this.builder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                this.builder = factory.newDocumentBuilder();
            }
            if ((data = this.zipFile.getNamedBytes(new String(this.objName + "/" + name))) != null) {
                return OfficeDocument.parse(this.builder, data);
            }
            return null;
        }
        catch (SAXException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
    }

    @Override
    void write(OfficeZip zip) throws IOException {
        if (this.hasChanged) {
            if (this.contentDOM != null) {
                zip.setNamedBytes(new String(this.objName + "/content.xml"), OfficeDocument.docToBytes(this.contentDOM));
            }
            if (this.settingsDOM != null) {
                zip.setNamedBytes(new String(this.objName + "/settings.xml"), OfficeDocument.docToBytes(this.settingsDOM));
            }
            if (this.stylesDOM != null) {
                zip.setNamedBytes(new String(this.objName + "/styles.xml"), OfficeDocument.docToBytes(this.stylesDOM));
            }
        }
    }

    @Override
    void writeManifestData(Document manifestDoc) throws DOMException {
        Element root = manifestDoc.getDocumentElement();
        if (this.contentDOM != null) {
            Element contentNode = manifestDoc.createElement("manifest:file-entry");
            contentNode.setAttribute("manifest:media-type", "text/xml");
            contentNode.setAttribute("manifest:full-path", new String(this.objName + "/content.xml"));
            root.appendChild(contentNode);
        }
        if (this.settingsDOM != null) {
            Element settingsNode = manifestDoc.createElement("manifest:file-entry");
            settingsNode.setAttribute("manifest:media-type", "text/xml");
            settingsNode.setAttribute("manifest:full-path", new String(this.objName + "/settings.xml"));
            root.appendChild(settingsNode);
        }
        if (this.stylesDOM != null) {
            Element stylesNode = manifestDoc.createElement("manifest:file-entry");
            stylesNode.setAttribute("manifest:media-type", "text/xml");
            stylesNode.setAttribute("manifest:full-path", new String(this.objName + "/styles.xml"));
        }
        Element objectNode = manifestDoc.createElement("manifest:file-entry");
        objectNode.setAttribute("manifest:media-type", this.objType);
        objectNode.setAttribute("manifest:full-path", new String(this.objName + "/"));
        root.appendChild(objectNode);
    }
}

