/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.PageLayout;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

public class PageStyleConverter
extends StyleConverterHelper {
    private boolean bHasFootnoteRules = false;

    public PageStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
    }

    public String getTextWidth() {
        String sWidth;
        PageLayout pageLayout;
        MasterPage masterPage = this.ofr.getFirstMasterPage();
        if (masterPage != null && (pageLayout = this.ofr.getPageLayout(masterPage.getPageLayoutName())) != null && (sWidth = pageLayout.getProperty("fo:page-width")) != null) {
            String sMarginRight;
            String sMarginLeft = pageLayout.getProperty("fo:margin-left");
            if (sMarginLeft != null) {
                sWidth = Misc.sub(sWidth, sMarginLeft);
            }
            if ((sMarginRight = pageLayout.getProperty("fo:margin-right")) != null) {
                sWidth = Misc.sub(sWidth, sMarginRight);
            }
            return sWidth;
        }
        return "17cm";
    }

    public void applyFootnoteRuleStyle(StyleInfo info) {
        this.bHasFootnoteRules = true;
        info.sClass = "footnoterule";
    }

    public void applyDefaultWritingDirection(StyleInfo info) {
        PageLayout pageLayout;
        MasterPage masterPage = this.ofr.getFirstMasterPage();
        if (masterPage != null && (pageLayout = this.ofr.getPageLayout(masterPage.getPageLayoutName())) != null) {
            PageStyleConverter.applyDirection(pageLayout, info);
        }
    }

    public void applyStyle(String sStyleName, StyleInfo info) {
        MasterPage masterPage = this.ofr.getMasterPage(sStyleName);
        if (masterPage != null) {
            String sDisplayName = masterPage.getDisplayName();
            if (this.ofr.isPresentation()) {
                info.sClass = "masterpage" + this.styleNames.getExportName(sDisplayName);
            }
        }
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        PageLayout pageLayout;
        MasterPage masterPage;
        StringBuffer buf = new StringBuffer();
        Enumeration<String> names = this.styleNames.keys();
        while (names.hasMoreElements()) {
            StyleWithProperties drawingPage;
            String sDisplayName = names.nextElement();
            MasterPage style = (MasterPage)this.getStyles().getStyleByDisplayName(sDisplayName);
            StyleInfo info = new StyleInfo();
            PageLayout pageLayout2 = this.ofr.getPageLayout(style.getPageLayoutName());
            if (pageLayout2 != null) {
                PageStyleConverter.applyDirection(pageLayout2, info);
                this.cssPageSize(pageLayout2, info.props);
                this.getFrameSc().cssBackground(pageLayout2, info.props, true);
            }
            if ((drawingPage = this.ofr.getDrawingPageStyle(style.getProperty("draw:style-name"))) != null) {
                this.cssDrawBackground(drawingPage, info.props, true);
            }
            buf.append(sIndent).append(".masterpage").append(this.styleNames.getExportName(sDisplayName)).append(" {").append(info.props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
        }
        if (this.ofr.isText() && (masterPage = this.ofr.getFirstMasterPage()) != null && (pageLayout = this.ofr.getPageLayout(masterPage.getPageLayoutName())) != null && this.bConvertStyles) {
            StyleInfo pageInfo = new StyleInfo();
            this.getFrameSc().cssBackground(pageLayout, pageInfo.props, true);
            if (pageInfo.hasAttributes()) {
                buf.append(sIndent).append("body {").append(pageInfo.props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
            }
            if (this.bHasFootnoteRules) {
                StyleInfo ruleInfo = new StyleInfo();
                this.cssFootnoteRule(pageLayout, ruleInfo.props);
                buf.append(sIndent).append("hr.footnoterule {").append(ruleInfo.props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
            }
        }
        return buf.toString();
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getMasterPages();
    }

    private void cssDrawBackground(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getProperty("draw:fill-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
    }

    private void cssPageSize(PageLayout style, CSVList props) {
        String sHeight;
        String sWidth = style.getProperty("fo:page-width");
        if (sWidth != null) {
            props.addValue("width", this.scale(sWidth));
        }
        if ((sHeight = style.getProperty("fo:page-height")) != null) {
            props.addValue("height", this.scale(sHeight));
        }
    }

    private void cssFootnoteRule(PageLayout style, CSVList props) {
        String sAdjustment;
        String sColor;
        String sWidth;
        String sHeight;
        String sAfter;
        String sBefore = style.getFootnoteProperty("style:distance-before-sep");
        if (sBefore != null) {
            props.addValue("margin-top", this.scale(sBefore));
        }
        if ((sAfter = style.getFootnoteProperty("style:distance-after-sep")) != null) {
            props.addValue("margin-bottom", this.scale(sAfter));
        }
        if ((sHeight = style.getFootnoteProperty("style:width")) != null) {
            props.addValue("height", this.scale(sHeight));
        }
        if ((sWidth = style.getFootnoteProperty("style:rel-width")) != null) {
            props.addValue("width", sWidth);
        }
        if ((sColor = style.getFootnoteProperty("style:color")) != null) {
            props.addValue("color", sColor);
            props.addValue("background-color", sColor);
        }
        if ("right".equals(sAdjustment = style.getFootnoteProperty("style:adjustment"))) {
            props.addValue("margin-left", "auto");
            props.addValue("margin-right", "0");
        } else if ("center".equals(sAdjustment)) {
            props.addValue("margin-left", "auto");
            props.addValue("margin-right", "auto");
        } else {
            props.addValue("margin-left", "0");
            props.addValue("margin-right", "auto");
        }
    }
}

