/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

public class HeadingStyleConverter
extends StyleConverterHelper {
    public HeadingStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXHeadingStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuffer buf = new StringBuffer();
            for (int i = 1; i <= 6; ++i) {
                if (this.ofr.getHeadingStyle(i) == null) continue;
                CSVList props = new CSVList(";");
                this.getParSc().applyProperties(this.ofr.getHeadingStyle(i), props, true);
                props.addValue("clear", "left");
                buf.append(sIndent).append("h").append(i).append(" {").append(props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
            }
            return buf.toString();
        }
        return "";
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getParStyles();
    }

    public void applyStyle(int nLevel, String sStyleName, StyleInfo info) {
        StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyle(sStyleName);
        if (style != null) {
            if (this.config.multilingual()) {
                HeadingStyleConverter.applyLang(style, info);
            }
            HeadingStyleConverter.applyDirection(style, info);
            if (style.isAutomatic()) {
                this.applyStyle(nLevel, style.getParentName(), info);
                if (this.bConvertHard) {
                    this.getParSc().applyProperties(style, info.props, false);
                }
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    info.sTagName = this.styleMap.getBlockElement(sDisplayName);
                    if (!"(none)".equals(this.styleMap.getBlockCss(sDisplayName))) {
                        info.sClass = this.styleMap.getBlockCss(sDisplayName);
                    }
                }
            }
        }
    }

    public void applyInnerStyle(int nLevel, String sStyleName, StyleInfo info) {
        StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyle(sStyleName);
        if (style != null) {
            if (style.isAutomatic()) {
                this.applyInnerStyle(nLevel, style.getParentName(), info);
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    info.sTagName = this.styleMap.getElement(sDisplayName);
                    if (!"(none)".equals(this.styleMap.getCss(sDisplayName))) {
                        info.sClass = this.styleMap.getCss(sDisplayName);
                    }
                }
            }
        }
    }
}

