/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import writer2latex.api.Config;
import writer2latex.api.IndexPageEntry;
import writer2latex.api.OutputFile;
import writer2latex.base.BatchConverterBase;
import writer2latex.xhtml.L10n;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlDocument;

public class BatchConverterImpl
extends BatchConverterBase {
    private XhtmlConfig config = new XhtmlConfig();
    private XhtmlDocument template = null;
    private String sDefaultLang;
    private String sDefaultCountry;
    private L10n l10n = new L10n();

    public BatchConverterImpl() {
        this.sDefaultLang = System.getProperty("user.language");
        this.sDefaultCountry = System.getProperty("user.country");
        this.l10n.setLocale(this.sDefaultLang, this.sDefaultCountry);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void readTemplate(InputStream is) throws IOException {
        this.template = new XhtmlDocument("Template", 0);
        try {
            this.template.read(is);
        }
        catch (IOException e) {
            this.template = null;
            throw e;
        }
    }

    @Override
    public void readTemplate(File file) throws IOException {
        this.readTemplate(new FileInputStream(file));
    }

    @Override
    protected String getIndexFileName() {
        return "index.html";
    }

    @Override
    public OutputFile createIndexFile(String sHeading, IndexPageEntry[] entries) {
        Element a;
        Element img;
        Element p;
        int i;
        Element title;
        Element footer;
        Element header;
        XhtmlDocument htmlDoc = new XhtmlDocument("index", 0);
        htmlDoc.setConfig(this.config);
        if (this.template != null) {
            htmlDoc.readFromTemplate(this.template);
        } else {
            htmlDoc.createHeaderFooter();
        }
        Document htmlDOM = htmlDoc.getContentDOM();
        Element head = htmlDoc.getHeadNode();
        if (head != null) {
            Element meta = htmlDOM.createElement("meta");
            meta.setAttribute("http-equiv", "Content-Type");
            meta.setAttribute("content", "text/html; charset=" + htmlDoc.getEncoding().toLowerCase());
            head.appendChild(meta);
            if (this.config.xhtmlCustomStylesheet().length() > 0) {
                Element htmlStyle = htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                htmlStyle.setAttribute("type", "text/css");
                htmlStyle.setAttribute("media", "all");
                htmlStyle.setAttribute("href", this.config.xhtmlCustomStylesheet());
                head.appendChild(htmlStyle);
            }
        }
        if ((header = htmlDoc.getHeaderNode()) != null) {
            if (this.config.getXhtmlUplink().length() > 0) {
                Element a2 = htmlDOM.createElement("a");
                a2.setAttribute("href", this.config.getXhtmlUplink());
                a2.appendChild(htmlDOM.createTextNode(this.l10n.get(0)));
                header.appendChild(a2);
            } else {
                header.appendChild(htmlDOM.createTextNode(this.l10n.get(0)));
            }
        }
        if ((footer = htmlDoc.getFooterNode()) != null) {
            if (this.config.getXhtmlUplink().length() > 0) {
                Element a3 = htmlDOM.createElement("a");
                a3.setAttribute("href", this.config.getXhtmlUplink());
                a3.appendChild(htmlDOM.createTextNode(this.l10n.get(0)));
                footer.appendChild(a3);
            } else {
                footer.appendChild(htmlDOM.createTextNode(this.l10n.get(0)));
            }
        }
        if ((title = htmlDoc.getTitleNode()) != null) {
            title.appendChild(htmlDOM.createTextNode(sHeading));
        }
        Element h1 = htmlDOM.createElement("h1");
        htmlDoc.getContentNode().appendChild(h1);
        h1.appendChild(htmlDOM.createTextNode(sHeading));
        int nLen = entries.length;
        Collator collator = Collator.getInstance(new Locale(this.sDefaultLang, this.sDefaultCountry));
        for (int i2 = 0; i2 < nLen; ++i2) {
            if (entries[i2] == null) continue;
            for (int j = i2 + 1; j < nLen; ++j) {
                if (entries[j] == null) continue;
                IndexPageEntry entryi = entries[i2];
                IndexPageEntry entryj = entries[j];
                if (collator.compare(entryi.getDisplayName(), entryj.getDisplayName()) <= 0) continue;
                entries[i2] = entryj;
                entries[j] = entryi;
            }
        }
        boolean bUseIcon = this.config.getXhtmlDirectoryIcon().length() > 0;
        for (i = 0; i < nLen; ++i) {
            if (entries[i] == null || !entries[i].isDirectory()) continue;
            p = htmlDOM.createElement("p");
            htmlDoc.getContentNode().appendChild(p);
            if (bUseIcon) {
                img = htmlDOM.createElement("img");
                p.appendChild(img);
                img.setAttribute("src", this.config.getXhtmlDirectoryIcon());
                img.setAttribute("alt", this.l10n.get(8));
                p.appendChild(htmlDOM.createTextNode(" "));
            }
            a = htmlDOM.createElement("a");
            p.appendChild(a);
            a.setAttribute("href", entries[i].getFile());
            a.appendChild(htmlDOM.createTextNode(entries[i].getDisplayName()));
        }
        bUseIcon = this.config.getXhtmlDocumentIcon().length() > 0;
        for (i = 0; i < nLen; ++i) {
            if (entries[i] == null || entries[i].isDirectory()) continue;
            p = htmlDOM.createElement("p");
            htmlDoc.getContentNode().appendChild(p);
            if (bUseIcon) {
                img = htmlDOM.createElement("img");
                p.appendChild(img);
                img.setAttribute("src", this.config.getXhtmlDocumentIcon());
                img.setAttribute("alt", this.l10n.get(9));
                p.appendChild(htmlDOM.createTextNode(" "));
            }
            if (entries[i].getFile() != null) {
                a = htmlDOM.createElement("a");
                p.appendChild(a);
                a.setAttribute("href", entries[i].getFile());
                a.appendChild(htmlDOM.createTextNode(entries[i].getDisplayName()));
            } else {
                p.appendChild(htmlDOM.createTextNode(entries[i].getDisplayName()));
            }
            if (entries[i].getPdfFile() != null) {
                p.appendChild(htmlDOM.createTextNode(" "));
                Element pdfa = htmlDOM.createElement("a");
                p.appendChild(pdfa);
                pdfa.setAttribute("href", entries[i].getPdfFile());
                pdfa.appendChild(htmlDOM.createTextNode("pdf"));
            }
            if (entries[i].getDescription() == null) continue;
            p.appendChild(htmlDOM.createTextNode(": " + entries[i].getDescription()));
        }
        return htmlDoc;
    }
}

