/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;
import writer2latex.xmerge.OfficeDocument;

public class MetaData
implements writer2latex.api.MetaData {
    private String sTitle = "";
    private String sCreator = "";
    private String sInitialCreator = "";
    private String sDate = "";
    private String sDescription = "";
    private String sLanguage = "";
    private String sSubject = "";
    private String sKeywords = "";
    private Map<String, String> userdefined = new HashMap<String, String>();

    public MetaData(OfficeDocument oooDoc) {
        NodeList list;
        Document dom = oooDoc.getMetaDOM();
        if (dom == null) {
            dom = oooDoc.getContentDOM();
        }
        if ((list = dom.getElementsByTagName("office:meta")).getLength() == 0) {
            return;
        }
        Node meta = list.item(0);
        if (!meta.hasChildNodes()) {
            return;
        }
        CSVList keywords = new CSVList(", ");
        list = meta.getChildNodes();
        int nLen = list.getLength();
        for (int i = 0; i < nLen; ++i) {
            String sPropertyName;
            Node child = list.item(i);
            String sName = child.getNodeName();
            if ("dc:title".equals(sName)) {
                this.sTitle = this.getContent(child);
                continue;
            }
            if ("dc:creator".equals(sName)) {
                this.sCreator = this.getContent(child);
                continue;
            }
            if ("dc:date".equals(sName)) {
                this.sDate = this.getContent(child);
                continue;
            }
            if ("dc:description".equals(sName)) {
                this.sDescription = this.getContent(child);
                continue;
            }
            if ("dc:language".equals(sName)) {
                this.sLanguage = this.getContent(child);
                continue;
            }
            if ("dc:subject".equals(sName)) {
                this.sSubject = this.getContent(child);
                continue;
            }
            if ("meta:initial-creator".equals(sName)) {
                this.sInitialCreator = this.getContent(child);
                continue;
            }
            if ("meta:keyword".equals(sName)) {
                keywords.addValue(this.getContent(child));
                continue;
            }
            if ("meta:keywords".equals(sName)) {
                if (!child.hasChildNodes()) continue;
                NodeList keywordList = child.getChildNodes();
                int nWordCount = keywordList.getLength();
                for (int j = 0; j < nWordCount; ++j) {
                    Node grandchild = keywordList.item(j);
                    if (!"meta:keyword".equals(grandchild.getNodeName())) continue;
                    keywords.addValue(this.getContent(grandchild));
                }
                continue;
            }
            if (!"meta:user-defined".equals(sName) || (sPropertyName = Misc.getAttribute(child, "meta:name")) == null) continue;
            this.userdefined.put(sPropertyName, this.getContent(child));
        }
        this.sKeywords = keywords.toString();
    }

    @Override
    public String getTitle() {
        return this.sTitle;
    }

    @Override
    public String getCreator() {
        return this.sCreator == null ? this.sInitialCreator : this.sCreator;
    }

    public String getInitialCreator() {
        return this.sInitialCreator;
    }

    @Override
    public String getDate() {
        return this.sDate;
    }

    @Override
    public String getDescription() {
        return this.sDescription;
    }

    @Override
    public String getLanguage() {
        return this.sLanguage;
    }

    public void setLanguage(String sLanguage) {
        this.sLanguage = sLanguage;
    }

    @Override
    public String getSubject() {
        return this.sSubject;
    }

    @Override
    public String getKeywords() {
        return this.sKeywords;
    }

    @Override
    public Map<String, String> getUserDefinedMetaData() {
        return this.userdefined;
    }

    private String getContent(Node node) {
        StringBuffer buf = new StringBuffer();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            buf.append(child.getNodeValue());
        }
        return buf.toString();
    }
}

