/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.i18n.I18n;
import writer2latex.latex.i18n.ReplacementTrieNode;
import writer2latex.latex.i18n.UnicodeStringParser;
import writer2latex.latex.i18n.UnicodeTable;
import writer2latex.latex.i18n.UnicodeTableHandler;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;

public class ClassicI18n
extends I18n {
    public static final int ASCII = 0;
    public static final int LATIN1 = 1;
    public static final int LATIN2 = 2;
    public static final int ISO_8859_7 = 3;
    public static final int CP1250 = 4;
    public static final int CP1251 = 5;
    public static final int KOI8_R = 6;
    public static final int UTF8 = 7;
    private static final int T1_ENC = 1;
    private static final int T2A_ENC = 2;
    private static final int T3_ENC = 4;
    private static final int LGR_ENC = 8;
    private static final int ANY_ENC = 15;
    private static Hashtable<String, String> babelLanguages = new Hashtable();
    private Hashtable<String, UnicodeTable> tableSet;
    private UnicodeTable table;
    private Stack<UnicodeTable> tableStack;
    private UnicodeStringParser ucparser;
    private int nDefaultFontenc = ClassicI18n.getFontenc(this.sDefaultLanguage);
    private boolean bT2A = false;
    private boolean bGreek = false;
    private boolean bPolytonicGreek = false;

    public static final int readInputenc(String sInputenc) {
        if ("ascii".equals(sInputenc)) {
            return 0;
        }
        if ("latin1".equals(sInputenc)) {
            return 1;
        }
        if ("latin2".equals(sInputenc)) {
            return 2;
        }
        if ("iso-8859-7".equals(sInputenc)) {
            return 3;
        }
        if ("cp1250".equals(sInputenc)) {
            return 4;
        }
        if ("cp1251".equals(sInputenc)) {
            return 5;
        }
        if ("koi8-r".equals(sInputenc)) {
            return 6;
        }
        if ("utf8".equals(sInputenc)) {
            return 7;
        }
        return 0;
    }

    public static final String writeInputenc(int nInputenc) {
        switch (nInputenc) {
            case 0: {
                return "ascii";
            }
            case 1: {
                return "latin1";
            }
            case 2: {
                return "latin2";
            }
            case 3: {
                return "iso-8859-7";
            }
            case 4: {
                return "cp1250";
            }
            case 5: {
                return "cp1251";
            }
            case 6: {
                return "koi8-r";
            }
            case 7: {
                return "utf8";
            }
        }
        return "???";
    }

    public static final String writeJavaEncoding(int nInputenc) {
        switch (nInputenc) {
            case 0: {
                return "ASCII";
            }
            case 1: {
                return "ISO8859_1";
            }
            case 2: {
                return "ISO8859_2";
            }
            case 3: {
                return "ISO8859_7";
            }
            case 4: {
                return "Cp1250";
            }
            case 5: {
                return "Cp1251";
            }
            case 6: {
                return "KOI8_R";
            }
            case 7: {
                return "UTF-8";
            }
        }
        return "???";
    }

    public static final int readFontencs(String sFontencs) {
        if ("ANY".equals(sFontencs = sFontencs.toUpperCase())) {
            return 15;
        }
        int nFontencs = 0;
        if (sFontencs.indexOf("T1") >= 0) {
            ++nFontencs;
        }
        if (sFontencs.indexOf("T2A") >= 0) {
            nFontencs += 2;
        }
        if (sFontencs.indexOf("T3") >= 0) {
            nFontencs += 4;
        }
        if (sFontencs.indexOf("LGR") >= 0) {
            nFontencs += 8;
        }
        return nFontencs;
    }

    private static final boolean supportsFontenc(int nFontencs, int nFontenc) {
        return (nFontencs & nFontenc) != 0;
    }

    private static final int getFontenc(int nFontencs) {
        if (ClassicI18n.supportsFontenc(nFontencs, 1)) {
            return 1;
        }
        if (ClassicI18n.supportsFontenc(nFontencs, 2)) {
            return 2;
        }
        if (ClassicI18n.supportsFontenc(nFontencs, 4)) {
            return 4;
        }
        if (ClassicI18n.supportsFontenc(nFontencs, 8)) {
            return 8;
        }
        return 0;
    }

    private static final int getFontenc(String sLang) {
        if ("el".equals(sLang)) {
            return 8;
        }
        if ("ru".equals(sLang)) {
            return 2;
        }
        if ("uk".equals(sLang)) {
            return 2;
        }
        if ("bg".equals(sLang)) {
            return 2;
        }
        if ("sr".equals(sLang)) {
            return 2;
        }
        return 1;
    }

    private static final String getFontencCs(int nFontenc) {
        switch (nFontenc) {
            case 1: {
                return "\\textlatin";
            }
            case 2: {
                return "\\textcyrillic";
            }
            case 4: {
                return "\\textipa";
            }
            case 8: {
                return "\\textgreek";
            }
        }
        return null;
    }

    public ClassicI18n(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.ucparser = new UnicodeStringParser();
        String sSymbols = "ascii";
        if (config.getInputencoding() != 0) {
            sSymbols = sSymbols + "|" + ClassicI18n.writeInputenc(config.getInputencoding());
        }
        if (config.useWasysym()) {
            sSymbols = sSymbols + "|wasysym";
        }
        if (config.useBbding()) {
            sSymbols = sSymbols + "|bbding";
        }
        if (config.useIfsym()) {
            sSymbols = sSymbols + "|ifsym";
        }
        if (config.usePifont()) {
            sSymbols = sSymbols + "|dingbats";
        }
        if (config.useEurosym()) {
            sSymbols = sSymbols + "|eurosym";
        }
        if (config.useTipa()) {
            sSymbols = sSymbols + "|tipa";
        }
        this.tableSet = new Hashtable();
        UnicodeTableHandler handler = new UnicodeTableHandler(this.tableSet, sSymbols);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        InputStream is = this.getClass().getResourceAsStream("symbols.xml");
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            System.err.println("Oops - Unable to read symbols.xml");
            t.printStackTrace();
        }
        this.tableStack = new Stack();
        this.tableStack.push(this.tableSet.get("root"));
        this.table = this.tableSet.get("root");
    }

    public ClassicI18n(LaTeXConfig config) {
        this(null, config, null);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        pack.append("\\usepackage[").append(ClassicI18n.writeInputenc(this.config.getInputencoding())).append("]{inputenc}").nl();
        CSVList fontencs = new CSVList(',');
        if (this.bT2A) {
            fontencs.addValue("T2A");
        }
        if (this.bGreek) {
            fontencs.addValue("LGR");
        }
        if (this.config.useTipa()) {
            fontencs.addValue("T3");
        }
        fontencs.addValue("T1");
        pack.append("\\usepackage[").append(fontencs.toString()).append("]{fontenc}").nl();
        if (this.greek() && !this.languages.contains("el")) {
            this.languages.add("el");
        }
        if (this.cyrillic() && !this.languages.contains("ru") && !this.languages.contains("uk") && !this.languages.contains("bg")) {
            this.languages.add("ru");
        }
        CSVList babelopt = new CSVList(",");
        for (String sLang : this.languages) {
            if (sLang.equals(this.sDefaultLanguage)) continue;
            if ("el".equals(sLang) && this.polytonicGreek()) {
                babelopt.addValue("polutonikogreek");
                continue;
            }
            String sBabelLang = this.getBabelLanguage(sLang);
            if (sBabelLang == null) continue;
            babelopt.addValue(sBabelLang);
        }
        if (this.sDefaultLanguage != null) {
            if ("el".equals(this.sDefaultLanguage) && this.polytonicGreek()) {
                babelopt.addValue("polutonikogreek");
            } else {
                String sBabelLang = this.getBabelLanguage(this.sDefaultLanguage);
                if (sBabelLang != null) {
                    babelopt.addValue(sBabelLang);
                }
            }
        }
        if (!babelopt.isEmpty()) {
            pack.append("\\usepackage[").append(babelopt.toString()).append("]{babel}").nl();
            if (this.languages.contains("pl")) {
                pack.append("\\let\\lll\\undefined").nl();
            }
        }
        if (this.config.useTipa()) {
            pack.append("\\usepackage[noenc]{tipa}").nl().append("\\usepackage{tipx}").nl();
        }
        if (this.config.useBbding()) {
            pack.append("\\usepackage{bbding}").nl().append("\\let\\bbCross\\Cross\\let\\Cross\\undefined").nl().append("\\let\\bbSquare\\Square\\let\\Square\\undefined").nl().append("\\let\\bbTrianbleUp\\TriangleUp\\let\\TriangleUp\\undefined").nl().append("\\let\\bbTrianlgeDown\\TriangleDown\\let\\TriangleDown\\undefined").nl();
        }
        if (this.config.useIfsym()) {
            pack.append("\\usepackage[geometry,weather,misc,clock]{ifsym}").nl();
        }
        if (this.config.usePifont()) {
            pack.append("\\usepackage{pifont}").nl();
        }
        if (this.config.useEurosym()) {
            pack.append("\\usepackage{eurosym}").nl();
        }
        pack.append("\\usepackage{amsmath}").nl();
        if (this.config.useWasysym()) {
            pack.append("\\usepackage{wasysym}").nl();
        }
        pack.append("\\usepackage{amssymb,amsfonts,textcomp}").nl();
    }

    @Override
    public void applyLanguage(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba) {
        String sISOLang;
        if (!this.bAlwaysUseDefaultLang && style != null && (sISOLang = style.getProperty("fo:language", bInherit)) != null) {
            this.languages.add(sISOLang);
            String sLang = this.getBabelLanguage(sISOLang);
            if (sLang != null) {
                if (bDecl) {
                    ba.add("\\selectlanguage{" + sLang + "}", "");
                } else {
                    ba.add("\\foreignlanguage{" + sLang + "}{", "}");
                }
            }
        }
    }

    @Override
    public void pushSpecialTable(String sName) {
        if (sName != null) {
            this.table = this.tableSet.get(sName);
            if (this.table == null) {
                this.table = this.tableSet.get("root");
            }
        }
        this.tableStack.push(this.table);
    }

    @Override
    public void popSpecialTable() {
        this.tableStack.pop();
        this.table = this.tableStack.peek();
    }

    public int getCharCount() {
        return this.table.getCharCount();
    }

    @Override
    public String convert(String s, boolean bMathMode, String sLang) {
        int i;
        if (!this.bAlwaysUseDefaultLang && sLang != null) {
            this.languages.add(sLang);
        }
        StringBuffer buf = new StringBuffer();
        int nFontenc = this.bAlwaysUseDefaultLang ? this.nDefaultFontenc : ClassicI18n.getFontenc(sLang);
        int nLen = s.length();
        int nStart = i = 0;
        while (i < nLen) {
            ReplacementTrieNode node = this.stringReplace.get(s, i, nLen);
            if (node != null) {
                boolean bOtherFontenc;
                if (i > nStart) {
                    this.convert(s, nStart, i, bMathMode, sLang, buf, nFontenc);
                }
                boolean bl = bOtherFontenc = !ClassicI18n.supportsFontenc(node.getFontencs(), nFontenc);
                if (bOtherFontenc) {
                    buf.append(ClassicI18n.getFontencCs(ClassicI18n.getFontenc(node.getFontencs()))).append("{");
                }
                buf.append(node.getLaTeXCode());
                if (bOtherFontenc) {
                    buf.append("}");
                }
                nStart = i += node.getInputLength();
                continue;
            }
            ++i;
        }
        if (nStart < nLen) {
            this.convert(s, nStart, nLen, bMathMode, sLang, buf, nFontenc);
        }
        return buf.toString();
    }

    private void convert(String s, int nStart, int nEnd, boolean bMathMode, String sLang, StringBuffer buf, int nFontenc) {
        int nCurFontenc = nFontenc;
        this.ucparser.reset(this.table, s, nStart, nEnd);
        boolean bIsFirst = true;
        char cProtect = '\u0000';
        boolean bTempMathMode = false;
        while (this.ucparser.next()) {
            char c = this.ucparser.getChar();
            if (bMathMode) {
                buf.append(this.convertMathChar(c, nFontenc));
            } else if (this.greekMath(c, nFontenc) || this.table.hasMathChar(c) && !this.table.hasTextChar(c)) {
                if (!bTempMathMode) {
                    buf.append("$");
                    bTempMathMode = true;
                }
                buf.append(this.convertMathChar(c, nFontenc));
                cProtect = '\u0000';
            } else if (this.table.hasTextChar(c)) {
                char cc;
                int nFontencs;
                if (bTempMathMode) {
                    buf.append("$");
                    bTempMathMode = false;
                }
                if (ClassicI18n.supportsFontenc(nFontencs = this.table.getFontencs(c), nCurFontenc)) {
                    char cProtectThis = this.table.getProtectChar(c);
                    if (cProtectThis != '\u0000' && (cProtectThis == cProtect || bIsFirst)) {
                        buf.append("{}");
                    }
                    cProtect = cProtectThis;
                    this.setFlags(c, nCurFontenc);
                    if (this.ucparser.hasCombiningChar()) {
                        cc = this.ucparser.getCombiningChar();
                        if (ClassicI18n.supportsFontenc(this.table.getFontencs(cc), nCurFontenc)) {
                            buf.append(this.table.getTextChar(cc)).append("{").append(this.table.getTextChar(c)).append("}");
                        } else {
                            buf.append(this.table.getTextChar(c));
                        }
                    } else {
                        buf.append(this.table.getTextChar(c));
                    }
                } else {
                    cProtect = this.table.getProtectChar(c);
                    int nFontenc1 = ClassicI18n.getFontenc(nFontencs);
                    this.setFlags(c, nFontenc1);
                    if (nCurFontenc != nFontenc) {
                        buf.append("}");
                    }
                    if (nFontenc1 != nFontenc) {
                        buf.append(ClassicI18n.getFontencCs(nFontenc1)).append("{");
                    }
                    if (this.ucparser.hasCombiningChar()) {
                        cc = this.ucparser.getCombiningChar();
                        if (ClassicI18n.supportsFontenc(this.table.getFontencs(cc), nCurFontenc)) {
                            buf.append(this.table.getTextChar(cc)).append("{").append(this.table.getTextChar(c)).append("}");
                        } else {
                            buf.append(this.table.getTextChar(c));
                        }
                    } else {
                        buf.append(this.table.getTextChar(c));
                    }
                    nCurFontenc = nFontenc1;
                }
            } else {
                buf.append(this.notFound(c, nCurFontenc));
            }
            bIsFirst = false;
        }
        if (bTempMathMode) {
            buf.append("$");
        }
        if (nCurFontenc != nFontenc) {
            buf.append("}");
        }
    }

    private String convertMathChar(char c, int nFontenc) {
        if (this.table.hasMathChar(c)) {
            return this.table.getMathChar(c);
        }
        if (this.table.hasTextChar(c)) {
            int nFontencs = this.table.getFontencs(c);
            if (ClassicI18n.supportsFontenc(nFontencs, nFontenc)) {
                this.setFlags(c, nFontenc);
                if (this.table.getCharType(c) == 1) {
                    return "\\text{" + this.table.getTextChar(c) + "{}}";
                }
                return "\\text{" + this.table.getTextChar(c) + "}";
            }
            int nFontenc1 = ClassicI18n.getFontenc(nFontencs);
            this.setFlags(c, nFontenc1);
            if (this.table.getCharType(c) == 1) {
                return "\\text{" + ClassicI18n.getFontencCs(nFontenc1) + "{" + this.table.getTextChar(c) + "{}}}";
            }
            return "\\text{" + ClassicI18n.getFontencCs(nFontenc1) + "{" + this.table.getTextChar(c) + "}}";
        }
        return "\\text{" + this.notFound(c, nFontenc) + "}";
    }

    private String notFound(char c, int nFontenc) {
        String sErrorMsg = "[" + Integer.toHexString(c).toUpperCase() + "?]";
        if (nFontenc == 1) {
            return sErrorMsg;
        }
        return "\\textlatin{" + sErrorMsg + "}";
    }

    private String getBabelLanguage(String sLang) {
        if (babelLanguages.containsKey(sLang)) {
            return babelLanguages.get(sLang);
        }
        return null;
    }

    private boolean cyrillic() {
        return this.bT2A;
    }

    private boolean greek() {
        return this.bGreek;
    }

    private boolean polytonicGreek() {
        return this.bPolytonicGreek;
    }

    private boolean greekMath(char c, int nFontenc) {
        return this.bGreekMath && nFontenc != 8 && this.table.getFontencs(c) == 8;
    }

    private void setFlags(char c, int nFontenc) {
        if (c >= '\u1f00' && c <= '\u1fff') {
            this.bPolytonicGreek = true;
        }
        if (nFontenc == 8) {
            this.bGreek = true;
        }
        if (nFontenc == 2) {
            this.bT2A = true;
        }
    }

    static {
        babelLanguages.put("en", "english");
        babelLanguages.put("bg", "bulgarian");
        babelLanguages.put("cs", "czech");
        babelLanguages.put("da", "danish");
        babelLanguages.put("de", "ngerman");
        babelLanguages.put("el", "greek");
        babelLanguages.put("es", "spanish");
        babelLanguages.put("fi", "finnish");
        babelLanguages.put("fr", "french");
        babelLanguages.put("ga", "irish");
        babelLanguages.put("hr", "croatian");
        babelLanguages.put("hu", "magyar");
        babelLanguages.put("la", "latin");
        babelLanguages.put("is", "icelandic");
        babelLanguages.put("it", "italian");
        babelLanguages.put("nl", "dutch");
        babelLanguages.put("nb", "norsk");
        babelLanguages.put("nn", "nynorsk");
        babelLanguages.put("pl", "polish");
        babelLanguages.put("pt", "portuges");
        babelLanguages.put("ro", "romanian");
        babelLanguages.put("ru", "russian");
        babelLanguages.put("sk", "slovak");
        babelLanguages.put("sl", "slovene");
        babelLanguages.put("sr", "serbian");
        babelLanguages.put("sv", "swedish");
        babelLanguages.put("tr", "turkish");
        babelLanguages.put("uk", "ukrainian");
    }
}

