/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.StarMathConverter;
import writer2latex.office.OfficeReader;
import writer2latex.office.TableReader;
import writer2latex.util.Misc;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.EmbeddedXMLObject;

public final class MathmlConverter
extends ConverterHelper {
    private StarMathConverter smc;
    private boolean bContainsFormulas = false;
    private boolean bAddParAfterDisplay = false;
    private Element theEquation = null;
    private Element theSequence = null;

    public MathmlConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.smc = new StarMathConverter(palette.getI18n(), config);
        this.bAddParAfterDisplay = config.formatting() >= 3;
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bContainsFormulas) {
            if (this.config.useOoomath()) {
                pack.append("\\usepackage{ooomath}").nl();
            } else {
                this.smc.appendDeclarations(pack, decl);
            }
        }
    }

    public String convert(Node settings, Node formula) {
        Element semantics = Misc.getChildByTagName(formula, "semantics");
        if (semantics == null) {
            semantics = Misc.getChildByTagName(formula, "math:semantics");
        }
        if (semantics != null) {
            Element annotation = Misc.getChildByTagName(semantics, "annotation");
            if (annotation == null) {
                annotation = Misc.getChildByTagName(semantics, "math:annotation");
            }
            if (annotation != null) {
                String sStarMath = "";
                if (annotation.hasChildNodes()) {
                    NodeList anl = annotation.getChildNodes();
                    int nLen = anl.getLength();
                    for (int i = 0; i < nLen; ++i) {
                        if (anl.item(i).getNodeType() != 3) continue;
                        sStarMath = sStarMath + anl.item(i).getNodeValue();
                    }
                    this.bContainsFormulas = true;
                    return this.smc.convert(sStarMath);
                }
            }
        }
        if (formula.hasChildNodes()) {
            return "\\text{Warning: No StarMath annotation}";
        }
        return " ";
    }

    public boolean handleDisplayEquation(TableReader table, LaTeXDocumentPortion ldp) {
        if (table.getRowCount() == 1 && table.getColCount() == 2 && OfficeReader.isSingleParagraph(table.getCell(0, 0)) && OfficeReader.isSingleParagraph(table.getCell(0, 1))) {
            this.theEquation = null;
            this.theSequence = null;
            if (this.parseDisplayEquation(Misc.getFirstChildElement(table.getCell(0, 0))) && this.theEquation != null && this.theSequence == null) {
                Element myEquation = this.theEquation;
                this.theEquation = null;
                this.theSequence = null;
                if (this.parseDisplayEquation(Misc.getFirstChildElement(table.getCell(0, 1))) && this.theEquation == null && this.theSequence != null) {
                    this.handleDisplayEquation(myEquation, this.theSequence, ldp);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean handleDisplayEquation(Element node, LaTeXDocumentPortion ldp) {
        this.theEquation = null;
        this.theSequence = null;
        if (this.parseDisplayEquation(node) && this.theEquation != null) {
            this.handleDisplayEquation(this.theEquation, this.theSequence, ldp);
            return true;
        }
        return false;
    }

    private void handleDisplayEquation(Element equation, Element sequence, LaTeXDocumentPortion ldp) {
        String sLaTeX = this.convert(null, equation);
        if (!" ".equals(sLaTeX)) {
            if (sequence != null) {
                ldp.append("\\begin{equation}");
                this.palette.getFieldCv().handleSequenceLabel(sequence, ldp);
                ldp.nl().append(sLaTeX).nl().append("\\end{equation}").nl();
                if (this.bAddParAfterDisplay) {
                    ldp.nl();
                }
            } else {
                ldp.append("\\begin{equation*}").nl().append(sLaTeX).nl().append("\\end{equation*}").nl();
                if (this.bAddParAfterDisplay) {
                    ldp.nl();
                }
            }
        }
    }

    private boolean parseDisplayEquation(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Node equation = this.getFormula(child);
            if (equation != null) {
                if (this.theEquation == null) {
                    this.theEquation = (Element)equation;
                    continue;
                }
                return false;
            }
            if (Misc.isElement(child)) {
                String sName = child.getNodeName();
                if ("text:sequence".equals(sName)) {
                    if (this.theSequence == null) {
                        this.theSequence = (Element)child;
                        continue;
                    }
                    return false;
                }
                if ("text:span".equals(sName)) {
                    if (this.parseDisplayEquation(child)) continue;
                    return false;
                }
                if ("text:s".equals(sName) || "text:tab".equals(sName) || "text:tab-stop".equals(sName) || "text:soft-page-break".equals(sName)) continue;
                return false;
            }
            if (!Misc.isText(child)) continue;
            String s = child.getNodeValue();
            int nLen = s.length();
            for (int i = 0; i < nLen; ++i) {
                char c = s.charAt(i);
                if (c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == ' ' || c == '\u00a0') continue;
                return false;
            }
        }
        return true;
    }

    private Node getFormula(Node node) {
        String sHref;
        if (Misc.isElement(node, "draw:frame")) {
            node = Misc.getFirstChildElement(node);
        }
        if ((sHref = Misc.getAttribute(node, "xlink:href")) != null) {
            if (this.ofr.isInPackage(sHref)) {
                EmbeddedObject object;
                if (sHref.startsWith("#")) {
                    sHref = sHref.substring(1);
                }
                if (sHref.startsWith("./")) {
                    sHref = sHref.substring(2);
                }
                if ((object = this.palette.getEmbeddedObject(sHref)) != null && ("application/vnd.sun.xml.math".equals(object.getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType()))) {
                    try {
                        Document formuladoc = ((EmbeddedXMLObject)object).getContentDOM();
                        Element formula = Misc.getChildByTagName(formuladoc, "math");
                        if (formula == null) {
                            formula = Misc.getChildByTagName(formuladoc, "math:math");
                        }
                        return formula;
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Element formula = Misc.getChildByTagName(node, "math");
            if (formula == null) {
                formula = Misc.getChildByTagName(node, "math:math");
            }
            return formula;
        }
        return null;
    }
}

