/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Hashtable;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.StyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;

public class ListStyleConverter
extends StyleConverter {
    boolean bNeedSaveEnumCounter = false;
    private Hashtable<String, String[]> listStyleLevelNames = new Hashtable();

    public ListStyleConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.config.formatting() >= 3 || !this.styleNames.isEmpty()) {
            decl.append("% List styles").nl();
            if (this.bNeedSaveEnumCounter) {
                decl.append("\\newcounter{saveenum}").nl();
            }
            if (this.config.formatting() >= 3) {
                decl.append("\\newcommand\\writerlistleftskip{}").nl().append("\\newcommand\\writerlistparindent{}").nl().append("\\newcommand\\writerlistlabel{}").nl().append("\\newcommand\\writerlistremovelabel{").append("\\aftergroup\\let\\aftergroup\\writerlistparindent\\aftergroup\\relax").append("\\aftergroup\\let\\aftergroup\\writerlistlabel\\aftergroup\\relax}").nl();
            }
            super.appendDeclarations(pack, decl);
        }
    }

    public void applyListStyle(boolean bOrdered, BeforeAfter ba, Context oc) {
        String sDisplayName = this.ofr.getListStyles().getDisplayName(oc.getListStyleName());
        if (this.config.getListStyleMap().contains(sDisplayName)) {
            ba.add(this.config.getListStyleMap().getBefore(sDisplayName), this.config.getListStyleMap().getAfter(sDisplayName));
            return;
        }
        ListStyle style = this.ofr.getListStyle(oc.getListStyleName());
        if (style == null || this.config.formatting() <= 1) {
            if (oc.getListLevel() <= 4) {
                if (bOrdered) {
                    ba.add("\\begin{enumerate}", "\\end{enumerate}");
                } else {
                    ba.add("\\begin{itemize}", "\\end{itemize}");
                }
            }
            return;
        }
        if (this.config.formatting() == 2 || this.config.formatting() >= 3 && oc.isInTable()) {
            if (oc.getListLevel() == 1) {
                if (!this.styleNames.containsName(this.getDisplayName(oc.getListStyleName()))) {
                    this.createListStyleLabels(oc.getListStyleName());
                }
                ba.add("\\liststyle" + this.styleNames.getExportName(this.getDisplayName(oc.getListStyleName())) + "\n", "");
            }
            if (oc.getListLevel() <= 4) {
                String sCounterName = this.listStyleLevelNames.get(oc.getListStyleName())[oc.getListLevel()];
                if (oc.isInContinuedList() && style.isNumber(oc.getListLevel())) {
                    this.bNeedSaveEnumCounter = true;
                    ba.add("\\setcounter{saveenum}{\\value{" + sCounterName + "}}\n", "");
                }
                if (bOrdered) {
                    ba.add("\\begin{enumerate}", "\\end{enumerate}");
                } else {
                    ba.add("\\begin{itemize}", "\\end{itemize}");
                }
                if (oc.isInContinuedList() && style.isNumber(oc.getListLevel())) {
                    ba.add("\n\\setcounter{" + sCounterName + "}{\\value{saveenum}}", "");
                }
            }
            return;
        }
        if (oc.getListLevel() <= 4) {
            if (!this.styleNames.containsName(this.getDisplayName(oc.getListStyleName()))) {
                this.createListStyle(oc.getListStyleName());
            }
            String sTeXName = "list" + this.styleNames.getExportName(this.getDisplayName(oc.getListStyleName())) + "level" + Misc.int2roman(oc.getListLevel());
            if (!oc.isInContinuedList() && style.isNumber(oc.getListLevel())) {
                int nStartValue = Misc.getPosInteger(style.getLevelProperty(oc.getListLevel(), "text:start-value"), 1) - 1;
                ba.add("\n\\setcounter{" + sTeXName + "}{" + Integer.toString(nStartValue) + "}\n", "");
            }
            ba.add("\\begin{" + sTeXName + "}", "\\end{" + sTeXName + "}");
        }
    }

    public void applyListItemStyle(String sStyleName, int nLevel, boolean bHeader, boolean bRestart, int nStartValue, BeforeAfter ba, Context oc) {
        String sDisplayName = this.ofr.getListStyles().getDisplayName(sStyleName);
        if (this.config.getListItemStyleMap().contains(sDisplayName)) {
            ba.add(this.config.getListItemStyleMap().getBefore(sDisplayName), this.config.getListItemStyleMap().getAfter(sDisplayName));
            return;
        }
        ListStyle style = this.ofr.getListStyle(sStyleName);
        if (style == null || this.config.formatting() <= 1) {
            if (nLevel <= 4) {
                if (bHeader) {
                    ba.add("\\item[] ", "");
                } else {
                    ba.add("\\item ", "");
                }
            }
            return;
        }
        if (this.config.formatting() == 2 || this.config.formatting() >= 3 && oc.isInTable()) {
            if (nLevel <= 4) {
                if (bHeader) {
                    ba.add("\\item[] ", "");
                } else if (bRestart && style.isNumber(nLevel)) {
                    ba.add("\n\\setcounter{enum" + Misc.int2roman(nLevel) + "}{" + (nStartValue - 1) + "}\n\\item ", "");
                } else {
                    ba.add("\\item ", "");
                }
            }
            return;
        }
        if (nLevel <= 4 && !bHeader) {
            String sTeXName = "list" + this.styleNames.getExportName(this.getDisplayName(sStyleName)) + "level" + Misc.int2roman(nLevel);
            if (bRestart && style.isNumber(nLevel)) {
                ba.add("\\setcounter{" + sTeXName + "}{" + (nStartValue - 1) + "}\n", "");
            }
            ba.add("\\item ", "");
        }
    }

    private void createListStyleLabels(String sStyleName) {
        String sTeXName = this.styleNames.getExportName(this.getDisplayName(sStyleName));
        this.declarations.append("\\newcommand\\liststyle").append(sTeXName).append("{%").nl();
        ListStyle style = this.ofr.getListStyle(sStyleName);
        int nEnum = 0;
        int nItem = 0;
        String[] sName = new String[5];
        for (int i = 1; i <= 4; ++i) {
            sName[i] = style.isNumber(i) ? "enum" + Misc.int2roman(++nEnum) : "item" + Misc.int2roman(++nItem);
        }
        this.listStyleLevelNames.put(sStyleName, sName);
        this.createLabels(style, sName, 4, false, true, false, this.declarations);
        this.declarations.append("}").nl();
    }

    private void createListStyle(String sStyleName) {
        int i;
        ListStyle style = this.ofr.getListStyle(sStyleName);
        String sTeXName = this.styleNames.getExportName(this.getDisplayName(sStyleName));
        String[] sLevelName = new String[5];
        for (i = 1; i <= 4; ++i) {
            sLevelName[i] = "list" + sTeXName + "level" + Misc.int2roman(i);
        }
        this.createLabels(style, sLevelName, 4, true, false, true, this.declarations);
        for (i = 1; i <= 4; ++i) {
            String sTextAlign = style.getLevelStyleProperty(i, "fo:text-align");
            String sAlignmentChar = "l";
            if (sTextAlign != null) {
                if ("end".equals(sTextAlign)) {
                    sAlignmentChar = "r";
                } else if ("right".equals(sTextAlign)) {
                    sAlignmentChar = "r";
                } else if ("center".equals(sTextAlign)) {
                    sAlignmentChar = "c";
                }
            }
            if (style.isNewType(i)) {
                String sTextIndent;
                String sMarginLeft = style.getLevelStyleProperty(i, "fo:margin-left");
                if (sMarginLeft == null) {
                    sMarginLeft = "0cm";
                }
                if ((sTextIndent = style.getLevelStyleProperty(i, "fo:text-indent")) == null) {
                    sTextIndent = "0cm";
                }
                String sDefWriterlistleftskip = "\\def\\writerlistleftskip{\\setlength\\leftskip{" + sMarginLeft + "}}";
                String sDefWriterlistparindent = "\\def\\writerlistparindent{\\setlength\\parindent{" + sTextIndent + "}}";
                String sFormat = style.getLevelStyleProperty(i, "text:label-followed-by");
                String sTheLabel = "\\label" + sLevelName[i] + ("space".equals(sFormat) ? "\\ " : "");
                if ("listtab".equals(sFormat) || sAlignmentChar == "r") {
                    sTheLabel = "\\makebox[0cm][" + sAlignmentChar + "]{" + sTheLabel + "}";
                    if ("listtab".equals(sFormat)) {
                        String sTabPos = style.getLevelStyleProperty(i, "text:list-tab-stop-position");
                        if (sTabPos == null) {
                            sTabPos = "0cm";
                        }
                        sTheLabel = sTheLabel + "\\hspace{" + Misc.sub(sTabPos, Misc.add(sMarginLeft, sTextIndent)) + "}";
                    }
                }
                this.declarations.append("\\newenvironment{").append(sLevelName[i]).append("}{").append(sDefWriterlistleftskip).append("\\def\\writerlistparindent{}").append("\\def\\writerlistlabel{}").append("\\def\\item{").append(sDefWriterlistparindent).append("\\def\\writerlistlabel{");
                if (style.isNumber(i)) {
                    this.declarations.append("\\stepcounter{").append(sLevelName[i]).append("}");
                }
                this.declarations.append(sTheLabel).append("\\writerlistremovelabel}}}{}").nl();
                continue;
            }
            String sSpaceBefore = this.getLength(style, i, "text:space-before");
            String sLabelWidth = this.getLength(style, i, "text:min-label-width");
            String sLabelDistance = this.getLength(style, i, "text:min-label-distance");
            this.declarations.append("\\newenvironment{").append(sLevelName[i]).append("}{").append("\\def\\writerlistleftskip{\\addtolength\\leftskip{").append(Misc.add(sSpaceBefore, sLabelWidth)).append("}}").append("\\def\\writerlistparindent{}").append("\\def\\writerlistlabel{}");
            this.declarations.append("\\def\\item{").append("\\def\\writerlistparindent{\\setlength\\parindent{").append("-").append(sLabelWidth).append("}}").append("\\def\\writerlistlabel{");
            if (style.isNumber(i)) {
                this.declarations.append("\\stepcounter{").append(sLevelName[i]).append("}");
            }
            this.declarations.append("\\makebox[").append(sLabelWidth).append("][").append(sAlignmentChar).append("]{").append("\\label").append(sLevelName[i]).append("}").append("\\hspace{").append(sLabelDistance).append("}").append("\\writerlistremovelabel}}}{}").nl();
        }
    }

    private void createLabels(ListStyle style, String[] sName, int nMaxLevel, boolean bDeclareCounters, boolean bRenewLabels, boolean bUseTextStyle, LaTeXDocumentPortion ldp) {
        int i;
        if (bDeclareCounters) {
            int j = 0;
            for (i = 1; i <= nMaxLevel; ++i) {
                if (!style.isNumber(i)) continue;
                ldp.append("\\newcounter{").append(sName[i]).append("}");
                if (j > 0) {
                    ldp.append("[").append(sName[j]).append("]");
                }
                ldp.nl();
                j = i;
            }
        }
        String[] sNumFormat = new String[nMaxLevel + 1];
        for (i = 1; i <= nMaxLevel; ++i) {
            String s = ListStyleConverter.numFormat(style.getLevelProperty(i, "style:num-format"));
            sNumFormat[i] = s == null ? "" : s + "{" + sName[i] + "}";
        }
        for (i = 1; i <= nMaxLevel; ++i) {
            if (!style.isNumber(i)) continue;
            ldp.append("\\renewcommand\\the").append(sName[i]).append("{");
            int nLevels = Misc.getPosInteger(style.getLevelProperty(i, "text:display-levels"), 1);
            for (int j = i - nLevels + 1; j < i; ++j) {
                if (!style.isNumber(j)) continue;
                ldp.append(sNumFormat[j]).append(".");
            }
            ldp.append(sNumFormat[i]);
            ldp.append("}").nl();
        }
        for (i = 1; i <= nMaxLevel; ++i) {
            ldp.append(bRenewLabels ? "\\renewcommand" : "\\newcommand").append("\\label").append(sName[i]).append("{");
            BeforeAfter baText = new BeforeAfter();
            if (bUseTextStyle) {
                String sStyleName = style.getLevelProperty(i, "text:style-name");
                this.palette.getCharSc().applyTextStyle(sStyleName, baText, new Context());
            }
            if (style.isNumber(i)) {
                String sPrefix = style.getLevelProperty(i, "style:num-prefix");
                String sSuffix = style.getLevelProperty(i, "style:num-suffix");
                ldp.append(baText.getBefore());
                if (sPrefix != null) {
                    ldp.append(this.palette.getI18n().convert(sPrefix, false, "en"));
                }
                ldp.append("\\the").append(sName[i]);
                if (sSuffix != null) {
                    ldp.append(this.palette.getI18n().convert(sSuffix, false, "en"));
                }
                ldp.append(baText.getAfter());
            } else if (style.isBullet(i)) {
                String sBullet = style.getLevelProperty(i, "text:bullet-char");
                ldp.append(baText.getBefore());
                if (sBullet != null) {
                    String sFontName = this.palette.getCharSc().getFontName(style.getLevelProperty(i, "text:style-name"));
                    this.palette.getI18n().pushSpecialTable(sFontName);
                    ldp.append(this.palette.getI18n().convert(sBullet, false, "en"));
                    this.palette.getI18n().popSpecialTable();
                }
                ldp.append(baText.getAfter());
            } else {
                ldp.append("\\textbullet");
            }
            ldp.append("}").nl();
        }
    }

    private String getLength(ListStyle style, int nLevel, String sProperty) {
        String s = style.getLevelStyleProperty(nLevel, sProperty);
        if (s == null) {
            return "0cm";
        }
        return s;
    }

    private String getDisplayName(String sName) {
        String sDisplayName = this.ofr.getListStyles().getDisplayName(sName);
        return sDisplayName != null ? sDisplayName : sName;
    }

    public static final String numFormat(String sFormat) {
        if ("1".equals(sFormat)) {
            return "\\arabic";
        }
        if ("i".equals(sFormat)) {
            return "\\roman";
        }
        if ("I".equals(sFormat)) {
            return "\\Roman";
        }
        if ("a".equals(sFormat)) {
            return "\\alph";
        }
        if ("A".equals(sFormat)) {
            return "\\Alph";
        }
        return null;
    }
}

