/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;
import writer2latex.xmerge.BinaryGraphicsDocument;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.EmbeddedXMLObject;

public class DrawConverter
extends ConverterHelper {
    private boolean bNeedGraphicx = false;
    private boolean bNeedOOoLaTeXPreamble = false;
    private Stack<LinkedList<Element>> floatingFramesStack = new Stack();

    private Element getFrame(Element onode) {
        if (this.ofr.isOpenDocument()) {
            return (Element)onode.getParentNode();
        }
        return onode;
    }

    public DrawConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.floatingFramesStack.push(new LinkedList());
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedGraphicx) {
            pack.append("\\usepackage");
            if (this.config.getBackend() == 2) {
                pack.append("[pdftex]");
            } else if (this.config.getBackend() == 1) {
                pack.append("[dvips]");
            }
            pack.append("{graphicx}").nl();
        }
        if (this.bNeedOOoLaTeXPreamble) {
            String sDescription = this.palette.getMetaData().getDescription();
            int nStart = sDescription.indexOf("%%% OOoLatex Preamble %%%%%%%%%%%%%%");
            int nEnd = sDescription.indexOf("%%% End OOoLatex Preamble %%%%%%%%%%%%");
            if (nStart > -1 && nEnd > nStart) {
                decl.append("% OOoLaTeX preamble").nl().append(sDescription.substring(nStart + 37, nEnd));
            }
        }
    }

    public void handleCaption(Element node, LaTeXDocumentPortion ldp, Context oc) {
        LaTeXDocumentPortion capLdp = new LaTeXDocumentPortion(true);
        if (oc.isInFigureFloat()) {
            capLdp.append("\\caption");
            this.palette.getCaptionCv().handleCaptionBody(node, capLdp, oc, false);
        } else {
            capLdp.append("\\captionof{figure}");
            this.palette.getCaptionCv().handleCaptionBody(node, capLdp, oc, true);
        }
        this.flushFloatingFrames(ldp, oc);
        ldp.append(capLdp);
    }

    public void handleDrawElement(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getTagName();
        if (sName.equals("draw:object")) {
            this.handleDrawObject(node, ldp, oc);
        } else if (sName.equals("draw:object-ole")) {
            this.handleDrawObject(node, ldp, oc);
        } else if (!oc.isInHeaderFooter() && sName.equals("draw:image")) {
            this.handleDrawImage(node, ldp, oc);
        } else if (!oc.isInHeaderFooter() && sName.equals("draw:text-box")) {
            this.handleDrawTextBox(node, ldp, oc);
        } else if (sName.equals("draw:a")) {
            this.palette.getFieldCv().handleAnchor(node, ldp, oc);
        } else if (sName.equals("draw:frame")) {
            this.handleDrawElement(Misc.getFirstChildElement(node), ldp, oc);
        } else {
            ldp.append("[Warning: Draw object ignored]");
        }
    }

    private void handleDrawObject(Element node, LaTeXDocumentPortion ldp, Context oc) {
        block21: {
            String sHref = Misc.getAttribute(node, "xlink:href");
            if (sHref != null) {
                if (this.ofr.isInPackage(sHref)) {
                    EmbeddedObject object;
                    if (sHref.startsWith("#")) {
                        sHref = sHref.substring(1);
                    }
                    if (sHref.startsWith("./")) {
                        sHref = sHref.substring(2);
                    }
                    if ((object = this.palette.getEmbeddedObject(sHref)) != null) {
                        if ("application/vnd.sun.xml.math".equals(object.getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType())) {
                            try {
                                String sLaTeX;
                                Document settings = ((EmbeddedXMLObject)object).getSettingsDOM();
                                Document formuladoc = ((EmbeddedXMLObject)object).getContentDOM();
                                Element formula = Misc.getChildByTagName(formuladoc, "math");
                                if (formula == null) {
                                    formula = Misc.getChildByTagName(formuladoc, "math:math");
                                }
                                if (" ".equals(sLaTeX = this.palette.getMathmlCv().convert(settings, formula))) break block21;
                                ldp.append(" $").append(sLaTeX).append("$");
                                if (Character.isLetterOrDigit(OfficeReader.getNextChar(node))) {
                                    ldp.append(" ");
                                }
                            }
                            catch (SAXException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        } else {
                            Element replacementImage;
                            boolean bIgnore = true;
                            if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(node), "draw:image")) != null) {
                                this.handleDrawImage(replacementImage, ldp, oc);
                                bIgnore = false;
                            }
                            if (bIgnore) {
                                ldp.append("[Warning: object ignored]");
                            }
                        }
                    }
                }
            } else {
                Element formula = Misc.getChildByTagName(node, "math");
                if (formula == null) {
                    formula = Misc.getChildByTagName(node, "math:math");
                }
                if (formula != null) {
                    ldp.append(" $").append(this.palette.getMathmlCv().convert(null, formula)).append("$");
                    if (Character.isLetterOrDigit(OfficeReader.getNextChar(node))) {
                        ldp.append(" ");
                    }
                } else {
                    Element replacementImage;
                    boolean bIgnore = true;
                    if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(node), "draw:image")) != null) {
                        this.handleDrawImage(replacementImage, ldp, oc);
                        bIgnore = false;
                    }
                    if (bIgnore) {
                        ldp.append("[Warning: object ignored]");
                    }
                }
            }
        }
    }

    private void applyFigureFloat(BeforeAfter ba, Context oc) {
        if (this.config.floatFigures() && !oc.isInFrame() && !oc.isInTable()) {
            if (oc.isInMulticols()) {
                ba.add("\\begin{figure*}", "\\end{figure*}\n");
            } else {
                ba.add("\\begin{figure}", "\\end{figure}\n");
            }
            if (this.config.getFloatOptions().length() > 0) {
                ba.add("[" + this.config.getFloatOptions() + "]", "");
            }
            ba.add("\n", "");
            oc.setInFigureFloat(true);
        }
        if (!oc.isInFrame() && this.config.alignFrames()) {
            if (this.config.floatFigures()) {
                ba.add("\\centering\n", "\n");
            } else {
                ba.add("\\begin{center}\n", "\n\\end{center}\n");
            }
        }
    }

    private void handleDrawImage(Element node, LaTeXDocumentPortion ldp, Context oc) {
        switch (this.config.imageContent()) {
            case 0: {
                return;
            }
            case 2: {
                System.err.println("Warning: Images are not allowed");
                return;
            }
            case 3: {
                ldp.append("% Error in document: An image was ignored");
                return;
            }
        }
        Element frame = this.getFrame(node);
        String sName = frame.getAttribute("draw:name");
        this.palette.getFieldCv().addTarget(sName, "|graphic", ldp);
        String sAnchor = frame.getAttribute("text:anchor-type");
        StyleWithProperties style = this.ofr.getFrameStyle(Misc.getAttribute(frame, "draw:style-name"));
        if (style != null) {
            String sOOoLaTeX = style.getProperty("OOoLatexArgs");
            int n = 0;
            if (sOOoLaTeX != null) {
                n = sOOoLaTeX.indexOf("\u00a7display\u00a7");
                if (n > -1) {
                    ldp.append("\\[").append(sOOoLaTeX.substring(n + 9)).append("\\]");
                    this.bNeedOOoLaTeXPreamble = true;
                    return;
                }
                n = sOOoLaTeX.indexOf("\u00a7inline\u00a7");
                if (n > -1) {
                    ldp.append("$").append(sOOoLaTeX.substring(n + 8)).append("$");
                    this.bNeedOOoLaTeXPreamble = true;
                    return;
                }
                n = sOOoLaTeX.indexOf("\u00a7text\u00a7");
                if (n > -1) {
                    ldp.append(sOOoLaTeX.substring(n + 6));
                    this.bNeedOOoLaTeXPreamble = true;
                    return;
                }
            }
        }
        if ("as-char".equals(sAnchor)) {
            this.handleDrawImageAsChar(node, ldp, oc);
        } else {
            this.floatingFramesStack.peek().add(node);
        }
    }

    private void handleDrawImageAsChar(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append(" ");
        this.includeGraphics(node, ldp, oc);
        ldp.append(" ");
    }

    private void handleDrawImageFloat(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        BeforeAfter ba = new BeforeAfter();
        this.applyFigureFloat(ba, ic);
        ldp.append(ba.getBefore());
        this.includeGraphics(node, ldp, ic);
        ldp.append(ba.getAfter());
    }

    private void includeGraphics(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFileName = null;
        boolean bCommentOut = true;
        String sHref = node.getAttribute("xlink:href");
        if (sHref.length() > 0 && !this.ofr.isInPackage(sHref)) {
            sFileName = this.ofr.fixRelativeLink(sHref);
            int nExtStart = sHref.lastIndexOf(".");
            String sExt = nExtStart >= 0 ? sHref.substring(nExtStart).toLowerCase() : "";
            bCommentOut = !(sFileName.indexOf(":") <= -1 && (this.config.getBackend() == 3 || this.config.getBackend() == 2 && ".jpg".equals(sExt) || this.config.getBackend() == 2 && ".png".equals(sExt) || this.config.getBackend() == 2 && ".pdf".equals(sExt) || this.config.getBackend() == 4 && ".jpg".equals(sExt) || this.config.getBackend() == 4 && ".png".equals(sExt) || this.config.getBackend() == 4 && ".pdf".equals(sExt) || this.config.getBackend() == 1 && ".eps".equals(sExt)));
        } else {
            BinaryGraphicsDocument bgd = this.palette.getImageLoader().getImage(node);
            if (bgd != null) {
                this.palette.addDocument(bgd);
                sFileName = bgd.getFileName();
                String sMIME = bgd.getDocumentMIMEType();
                boolean bl = bCommentOut = !(this.config.getBackend() == 3 || this.config.getBackend() == 2 && "image/jpeg".equals(sMIME) || this.config.getBackend() == 2 && "image/png".equals(sMIME) || this.config.getBackend() == 2 && "application/pdf".equals(sMIME) || this.config.getBackend() == 4 && "image/jpeg".equals(sMIME) || this.config.getBackend() == 4 && "image/png".equals(sMIME) || this.config.getBackend() == 4 && "application/pdf".equals(sMIME) || this.config.getBackend() == 1 && "image/x-eps".equals(sMIME));
            }
        }
        if (sFileName == null) {
            ldp.append("[Warning: Image not found]");
            return;
        }
        this.bNeedGraphicx = true;
        if (bCommentOut) {
            ldp.append(" [Warning: Image ignored] ");
            ldp.append("% Unhandled or unsupported graphics:").nl().append("%");
        }
        ldp.append("\\includegraphics");
        CSVList options = new CSVList(',');
        if (!this.config.originalImageSize()) {
            Element frame = this.getFrame(node);
            String sWidth = Misc.truncateLength(frame.getAttribute("svg:width"));
            String sHeight = Misc.truncateLength(frame.getAttribute("svg:height"));
            if (sWidth != null) {
                options.addValue("width=" + sWidth);
            }
            if (sHeight != null) {
                options.addValue("height=" + sHeight);
            }
        }
        if (this.config.getImageOptions().length() > 0) {
            options.addValue(this.config.getImageOptions());
        }
        if (!options.isEmpty()) {
            ldp.append("[").append(options.toString()).append("]");
        }
        if (this.config.removeGraphicsExtension()) {
            sFileName = Misc.removeExtension(sFileName);
        }
        ldp.append("{").append(sFileName).append("}");
        if (bCommentOut) {
            ldp.nl();
        }
    }

    private void handleDrawTextBox(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Element frame = this.getFrame(node);
        String sName = frame.getAttribute("draw:name");
        this.palette.getFieldCv().addTarget(sName, "|frame", ldp);
        String sAnchor = frame.getAttribute("text:anchor-type");
        if ("as-char".equals(sAnchor)) {
            this.makeDrawTextBox(node, ldp, oc);
        } else {
            this.floatingFramesStack.peek().add(node);
        }
    }

    private void handleDrawTextBoxFloat(Element node, LaTeXDocumentPortion ldp, Context oc) {
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.applyFigureFloat(ba, ic);
        ldp.append(ba.getBefore());
        this.makeDrawTextBox(node, ldp, ic);
        ldp.append(ba.getAfter());
    }

    private void makeDrawTextBox(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Element par;
        String sSeqName;
        Context ic = (Context)oc.clone();
        ic.setInFrame(true);
        ic.setNoFootnotes(true);
        boolean bIsCaption = false;
        if (OfficeReader.isSingleParagraph(node) && this.ofr.isFigureSequenceName(sSeqName = this.ofr.getSequenceName(par = Misc.getFirstChildElement(node)))) {
            bIsCaption = true;
        }
        String sWidth = Misc.truncateLength(this.getFrame(node).getAttribute("svg:width"));
        if (!bIsCaption) {
            ldp.append("\\begin{minipage}{").append(sWidth).append("}").nl();
        }
        this.floatingFramesStack.push(new LinkedList());
        this.palette.getBlockCv().traverseBlockText(node, ldp, ic);
        this.flushFloatingFrames(ldp, ic);
        this.floatingFramesStack.pop();
        if (!bIsCaption) {
            ldp.append("\\end{minipage}");
        }
        if (!oc.isNoFootnotes()) {
            this.palette.getNoteCv().flushFootnotes(ldp, oc);
        }
    }

    public void flushFloatingFrames(LaTeXDocumentPortion ldp, Context oc) {
        LinkedList<Element> floatingFrames = this.floatingFramesStack.peek();
        int n = floatingFrames.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element node = floatingFrames.get(i);
            String sName = node.getNodeName();
            if (sName.equals("draw:image")) {
                this.handleDrawImageFloat(node, ldp, oc);
                continue;
            }
            if (!sName.equals("draw:text-box")) continue;
            this.handleDrawTextBoxFloat(node, ldp, oc);
        }
        floatingFrames.clear();
    }
}

