/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.bibtex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.api.ConverterFactory;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.i18n.I18n;
import writer2latex.office.BibMark;
import writer2latex.util.ExportNameCollection;
import writer2latex.xmerge.Document;

public class BibTeXDocument
implements Document {
    private static final String FILE_EXTENSION = ".bib";
    private String sName;
    private Hashtable<String, BibMark> entries = new Hashtable();
    private ExportNameCollection exportNames = new ExportNameCollection("", true, "_-:");
    private I18n i18n;
    private boolean bIsMaster;

    public BibTeXDocument(String sName, boolean bIsMaster) {
        this.sName = this.trimDocumentName(sName);
        this.bIsMaster = bIsMaster;
        this.i18n = new ClassicI18n(new LaTeXConfig());
    }

    @Override
    public void read(InputStream is) throws IOException {
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public String getFileName() {
        return new String(this.sName + FILE_EXTENSION);
    }

    @Override
    public String getMIMEType() {
        return "application/x-bibtex";
    }

    @Override
    public boolean isMasterDocument() {
        return this.bIsMaster;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "ASCII");
        osw.write("%% This file was converted to BibTeX by Writer2BibTeX ver. " + ConverterFactory.getVersion() + ".\n");
        osw.write("%% See http://writer2latex.sourceforge.net for more info.\n");
        osw.write("\n");
        Enumeration<BibMark> enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            BibMark entry = enumeration.nextElement();
            osw.write("@");
            osw.write(entry.getEntryType().toUpperCase());
            osw.write("{");
            osw.write(this.exportNames.getExportName(entry.getIdentifier()));
            osw.write(",\n");
            for (int i = 0; i < 31; ++i) {
                String sValue = entry.getField(i);
                if (sValue == null) continue;
                if (i == 2 || i == 7) {
                    sValue = sValue.replaceAll(";", " and ");
                }
                osw.write("    ");
                osw.write(BibTeXDocument.getFieldName(i).toUpperCase());
                osw.write(" = {");
                for (int j = 0; j < sValue.length(); ++j) {
                    String s = this.i18n.convert(Character.toString(sValue.charAt(j)), false, "en");
                    if (s.charAt(0) == '\\') {
                        osw.write("{");
                    }
                    osw.write(s);
                    if (s.charAt(0) != '\\') continue;
                    osw.write("}");
                }
                osw.write("},\n");
            }
            osw.write("}\n\n");
        }
        osw.flush();
        osw.close();
    }

    public static final String getFieldName(int nField) {
        switch (nField) {
            case 0: {
                return "address";
            }
            case 1: {
                return "annote";
            }
            case 2: {
                return "author";
            }
            case 3: {
                return "booktitle";
            }
            case 4: {
                return "chapter";
            }
            case 6: {
                return "edition";
            }
            case 7: {
                return "editor";
            }
            case 8: {
                return "howpublished";
            }
            case 9: {
                return "institution";
            }
            case 10: {
                return "journal";
            }
            case 12: {
                return "month";
            }
            case 13: {
                return "note";
            }
            case 14: {
                return "number";
            }
            case 15: {
                return "organization";
            }
            case 16: {
                return "pages";
            }
            case 17: {
                return "publisher";
            }
            case 18: {
                return "school";
            }
            case 19: {
                return "series";
            }
            case 20: {
                return "title";
            }
            case 21: {
                return "type";
            }
            case 22: {
                return "volume";
            }
            case 23: {
                return "year";
            }
            case 24: {
                return "url";
            }
            case 25: {
                return "custom1";
            }
            case 26: {
                return "custom2";
            }
            case 27: {
                return "custom3";
            }
            case 28: {
                return "custom4";
            }
            case 29: {
                return "custom5";
            }
            case 30: {
                return "isbn";
            }
        }
        return null;
    }

    public boolean containsKey(String sIdentifier) {
        return this.entries.containsKey(sIdentifier);
    }

    public void put(BibMark entry) {
        this.entries.put(entry.getIdentifier(), entry);
        this.exportNames.addName(entry.getIdentifier());
    }

    public String getExportName(String sIdentifier) {
        return this.exportNames.getExportName(sIdentifier);
    }

    private String trimDocumentName(String name) {
        String temp = name.toLowerCase();
        if (temp.endsWith(FILE_EXTENSION)) {
            int nlen = name.length();
            int endIndex = nlen - FILE_EXTENSION.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }
}

