/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.api.ComplexOption;
import writer2latex.api.Config;
import writer2latex.base.Option;
import writer2latex.xmerge.NewDOMDocument;

public abstract class ConfigBase
implements Config {
    protected Option[] options = new Option[this.getOptionCount()];
    protected Map<String, ComplexOption> optionGroups = new HashMap<String, ComplexOption>();

    protected abstract int getOptionCount();

    protected abstract String getDefaultConfigPath();

    @Override
    public void setOption(String sName, String sValue) {
        if (sName != null && sValue != null) {
            for (int j = 0; j < this.getOptionCount(); ++j) {
                if (!sName.equals(this.options[j].getName())) continue;
                this.options[j].setString(sValue);
                break;
            }
        }
    }

    @Override
    public String getOption(String sName) {
        if (sName != null) {
            for (int j = 0; j < this.getOptionCount(); ++j) {
                if (!sName.equals(this.options[j].getName())) continue;
                return this.options[j].getString();
            }
        }
        return null;
    }

    @Override
    public ComplexOption getComplexOption(String sGroup) {
        return this.optionGroups.get(sGroup);
    }

    protected ComplexOption addComplexOption(String sGroup) {
        this.optionGroups.put(sGroup, new ComplexOption());
        return this.optionGroups.get(sGroup);
    }

    @Override
    public void readDefaultConfig(String sName) throws IllegalArgumentException {
        InputStream is = this.getClass().getResourceAsStream(this.getDefaultConfigPath() + sName);
        if (is == null) {
            throw new IllegalArgumentException("The internal configuration '" + sName + "' does not exist");
        }
        try {
            this.read(is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The internal configuration '" + sName + "' is invalid");
        }
    }

    @Override
    public void read(InputStream is) throws IOException {
        NewDOMDocument doc = new NewDOMDocument("config", ".xml");
        doc.read(is);
        Document dom = doc.getContentDOM();
        if (dom == null) {
            throw new IOException("Failed to parse configuration");
        }
        Element root = dom.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element elm = (Element)child;
            if (elm.getTagName().equals("option")) {
                String sName = elm.getAttribute("name");
                String sValue = elm.getAttribute("value");
                if (sName == "") continue;
                this.setOption(sName, sValue);
                continue;
            }
            this.readInner(elm);
        }
    }

    @Override
    public void read(File file) throws IOException {
        this.read(new FileInputStream(file));
    }

    protected abstract void readInner(Element var1);

    @Override
    public void write(OutputStream os) throws IOException {
        NewDOMDocument doc = new NewDOMDocument("config", ".xml");
        Document dom = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            dom = domImpl.createDocument("", "config", null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Element rootElement = dom.getDocumentElement();
        for (int i = 0; i < this.getOptionCount(); ++i) {
            Element optionNode = dom.createElement("option");
            optionNode.setAttribute("name", this.options[i].getName());
            optionNode.setAttribute("value", this.options[i].getString());
            rootElement.appendChild(optionNode);
        }
        this.writeInner(dom);
        doc.setContentDOM(dom);
        doc.write(os);
    }

    @Override
    public void write(File file) throws IOException {
        this.write(new FileOutputStream(file));
    }

    protected abstract void writeInner(Document var1);
}

