#ifndef RENDER_HPP
#define RENDER_HPP

#include <string>
#include <vector>
#include <pthread.h>
#include "inkview.h"
extern "C" {
#include "fitz-internal.h"
}
#include "utils.hpp"

using namespace std;

struct cbox_params
{
    bool drop_text;
    bool drop_images;
    fz_rect bbox;
    fz_rect cbox;
    cbox_params(bool _drop_images, bool _drop_text, fz_rect _bbox)
    {
        drop_images = _drop_images;
        drop_text = _drop_text;
        bbox = _bbox;
        cbox = fz_empty_rect;
    }
};

fz_device* fz_new_cbox_device(fz_context* ctx, cbox_params* params);

struct pbook_params
{
    bool mono;
    bool drop_text;
    bool drop_images;
    fz_device* canvas;
    pbook_params(bool _mono, bool _drop_images, bool _drop_text, fz_device* _canvas)
    {
        mono = _mono;
        drop_images = _drop_images;
        drop_text = _drop_text;
        canvas = _canvas;
    }
};

fz_device* fz_new_pbook_device(fz_context* ctx, pbook_params* params);

struct TTOCEntry
{
    int Level;
    int PageNum;
    string Caption;
    TTOCEntry() { }
    TTOCEntry(int aLevel, int aPageNum, const string& aCaption)
    {
        Level = aLevel;
        PageNum = aPageNum;
        Caption = aCaption;
    }
};

class TRender
{
private:
    fz_cookie FCtl; //parser control structure
    fz_context* FCtx;
    fz_document* FDoc;
    int FBufWidth, FBufHeight;
    unsigned char* FBuf;
    fz_rect FCBox; //contents bounding rect
    fz_irect FIBox; //image rect

    int FPageCount;

    void Start() { memset(&FCtl, 0, sizeof(FCtl)); }
public:
    int GetPageCount() { return FPageCount; }

    void LoadFile(const string& aFileName);
    void CloseFile();
    void RenderPage(int aPageIdx, int W, int H, int A, bool aDropImages, bool aDropText, bool aDropMargins);
    ibitmap* GetPage(TMemAlloc* aMalloc, irect *aCBox);
    void Abort() { FCtl.abort = true; }

    void LoadTOC(vector<TTOCEntry*>& aTOC);

    TRender();
    ~TRender();
};

struct TPrefetch
{
    pthread_t tid;
    TRender* Render;
    int PageIdx;
    int W;
    int H;
    int A;
    bool DropImages;
    bool DropText;
    bool DropMargins;
    bool Valid(int aPageIdx, int aW, int aH, int aA, bool aDropImages, bool aDropText, bool aDropMargins);
    void Abort();
    void Wait();
    TPrefetch(TRender* aRender, int aPageIdx, int aW, int aH, int aA, bool aDropImages, bool aDropText, bool aDropMargins);
};

#endif // RENDER_HPP
