#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

NEWDIR=$(date +"notepad-%Y-%m-%d-%H-%M-%S")
mkdir ../$NEWDIR
NEWDIR="../$NEWDIR"
cp notepad.pdf $NEWDIR
cp kword.png $NEWDIR

cat <<EOF > $NEWDIR/manifest.xml
<?xml version="1.0" encoding="utf-8"?> 
<package> 
  <metadata> 
    <dc-metadata> 
      <Title>New notepad</Title> 
      <Description>$(date +"%Y-%m-%dT%H:%M:%S")</Description>
      <Date>2008-02-16T18:34:05</Date> 
    </dc-metadata> 
    <y-metadata>
      <startpage>notepad.pdf</startpage> 
      <image>kword.png</image> 
      <version>000</version> 
    <ItemSize>327680</ItemSize></y-metadata> 
  </metadata> 
</package> 
EOF

