#
# Autogenerated by Thrift Compiler
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
import evernote.edam.limits.ttypes


from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class PrivilegeLevel(object):
  """
  This enumeration defines the possible permission levels for a user.
  Free accounts will have a level of NORMAL and paid Premium accounts
  will have a level of PREMIUM.
  """
  NORMAL = 1
  PREMIUM = 3
  MANAGER = 7
  SUPPORT = 8
  ADMIN = 9

  _VALUES_TO_NAMES = {
    1: "NORMAL",
    3: "PREMIUM",
    7: "MANAGER",
    8: "SUPPORT",
    9: "ADMIN",
  }

  _NAMES_TO_VALUES = {
    "NORMAL": 1,
    "PREMIUM": 3,
    "MANAGER": 7,
    "SUPPORT": 8,
    "ADMIN": 9,
  }

class QueryFormat(object):
  """
  Every search query is specified as a sequence of characters.
  Currently, only the USER query format is supported.
  """
  USER = 1
  SEXP = 2

  _VALUES_TO_NAMES = {
    1: "USER",
    2: "SEXP",
  }

  _NAMES_TO_VALUES = {
    "USER": 1,
    "SEXP": 2,
  }

class NoteSortOrder(object):
  """
  This enumeration defines the possible sort ordering for notes when
  they are returned from a search result.
  """
  CREATED = 1
  UPDATED = 2
  RELEVANCE = 3
  UPDATE_SEQUENCE_NUMBER = 4
  TITLE = 5

  _VALUES_TO_NAMES = {
    1: "CREATED",
    2: "UPDATED",
    3: "RELEVANCE",
    4: "UPDATE_SEQUENCE_NUMBER",
    5: "TITLE",
  }

  _NAMES_TO_VALUES = {
    "CREATED": 1,
    "UPDATED": 2,
    "RELEVANCE": 3,
    "UPDATE_SEQUENCE_NUMBER": 4,
    "TITLE": 5,
  }

class PremiumOrderStatus(object):
  """
  This enumeration defines the possible states of a premium account
  
  NONE:    the user has never attempted to become a premium subscriber
  
  PENDING: the user has requested a premium account but their charge has not
    been confirmed
  
  ACTIVE:  the user has been charged and their premium account is in good
   standing
  
  FAILED:  the system attempted to charge the was denied. Their premium
    privileges have been revoked. We will periodically attempt to re-validate
    their order.
  
  CANCELLATION_PENDING: the user has requested that no further charges be made
    but the current account is still active.
  
  CANCELED: the premium account was canceled either because of failure to pay
    or user cancelation. No more attempts will be made to activate the account.
  """
  NONE = 0
  PENDING = 1
  ACTIVE = 2
  FAILED = 3
  CANCELLATION_PENDING = 4
  CANCELED = 5

  _VALUES_TO_NAMES = {
    0: "NONE",
    1: "PENDING",
    2: "ACTIVE",
    3: "FAILED",
    4: "CANCELLATION_PENDING",
    5: "CANCELED",
  }

  _NAMES_TO_VALUES = {
    "NONE": 0,
    "PENDING": 1,
    "ACTIVE": 2,
    "FAILED": 3,
    "CANCELLATION_PENDING": 4,
    "CANCELED": 5,
  }

class SharedNotebookPrivilegeLevel(object):
  """
  Privilege levels for accessing shared notebooks.
  
  READ_NOTEBOOK: Recipient is able to read the contents of the shared notebook
    but does to have access to information about other recipients of the
    notebook or the activity stream information.
  
  MODIFY_NOTEBOOK_PLUS_ACTIVITY: Recipient has rights to read and modify the contents
    of the shared notebook, including the right to move notes to the trash and to create
    notes in the notebook.  The recipient can also access information about other
    recipients and the activity stream.
  
  READ_NOTEBOOK_PLUS_ACTIVITY: Recipient has READ_NOTEBOOK rights and can also
    access information about other recipients and the activity stream.
  
  GROUP: If the user belongs to a group, such as a Business, that has a defined
    privilege level, use the privilege level of the group as the privilege for
    the individual.
  
  FULL_ACCESS: Recipient has full rights to the shared notebook and recipient lists,
    including privilege to revoke and create invitations and to change privilege
    levels on invitations for individuals.  This privilege level is primarily intended
    for use by individual shares.
  
  BUSINESS_FULL_ACCESS: Intended for use with Business Notebooks, a
  BUSINESS_FULL_ACCESS level is FULL_ACCESS with the additional rights to
  change how the notebook will appear in the business library, including the
  rights to publish and unpublish the notebook from the library.
  """
  READ_NOTEBOOK = 0
  MODIFY_NOTEBOOK_PLUS_ACTIVITY = 1
  READ_NOTEBOOK_PLUS_ACTIVITY = 2
  GROUP = 3
  FULL_ACCESS = 4
  BUSINESS_FULL_ACCESS = 5

  _VALUES_TO_NAMES = {
    0: "READ_NOTEBOOK",
    1: "MODIFY_NOTEBOOK_PLUS_ACTIVITY",
    2: "READ_NOTEBOOK_PLUS_ACTIVITY",
    3: "GROUP",
    4: "FULL_ACCESS",
    5: "BUSINESS_FULL_ACCESS",
  }

  _NAMES_TO_VALUES = {
    "READ_NOTEBOOK": 0,
    "MODIFY_NOTEBOOK_PLUS_ACTIVITY": 1,
    "READ_NOTEBOOK_PLUS_ACTIVITY": 2,
    "GROUP": 3,
    "FULL_ACCESS": 4,
    "BUSINESS_FULL_ACCESS": 5,
  }

class SponsoredGroupRole(object):
  """
  Enumeration of the roles that a User can have within a sponsored group.
  
  GROUP_MEMBER: The user is a member of the group with no special privileges.
  
  GROUP_ADMIN: The user is an administrator within the group.
  
  GROUP_OWNER: The user is the owner of the group.
  """
  GROUP_MEMBER = 1
  GROUP_ADMIN = 2
  GROUP_OWNER = 3

  _VALUES_TO_NAMES = {
    1: "GROUP_MEMBER",
    2: "GROUP_ADMIN",
    3: "GROUP_OWNER",
  }

  _NAMES_TO_VALUES = {
    "GROUP_MEMBER": 1,
    "GROUP_ADMIN": 2,
    "GROUP_OWNER": 3,
  }

class BusinessUserRole(object):
  """
  Enumeration of the roles that a User can have within an Evernote Business account.
  
  ADMIN: The user is an administrator of the Evernote Business account.
  
  NORMAL: The user is a regular user within the Evernote Business account.
  """
  ADMIN = 1
  NORMAL = 2

  _VALUES_TO_NAMES = {
    1: "ADMIN",
    2: "NORMAL",
  }

  _NAMES_TO_VALUES = {
    "ADMIN": 1,
    "NORMAL": 2,
  }

class SharedNotebookInstanceRestrictions(object):
  """
  An enumeration describing restrictions on the domain of shared notebook
  instances that are valid for a given operation, as used, for example, in
  NotebookRestrictions.
  
  ONLY_JOINED_OR_PREVIEW: The domain consists of shared notebooks that
    "belong" to the recipient or still available for preview by any recipient.
    Shared notebooks that the recipient has joined (the username has already been
    assigned to our user) are in the domain.  Additionally, shared notebooks
    that allow preview and have not yet been joined are in the domain.
  
  NO_SHARED_NOTEBOOKS: No shared notebooks are applicable to the operation.
  """
  ONLY_JOINED_OR_PREVIEW = 1
  NO_SHARED_NOTEBOOKS = 2

  _VALUES_TO_NAMES = {
    1: "ONLY_JOINED_OR_PREVIEW",
    2: "NO_SHARED_NOTEBOOKS",
  }

  _NAMES_TO_VALUES = {
    "ONLY_JOINED_OR_PREVIEW": 1,
    "NO_SHARED_NOTEBOOKS": 2,
  }


class Data(object):
  """
   In several places, EDAM exchanges blocks of bytes of data for a component
   which may be relatively large.  For example:  the contents of a clipped
   HTML note, the bytes of an embedded image, or the recognition XML for
   a large image.  This structure is used in the protocol to represent
   any of those large blocks of data when they are transmitted or when
   they are only referenced their metadata.
  
  <dl>
   <dt>bodyHash</dt>
     <dd>This field carries a one-way hash of the contents of the
     data body, in binary form.  The hash function is MD5<br/>
     Length:  EDAM_HASH_LEN (exactly)
     </dd>
  
   <dt>size</dt>
     <dd>The length, in bytes, of the data body.
     </dd>
  
   <dt>body</dt>
     <dd>This field is set to contain the binary contents of the data
     whenever the resource is being transferred.  If only metadata is
     being exchanged, this field will be empty.  For example, a client could
     notify the service about the change to an attribute for a resource
     without transmitting the binary resource contents.
     </dd>
   </dl>
  
  Attributes:
   - bodyHash
   - size
   - body
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'bodyHash', None, None, ), # 1
    (2, TType.I32, 'size', None, None, ), # 2
    (3, TType.STRING, 'body', None, None, ), # 3
  )

  def __init__(self, bodyHash=None, size=None, body=None,):
    self.bodyHash = bodyHash
    self.size = size
    self.body = body

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.bodyHash = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.size = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.body = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Data')
    if self.bodyHash is not None:
      oprot.writeFieldBegin('bodyHash', TType.STRING, 1)
      oprot.writeString(self.bodyHash)
      oprot.writeFieldEnd()
    if self.size is not None:
      oprot.writeFieldBegin('size', TType.I32, 2)
      oprot.writeI32(self.size)
      oprot.writeFieldEnd()
    if self.body is not None:
      oprot.writeFieldBegin('body', TType.STRING, 3)
      oprot.writeString(self.body)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class UserAttributes(object):
  """
   A structure holding the optional attributes that can be stored
   on a User.  These are generally less critical than the core User fields.
  
  <dl>
   <dt>defaultLocationName</dt>
     <dd>the location string that should be associated
     with the user in order to determine where notes are taken if not otherwise
     specified.<br/>
     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
     </dd>
  
   <dt>defaultLatitude</dt>
     <dd>if set, this is the latitude that should be
     assigned to any notes that have no other latitude information.
     </dd>
  
   <dt>defaultLongitude</dt>
     <dd>if set, this is the longitude that should be
     assigned to any notes that have no other longitude information.
     </dd>
  
   <dt>preactivation</dt>
     <dd>if set, the user account is not yet confirmed for
     login.  I.e. the account has been created, but we are still waiting for
     the user to complete the activation step.
     </dd>
  
   <dt>viewedPromotions</dt>
     <dd>a list of promotions the user has seen.
      This list may occasionally be modified by the system when promotions are
      no longer available.<br/>
      Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
     </dd>
  
   <dt>incomingEmailAddress</dt>
     <dd>if set, this is the email address that the
      user may send email to in order to add an email note directly into the
      account via the SMTP email gateway.  This is the part of the email
      address before the '@' symbol ... our domain is not included.
      If this is not set, the user may not add notes via the gateway.<br/>
      Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
     </dd>
  
   <dt>recentMailedAddresses</dt>
     <dd>if set, this will contain a list of email
      addresses that have recently been used as recipients
      of outbound emails by the user.  This can be used to pre-populate a
      list of possible destinations when a user wishes to send a note via
      email.<br/>
      Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX each<br/>
      Max:  EDAM_USER_RECENT_MAILED_ADDRESSES_MAX entries
     </dd>
  
   <dt>comments</dt>
     <dd>Free-form text field that may hold general support
      information, etc.<br/>
      Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
     </dd>
  
   <dt>dateAgreedToTermsOfService</dt>
     <dd>The date/time when the user agreed to
      the terms of service.  This can be used as the effective "start date"
      for the account.
     </dd>
  
   <dt>maxReferrals</dt>
     <dd>The number of referrals that the user is permitted
      to make.
     </dd>
  
   <dt>referralCount</dt>
     <dd>The number of referrals sent from this account.
     </dd>
  
   <dt>refererCode</dt>
     <dd>A code indicating where the user was sent from. AKA
      promotion code
     </dd>
  
   <dt>sentEmailDate</dt>
     <dd>The most recent date when the user sent outbound
      emails from the service.  Used with sentEmailCount to limit the number
      of emails that can be sent per day.
     </dd>
  
   <dt>sentEmailCount</dt>
     <dd>The number of emails that were sent from the user
      via the service on sentEmailDate.  Used to enforce a limit on the number
      of emails per user per day to prevent spamming.
     </dd>
  
   <dt>dailyEmailLimit</dt>
     <dd>If set, this is the maximum number of emails that
      may be sent in a given day from this account.  If unset, the server will
      use the configured default limit.
     </dd>
  
   <dt>emailOptOutDate</dt>
     <dd>If set, this is the date when the user asked
      to be excluded from offers and promotions sent by Evernote.  If not set,
      then the user currently agrees to receive these messages.
     </dd>
  
   <dt>partnerEmailOptInDate</dt>
     <dd>If set, this is the date when the user asked
      to be included in offers and promotions sent by Evernote's partners.
      If not sent, then the user currently does not agree to receive these
      emails.
     </dd>
  
   <dt>preferredLanguage</dt>
     <dd>a 2 character language codes based on:
         http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt used for
        localization purposes to determine what language to use for the web
        interface and for other direct communication (e.g. emails).
     </dd>
  
   <dt>preferredCountry</dt>
     <dd>Preferred country code based on ISO 3166-1-alpha-2 indicating the
     users preferred country</dd>
  
   <dt>clipFullPage</dt>
     <dd>Boolean flag set to true if the user wants to clip full pages by
     default when they use the web clipper without a selection.</dd>
  
   <dt>twitterUserName</dt>
     <dd>The username of the account of someone who has chosen to enable
     Twittering into Evernote.  This value is subject to change, since users
     may change their Twitter user name.</dd>
  
   <dt>twitterId</dt>
     <dd>The unique identifier of the user's Twitter account if that user
     has chosen to enable Twittering into Evernote.</dd>
  
   <dt>groupName</dt>
     <dd>A name identifier used to identify a particular set of branding and
      light customization.</dd>
  
   <dt>recognitionLanguage</dt>
     <dd>a 2 character language codes based on:
         http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt
         If set, this is used to determine the language that should be used
         when processing images and PDF files to find text.
         If not set, then the 'preferredLanguage' will be used.
     </dd>
  
   <dt>customerProfileId</dt>
     <dd>a numeric identified which provides a linkage between the user record
         and the direct credit card payment creditcard profile.
     </dd>
  
   <dt>educationalInstitution</dt>
     <dd>a flag indicating that the user is part of an educational institution which
     makes them eligible for discounts on bulk purchases
     </dd>
  
   <dt>businessAddress</dt>
     <dd>A string recording the business address of a Sponsored Account user who has requested invoicing.
     </dd>
   </dl>
  
   <dt>hideSponsorBilling</dt>
     <dd>A flag indicating whether to hide the billing information on a sponsored
         account owner's settings page
     </dd>
   </dl>
  
   <dt>taxExempt</dt>
     <dd>A flag indicating the user's sponsored group is exempt from sale tax
     </dd>
   </dl>
  
  Attributes:
   - defaultLocationName
   - defaultLatitude
   - defaultLongitude
   - preactivation
   - viewedPromotions
   - incomingEmailAddress
   - recentMailedAddresses
   - comments
   - dateAgreedToTermsOfService
   - maxReferrals
   - referralCount
   - refererCode
   - sentEmailDate
   - sentEmailCount
   - dailyEmailLimit
   - emailOptOutDate
   - partnerEmailOptInDate
   - preferredLanguage
   - preferredCountry
   - clipFullPage
   - twitterUserName
   - twitterId
   - groupName
   - recognitionLanguage
   - customerProfileId
   - referralProof
   - educationalDiscount
   - businessAddress
   - hideSponsorBilling
   - taxExempt
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'defaultLocationName', None, None, ), # 1
    (2, TType.DOUBLE, 'defaultLatitude', None, None, ), # 2
    (3, TType.DOUBLE, 'defaultLongitude', None, None, ), # 3
    (4, TType.BOOL, 'preactivation', None, None, ), # 4
    (5, TType.LIST, 'viewedPromotions', (TType.STRING,None), None, ), # 5
    (6, TType.STRING, 'incomingEmailAddress', None, None, ), # 6
    (7, TType.LIST, 'recentMailedAddresses', (TType.STRING,None), None, ), # 7
    None, # 8
    (9, TType.STRING, 'comments', None, None, ), # 9
    None, # 10
    (11, TType.I64, 'dateAgreedToTermsOfService', None, None, ), # 11
    (12, TType.I32, 'maxReferrals', None, None, ), # 12
    (13, TType.I32, 'referralCount', None, None, ), # 13
    (14, TType.STRING, 'refererCode', None, None, ), # 14
    (15, TType.I64, 'sentEmailDate', None, None, ), # 15
    (16, TType.I32, 'sentEmailCount', None, None, ), # 16
    (17, TType.I32, 'dailyEmailLimit', None, None, ), # 17
    (18, TType.I64, 'emailOptOutDate', None, None, ), # 18
    (19, TType.I64, 'partnerEmailOptInDate', None, None, ), # 19
    (20, TType.STRING, 'preferredLanguage', None, None, ), # 20
    (21, TType.STRING, 'preferredCountry', None, None, ), # 21
    (22, TType.BOOL, 'clipFullPage', None, None, ), # 22
    (23, TType.STRING, 'twitterUserName', None, None, ), # 23
    (24, TType.STRING, 'twitterId', None, None, ), # 24
    (25, TType.STRING, 'groupName', None, None, ), # 25
    (26, TType.STRING, 'recognitionLanguage', None, None, ), # 26
    (27, TType.I64, 'customerProfileId', None, None, ), # 27
    (28, TType.STRING, 'referralProof', None, None, ), # 28
    (29, TType.BOOL, 'educationalDiscount', None, None, ), # 29
    (30, TType.STRING, 'businessAddress', None, None, ), # 30
    (31, TType.BOOL, 'hideSponsorBilling', None, None, ), # 31
    (32, TType.BOOL, 'taxExempt', None, None, ), # 32
  )

  def __init__(self, defaultLocationName=None, defaultLatitude=None, defaultLongitude=None, preactivation=None, viewedPromotions=None, incomingEmailAddress=None, recentMailedAddresses=None, comments=None, dateAgreedToTermsOfService=None, maxReferrals=None, referralCount=None, refererCode=None, sentEmailDate=None, sentEmailCount=None, dailyEmailLimit=None, emailOptOutDate=None, partnerEmailOptInDate=None, preferredLanguage=None, preferredCountry=None, clipFullPage=None, twitterUserName=None, twitterId=None, groupName=None, recognitionLanguage=None, customerProfileId=None, referralProof=None, educationalDiscount=None, businessAddress=None, hideSponsorBilling=None, taxExempt=None,):
    self.defaultLocationName = defaultLocationName
    self.defaultLatitude = defaultLatitude
    self.defaultLongitude = defaultLongitude
    self.preactivation = preactivation
    self.viewedPromotions = viewedPromotions
    self.incomingEmailAddress = incomingEmailAddress
    self.recentMailedAddresses = recentMailedAddresses
    self.comments = comments
    self.dateAgreedToTermsOfService = dateAgreedToTermsOfService
    self.maxReferrals = maxReferrals
    self.referralCount = referralCount
    self.refererCode = refererCode
    self.sentEmailDate = sentEmailDate
    self.sentEmailCount = sentEmailCount
    self.dailyEmailLimit = dailyEmailLimit
    self.emailOptOutDate = emailOptOutDate
    self.partnerEmailOptInDate = partnerEmailOptInDate
    self.preferredLanguage = preferredLanguage
    self.preferredCountry = preferredCountry
    self.clipFullPage = clipFullPage
    self.twitterUserName = twitterUserName
    self.twitterId = twitterId
    self.groupName = groupName
    self.recognitionLanguage = recognitionLanguage
    self.customerProfileId = customerProfileId
    self.referralProof = referralProof
    self.educationalDiscount = educationalDiscount
    self.businessAddress = businessAddress
    self.hideSponsorBilling = hideSponsorBilling
    self.taxExempt = taxExempt

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.defaultLocationName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.DOUBLE:
          self.defaultLatitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.DOUBLE:
          self.defaultLongitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.preactivation = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.viewedPromotions = []
          (_etype3, _size0) = iprot.readListBegin()
          for _i4 in xrange(_size0):
            _elem5 = iprot.readString();
            self.viewedPromotions.append(_elem5)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.incomingEmailAddress = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.LIST:
          self.recentMailedAddresses = []
          (_etype9, _size6) = iprot.readListBegin()
          for _i10 in xrange(_size6):
            _elem11 = iprot.readString();
            self.recentMailedAddresses.append(_elem11)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRING:
          self.comments = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.I64:
          self.dateAgreedToTermsOfService = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.I32:
          self.maxReferrals = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.I32:
          self.referralCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRING:
          self.refererCode = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.I64:
          self.sentEmailDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.I32:
          self.sentEmailCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.I32:
          self.dailyEmailLimit = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 18:
        if ftype == TType.I64:
          self.emailOptOutDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 19:
        if ftype == TType.I64:
          self.partnerEmailOptInDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 20:
        if ftype == TType.STRING:
          self.preferredLanguage = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 21:
        if ftype == TType.STRING:
          self.preferredCountry = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 22:
        if ftype == TType.BOOL:
          self.clipFullPage = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 23:
        if ftype == TType.STRING:
          self.twitterUserName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 24:
        if ftype == TType.STRING:
          self.twitterId = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 25:
        if ftype == TType.STRING:
          self.groupName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 26:
        if ftype == TType.STRING:
          self.recognitionLanguage = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 27:
        if ftype == TType.I64:
          self.customerProfileId = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 28:
        if ftype == TType.STRING:
          self.referralProof = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 29:
        if ftype == TType.BOOL:
          self.educationalDiscount = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 30:
        if ftype == TType.STRING:
          self.businessAddress = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 31:
        if ftype == TType.BOOL:
          self.hideSponsorBilling = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 32:
        if ftype == TType.BOOL:
          self.taxExempt = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('UserAttributes')
    if self.defaultLocationName is not None:
      oprot.writeFieldBegin('defaultLocationName', TType.STRING, 1)
      oprot.writeString(self.defaultLocationName)
      oprot.writeFieldEnd()
    if self.defaultLatitude is not None:
      oprot.writeFieldBegin('defaultLatitude', TType.DOUBLE, 2)
      oprot.writeDouble(self.defaultLatitude)
      oprot.writeFieldEnd()
    if self.defaultLongitude is not None:
      oprot.writeFieldBegin('defaultLongitude', TType.DOUBLE, 3)
      oprot.writeDouble(self.defaultLongitude)
      oprot.writeFieldEnd()
    if self.preactivation is not None:
      oprot.writeFieldBegin('preactivation', TType.BOOL, 4)
      oprot.writeBool(self.preactivation)
      oprot.writeFieldEnd()
    if self.viewedPromotions is not None:
      oprot.writeFieldBegin('viewedPromotions', TType.LIST, 5)
      oprot.writeListBegin(TType.STRING, len(self.viewedPromotions))
      for iter12 in self.viewedPromotions:
        oprot.writeString(iter12)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.incomingEmailAddress is not None:
      oprot.writeFieldBegin('incomingEmailAddress', TType.STRING, 6)
      oprot.writeString(self.incomingEmailAddress)
      oprot.writeFieldEnd()
    if self.recentMailedAddresses is not None:
      oprot.writeFieldBegin('recentMailedAddresses', TType.LIST, 7)
      oprot.writeListBegin(TType.STRING, len(self.recentMailedAddresses))
      for iter13 in self.recentMailedAddresses:
        oprot.writeString(iter13)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.comments is not None:
      oprot.writeFieldBegin('comments', TType.STRING, 9)
      oprot.writeString(self.comments)
      oprot.writeFieldEnd()
    if self.dateAgreedToTermsOfService is not None:
      oprot.writeFieldBegin('dateAgreedToTermsOfService', TType.I64, 11)
      oprot.writeI64(self.dateAgreedToTermsOfService)
      oprot.writeFieldEnd()
    if self.maxReferrals is not None:
      oprot.writeFieldBegin('maxReferrals', TType.I32, 12)
      oprot.writeI32(self.maxReferrals)
      oprot.writeFieldEnd()
    if self.referralCount is not None:
      oprot.writeFieldBegin('referralCount', TType.I32, 13)
      oprot.writeI32(self.referralCount)
      oprot.writeFieldEnd()
    if self.refererCode is not None:
      oprot.writeFieldBegin('refererCode', TType.STRING, 14)
      oprot.writeString(self.refererCode)
      oprot.writeFieldEnd()
    if self.sentEmailDate is not None:
      oprot.writeFieldBegin('sentEmailDate', TType.I64, 15)
      oprot.writeI64(self.sentEmailDate)
      oprot.writeFieldEnd()
    if self.sentEmailCount is not None:
      oprot.writeFieldBegin('sentEmailCount', TType.I32, 16)
      oprot.writeI32(self.sentEmailCount)
      oprot.writeFieldEnd()
    if self.dailyEmailLimit is not None:
      oprot.writeFieldBegin('dailyEmailLimit', TType.I32, 17)
      oprot.writeI32(self.dailyEmailLimit)
      oprot.writeFieldEnd()
    if self.emailOptOutDate is not None:
      oprot.writeFieldBegin('emailOptOutDate', TType.I64, 18)
      oprot.writeI64(self.emailOptOutDate)
      oprot.writeFieldEnd()
    if self.partnerEmailOptInDate is not None:
      oprot.writeFieldBegin('partnerEmailOptInDate', TType.I64, 19)
      oprot.writeI64(self.partnerEmailOptInDate)
      oprot.writeFieldEnd()
    if self.preferredLanguage is not None:
      oprot.writeFieldBegin('preferredLanguage', TType.STRING, 20)
      oprot.writeString(self.preferredLanguage)
      oprot.writeFieldEnd()
    if self.preferredCountry is not None:
      oprot.writeFieldBegin('preferredCountry', TType.STRING, 21)
      oprot.writeString(self.preferredCountry)
      oprot.writeFieldEnd()
    if self.clipFullPage is not None:
      oprot.writeFieldBegin('clipFullPage', TType.BOOL, 22)
      oprot.writeBool(self.clipFullPage)
      oprot.writeFieldEnd()
    if self.twitterUserName is not None:
      oprot.writeFieldBegin('twitterUserName', TType.STRING, 23)
      oprot.writeString(self.twitterUserName)
      oprot.writeFieldEnd()
    if self.twitterId is not None:
      oprot.writeFieldBegin('twitterId', TType.STRING, 24)
      oprot.writeString(self.twitterId)
      oprot.writeFieldEnd()
    if self.groupName is not None:
      oprot.writeFieldBegin('groupName', TType.STRING, 25)
      oprot.writeString(self.groupName)
      oprot.writeFieldEnd()
    if self.recognitionLanguage is not None:
      oprot.writeFieldBegin('recognitionLanguage', TType.STRING, 26)
      oprot.writeString(self.recognitionLanguage)
      oprot.writeFieldEnd()
    if self.customerProfileId is not None:
      oprot.writeFieldBegin('customerProfileId', TType.I64, 27)
      oprot.writeI64(self.customerProfileId)
      oprot.writeFieldEnd()
    if self.referralProof is not None:
      oprot.writeFieldBegin('referralProof', TType.STRING, 28)
      oprot.writeString(self.referralProof)
      oprot.writeFieldEnd()
    if self.educationalDiscount is not None:
      oprot.writeFieldBegin('educationalDiscount', TType.BOOL, 29)
      oprot.writeBool(self.educationalDiscount)
      oprot.writeFieldEnd()
    if self.businessAddress is not None:
      oprot.writeFieldBegin('businessAddress', TType.STRING, 30)
      oprot.writeString(self.businessAddress)
      oprot.writeFieldEnd()
    if self.hideSponsorBilling is not None:
      oprot.writeFieldBegin('hideSponsorBilling', TType.BOOL, 31)
      oprot.writeBool(self.hideSponsorBilling)
      oprot.writeFieldEnd()
    if self.taxExempt is not None:
      oprot.writeFieldBegin('taxExempt', TType.BOOL, 32)
      oprot.writeBool(self.taxExempt)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Accounting(object):
  """
   This represents the bookkeeping information for the user's subscription.
  
  <dl>
   <dt>uploadLimit</dt>
     <dd>The number of bytes that can be uploaded to the account
     in the current month.  For new notes that are created, this is the length
     of the note content (in Unicode characters) plus the size of each resource
     (in bytes).  For edited notes, this is the the difference between the old
     length and the new length (if this is greater than 0) plus the size of
     each new resource.
     </dd>
   <dt>uploadLimitEnd</dt>
     <dd>The date and time when the current upload limit
     expires.  At this time, the monthly upload count reverts to 0 and a new
     limit is imposed.  This date and time is exclusive, so this is effectively
     the start of the new month.
     </dd>
   <dt>uploadLimitNextMonth</dt>
     <dd> When uploadLimitEnd is reached, the service
     will change uploadLimit to uploadLimitNextMonth. If a premium account is
     canceled, this mechanism will reset the quota appropriately.
     </dd>
   <dt>premiumServiceStatus</dt>
     <dd>Indicates the phases of a premium account
     during the billing process.
     </dd>
   <dt>premiumOrderNumber</dt>
     <dd>The order number used by the commerce system to
     process recurring payments
     </dd>
   <dt>premiumServiceStart</dt>
     <dd>The start date when this premium promotion
     began (this number will get overwritten if a premium service is canceled
     and then re-activated).
     </dd>
   <dt>premiumCommerceService</dt>
     <dd>The commerce system used (paypal, Google
     checkout, etc)
     </dd>
   <dt>premiumServiceSKU</dt>
     <dd>The code associated with the purchase eg. monthly
     or annual purchase. Clients should interpret this value and localize it.
     </dd>
   <dt>lastSuccessfulCharge</dt>
     <dd>Date the last time the user was charged.
     Null if never charged.
     </dd>
   <dt>lastFailedCharge</dt>
     <dd>Date the last time a charge was attempted and
     failed.
     </dd>
   <dt>lastFailedChargeReason</dt>
     <dd>Reason provided for the charge failure
     </dd>
   <dt>nextPaymentDue</dt>
     <dd>The end of the billing cycle. This could be in the
     past if there are failed charges.
     </dd>
   <dt>premiumLockUntil</dt>
     <dd>An internal variable to manage locking operations
     on the commerce variables.
     </dd>
   <dt>updated</dt>
     <dd>The date any modification where made to this record.
     </dd>
   <dt>premiumSubscriptionNumber</dt>
     <dd>The number number identifying the
     recurring subscription used to make the recurring charges.
     </dd>
   <dt>lastRequestedCharge</dt>
     <dd>Date charge last attempted</dd>
   <dt>currency</dt>
     <dd>ISO 4217 currency code</dd>
   <dt>unitPrice</dt>
     <dd>charge in the smallest unit of the currency (e.g. cents for USD)</dd>
   <dt>businessId</dt>
     <dd>If set, the ID of the Evernote Business account that the user is a
         member of. If not set, the user is not a member of a business.</dd>
   <dt>businessName</dt>
     <dd>The human-readable name of the Evernote Business account that
         the user is a member of.</dd>
   <dt>businessRole</dt>
     <dd>If set, the role of the user within the Evernote Business account
         that they are a member of.</dd>
   </dl>
  
  Attributes:
   - uploadLimit
   - uploadLimitEnd
   - uploadLimitNextMonth
   - premiumServiceStatus
   - premiumOrderNumber
   - premiumCommerceService
   - premiumServiceStart
   - premiumServiceSKU
   - lastSuccessfulCharge
   - lastFailedCharge
   - lastFailedChargeReason
   - nextPaymentDue
   - premiumLockUntil
   - updated
   - premiumSubscriptionNumber
   - lastRequestedCharge
   - currency
   - unitPrice
   - businessId
   - businessName
   - businessRole
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'uploadLimit', None, None, ), # 1
    (2, TType.I64, 'uploadLimitEnd', None, None, ), # 2
    (3, TType.I64, 'uploadLimitNextMonth', None, None, ), # 3
    (4, TType.I32, 'premiumServiceStatus', None, None, ), # 4
    (5, TType.STRING, 'premiumOrderNumber', None, None, ), # 5
    (6, TType.STRING, 'premiumCommerceService', None, None, ), # 6
    (7, TType.I64, 'premiumServiceStart', None, None, ), # 7
    (8, TType.STRING, 'premiumServiceSKU', None, None, ), # 8
    (9, TType.I64, 'lastSuccessfulCharge', None, None, ), # 9
    (10, TType.I64, 'lastFailedCharge', None, None, ), # 10
    (11, TType.STRING, 'lastFailedChargeReason', None, None, ), # 11
    (12, TType.I64, 'nextPaymentDue', None, None, ), # 12
    (13, TType.I64, 'premiumLockUntil', None, None, ), # 13
    (14, TType.I64, 'updated', None, None, ), # 14
    None, # 15
    (16, TType.STRING, 'premiumSubscriptionNumber', None, None, ), # 16
    (17, TType.I64, 'lastRequestedCharge', None, None, ), # 17
    (18, TType.STRING, 'currency', None, None, ), # 18
    (19, TType.I32, 'unitPrice', None, None, ), # 19
    (20, TType.I32, 'businessId', None, None, ), # 20
    (21, TType.STRING, 'businessName', None, None, ), # 21
    (22, TType.I32, 'businessRole', None, None, ), # 22
  )

  def __init__(self, uploadLimit=None, uploadLimitEnd=None, uploadLimitNextMonth=None, premiumServiceStatus=None, premiumOrderNumber=None, premiumCommerceService=None, premiumServiceStart=None, premiumServiceSKU=None, lastSuccessfulCharge=None, lastFailedCharge=None, lastFailedChargeReason=None, nextPaymentDue=None, premiumLockUntil=None, updated=None, premiumSubscriptionNumber=None, lastRequestedCharge=None, currency=None, unitPrice=None, businessId=None, businessName=None, businessRole=None,):
    self.uploadLimit = uploadLimit
    self.uploadLimitEnd = uploadLimitEnd
    self.uploadLimitNextMonth = uploadLimitNextMonth
    self.premiumServiceStatus = premiumServiceStatus
    self.premiumOrderNumber = premiumOrderNumber
    self.premiumCommerceService = premiumCommerceService
    self.premiumServiceStart = premiumServiceStart
    self.premiumServiceSKU = premiumServiceSKU
    self.lastSuccessfulCharge = lastSuccessfulCharge
    self.lastFailedCharge = lastFailedCharge
    self.lastFailedChargeReason = lastFailedChargeReason
    self.nextPaymentDue = nextPaymentDue
    self.premiumLockUntil = premiumLockUntil
    self.updated = updated
    self.premiumSubscriptionNumber = premiumSubscriptionNumber
    self.lastRequestedCharge = lastRequestedCharge
    self.currency = currency
    self.unitPrice = unitPrice
    self.businessId = businessId
    self.businessName = businessName
    self.businessRole = businessRole

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.uploadLimit = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.uploadLimitEnd = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.uploadLimitNextMonth = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.premiumServiceStatus = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.premiumOrderNumber = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.premiumCommerceService = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.premiumServiceStart = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.premiumServiceSKU = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.I64:
          self.lastSuccessfulCharge = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I64:
          self.lastFailedCharge = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.lastFailedChargeReason = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.I64:
          self.nextPaymentDue = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.I64:
          self.premiumLockUntil = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.I64:
          self.updated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.STRING:
          self.premiumSubscriptionNumber = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.I64:
          self.lastRequestedCharge = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 18:
        if ftype == TType.STRING:
          self.currency = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 19:
        if ftype == TType.I32:
          self.unitPrice = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 20:
        if ftype == TType.I32:
          self.businessId = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 21:
        if ftype == TType.STRING:
          self.businessName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 22:
        if ftype == TType.I32:
          self.businessRole = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Accounting')
    if self.uploadLimit is not None:
      oprot.writeFieldBegin('uploadLimit', TType.I64, 1)
      oprot.writeI64(self.uploadLimit)
      oprot.writeFieldEnd()
    if self.uploadLimitEnd is not None:
      oprot.writeFieldBegin('uploadLimitEnd', TType.I64, 2)
      oprot.writeI64(self.uploadLimitEnd)
      oprot.writeFieldEnd()
    if self.uploadLimitNextMonth is not None:
      oprot.writeFieldBegin('uploadLimitNextMonth', TType.I64, 3)
      oprot.writeI64(self.uploadLimitNextMonth)
      oprot.writeFieldEnd()
    if self.premiumServiceStatus is not None:
      oprot.writeFieldBegin('premiumServiceStatus', TType.I32, 4)
      oprot.writeI32(self.premiumServiceStatus)
      oprot.writeFieldEnd()
    if self.premiumOrderNumber is not None:
      oprot.writeFieldBegin('premiumOrderNumber', TType.STRING, 5)
      oprot.writeString(self.premiumOrderNumber)
      oprot.writeFieldEnd()
    if self.premiumCommerceService is not None:
      oprot.writeFieldBegin('premiumCommerceService', TType.STRING, 6)
      oprot.writeString(self.premiumCommerceService)
      oprot.writeFieldEnd()
    if self.premiumServiceStart is not None:
      oprot.writeFieldBegin('premiumServiceStart', TType.I64, 7)
      oprot.writeI64(self.premiumServiceStart)
      oprot.writeFieldEnd()
    if self.premiumServiceSKU is not None:
      oprot.writeFieldBegin('premiumServiceSKU', TType.STRING, 8)
      oprot.writeString(self.premiumServiceSKU)
      oprot.writeFieldEnd()
    if self.lastSuccessfulCharge is not None:
      oprot.writeFieldBegin('lastSuccessfulCharge', TType.I64, 9)
      oprot.writeI64(self.lastSuccessfulCharge)
      oprot.writeFieldEnd()
    if self.lastFailedCharge is not None:
      oprot.writeFieldBegin('lastFailedCharge', TType.I64, 10)
      oprot.writeI64(self.lastFailedCharge)
      oprot.writeFieldEnd()
    if self.lastFailedChargeReason is not None:
      oprot.writeFieldBegin('lastFailedChargeReason', TType.STRING, 11)
      oprot.writeString(self.lastFailedChargeReason)
      oprot.writeFieldEnd()
    if self.nextPaymentDue is not None:
      oprot.writeFieldBegin('nextPaymentDue', TType.I64, 12)
      oprot.writeI64(self.nextPaymentDue)
      oprot.writeFieldEnd()
    if self.premiumLockUntil is not None:
      oprot.writeFieldBegin('premiumLockUntil', TType.I64, 13)
      oprot.writeI64(self.premiumLockUntil)
      oprot.writeFieldEnd()
    if self.updated is not None:
      oprot.writeFieldBegin('updated', TType.I64, 14)
      oprot.writeI64(self.updated)
      oprot.writeFieldEnd()
    if self.premiumSubscriptionNumber is not None:
      oprot.writeFieldBegin('premiumSubscriptionNumber', TType.STRING, 16)
      oprot.writeString(self.premiumSubscriptionNumber)
      oprot.writeFieldEnd()
    if self.lastRequestedCharge is not None:
      oprot.writeFieldBegin('lastRequestedCharge', TType.I64, 17)
      oprot.writeI64(self.lastRequestedCharge)
      oprot.writeFieldEnd()
    if self.currency is not None:
      oprot.writeFieldBegin('currency', TType.STRING, 18)
      oprot.writeString(self.currency)
      oprot.writeFieldEnd()
    if self.unitPrice is not None:
      oprot.writeFieldBegin('unitPrice', TType.I32, 19)
      oprot.writeI32(self.unitPrice)
      oprot.writeFieldEnd()
    if self.businessId is not None:
      oprot.writeFieldBegin('businessId', TType.I32, 20)
      oprot.writeI32(self.businessId)
      oprot.writeFieldEnd()
    if self.businessName is not None:
      oprot.writeFieldBegin('businessName', TType.STRING, 21)
      oprot.writeString(self.businessName)
      oprot.writeFieldEnd()
    if self.businessRole is not None:
      oprot.writeFieldBegin('businessRole', TType.I32, 22)
      oprot.writeI32(self.businessRole)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class PremiumInfo(object):
  """
   This structure is used to provide information about a user's Premium account.
  <dl>
   <dt>currentTime</dt>
     <dd>
     The server-side date and time when this data was generated.
     </dd>
   <dt>premium</dt>
     <dd>
     True if the user's account is Premium.
     </dd>
   <dt>premiumRecurring</dt>
     <dd>
     True if the user's account is Premium and has a recurring payment method.
     </dd>
   <dt>premiumExpirationDate</dt>
     <dd>
     The date when the user's Premium account expires, or the date when the
     user's account will be charged if it has a recurring payment method.
     </dd>
   <dt>premiumExtendable</dt>
     <dd>
     True if the user is eligible for purchasing Premium account extensions.
     </dd>
   <dt>premiumPending</dt>
     <dd>
     True if the user's Premium account is pending payment confirmation
     </dd>
   <dt>premiumCancellationPending</dt>
     <dd>
     True if the user has requested that no further charges to be made; the
     Premium account will remain active until it expires.
     </dd>
   <dt>canPurchaseUploadAllowance</dt>
     <dd>
     True if the user is eligible for purchasing additional upload allowance.
     </dd>
   <dt>sponsoredGroupName</dt>
     <dd>
     The name of the sponsored group that the user is part of.
     </dd>
   <dt>sponsoredGroupRole</dt>
     <dd>
     DEPRECATED - will be removed in a future update.
     </dd>
   </dl>
  
  Attributes:
   - currentTime
   - premium
   - premiumRecurring
   - premiumExpirationDate
   - premiumExtendable
   - premiumPending
   - premiumCancellationPending
   - canPurchaseUploadAllowance
   - sponsoredGroupName
   - sponsoredGroupRole
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'currentTime', None, None, ), # 1
    (2, TType.BOOL, 'premium', None, None, ), # 2
    (3, TType.BOOL, 'premiumRecurring', None, None, ), # 3
    (4, TType.I64, 'premiumExpirationDate', None, None, ), # 4
    (5, TType.BOOL, 'premiumExtendable', None, None, ), # 5
    (6, TType.BOOL, 'premiumPending', None, None, ), # 6
    (7, TType.BOOL, 'premiumCancellationPending', None, None, ), # 7
    (8, TType.BOOL, 'canPurchaseUploadAllowance', None, None, ), # 8
    (9, TType.STRING, 'sponsoredGroupName', None, None, ), # 9
    (10, TType.I32, 'sponsoredGroupRole', None, None, ), # 10
  )

  def __init__(self, currentTime=None, premium=None, premiumRecurring=None, premiumExpirationDate=None, premiumExtendable=None, premiumPending=None, premiumCancellationPending=None, canPurchaseUploadAllowance=None, sponsoredGroupName=None, sponsoredGroupRole=None,):
    self.currentTime = currentTime
    self.premium = premium
    self.premiumRecurring = premiumRecurring
    self.premiumExpirationDate = premiumExpirationDate
    self.premiumExtendable = premiumExtendable
    self.premiumPending = premiumPending
    self.premiumCancellationPending = premiumCancellationPending
    self.canPurchaseUploadAllowance = canPurchaseUploadAllowance
    self.sponsoredGroupName = sponsoredGroupName
    self.sponsoredGroupRole = sponsoredGroupRole

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.currentTime = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.BOOL:
          self.premium = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.premiumRecurring = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.premiumExpirationDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.premiumExtendable = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.premiumPending = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.BOOL:
          self.premiumCancellationPending = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.BOOL:
          self.canPurchaseUploadAllowance = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRING:
          self.sponsoredGroupName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I32:
          self.sponsoredGroupRole = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('PremiumInfo')
    if self.currentTime is not None:
      oprot.writeFieldBegin('currentTime', TType.I64, 1)
      oprot.writeI64(self.currentTime)
      oprot.writeFieldEnd()
    if self.premium is not None:
      oprot.writeFieldBegin('premium', TType.BOOL, 2)
      oprot.writeBool(self.premium)
      oprot.writeFieldEnd()
    if self.premiumRecurring is not None:
      oprot.writeFieldBegin('premiumRecurring', TType.BOOL, 3)
      oprot.writeBool(self.premiumRecurring)
      oprot.writeFieldEnd()
    if self.premiumExpirationDate is not None:
      oprot.writeFieldBegin('premiumExpirationDate', TType.I64, 4)
      oprot.writeI64(self.premiumExpirationDate)
      oprot.writeFieldEnd()
    if self.premiumExtendable is not None:
      oprot.writeFieldBegin('premiumExtendable', TType.BOOL, 5)
      oprot.writeBool(self.premiumExtendable)
      oprot.writeFieldEnd()
    if self.premiumPending is not None:
      oprot.writeFieldBegin('premiumPending', TType.BOOL, 6)
      oprot.writeBool(self.premiumPending)
      oprot.writeFieldEnd()
    if self.premiumCancellationPending is not None:
      oprot.writeFieldBegin('premiumCancellationPending', TType.BOOL, 7)
      oprot.writeBool(self.premiumCancellationPending)
      oprot.writeFieldEnd()
    if self.canPurchaseUploadAllowance is not None:
      oprot.writeFieldBegin('canPurchaseUploadAllowance', TType.BOOL, 8)
      oprot.writeBool(self.canPurchaseUploadAllowance)
      oprot.writeFieldEnd()
    if self.sponsoredGroupName is not None:
      oprot.writeFieldBegin('sponsoredGroupName', TType.STRING, 9)
      oprot.writeString(self.sponsoredGroupName)
      oprot.writeFieldEnd()
    if self.sponsoredGroupRole is not None:
      oprot.writeFieldBegin('sponsoredGroupRole', TType.I32, 10)
      oprot.writeI32(self.sponsoredGroupRole)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.currentTime is None:
      raise TProtocol.TProtocolException(message='Required field currentTime is unset!')
    if self.premium is None:
      raise TProtocol.TProtocolException(message='Required field premium is unset!')
    if self.premiumRecurring is None:
      raise TProtocol.TProtocolException(message='Required field premiumRecurring is unset!')
    if self.premiumExtendable is None:
      raise TProtocol.TProtocolException(message='Required field premiumExtendable is unset!')
    if self.premiumPending is None:
      raise TProtocol.TProtocolException(message='Required field premiumPending is unset!')
    if self.premiumCancellationPending is None:
      raise TProtocol.TProtocolException(message='Required field premiumCancellationPending is unset!')
    if self.canPurchaseUploadAllowance is None:
      raise TProtocol.TProtocolException(message='Required field canPurchaseUploadAllowance is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class User(object):
  """
   This represents the information about a single user account.
  <dl>
   <dt>id</dt>
     <dd>The unique numeric identifier for the account, which will not
     change for the lifetime of the account.
     </dd>
  
   <dt>username</dt>
     <dd>The name that uniquely identifies a single user account. This name
     may be presented by the user, along with their password, to log into
     their account.
     May only contain a-z, 0-9, or '-', and may not start or end with the '-'
     <br/>
     Length:  EDAM_USER_USERNAME_LEN_MIN - EDAM_USER_USERNAME_LEN_MAX
     <br/>
     Regex:  EDAM_USER_USERNAME_REGEX
     </dd>
  
   <dt>email</dt>
     <dd>The email address registered for the user.  Must comply with
     RFC 2821 and RFC 2822.<br/>
     For privacy reasons, this field may not be populated when a User
     is retrieved via a call to UserStore.getUser().
     Length:  EDAM_EMAIL_LEN_MIN - EDAM_EMAIL_LEN_MAX
     <br/>
     Regex:  EDAM_EMAIL_REGEX
     </dd>
  
   <dt>name</dt>
     <dd>The printable name of the user, which may be a combination
     of given and family names.  This is used instead of separate "first"
     and "last" names due to variations in international name format/order.
     May not start or end with a whitespace character.  May contain any
     character but carriage return or newline (Unicode classes Zl and Zp).
     <br/>
     Length:  EDAM_USER_NAME_LEN_MIN - EDAM_USER_NAME_LEN_MAX
     <br/>
     Regex:  EDAM_USER_NAME_REGEX
     </dd>
  
   <dt>timezone</dt>
     <dd>The zone ID for the user's default location.  If present,
     this may be used to localize the display of any timestamp for which no
     other timezone is available.
     The format must be encoded as a standard zone ID such as
     "America/Los_Angeles" or "GMT+08:00"
     <br/>
     Length:  EDAM_TIMEZONE_LEN_MIN - EDAM_TIMEZONE_LEN_MAX
     <br/>
     Regex:  EDAM_TIMEZONE_REGEX
     </dd>
  
   <dt>privilege</dt>
     <dd>The level of access permitted for the user.
     </dd>
  
   <dt>created</dt>
     <dd>The date and time when this user account was created in the
     service.
     </dd>
  
   <dt>updated</dt>
     <dd>The date and time when this user account was last modified
     in the service.
     </dd>
  
   <dt>deleted</dt>
     <dd>If the account has been deleted from the system (e.g. as
     the result of a legal request by the user), the date and time of the
     deletion will be represented here.  If not, this value will not be set.
     </dd>
  
   <dt>active</dt>
     <dd>If the user account is available for login and
     synchronization, this flag will be set to true.
     </dd>
  
   <dt>shardId</dt>
     <dd>DEPRECATED - Client applications should have no need to use this field.
     </dd>
  
   <dt>attributes</dt>
     <dd>If present, this will contain a list of the attributes
     for this user account.
     </dd>
  
   <dt>accounting</dt>
     <dd>Bookkeeping information for the user's subscription.
     </dd>
  
   <dt>premiumInfo</dt>
     <dd>If present, this will contain a set of commerce information
     relating to the user's premium service level.
     </dd>
   </dl>
  
  Attributes:
   - id
   - username
   - email
   - name
   - timezone
   - privilege
   - created
   - updated
   - deleted
   - active
   - shardId
   - attributes
   - accounting
   - premiumInfo
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
    (2, TType.STRING, 'username', None, None, ), # 2
    (3, TType.STRING, 'email', None, None, ), # 3
    (4, TType.STRING, 'name', None, None, ), # 4
    None, # 5
    (6, TType.STRING, 'timezone', None, None, ), # 6
    (7, TType.I32, 'privilege', None, None, ), # 7
    None, # 8
    (9, TType.I64, 'created', None, None, ), # 9
    (10, TType.I64, 'updated', None, None, ), # 10
    (11, TType.I64, 'deleted', None, None, ), # 11
    None, # 12
    (13, TType.BOOL, 'active', None, None, ), # 13
    (14, TType.STRING, 'shardId', None, None, ), # 14
    (15, TType.STRUCT, 'attributes', (UserAttributes, UserAttributes.thrift_spec), None, ), # 15
    (16, TType.STRUCT, 'accounting', (Accounting, Accounting.thrift_spec), None, ), # 16
    (17, TType.STRUCT, 'premiumInfo', (PremiumInfo, PremiumInfo.thrift_spec), None, ), # 17
  )

  def __init__(self, id=None, username=None, email=None, name=None, timezone=None, privilege=None, created=None, updated=None, deleted=None, active=None, shardId=None, attributes=None, accounting=None, premiumInfo=None,):
    self.id = id
    self.username = username
    self.email = email
    self.name = name
    self.timezone = timezone
    self.privilege = privilege
    self.created = created
    self.updated = updated
    self.deleted = deleted
    self.active = active
    self.shardId = shardId
    self.attributes = attributes
    self.accounting = accounting
    self.premiumInfo = premiumInfo

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.username = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.email = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.timezone = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I32:
          self.privilege = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.I64:
          self.created = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I64:
          self.updated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.I64:
          self.deleted = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.BOOL:
          self.active = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRING:
          self.shardId = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.STRUCT:
          self.attributes = UserAttributes()
          self.attributes.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.STRUCT:
          self.accounting = Accounting()
          self.accounting.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.STRUCT:
          self.premiumInfo = PremiumInfo()
          self.premiumInfo.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('User')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    if self.username is not None:
      oprot.writeFieldBegin('username', TType.STRING, 2)
      oprot.writeString(self.username)
      oprot.writeFieldEnd()
    if self.email is not None:
      oprot.writeFieldBegin('email', TType.STRING, 3)
      oprot.writeString(self.email)
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 4)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.timezone is not None:
      oprot.writeFieldBegin('timezone', TType.STRING, 6)
      oprot.writeString(self.timezone)
      oprot.writeFieldEnd()
    if self.privilege is not None:
      oprot.writeFieldBegin('privilege', TType.I32, 7)
      oprot.writeI32(self.privilege)
      oprot.writeFieldEnd()
    if self.created is not None:
      oprot.writeFieldBegin('created', TType.I64, 9)
      oprot.writeI64(self.created)
      oprot.writeFieldEnd()
    if self.updated is not None:
      oprot.writeFieldBegin('updated', TType.I64, 10)
      oprot.writeI64(self.updated)
      oprot.writeFieldEnd()
    if self.deleted is not None:
      oprot.writeFieldBegin('deleted', TType.I64, 11)
      oprot.writeI64(self.deleted)
      oprot.writeFieldEnd()
    if self.active is not None:
      oprot.writeFieldBegin('active', TType.BOOL, 13)
      oprot.writeBool(self.active)
      oprot.writeFieldEnd()
    if self.shardId is not None:
      oprot.writeFieldBegin('shardId', TType.STRING, 14)
      oprot.writeString(self.shardId)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.STRUCT, 15)
      self.attributes.write(oprot)
      oprot.writeFieldEnd()
    if self.accounting is not None:
      oprot.writeFieldBegin('accounting', TType.STRUCT, 16)
      self.accounting.write(oprot)
      oprot.writeFieldEnd()
    if self.premiumInfo is not None:
      oprot.writeFieldBegin('premiumInfo', TType.STRUCT, 17)
      self.premiumInfo.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Tag(object):
  """
   A tag within a user's account is a unique name which may be organized
   a simple hierarchy.
  <dl>
   <dt>guid</dt>
     <dd>The unique identifier of this tag. Will be set by the service,
     so may be omitted by the client when creating the Tag.
     <br/>
     Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
     <br/>
     Regex:  EDAM_GUID_REGEX
     </dd>
  
   <dt>name</dt>
     <dd>A sequence of characters representing the tag's identifier.
     Case is preserved, but is ignored for comparisons.
     This means that an account may only have one tag with a given name, via
     case-insensitive comparison, so an account may not have both "food" and
     "Food" tags.
     May not contain a comma (','), and may not begin or end with a space.
     <br/>
     Length:  EDAM_TAG_NAME_LEN_MIN - EDAM_TAG_NAME_LEN_MAX
     <br/>
     Regex:  EDAM_TAG_NAME_REGEX
     </dd>
  
   <dt>parentGuid</dt>
     <dd>If this is set, then this is the GUID of the tag that
     holds this tag within the tag organizational hierarchy.  If this is
     not set, then the tag has no parent and it is a "top level" tag.
     Cycles are not allowed (e.g. a->parent->parent == a) and will be
     rejected by the service.
     <br/>
     Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
     <br/>
     Regex:  EDAM_GUID_REGEX
     </dd>
  
   <dt>updateSequenceNum</dt>
     <dd>A number identifying the last transaction to
     modify the state of this object.  The USN values are sequential within an
     account, and can be used to compare the order of modifications within the
     service.
     </dd>
   </dl>
  
  Attributes:
   - guid
   - name
   - parentGuid
   - updateSequenceNum
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    (3, TType.STRING, 'parentGuid', None, None, ), # 3
    (4, TType.I32, 'updateSequenceNum', None, None, ), # 4
  )

  def __init__(self, guid=None, name=None, parentGuid=None, updateSequenceNum=None,):
    self.guid = guid
    self.name = name
    self.parentGuid = parentGuid
    self.updateSequenceNum = updateSequenceNum

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.parentGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Tag')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.parentGuid is not None:
      oprot.writeFieldBegin('parentGuid', TType.STRING, 3)
      oprot.writeString(self.parentGuid)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 4)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LazyMap(object):
  """
  A structure that wraps a map of name/value pairs whose values are not
  always present in the structure in order to reduce space when obtaining
  batches of entities that contain the map.
  
  When the server provides the client with a LazyMap, it will fill in either
  the keysOnly field or the fullMap field, but never both, based on the API
  and parameters.
  
  When a client provides a LazyMap to the server as part of an update to
  an object, the server will only update the LazyMap if the fullMap field is
  set. If the fullMap field is not set, the server will not make any changes
  to the map.
  
  Check the API documentation of the individual calls involving the LazyMap
  for full details including the constraints of the names and values of the
  map.
  
  <dl>
  <dt>keysOnly</dt>
    <dd>The set of keys for the map.  This field is ignored by the
        server when set.
    </dd>
  
  <dt>fullMap</dt>
    <dd>The complete map, including all keys and values.
    </dd>
  </dl>
  
  Attributes:
   - keysOnly
   - fullMap
  """

  thrift_spec = (
    None, # 0
    (1, TType.SET, 'keysOnly', (TType.STRING,None), None, ), # 1
    (2, TType.MAP, 'fullMap', (TType.STRING,None,TType.STRING,None), None, ), # 2
  )

  def __init__(self, keysOnly=None, fullMap=None,):
    self.keysOnly = keysOnly
    self.fullMap = fullMap

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.SET:
          self.keysOnly = set()
          (_etype17, _size14) = iprot.readSetBegin()
          for _i18 in xrange(_size14):
            _elem19 = iprot.readString();
            self.keysOnly.add(_elem19)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.fullMap = {}
          (_ktype21, _vtype22, _size20 ) = iprot.readMapBegin() 
          for _i24 in xrange(_size20):
            _key25 = iprot.readString();
            _val26 = iprot.readString();
            self.fullMap[_key25] = _val26
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LazyMap')
    if self.keysOnly is not None:
      oprot.writeFieldBegin('keysOnly', TType.SET, 1)
      oprot.writeSetBegin(TType.STRING, len(self.keysOnly))
      for iter27 in self.keysOnly:
        oprot.writeString(iter27)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    if self.fullMap is not None:
      oprot.writeFieldBegin('fullMap', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.fullMap))
      for kiter28,viter29 in self.fullMap.items():
        oprot.writeString(kiter28)
        oprot.writeString(viter29)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ResourceAttributes(object):
  """
  Structure holding the optional attributes of a Resource
  <dl>
  <dt>sourceURL</dt>
    <dd>the original location where the resource was hosted
    <br/>
     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>timestamp</dt>
    <dd>the date and time that is associated with this resource
    (e.g. the time embedded in an image from a digital camera with a clock)
    </dd>
  
  <dt>latitude</dt>
    <dd>the latitude where the resource was captured
    </dd>
  
  <dt>longitude</dt>
    <dd>the longitude where the resource was captured
    </dd>
  
  <dt>altitude</dt>
    <dd>the altitude where the resource was captured
    </dd>
  
  <dt>cameraMake</dt>
    <dd>information about an image's camera, e.g. as embedded in
    the image's EXIF data
    <br/>
    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>cameraModel</dt>
    <dd>information about an image's camera, e.g. as embedded
    in the image's EXIF data
    <br/>
    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>clientWillIndex</dt>
    <dd>if true, then the original client that submitted
    the resource plans to submit the recognition index for this resource at a
    later time.
    </dd>
  
  <dt>recoType</dt>
    <dd>DEPRECATED - this field is no longer set by the service, so should
      be ignored.
    </dd>
  
  <dt>fileName</dt>
    <dd>if the resource came from a source that provided an
    explicit file name, the original name will be stored here.  Many resources
    come from unnamed sources, so this will not always be set.
    </dd>
  
  <dt>attachment</dt>
    <dd>this will be true if the resource should be displayed as an attachment,
    or false if the resource should be displayed inline (if possible).
    </dd>
  
  <dt>applicationData</dt>
  <dd>Provides a location for applications to store a relatively small
  (4kb) blob of data associated with a Resource that is not visible to the user
  and that is opaque to the Evernote service. A single application may use at most
  one entry in this map, using its API consumer key as the map key. See the
  documentation for LazyMap for a description of when the actual map values
  are returned by the service.
  <p>To safely add or modify your application's entry in the map, use
  NoteStore.setResourceApplicationDataEntry. To safely remove your application's
  entry from the map, use NoteStore.unsetResourceApplicationDataEntry.</p>
  Minimum length of a name (key): EDAM_APPLICATIONDATA_NAME_LEN_MIN
  <br/>
  Sum max size of key and value: EDAM_APPLICATIONDATA_ENTRY_LEN_MAX
  <br/>
  Syntax regex for name (key): EDAM_APPLICATIONDATA_NAME_REGEX
  </dd>
  
  </dl>
  
  Attributes:
   - sourceURL
   - timestamp
   - latitude
   - longitude
   - altitude
   - cameraMake
   - cameraModel
   - clientWillIndex
   - recoType
   - fileName
   - attachment
   - applicationData
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'sourceURL', None, None, ), # 1
    (2, TType.I64, 'timestamp', None, None, ), # 2
    (3, TType.DOUBLE, 'latitude', None, None, ), # 3
    (4, TType.DOUBLE, 'longitude', None, None, ), # 4
    (5, TType.DOUBLE, 'altitude', None, None, ), # 5
    (6, TType.STRING, 'cameraMake', None, None, ), # 6
    (7, TType.STRING, 'cameraModel', None, None, ), # 7
    (8, TType.BOOL, 'clientWillIndex', None, None, ), # 8
    (9, TType.STRING, 'recoType', None, None, ), # 9
    (10, TType.STRING, 'fileName', None, None, ), # 10
    (11, TType.BOOL, 'attachment', None, None, ), # 11
    (12, TType.STRUCT, 'applicationData', (LazyMap, LazyMap.thrift_spec), None, ), # 12
  )

  def __init__(self, sourceURL=None, timestamp=None, latitude=None, longitude=None, altitude=None, cameraMake=None, cameraModel=None, clientWillIndex=None, recoType=None, fileName=None, attachment=None, applicationData=None,):
    self.sourceURL = sourceURL
    self.timestamp = timestamp
    self.latitude = latitude
    self.longitude = longitude
    self.altitude = altitude
    self.cameraMake = cameraMake
    self.cameraModel = cameraModel
    self.clientWillIndex = clientWillIndex
    self.recoType = recoType
    self.fileName = fileName
    self.attachment = attachment
    self.applicationData = applicationData

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.sourceURL = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.DOUBLE:
          self.latitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.DOUBLE:
          self.longitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.DOUBLE:
          self.altitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.cameraMake = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.cameraModel = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.BOOL:
          self.clientWillIndex = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRING:
          self.recoType = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.STRING:
          self.fileName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.BOOL:
          self.attachment = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.STRUCT:
          self.applicationData = LazyMap()
          self.applicationData.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ResourceAttributes')
    if self.sourceURL is not None:
      oprot.writeFieldBegin('sourceURL', TType.STRING, 1)
      oprot.writeString(self.sourceURL)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 2)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.latitude is not None:
      oprot.writeFieldBegin('latitude', TType.DOUBLE, 3)
      oprot.writeDouble(self.latitude)
      oprot.writeFieldEnd()
    if self.longitude is not None:
      oprot.writeFieldBegin('longitude', TType.DOUBLE, 4)
      oprot.writeDouble(self.longitude)
      oprot.writeFieldEnd()
    if self.altitude is not None:
      oprot.writeFieldBegin('altitude', TType.DOUBLE, 5)
      oprot.writeDouble(self.altitude)
      oprot.writeFieldEnd()
    if self.cameraMake is not None:
      oprot.writeFieldBegin('cameraMake', TType.STRING, 6)
      oprot.writeString(self.cameraMake)
      oprot.writeFieldEnd()
    if self.cameraModel is not None:
      oprot.writeFieldBegin('cameraModel', TType.STRING, 7)
      oprot.writeString(self.cameraModel)
      oprot.writeFieldEnd()
    if self.clientWillIndex is not None:
      oprot.writeFieldBegin('clientWillIndex', TType.BOOL, 8)
      oprot.writeBool(self.clientWillIndex)
      oprot.writeFieldEnd()
    if self.recoType is not None:
      oprot.writeFieldBegin('recoType', TType.STRING, 9)
      oprot.writeString(self.recoType)
      oprot.writeFieldEnd()
    if self.fileName is not None:
      oprot.writeFieldBegin('fileName', TType.STRING, 10)
      oprot.writeString(self.fileName)
      oprot.writeFieldEnd()
    if self.attachment is not None:
      oprot.writeFieldBegin('attachment', TType.BOOL, 11)
      oprot.writeBool(self.attachment)
      oprot.writeFieldEnd()
    if self.applicationData is not None:
      oprot.writeFieldBegin('applicationData', TType.STRUCT, 12)
      self.applicationData.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Resource(object):
  """
  Every media file that is embedded or attached to a note is represented
  through a Resource entry.
  <dl>
  <dt>guid</dt>
    <dd>The unique identifier of this resource.  Will be set whenever
    a resource is retrieved from the service, but may be null when a client
    is creating a resource.
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>noteGuid</dt>
    <dd>The unique identifier of the Note that holds this
    Resource. Will be set whenever the resource is retrieved from the service,
    but may be null when a client is creating a resource.
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>data</dt>
    <dd>The contents of the resource.
    Maximum length:  The data.body is limited to EDAM_RESOURCE_SIZE_MAX_FREE
    for free accounts and EDAM_RESOURCE_SIZE_MAX_PREMIUM for premium accounts.
    </dd>
  
  <dt>mime</dt>
    <dd>The MIME type for the embedded resource.  E.g. "image/gif"
    <br/>
    Length:  EDAM_MIME_LEN_MIN - EDAM_MIME_LEN_MAX
    <br/>
    Regex:  EDAM_MIME_REGEX
    </dd>
  
  <dt>width</dt>
    <dd>If set, this contains the display width of this resource, in
    pixels.
    </dd>
  
  <dt>height</dt>
    <dd>If set, this contains the display height of this resource,
    in pixels.
    </dd>
  
  <dt>duration</dt>
    <dd>DEPRECATED: ignored.
    </dd>
  
  <dt>active</dt>
    <dd>DEPRECATED: ignored.
    </dd>
  
  <dt>recognition</dt>
    <dd>If set, this will hold the encoded data that provides
    information on search and recognition within this resource.
    </dd>
  
  <dt>attributes</dt>
    <dd>A list of the attributes for this resource.
    </dd>
  
  <dt>updateSequenceNum</dt>
    <dd>A number identifying the last transaction to
    modify the state of this object. The USN values are sequential within an
    account, and can be used to compare the order of modifications within the
    service.
    </dd>
  
  <dt>alternateData</dt>
    <dd>Some Resources may be assigned an alternate data format by the service
    which may be more appropriate for indexing or rendering than the original
    data provided by the user.  In these cases, the alternate data form will
    be available via this Data element.  If a Resource has no alternate form,
    this field will be unset.</dd>
  </dl>
  
  Attributes:
   - guid
   - noteGuid
   - data
   - mime
   - width
   - height
   - duration
   - active
   - recognition
   - attributes
   - updateSequenceNum
   - alternateData
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'noteGuid', None, None, ), # 2
    (3, TType.STRUCT, 'data', (Data, Data.thrift_spec), None, ), # 3
    (4, TType.STRING, 'mime', None, None, ), # 4
    (5, TType.I16, 'width', None, None, ), # 5
    (6, TType.I16, 'height', None, None, ), # 6
    (7, TType.I16, 'duration', None, None, ), # 7
    (8, TType.BOOL, 'active', None, None, ), # 8
    (9, TType.STRUCT, 'recognition', (Data, Data.thrift_spec), None, ), # 9
    None, # 10
    (11, TType.STRUCT, 'attributes', (ResourceAttributes, ResourceAttributes.thrift_spec), None, ), # 11
    (12, TType.I32, 'updateSequenceNum', None, None, ), # 12
    (13, TType.STRUCT, 'alternateData', (Data, Data.thrift_spec), None, ), # 13
  )

  def __init__(self, guid=None, noteGuid=None, data=None, mime=None, width=None, height=None, duration=None, active=None, recognition=None, attributes=None, updateSequenceNum=None, alternateData=None,):
    self.guid = guid
    self.noteGuid = noteGuid
    self.data = data
    self.mime = mime
    self.width = width
    self.height = height
    self.duration = duration
    self.active = active
    self.recognition = recognition
    self.attributes = attributes
    self.updateSequenceNum = updateSequenceNum
    self.alternateData = alternateData

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.noteGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.data = Data()
          self.data.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.mime = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I16:
          self.width = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I16:
          self.height = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I16:
          self.duration = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.BOOL:
          self.active = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRUCT:
          self.recognition = Data()
          self.recognition.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRUCT:
          self.attributes = ResourceAttributes()
          self.attributes.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.STRUCT:
          self.alternateData = Data()
          self.alternateData.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Resource')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.noteGuid is not None:
      oprot.writeFieldBegin('noteGuid', TType.STRING, 2)
      oprot.writeString(self.noteGuid)
      oprot.writeFieldEnd()
    if self.data is not None:
      oprot.writeFieldBegin('data', TType.STRUCT, 3)
      self.data.write(oprot)
      oprot.writeFieldEnd()
    if self.mime is not None:
      oprot.writeFieldBegin('mime', TType.STRING, 4)
      oprot.writeString(self.mime)
      oprot.writeFieldEnd()
    if self.width is not None:
      oprot.writeFieldBegin('width', TType.I16, 5)
      oprot.writeI16(self.width)
      oprot.writeFieldEnd()
    if self.height is not None:
      oprot.writeFieldBegin('height', TType.I16, 6)
      oprot.writeI16(self.height)
      oprot.writeFieldEnd()
    if self.duration is not None:
      oprot.writeFieldBegin('duration', TType.I16, 7)
      oprot.writeI16(self.duration)
      oprot.writeFieldEnd()
    if self.active is not None:
      oprot.writeFieldBegin('active', TType.BOOL, 8)
      oprot.writeBool(self.active)
      oprot.writeFieldEnd()
    if self.recognition is not None:
      oprot.writeFieldBegin('recognition', TType.STRUCT, 9)
      self.recognition.write(oprot)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.STRUCT, 11)
      self.attributes.write(oprot)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 12)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.alternateData is not None:
      oprot.writeFieldBegin('alternateData', TType.STRUCT, 13)
      self.alternateData.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteAttributes(object):
  """
  The list of optional attributes that can be stored on a note.
  <dl>
  <dt>subjectDate</dt>
    <dd>time that the note refers to
    </dd>
  
  <dt>latitude</dt>
    <dd>the latitude where the note was taken
    </dd>
  
  <dt>longitude</dt>
    <dd>the longitude where the note was taken
    </dd>
  
  <dt>altitude</dt>
    <dd>the altitude where the note was taken
    </dd>
  
  <dt>author</dt>
    <dd>the author of the content of the note
    <br/>
    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>source</dt>
    <dd>the method that the note was added to the account, if the
    note wasn't directly authored in an Evernote desktop client.
    <br/>
    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>sourceURL</dt>
    <dd>the original location where the resource was hosted. For web clips,
    this will be the URL of the page that was clipped.
    <br/>
    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>sourceApplication</dt>
    <dd>an identifying string for the application that
    created this note.  This string does not have a guaranteed syntax or
    structure -- it is intended for human inspection and tracking.
    <br/>
    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
    </dd>
  
  <dt>shareDate</dt>
   <dd>The date and time when this note was directly shared via its own URL.
   This is only set on notes that were individually shared - it is independent
   of any notebook-level sharing of the containing notepbook. This field
   is treated as "read-only" for clients; the server will ignore changes
   to this field from an external client.
   </dd>
  
  <dt>placeName</dt>
  <dd>Allows the user to assign a human-readable location name associated
  with a note. Users may assign values like 'Home' and 'Work'. Place
  names may also be populated with values from geonames database
  (e.g., a restaurant name). Applications are encouraged to normalize values
  so that grouping values by place name provides a useful result. Applications
  MUST NOT automatically add place name values based on geolocation without
  confirmation from the user; that is, the value in this field should be
  more useful than a simple automated lookup based on the note's latitude
  and longitude.</dd>
  
  <dt>contentClass</dt>
  <dd>The class (or type) of note. This field is used to indicate to
  clients that special structured information is represented within
  the note such that special rules apply when making
  modifications. If contentClass is set and the client
  application does not specifically support the specified class,
  the client MUST treat the note as read-only. In this case, the
  client MAY modify the note's notebook and tags via the
  Note.notebookGuid and Note.tagGuids fields.
  <p>Applications should set contentClass only when they are creating notes
  that contain structured information that needs to be maintained in order
  for the user to be able to use the note within that application.
  Setting contentClass makes a note read-only in other applications, so
  there is a trade-off when an application chooses to use contentClass.
  Applications that set contentClass when creating notes must use a contentClass
  string of the form <i>CompanyName.ApplicationName</i> to ensure uniqueness.</p>
  Length restrictions: EDAM_NOTE_CONTENT_CLASS_LEN_MIN, EDAM_NOTE_CONTENT_CLASS_LEN_MAX
  <br/>
  Regex: EDAM_NOTE_CONTENT_CLASS_REGEX
  </dd>
  
  <dt>applicationData</dt>
  <dd>Provides a location for applications to store a relatively small
  (4kb) blob of data that is not meant to be visible to the user and
  that is opaque to the Evernote service. A single application may use at most
  one entry in this map, using its API consumer key as the map key. See the
  documentation for LazyMap for a description of when the actual map values
  are returned by the service.
  <p>To safely add or modify your application's entry in the map, use
  NoteStore.setNoteApplicationDataEntry. To safely remove your application's
  entry from the map, use NoteStore.unsetNoteApplicationDataEntry.</p>
  Minimum length of a name (key): EDAM_APPLICATIONDATA_NAME_LEN_MIN
  <br/>
  Sum max size of key and value: EDAM_APPLICATIONDATA_ENTRY_LEN_MAX
  <br/>
  Syntax regex for name (key): EDAM_APPLICATIONDATA_NAME_REGEX
  </dd>
  
  <dt>lastEditedBy</dt>
  <dd>An indication of who made the last change to the note.  If you are
  accessing the note via a shared notebook to which you have modification
  rights, or if you are the owner of the notebook to which the note belongs,
  then you have access to the value.  In this case, the value will be
  unset if the owner of the notebook containing the note was the last to
  make the modification, else it will be a string describing the
  guest who made the last edit.  If you do not have access to this value,
  it will be left unset.  This field is read-only by clients.  The server
  will ignore all values set by clients into this field.</dd>
  
  <dt>classifications</dt>
  <dd>A map of classifications applied to the note by clients or by the
  Evernote service. The key is the string name of the classification type,
  and the value is a constant that begins with CLASSIFICATION_.</dd>
  
  </dl>
  
  Attributes:
   - subjectDate
   - latitude
   - longitude
   - altitude
   - author
   - source
   - sourceURL
   - sourceApplication
   - shareDate
   - placeName
   - contentClass
   - applicationData
   - lastEditedBy
   - classifications
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'subjectDate', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.DOUBLE, 'latitude', None, None, ), # 10
    (11, TType.DOUBLE, 'longitude', None, None, ), # 11
    (12, TType.DOUBLE, 'altitude', None, None, ), # 12
    (13, TType.STRING, 'author', None, None, ), # 13
    (14, TType.STRING, 'source', None, None, ), # 14
    (15, TType.STRING, 'sourceURL', None, None, ), # 15
    (16, TType.STRING, 'sourceApplication', None, None, ), # 16
    (17, TType.I64, 'shareDate', None, None, ), # 17
    None, # 18
    None, # 19
    None, # 20
    (21, TType.STRING, 'placeName', None, None, ), # 21
    (22, TType.STRING, 'contentClass', None, None, ), # 22
    (23, TType.STRUCT, 'applicationData', (LazyMap, LazyMap.thrift_spec), None, ), # 23
    (24, TType.STRING, 'lastEditedBy', None, None, ), # 24
    None, # 25
    (26, TType.MAP, 'classifications', (TType.STRING,None,TType.STRING,None), None, ), # 26
  )

  def __init__(self, subjectDate=None, latitude=None, longitude=None, altitude=None, author=None, source=None, sourceURL=None, sourceApplication=None, shareDate=None, placeName=None, contentClass=None, applicationData=None, lastEditedBy=None, classifications=None,):
    self.subjectDate = subjectDate
    self.latitude = latitude
    self.longitude = longitude
    self.altitude = altitude
    self.author = author
    self.source = source
    self.sourceURL = sourceURL
    self.sourceApplication = sourceApplication
    self.shareDate = shareDate
    self.placeName = placeName
    self.contentClass = contentClass
    self.applicationData = applicationData
    self.lastEditedBy = lastEditedBy
    self.classifications = classifications

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.subjectDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.DOUBLE:
          self.latitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.DOUBLE:
          self.longitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.DOUBLE:
          self.altitude = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.STRING:
          self.author = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRING:
          self.source = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.STRING:
          self.sourceURL = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.STRING:
          self.sourceApplication = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.I64:
          self.shareDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 21:
        if ftype == TType.STRING:
          self.placeName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 22:
        if ftype == TType.STRING:
          self.contentClass = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 23:
        if ftype == TType.STRUCT:
          self.applicationData = LazyMap()
          self.applicationData.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 24:
        if ftype == TType.STRING:
          self.lastEditedBy = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 26:
        if ftype == TType.MAP:
          self.classifications = {}
          (_ktype31, _vtype32, _size30 ) = iprot.readMapBegin() 
          for _i34 in xrange(_size30):
            _key35 = iprot.readString();
            _val36 = iprot.readString();
            self.classifications[_key35] = _val36
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteAttributes')
    if self.subjectDate is not None:
      oprot.writeFieldBegin('subjectDate', TType.I64, 1)
      oprot.writeI64(self.subjectDate)
      oprot.writeFieldEnd()
    if self.latitude is not None:
      oprot.writeFieldBegin('latitude', TType.DOUBLE, 10)
      oprot.writeDouble(self.latitude)
      oprot.writeFieldEnd()
    if self.longitude is not None:
      oprot.writeFieldBegin('longitude', TType.DOUBLE, 11)
      oprot.writeDouble(self.longitude)
      oprot.writeFieldEnd()
    if self.altitude is not None:
      oprot.writeFieldBegin('altitude', TType.DOUBLE, 12)
      oprot.writeDouble(self.altitude)
      oprot.writeFieldEnd()
    if self.author is not None:
      oprot.writeFieldBegin('author', TType.STRING, 13)
      oprot.writeString(self.author)
      oprot.writeFieldEnd()
    if self.source is not None:
      oprot.writeFieldBegin('source', TType.STRING, 14)
      oprot.writeString(self.source)
      oprot.writeFieldEnd()
    if self.sourceURL is not None:
      oprot.writeFieldBegin('sourceURL', TType.STRING, 15)
      oprot.writeString(self.sourceURL)
      oprot.writeFieldEnd()
    if self.sourceApplication is not None:
      oprot.writeFieldBegin('sourceApplication', TType.STRING, 16)
      oprot.writeString(self.sourceApplication)
      oprot.writeFieldEnd()
    if self.shareDate is not None:
      oprot.writeFieldBegin('shareDate', TType.I64, 17)
      oprot.writeI64(self.shareDate)
      oprot.writeFieldEnd()
    if self.placeName is not None:
      oprot.writeFieldBegin('placeName', TType.STRING, 21)
      oprot.writeString(self.placeName)
      oprot.writeFieldEnd()
    if self.contentClass is not None:
      oprot.writeFieldBegin('contentClass', TType.STRING, 22)
      oprot.writeString(self.contentClass)
      oprot.writeFieldEnd()
    if self.applicationData is not None:
      oprot.writeFieldBegin('applicationData', TType.STRUCT, 23)
      self.applicationData.write(oprot)
      oprot.writeFieldEnd()
    if self.lastEditedBy is not None:
      oprot.writeFieldBegin('lastEditedBy', TType.STRING, 24)
      oprot.writeString(self.lastEditedBy)
      oprot.writeFieldEnd()
    if self.classifications is not None:
      oprot.writeFieldBegin('classifications', TType.MAP, 26)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.classifications))
      for kiter37,viter38 in self.classifications.items():
        oprot.writeString(kiter37)
        oprot.writeString(viter38)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Note(object):
  """
  Represents a single note in the user's account.
  
  <dl>
  <dt>guid</dt>
    <dd>The unique identifier of this note.  Will be set by the
    server, but will be omitted by clients calling NoteStore.createNote()
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>title</dt>
    <dd>The subject of the note.  Can't begin or end with a space.
    <br/>
    Length:  EDAM_NOTE_TITLE_LEN_MIN - EDAM_NOTE_TITLE_LEN_MAX
    <br/>
    Regex:  EDAM_NOTE_TITLE_REGEX
    </dd>
  
  <dt>content</dt>
    <dd>The XHTML block that makes up the note.  This is
    the canonical form of the note's contents, so will include abstract
    Evernote tags for internal resource references.  A client may create
    a separate transformed version of this content for internal presentation,
    but the same canonical bytes should be used for transmission and
    comparison unless the user chooses to modify their content.
    <br/>
    Length:  EDAM_NOTE_CONTENT_LEN_MIN - EDAM_NOTE_CONTENT_LEN_MAX
    </dd>
  
  <dt>contentHash</dt>
    <dd>The binary MD5 checksum of the UTF-8 encoded content
    body. This will always be set by the server, but clients may choose to omit
    this when they submit a note with content.
    <br/>
    Length:  EDAM_HASH_LEN (exactly)
    </dd>
  
  <dt>contentLength</dt>
    <dd>The number of Unicode characters in the content of
    the note.  This will always be set by the service, but clients may choose
    to omit this value when they submit a Note.
    </dd>
  
  <dt>created</dt>
    <dd>The date and time when the note was created in one of the
    clients.  In most cases, this will match the user's sense of when
    the note was created, and ordering between notes will be based on
    ordering of this field.  However, this is not a "reliable" timestamp
    if a client has an incorrect clock, so it cannot provide a true absolute
    ordering between notes.  Notes created directly through the service
    (e.g. via the web GUI) will have an absolutely ordered "created" value.
    </dd>
  
  <dt>updated</dt>
    <dd>The date and time when the note was last modified in one of
    the clients.  In most cases, this will match the user's sense of when
    the note was modified, but this field may not be absolutely reliable
    due to the possibility of client clock errors.
    </dd>
  
  <dt>deleted</dt>
    <dd>If present, the note is considered "deleted", and this
    stores the date and time when the note was deleted by one of the clients.
    In most cases, this will match the user's sense of when the note was
    deleted, but this field may be unreliable due to the possibility of
    client clock errors.
    </dd>
  
  <dt>active</dt>
    <dd>If the note is available for normal actions and viewing,
    this flag will be set to true.
    </dd>
  
  <dt>updateSequenceNum</dt>
    <dd>A number identifying the last transaction to
    modify the state of this note (including changes to the note's attributes
    or resources).  The USN values are sequential within an account,
    and can be used to compare the order of modifications within the service.
    </dd>
  
  <dt>notebookGuid</dt>
    <dd>The unique identifier of the notebook that contains
    this note.  If no notebookGuid is provided on a call to createNote(), the
    default notebook will be used instead.
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>tagGuids</dt>
    <dd>A list of the GUID identifiers for tags that are applied to this note.
    This may be provided in a call to createNote() to unambiguously declare
    the tags that should be assigned to the new note.  Alternately, clients
    may pass the names of desired tags via the 'tagNames' field during
    note creation.
    If the list of tags are omitted on a call to createNote(), then
    the server will assume that no changes have been made to the resources.
    Maximum:  EDAM_NOTE_TAGS_MAX tags per note
    </dd>
  
  <dt>resources</dt>
    <dd>The list of resources that are embedded within this note.
    If the list of resources are omitted on a call to updateNote(), then
    the server will assume that no changes have been made to the resources.
    The binary contents of the resources must be provided when the resource
    is first sent to the service, but it will be omitted by the service when
    the Note is returned in the future.
    Maximum:  EDAM_NOTE_RESOURCES_MAX resources per note
    </dd>
  
  <dt>attributes</dt>
    <dd>A list of the attributes for this note.
    If the list of attributes are omitted on a call to updateNote(), then
    the server will assume that no changes have been made to the resources.
    </dd>
  
  <dt>tagNames</dt>
    <dd>May be provided by clients during calls to createNote() as an
    alternative to providing the tagGuids of existing tags.  If any tagNames
    are provided during createNote(), these will be found, or created if they
    don't already exist.  Created tags will have no parent (they will be at
    the top level of the tag panel).
    </dd>
  </dl>
  
  Attributes:
   - guid
   - title
   - content
   - contentHash
   - contentLength
   - created
   - updated
   - deleted
   - active
   - updateSequenceNum
   - notebookGuid
   - tagGuids
   - resources
   - attributes
   - tagNames
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'title', None, None, ), # 2
    (3, TType.STRING, 'content', None, None, ), # 3
    (4, TType.STRING, 'contentHash', None, None, ), # 4
    (5, TType.I32, 'contentLength', None, None, ), # 5
    (6, TType.I64, 'created', None, None, ), # 6
    (7, TType.I64, 'updated', None, None, ), # 7
    (8, TType.I64, 'deleted', None, None, ), # 8
    (9, TType.BOOL, 'active', None, None, ), # 9
    (10, TType.I32, 'updateSequenceNum', None, None, ), # 10
    (11, TType.STRING, 'notebookGuid', None, None, ), # 11
    (12, TType.LIST, 'tagGuids', (TType.STRING,None), None, ), # 12
    (13, TType.LIST, 'resources', (TType.STRUCT,(Resource, Resource.thrift_spec)), None, ), # 13
    (14, TType.STRUCT, 'attributes', (NoteAttributes, NoteAttributes.thrift_spec), None, ), # 14
    (15, TType.LIST, 'tagNames', (TType.STRING,None), None, ), # 15
  )

  def __init__(self, guid=None, title=None, content=None, contentHash=None, contentLength=None, created=None, updated=None, deleted=None, active=None, updateSequenceNum=None, notebookGuid=None, tagGuids=None, resources=None, attributes=None, tagNames=None,):
    self.guid = guid
    self.title = title
    self.content = content
    self.contentHash = contentHash
    self.contentLength = contentLength
    self.created = created
    self.updated = updated
    self.deleted = deleted
    self.active = active
    self.updateSequenceNum = updateSequenceNum
    self.notebookGuid = notebookGuid
    self.tagGuids = tagGuids
    self.resources = resources
    self.attributes = attributes
    self.tagNames = tagNames

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.title = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.content = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.contentHash = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.contentLength = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I64:
          self.created = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.updated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I64:
          self.deleted = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.BOOL:
          self.active = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.notebookGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.LIST:
          self.tagGuids = []
          (_etype42, _size39) = iprot.readListBegin()
          for _i43 in xrange(_size39):
            _elem44 = iprot.readString();
            self.tagGuids.append(_elem44)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.LIST:
          self.resources = []
          (_etype48, _size45) = iprot.readListBegin()
          for _i49 in xrange(_size45):
            _elem50 = Resource()
            _elem50.read(iprot)
            self.resources.append(_elem50)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRUCT:
          self.attributes = NoteAttributes()
          self.attributes.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.LIST:
          self.tagNames = []
          (_etype54, _size51) = iprot.readListBegin()
          for _i55 in xrange(_size51):
            _elem56 = iprot.readString();
            self.tagNames.append(_elem56)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Note')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.title is not None:
      oprot.writeFieldBegin('title', TType.STRING, 2)
      oprot.writeString(self.title)
      oprot.writeFieldEnd()
    if self.content is not None:
      oprot.writeFieldBegin('content', TType.STRING, 3)
      oprot.writeString(self.content)
      oprot.writeFieldEnd()
    if self.contentHash is not None:
      oprot.writeFieldBegin('contentHash', TType.STRING, 4)
      oprot.writeString(self.contentHash)
      oprot.writeFieldEnd()
    if self.contentLength is not None:
      oprot.writeFieldBegin('contentLength', TType.I32, 5)
      oprot.writeI32(self.contentLength)
      oprot.writeFieldEnd()
    if self.created is not None:
      oprot.writeFieldBegin('created', TType.I64, 6)
      oprot.writeI64(self.created)
      oprot.writeFieldEnd()
    if self.updated is not None:
      oprot.writeFieldBegin('updated', TType.I64, 7)
      oprot.writeI64(self.updated)
      oprot.writeFieldEnd()
    if self.deleted is not None:
      oprot.writeFieldBegin('deleted', TType.I64, 8)
      oprot.writeI64(self.deleted)
      oprot.writeFieldEnd()
    if self.active is not None:
      oprot.writeFieldBegin('active', TType.BOOL, 9)
      oprot.writeBool(self.active)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 10)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.notebookGuid is not None:
      oprot.writeFieldBegin('notebookGuid', TType.STRING, 11)
      oprot.writeString(self.notebookGuid)
      oprot.writeFieldEnd()
    if self.tagGuids is not None:
      oprot.writeFieldBegin('tagGuids', TType.LIST, 12)
      oprot.writeListBegin(TType.STRING, len(self.tagGuids))
      for iter57 in self.tagGuids:
        oprot.writeString(iter57)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.resources is not None:
      oprot.writeFieldBegin('resources', TType.LIST, 13)
      oprot.writeListBegin(TType.STRUCT, len(self.resources))
      for iter58 in self.resources:
        iter58.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.STRUCT, 14)
      self.attributes.write(oprot)
      oprot.writeFieldEnd()
    if self.tagNames is not None:
      oprot.writeFieldBegin('tagNames', TType.LIST, 15)
      oprot.writeListBegin(TType.STRING, len(self.tagNames))
      for iter59 in self.tagNames:
        oprot.writeString(iter59)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Publishing(object):
  """
  If a Notebook has been opened to the public, the Notebook will have a
  reference to one of these structures, which gives the location and optional
  description of the externally-visible public Notebook.
  <dl>
  <dt>uri</dt>
    <dd>If this field is present, then the notebook is published for
    mass consumption on the Internet under the provided URI, which is
    relative to a defined base publishing URI defined by the service.
    This field can only be modified via the web service GUI ... publishing
    cannot be modified via an offline client.
    <br/>
    Length:  EDAM_PUBLISHING_URI_LEN_MIN - EDAM_PUBLISHING_URI_LEN_MAX
    <br/>
    Regex:  EDAM_PUBLISHING_URI_REGEX
    </dd>
  
  <dt>order</dt>
    <dd>When the notes are publicly displayed, they will be sorted
    based on the requested criteria.
    </dd>
  
  <dt>ascending</dt>
    <dd>If this is set to true, then the public notes will be
    displayed in ascending order (e.g. from oldest to newest).  Otherwise,
    the notes will be displayed in descending order (e.g. newest to oldest).
    </dd>
  
  <dt>publicDescription</dt>
    <dd>This field may be used to provide a short
    description of the notebook, which may be displayed when (e.g.) the
    notebook is shown in a public view.  Can't begin or end with a space.
    <br/>
    Length:  EDAM_PUBLISHING_DESCRIPTION_LEN_MIN -
             EDAM_PUBLISHING_DESCRIPTION_LEN_MAX
    <br/>
    Regex:  EDAM_PUBLISHING_DESCRIPTION_REGEX
    </dd>
  
  </dl>
  
  Attributes:
   - uri
   - order
   - ascending
   - publicDescription
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'uri', None, None, ), # 1
    (2, TType.I32, 'order', None, None, ), # 2
    (3, TType.BOOL, 'ascending', None, None, ), # 3
    (4, TType.STRING, 'publicDescription', None, None, ), # 4
  )

  def __init__(self, uri=None, order=None, ascending=None, publicDescription=None,):
    self.uri = uri
    self.order = order
    self.ascending = ascending
    self.publicDescription = publicDescription

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.uri = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.order = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.ascending = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.publicDescription = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Publishing')
    if self.uri is not None:
      oprot.writeFieldBegin('uri', TType.STRING, 1)
      oprot.writeString(self.uri)
      oprot.writeFieldEnd()
    if self.order is not None:
      oprot.writeFieldBegin('order', TType.I32, 2)
      oprot.writeI32(self.order)
      oprot.writeFieldEnd()
    if self.ascending is not None:
      oprot.writeFieldBegin('ascending', TType.BOOL, 3)
      oprot.writeBool(self.ascending)
      oprot.writeFieldEnd()
    if self.publicDescription is not None:
      oprot.writeFieldBegin('publicDescription', TType.STRING, 4)
      oprot.writeString(self.publicDescription)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class BusinessNotebook(object):
  """
  If a Notebook contained in an Evernote Business account has been published
  the to business library, the Notebook will have a reference to one of these
  structures, which specifies how the Notebook will be represented in the
  library.
  
  <dl>
  <dt>notebookDescription</dt>
    <dd>A short description of the notebook's content that will be displayed
        in the business library user interface. The description may not begin
        or end with whitespace.
    <br/>
    Length: EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_LEN_MIN -
            EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_LEN_MAX
    <br/>
    Regex:  EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_REGEX
    </dd>
  
  <dt>privilege</dt>
    <dd>The privileges that will be granted to users who join the notebook through
        the business library.
    </dd>
  
  <dt>recommended</dt>
    <dd>Whether the notebook should be "recommended" when displayed in the business
        library user interface.
    </dd>
  </dl>
  
  Attributes:
   - notebookDescription
   - privilege
   - recommended
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'notebookDescription', None, None, ), # 1
    (2, TType.I32, 'privilege', None, None, ), # 2
    (3, TType.BOOL, 'recommended', None, None, ), # 3
  )

  def __init__(self, notebookDescription=None, privilege=None, recommended=None,):
    self.notebookDescription = notebookDescription
    self.privilege = privilege
    self.recommended = recommended

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.notebookDescription = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.privilege = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.recommended = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('BusinessNotebook')
    if self.notebookDescription is not None:
      oprot.writeFieldBegin('notebookDescription', TType.STRING, 1)
      oprot.writeString(self.notebookDescription)
      oprot.writeFieldEnd()
    if self.privilege is not None:
      oprot.writeFieldBegin('privilege', TType.I32, 2)
      oprot.writeI32(self.privilege)
      oprot.writeFieldEnd()
    if self.recommended is not None:
      oprot.writeFieldBegin('recommended', TType.BOOL, 3)
      oprot.writeBool(self.recommended)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SavedSearch(object):
  """
  A named search associated with the account that can be quickly re-used.
  <dl>
  <dt>guid</dt>
    <dd>The unique identifier of this search.  Will be set by the
    service, so may be omitted by the client when creating.
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>name</dt>
    <dd>The name of the saved search to display in the GUI.  The
    account may only contain one search with a given name (case-insensitive
    compare). Can't begin or end with a space.
    <br/>
    Length:  EDAM_SAVED_SEARCH_NAME_LEN_MIN - EDAM_SAVED_SEARCH_NAME_LEN_MAX
    <br/>
    Regex:  EDAM_SAVED_SEARCH_NAME_REGEX
    </dd>
  
  <dt>query</dt>
    <dd>A string expressing the search to be performed.
    <br/>
    Length:  EDAM_SAVED_SEARCH_QUERY_LEN_MIN - EDAM_SAVED_SEARCH_QUERY_LEN_MAX
    </dd>
  
  <dt>format</dt>
    <dd>The format of the query string, to determine how to parse
    and process it.
    </dd>
  
  <dt>updateSequenceNum</dt>
    <dd>A number identifying the last transaction to
    modify the state of this object.  The USN values are sequential within an
    account, and can be used to compare the order of modifications within the
    service.
    </dd>
  </dl>
  
  Attributes:
   - guid
   - name
   - query
   - format
   - updateSequenceNum
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    (3, TType.STRING, 'query', None, None, ), # 3
    (4, TType.I32, 'format', None, None, ), # 4
    (5, TType.I32, 'updateSequenceNum', None, None, ), # 5
  )

  def __init__(self, guid=None, name=None, query=None, format=None, updateSequenceNum=None,):
    self.guid = guid
    self.name = name
    self.query = query
    self.format = format
    self.updateSequenceNum = updateSequenceNum

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.query = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.format = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SavedSearch')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.query is not None:
      oprot.writeFieldBegin('query', TType.STRING, 3)
      oprot.writeString(self.query)
      oprot.writeFieldEnd()
    if self.format is not None:
      oprot.writeFieldBegin('format', TType.I32, 4)
      oprot.writeI32(self.format)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 5)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SharedNotebook(object):
  """
  Shared notebooks represent a relationship between a notebook and a single
  share invitation recipient.
  <dl>
  <dt>id</dt>
  <dd>the primary identifier of the share</dd>
  
  <dt>userId</dt>
  <dd>the user id of the owner of the notebook</dd>
  
  <dt>notebookGuid</dt>
  <dd>the GUID of the associated notebook shared.</dd>
  
  <dt>email</dt>
  <dd>the email address of the recipient - used by the notebook
  owner to identify who they shared with.</dd>
  
  <dt>notebookModifiable</dt>
  <dd>(DEPRECATED) a flag indicating the share is read/write -otherwise it's read
      only.  This field is deprecated in favor of the new "privilege" field.</dd>
  
  <dt>requireLogin</dt>
  <dd>(DEPRECATED) indicates that a user must login to access the share.  This
      field is deprecated and will be "true" for all new shared notebooks.  It
      is read-only and ignored when creating or modifying a shared notebook,
      except that a shared notebook can be modified to require login.
      See "allowPreview" for information on privileges and shared notebooks.</dd>
  
  <dt>serviceCreated</dt>
  <dd>the date the owner first created the share with the specific email
    address</dd>
  
  <dt>serviceUpdated</dt>
  <dd>the date the shared notebook was last updated on the service.  This
      will be updated when authenticateToSharedNotebook is called the first
      time with a shared notebook requiring login (i.e. when the username is
      bound to that shared notebook).</dd>
  
  <dt>username</dt>
  <dd>the username of the user who can access this share.
    Once it's assigned it cannot be changed.</dd>
  
  <dt>privilege</dt>
  <dd>The privilege level granted to the notebook, activity stream, and
      invitations.  See the corresponding enumeration for details.</dd>
  
  <dt>allowPreview</dt>
  <dd>Whether or not to grant "READ_NOTEBOOK" privilege without an
      authentication token, for authenticateToSharedNotebook(...).  With
      the change to "requireLogin" always being true for new shared
      notebooks, this is the only way to access a shared notebook without
      an authorization token.  This setting expires after the first use
      of authenticateToSharedNotebook(...) with a valid authentication
      token.</dd>
  </dl>
  
  Attributes:
   - id
   - userId
   - notebookGuid
   - email
   - notebookModifiable
   - requireLogin
   - serviceCreated
   - serviceUpdated
   - shareKey
   - username
   - privilege
   - allowPreview
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'id', None, None, ), # 1
    (2, TType.I32, 'userId', None, None, ), # 2
    (3, TType.STRING, 'notebookGuid', None, None, ), # 3
    (4, TType.STRING, 'email', None, None, ), # 4
    (5, TType.BOOL, 'notebookModifiable', None, None, ), # 5
    (6, TType.BOOL, 'requireLogin', None, None, ), # 6
    (7, TType.I64, 'serviceCreated', None, None, ), # 7
    (8, TType.STRING, 'shareKey', None, None, ), # 8
    (9, TType.STRING, 'username', None, None, ), # 9
    (10, TType.I64, 'serviceUpdated', None, None, ), # 10
    (11, TType.I32, 'privilege', None, None, ), # 11
    (12, TType.BOOL, 'allowPreview', None, None, ), # 12
  )

  def __init__(self, id=None, userId=None, notebookGuid=None, email=None, notebookModifiable=None, requireLogin=None, serviceCreated=None, serviceUpdated=None, shareKey=None, username=None, privilege=None, allowPreview=None,):
    self.id = id
    self.userId = userId
    self.notebookGuid = notebookGuid
    self.email = email
    self.notebookModifiable = notebookModifiable
    self.requireLogin = requireLogin
    self.serviceCreated = serviceCreated
    self.serviceUpdated = serviceUpdated
    self.shareKey = shareKey
    self.username = username
    self.privilege = privilege
    self.allowPreview = allowPreview

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.id = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.userId = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.notebookGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.email = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.notebookModifiable = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.requireLogin = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.serviceCreated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I64:
          self.serviceUpdated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.shareKey = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRING:
          self.username = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.I32:
          self.privilege = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.BOOL:
          self.allowPreview = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SharedNotebook')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I64, 1)
      oprot.writeI64(self.id)
      oprot.writeFieldEnd()
    if self.userId is not None:
      oprot.writeFieldBegin('userId', TType.I32, 2)
      oprot.writeI32(self.userId)
      oprot.writeFieldEnd()
    if self.notebookGuid is not None:
      oprot.writeFieldBegin('notebookGuid', TType.STRING, 3)
      oprot.writeString(self.notebookGuid)
      oprot.writeFieldEnd()
    if self.email is not None:
      oprot.writeFieldBegin('email', TType.STRING, 4)
      oprot.writeString(self.email)
      oprot.writeFieldEnd()
    if self.notebookModifiable is not None:
      oprot.writeFieldBegin('notebookModifiable', TType.BOOL, 5)
      oprot.writeBool(self.notebookModifiable)
      oprot.writeFieldEnd()
    if self.requireLogin is not None:
      oprot.writeFieldBegin('requireLogin', TType.BOOL, 6)
      oprot.writeBool(self.requireLogin)
      oprot.writeFieldEnd()
    if self.serviceCreated is not None:
      oprot.writeFieldBegin('serviceCreated', TType.I64, 7)
      oprot.writeI64(self.serviceCreated)
      oprot.writeFieldEnd()
    if self.shareKey is not None:
      oprot.writeFieldBegin('shareKey', TType.STRING, 8)
      oprot.writeString(self.shareKey)
      oprot.writeFieldEnd()
    if self.username is not None:
      oprot.writeFieldBegin('username', TType.STRING, 9)
      oprot.writeString(self.username)
      oprot.writeFieldEnd()
    if self.serviceUpdated is not None:
      oprot.writeFieldBegin('serviceUpdated', TType.I64, 10)
      oprot.writeI64(self.serviceUpdated)
      oprot.writeFieldEnd()
    if self.privilege is not None:
      oprot.writeFieldBegin('privilege', TType.I32, 11)
      oprot.writeI32(self.privilege)
      oprot.writeFieldEnd()
    if self.allowPreview is not None:
      oprot.writeFieldBegin('allowPreview', TType.BOOL, 12)
      oprot.writeBool(self.allowPreview)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NotebookRestrictions(object):
  """
  This structure captures information about the types of operations
  that cannot be performed on a given notebook with a type of
  authenticated access and credentials.  The values filled into this
  structure are based on then-current values in the server database
  for shared notebooks and notebook publishing records, as well as
  information related to the authentication token.  Information from
  the authentication token includes the application that is accessing
  the server, as defined by the permissions granted by consumer (api)
  key, and the method used to obtain the token, for example via
  authenticateToSharedNotebook, authenticateToBusiness, etc.  Note
  that changes to values in this structure that are the result of
  shared notebook or publishing record changes are communicated to
  the client via a change in the notebook USN during sync.  It is
  important to use the same access method, parameters, and consumer
  key in order obtain correct results from the sync engine.
  
  The server has the final say on what is allowed as values may
  change between calls to obtain NotebookRestrictions instances
  and to operate on data on the service.
  
  If the following are set and true, then the given restriction is
  in effect, as accessed by the same authentication token from which
  the values were obtained.
  
  <dt>noReadNotes</dt>
    <dd>The client is not able to read notes from the service and
    the notebook is write-only.
    </dd>
  <dt>noCreateNotes</dt>
    <dd>The client may not create new notes in the notebook.
    </dd>
  <dt>noUpdateNotes</dt>
    <dd>The client may not update notes currently in the notebook.
    </dd>
  <dt>noExpungeNotes</dt>
    <dd>The client may not expunge notes currently in the notebook.
    </dd>
  <dt>noShareNotes</dt>
    <dd>The client may not share notes in the notebook via the
    shareNote method.
    </dd>
  <dt>noEmailNotes</dt>
    <dd>The client may not e-mail notes via the Evernote service by
    using the emailNote method.
    </dd>
  <dt>noSendMessageToRecipients</dt>
    <dd>The client may not send messages to the share recipients of
    the notebook.
    </dd>
  <dt>noUpdateNotebook</dt>
    <dd>The client may not update the Notebook object itself, for
    example, via the updateNotebook method.
    </dd>
  <dt>noExpungeNotebook</dt>
    <dd>The client may not expunge the Notebook object itself, for
    example, via the expungeNotebook method.
    </dd>
  <dt>noSetDefaultNotebook</dt>
    <dd>The client may not set this notebook to be the default notebook.
    The caller should leave Notebook.defaultNotebook unset.
    </dd>
  <dt>noSetNotebookStack</dt>
    <dd>If the client is able to update the Notebook, the Notebook.stack
    value may not be set.
    </dd>
  <dt>noPublishToPublic</dt>
    <dd>The client may not change the publish the notebook to the public.
    For example, business notebooks may not be shared publicly.
    </dd>
  <dt>noPublishToBusinessLibrary</dt>
    <dd>The client may not publish the notebook to the business library.
    </dd>
  <dt>noCreateTags</dt>
    <dd>The client may not complete an operation that results in a new tag
    being created in the owner's account.
    </dd>
  <dt>noUpdateTags</dt>
    <dd>The client may not update tags in the owner's account.
    </dd>
  <dt>noExpungeTags</dt>
    <dd>The client may not expunge tags in the owner's account.
    </dd>
  <dt>noSetParentTag</dt>
    <dd>If the client is able to create or update tags in the owner's account,
    then they will not be able to set the parent tag.  Leave the value unset.
    </dd>
  <dt>noCreateSharedNotebooks</dt>
    <dd>The client is unable to create shared notebooks for the notebook.
    </dd>
  <dt>updateWhichSharedNotebookRestrictions</dt>
    <dd>Restrictions on which shared notebook instances can be updated.  If the
    value is not set or null, then the client can update any of the shared notebooks
    associated with the notebook on which the NotebookRestrictions are defined.
    See the enumeration for further details.
    </dd>
  <dt>expungeWhichSharedNotebookRestrictions</dt>
    <dd>Restrictions on which shared notebook instances can be expunged.  If the
    value is not set or null, then the client can expunge any of the shared notebooks
    associated with the notebook on which the NotebookRestrictions are defined.
    See the enumeration for further details.
    </dd>
  
  Attributes:
   - noReadNotes
   - noCreateNotes
   - noUpdateNotes
   - noExpungeNotes
   - noShareNotes
   - noEmailNotes
   - noSendMessageToRecipients
   - noUpdateNotebook
   - noExpungeNotebook
   - noSetDefaultNotebook
   - noSetNotebookStack
   - noPublishToPublic
   - noPublishToBusinessLibrary
   - noCreateTags
   - noUpdateTags
   - noExpungeTags
   - noSetParentTag
   - noCreateSharedNotebooks
   - updateWhichSharedNotebookRestrictions
   - expungeWhichSharedNotebookRestrictions
  """

  thrift_spec = (
    None, # 0
    (1, TType.BOOL, 'noReadNotes', None, None, ), # 1
    (2, TType.BOOL, 'noCreateNotes', None, None, ), # 2
    (3, TType.BOOL, 'noUpdateNotes', None, None, ), # 3
    (4, TType.BOOL, 'noExpungeNotes', None, None, ), # 4
    (5, TType.BOOL, 'noShareNotes', None, None, ), # 5
    (6, TType.BOOL, 'noEmailNotes', None, None, ), # 6
    (7, TType.BOOL, 'noSendMessageToRecipients', None, None, ), # 7
    (8, TType.BOOL, 'noUpdateNotebook', None, None, ), # 8
    (9, TType.BOOL, 'noExpungeNotebook', None, None, ), # 9
    (10, TType.BOOL, 'noSetDefaultNotebook', None, None, ), # 10
    (11, TType.BOOL, 'noSetNotebookStack', None, None, ), # 11
    (12, TType.BOOL, 'noPublishToPublic', None, None, ), # 12
    (13, TType.BOOL, 'noPublishToBusinessLibrary', None, None, ), # 13
    (14, TType.BOOL, 'noCreateTags', None, None, ), # 14
    (15, TType.BOOL, 'noUpdateTags', None, None, ), # 15
    (16, TType.BOOL, 'noExpungeTags', None, None, ), # 16
    (17, TType.BOOL, 'noSetParentTag', None, None, ), # 17
    (18, TType.BOOL, 'noCreateSharedNotebooks', None, None, ), # 18
    (19, TType.I32, 'updateWhichSharedNotebookRestrictions', None, None, ), # 19
    (20, TType.I32, 'expungeWhichSharedNotebookRestrictions', None, None, ), # 20
  )

  def __init__(self, noReadNotes=None, noCreateNotes=None, noUpdateNotes=None, noExpungeNotes=None, noShareNotes=None, noEmailNotes=None, noSendMessageToRecipients=None, noUpdateNotebook=None, noExpungeNotebook=None, noSetDefaultNotebook=None, noSetNotebookStack=None, noPublishToPublic=None, noPublishToBusinessLibrary=None, noCreateTags=None, noUpdateTags=None, noExpungeTags=None, noSetParentTag=None, noCreateSharedNotebooks=None, updateWhichSharedNotebookRestrictions=None, expungeWhichSharedNotebookRestrictions=None,):
    self.noReadNotes = noReadNotes
    self.noCreateNotes = noCreateNotes
    self.noUpdateNotes = noUpdateNotes
    self.noExpungeNotes = noExpungeNotes
    self.noShareNotes = noShareNotes
    self.noEmailNotes = noEmailNotes
    self.noSendMessageToRecipients = noSendMessageToRecipients
    self.noUpdateNotebook = noUpdateNotebook
    self.noExpungeNotebook = noExpungeNotebook
    self.noSetDefaultNotebook = noSetDefaultNotebook
    self.noSetNotebookStack = noSetNotebookStack
    self.noPublishToPublic = noPublishToPublic
    self.noPublishToBusinessLibrary = noPublishToBusinessLibrary
    self.noCreateTags = noCreateTags
    self.noUpdateTags = noUpdateTags
    self.noExpungeTags = noExpungeTags
    self.noSetParentTag = noSetParentTag
    self.noCreateSharedNotebooks = noCreateSharedNotebooks
    self.updateWhichSharedNotebookRestrictions = updateWhichSharedNotebookRestrictions
    self.expungeWhichSharedNotebookRestrictions = expungeWhichSharedNotebookRestrictions

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.BOOL:
          self.noReadNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.BOOL:
          self.noCreateNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.noUpdateNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.noExpungeNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.noShareNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.noEmailNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.BOOL:
          self.noSendMessageToRecipients = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.BOOL:
          self.noUpdateNotebook = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.BOOL:
          self.noExpungeNotebook = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.BOOL:
          self.noSetDefaultNotebook = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.BOOL:
          self.noSetNotebookStack = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.BOOL:
          self.noPublishToPublic = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.BOOL:
          self.noPublishToBusinessLibrary = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.BOOL:
          self.noCreateTags = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.BOOL:
          self.noUpdateTags = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.BOOL:
          self.noExpungeTags = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.BOOL:
          self.noSetParentTag = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 18:
        if ftype == TType.BOOL:
          self.noCreateSharedNotebooks = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 19:
        if ftype == TType.I32:
          self.updateWhichSharedNotebookRestrictions = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 20:
        if ftype == TType.I32:
          self.expungeWhichSharedNotebookRestrictions = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NotebookRestrictions')
    if self.noReadNotes is not None:
      oprot.writeFieldBegin('noReadNotes', TType.BOOL, 1)
      oprot.writeBool(self.noReadNotes)
      oprot.writeFieldEnd()
    if self.noCreateNotes is not None:
      oprot.writeFieldBegin('noCreateNotes', TType.BOOL, 2)
      oprot.writeBool(self.noCreateNotes)
      oprot.writeFieldEnd()
    if self.noUpdateNotes is not None:
      oprot.writeFieldBegin('noUpdateNotes', TType.BOOL, 3)
      oprot.writeBool(self.noUpdateNotes)
      oprot.writeFieldEnd()
    if self.noExpungeNotes is not None:
      oprot.writeFieldBegin('noExpungeNotes', TType.BOOL, 4)
      oprot.writeBool(self.noExpungeNotes)
      oprot.writeFieldEnd()
    if self.noShareNotes is not None:
      oprot.writeFieldBegin('noShareNotes', TType.BOOL, 5)
      oprot.writeBool(self.noShareNotes)
      oprot.writeFieldEnd()
    if self.noEmailNotes is not None:
      oprot.writeFieldBegin('noEmailNotes', TType.BOOL, 6)
      oprot.writeBool(self.noEmailNotes)
      oprot.writeFieldEnd()
    if self.noSendMessageToRecipients is not None:
      oprot.writeFieldBegin('noSendMessageToRecipients', TType.BOOL, 7)
      oprot.writeBool(self.noSendMessageToRecipients)
      oprot.writeFieldEnd()
    if self.noUpdateNotebook is not None:
      oprot.writeFieldBegin('noUpdateNotebook', TType.BOOL, 8)
      oprot.writeBool(self.noUpdateNotebook)
      oprot.writeFieldEnd()
    if self.noExpungeNotebook is not None:
      oprot.writeFieldBegin('noExpungeNotebook', TType.BOOL, 9)
      oprot.writeBool(self.noExpungeNotebook)
      oprot.writeFieldEnd()
    if self.noSetDefaultNotebook is not None:
      oprot.writeFieldBegin('noSetDefaultNotebook', TType.BOOL, 10)
      oprot.writeBool(self.noSetDefaultNotebook)
      oprot.writeFieldEnd()
    if self.noSetNotebookStack is not None:
      oprot.writeFieldBegin('noSetNotebookStack', TType.BOOL, 11)
      oprot.writeBool(self.noSetNotebookStack)
      oprot.writeFieldEnd()
    if self.noPublishToPublic is not None:
      oprot.writeFieldBegin('noPublishToPublic', TType.BOOL, 12)
      oprot.writeBool(self.noPublishToPublic)
      oprot.writeFieldEnd()
    if self.noPublishToBusinessLibrary is not None:
      oprot.writeFieldBegin('noPublishToBusinessLibrary', TType.BOOL, 13)
      oprot.writeBool(self.noPublishToBusinessLibrary)
      oprot.writeFieldEnd()
    if self.noCreateTags is not None:
      oprot.writeFieldBegin('noCreateTags', TType.BOOL, 14)
      oprot.writeBool(self.noCreateTags)
      oprot.writeFieldEnd()
    if self.noUpdateTags is not None:
      oprot.writeFieldBegin('noUpdateTags', TType.BOOL, 15)
      oprot.writeBool(self.noUpdateTags)
      oprot.writeFieldEnd()
    if self.noExpungeTags is not None:
      oprot.writeFieldBegin('noExpungeTags', TType.BOOL, 16)
      oprot.writeBool(self.noExpungeTags)
      oprot.writeFieldEnd()
    if self.noSetParentTag is not None:
      oprot.writeFieldBegin('noSetParentTag', TType.BOOL, 17)
      oprot.writeBool(self.noSetParentTag)
      oprot.writeFieldEnd()
    if self.noCreateSharedNotebooks is not None:
      oprot.writeFieldBegin('noCreateSharedNotebooks', TType.BOOL, 18)
      oprot.writeBool(self.noCreateSharedNotebooks)
      oprot.writeFieldEnd()
    if self.updateWhichSharedNotebookRestrictions is not None:
      oprot.writeFieldBegin('updateWhichSharedNotebookRestrictions', TType.I32, 19)
      oprot.writeI32(self.updateWhichSharedNotebookRestrictions)
      oprot.writeFieldEnd()
    if self.expungeWhichSharedNotebookRestrictions is not None:
      oprot.writeFieldBegin('expungeWhichSharedNotebookRestrictions', TType.I32, 20)
      oprot.writeI32(self.expungeWhichSharedNotebookRestrictions)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Notebook(object):
  """
  A unique container for a set of notes.
  <dl>
  <dt>guid</dt>
    <dd>The unique identifier of this notebook.
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>name</dt>
    <dd>A sequence of characters representing the name of the
    notebook.  May be changed by clients, but the account may not contain two
    notebooks with names that are equal via a case-insensitive comparison.
    Can't begin or end with a space.
    <br/>
    Length:  EDAM_NOTEBOOK_NAME_LEN_MIN - EDAM_NOTEBOOK_NAME_LEN_MAX
    <br/>
    Regex:  EDAM_NOTEBOOK_NAME_REGEX
    </dd>
  
  <dt>updateSequenceNum</dt>
    <dd>A number identifying the last transaction to
    modify the state of this object.  The USN values are sequential within an
    account, and can be used to compare the order of modifications within the
    service.
    </dd>
  
  <dt>defaultNotebook</dt>
    <dd>If true, this notebook should be used for new notes
    whenever the user has not (or cannot) specify a desired target notebook.
    For example, if a note is submitted via SMTP email.
    The service will maintain at most one defaultNotebook per account.
    If a second notebook is created or updated with defaultNotebook set to
    true, the service will automatically update the prior notebook's
    defaultNotebook field to false.  If the default notebook is deleted
    (i.e. "active" set to false), the "defaultNotebook" field will be
    set to false by the service.  If the account has no default notebook
    set, the service will use the most recent notebook as the default.
    </dd>
  
  <dt>serviceCreated</dt>
    <dd>The time when this notebook was created on the
    service. This will be set on the service during creation, and the service
    will provide this value when it returns a Notebook to a client.
    The service will ignore this value if it is sent by clients.
    </dd>
  
  <dt>serviceUpdated</dt>
    <dd>The time when this notebook was last modified on the
    service.  This will be set on the service during creation, and the service
    will provide this value when it returns a Notebook to a client.
    The service will ignore this value if it is sent by clients.
    </dd>
  
  <dt>publishing</dt>
    <dd>If the Notebook has been opened for public access, or
    business users shared with their business (i.e. if 'published' is
    set to true), then this will point to the set of publishing
    information for the Notebook (URI, description, etc.).  A
    Notebook cannot be published without providing this information,
    but it will persist for later use if publishing is ever disabled
    on the Notebook.  Clients that do not wish to change the
    publishing behavior of a Notebook should not set this value when
    calling NoteStore.updateNotebook().
    </dd>
  
  <dt>published</dt>
    <dd>If this is set to true, then the Notebook will be
    accessible either to the public, or for business users to their business,
    via the 'publishing' specification, which must also be set.  If this is set
    to false, the Notebook will not be available to the public (or business).
    Clients that do not wish to change the publishing behavior of a Notebook
    should not set this value when calling NoteStore.updateNotebook().
    </dd>
  
  <dt>stack</dt>
    <dd>If this is set, then the notebook is visually contained within a stack
    of notebooks with this name.  All notebooks in the same account with the
    same 'stack' field are considered to be in the same stack.
    Notebooks with no stack set are "top level" and not contained within a
    stack.
    </dd>
  
  <dt>sharedNotebookIds</dt>
    <dd><i>DEPRECATED</i> - replaced by sharedNotebooks.</dd>
  
  <dt>sharedNotebooks</dt>
    <dd>The list of recipients to whom this notebook has been shared
    (one SharedNotebook object per recipient email address). This field will
    be unset if you do not have permission to access this data. If you are
    accessing the notebook as the owner or via a shared notebook that is
    modifiable, then you have access to this data and the value will be set.
    This field is read-only. Clients may not make changes to shared notebooks
    via this field.
    </dd>
  
  <dt>businessNotebook</dt>
    <dd>If the notebook is part of a business account and has been published to the
    business library, this will contain information for the library listing.
    The presence or absence of this field is not a reliable test of whether a given
    notebook is in fact a business notebook - the field is only used when a notebook is or
    has been published to the business library.
    </dd>
  
  <dt>contact</dt>
    <dd>Intended for use with Business accounts, this field identifies the user who
    has been designated as the "contact".  For notebooks created in business
    accounts, the server will automatically set this value to the user who created
    the notebook unless Notebook.contact.username has been set, in which that value
    will be used.  When updating a notebook, it is common to leave Notebook.contact
    field unset, indicating that no change to the value is being requested and that
    the existing value, if any, should be preserved.
    </dd>
  
  </dl>
  
  Attributes:
   - guid
   - name
   - updateSequenceNum
   - defaultNotebook
   - serviceCreated
   - serviceUpdated
   - publishing
   - published
   - stack
   - sharedNotebookIds
   - sharedNotebooks
   - businessNotebook
   - contact
   - restrictions
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    None, # 3
    None, # 4
    (5, TType.I32, 'updateSequenceNum', None, None, ), # 5
    (6, TType.BOOL, 'defaultNotebook', None, None, ), # 6
    (7, TType.I64, 'serviceCreated', None, None, ), # 7
    (8, TType.I64, 'serviceUpdated', None, None, ), # 8
    None, # 9
    (10, TType.STRUCT, 'publishing', (Publishing, Publishing.thrift_spec), None, ), # 10
    (11, TType.BOOL, 'published', None, None, ), # 11
    (12, TType.STRING, 'stack', None, None, ), # 12
    (13, TType.LIST, 'sharedNotebookIds', (TType.I64,None), None, ), # 13
    (14, TType.LIST, 'sharedNotebooks', (TType.STRUCT,(SharedNotebook, SharedNotebook.thrift_spec)), None, ), # 14
    (15, TType.STRUCT, 'businessNotebook', (BusinessNotebook, BusinessNotebook.thrift_spec), None, ), # 15
    (16, TType.STRUCT, 'contact', (User, User.thrift_spec), None, ), # 16
    (17, TType.STRUCT, 'restrictions', (NotebookRestrictions, NotebookRestrictions.thrift_spec), None, ), # 17
  )

  def __init__(self, guid=None, name=None, updateSequenceNum=None, defaultNotebook=None, serviceCreated=None, serviceUpdated=None, publishing=None, published=None, stack=None, sharedNotebookIds=None, sharedNotebooks=None, businessNotebook=None, contact=None, restrictions=None,):
    self.guid = guid
    self.name = name
    self.updateSequenceNum = updateSequenceNum
    self.defaultNotebook = defaultNotebook
    self.serviceCreated = serviceCreated
    self.serviceUpdated = serviceUpdated
    self.publishing = publishing
    self.published = published
    self.stack = stack
    self.sharedNotebookIds = sharedNotebookIds
    self.sharedNotebooks = sharedNotebooks
    self.businessNotebook = businessNotebook
    self.contact = contact
    self.restrictions = restrictions

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.defaultNotebook = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.serviceCreated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I64:
          self.serviceUpdated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.STRUCT:
          self.publishing = Publishing()
          self.publishing.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.BOOL:
          self.published = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.STRING:
          self.stack = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.LIST:
          self.sharedNotebookIds = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = iprot.readI64();
            self.sharedNotebookIds.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.LIST:
          self.sharedNotebooks = []
          (_etype69, _size66) = iprot.readListBegin()
          for _i70 in xrange(_size66):
            _elem71 = SharedNotebook()
            _elem71.read(iprot)
            self.sharedNotebooks.append(_elem71)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.STRUCT:
          self.businessNotebook = BusinessNotebook()
          self.businessNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.STRUCT:
          self.contact = User()
          self.contact.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 17:
        if ftype == TType.STRUCT:
          self.restrictions = NotebookRestrictions()
          self.restrictions.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Notebook')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 5)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.defaultNotebook is not None:
      oprot.writeFieldBegin('defaultNotebook', TType.BOOL, 6)
      oprot.writeBool(self.defaultNotebook)
      oprot.writeFieldEnd()
    if self.serviceCreated is not None:
      oprot.writeFieldBegin('serviceCreated', TType.I64, 7)
      oprot.writeI64(self.serviceCreated)
      oprot.writeFieldEnd()
    if self.serviceUpdated is not None:
      oprot.writeFieldBegin('serviceUpdated', TType.I64, 8)
      oprot.writeI64(self.serviceUpdated)
      oprot.writeFieldEnd()
    if self.publishing is not None:
      oprot.writeFieldBegin('publishing', TType.STRUCT, 10)
      self.publishing.write(oprot)
      oprot.writeFieldEnd()
    if self.published is not None:
      oprot.writeFieldBegin('published', TType.BOOL, 11)
      oprot.writeBool(self.published)
      oprot.writeFieldEnd()
    if self.stack is not None:
      oprot.writeFieldBegin('stack', TType.STRING, 12)
      oprot.writeString(self.stack)
      oprot.writeFieldEnd()
    if self.sharedNotebookIds is not None:
      oprot.writeFieldBegin('sharedNotebookIds', TType.LIST, 13)
      oprot.writeListBegin(TType.I64, len(self.sharedNotebookIds))
      for iter72 in self.sharedNotebookIds:
        oprot.writeI64(iter72)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.sharedNotebooks is not None:
      oprot.writeFieldBegin('sharedNotebooks', TType.LIST, 14)
      oprot.writeListBegin(TType.STRUCT, len(self.sharedNotebooks))
      for iter73 in self.sharedNotebooks:
        iter73.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.businessNotebook is not None:
      oprot.writeFieldBegin('businessNotebook', TType.STRUCT, 15)
      self.businessNotebook.write(oprot)
      oprot.writeFieldEnd()
    if self.contact is not None:
      oprot.writeFieldBegin('contact', TType.STRUCT, 16)
      self.contact.write(oprot)
      oprot.writeFieldEnd()
    if self.restrictions is not None:
      oprot.writeFieldBegin('restrictions', TType.STRUCT, 17)
      self.restrictions.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LinkedNotebook(object):
  """
  A link in an users account that refers them to a public or individual share in
  another user's account.
  
  <dl>
  <dt>shareName</dt>
  <dd>the display name of the shared notebook.
    The link owner can change this.</dd>
  
  <dt>username</dt>
  <dd>the username of the user who owns the shared or public notebook</dd>
  
  <dt>shardId</dt>
  <dd>the shard ID of the notebook if the notebook is not public</dt>
  
  <dt>shareKey</dt>
  <dd>the secret key that provides access to the shared notebook</dd>
  
  <dt>uri</dt>
  <dd>the identifier of the public notebook</dd>
  
  <dt>guid</dt>
    <dd>The unique identifier of this linked notebook.  Will be set whenever
    a linked notebook is retrieved from the service, but may be null when a client
    is creating a linked notebook.
    <br/>
    Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
    <br/>
    Regex:  EDAM_GUID_REGEX
    </dd>
  
  <dt>updateSequenceNum</dt>
    <dd>A number identifying the last transaction to
    modify the state of this object.  The USN values are sequential within an
    account, and can be used to compare the order of modifications within the
    service.
    </dd>
  
  <dt>noteStoreUrl</dt>
    <dd>
    This field will contain the full URL that clients should use to make
    NoteStore requests to the server shard that contains that notebook's data.
    I.e. this is the URL that should be used to create the Thrift HTTP client
    transport to send messages to the NoteStore service for the account.
    </dd>
  
  <dt>webApiUrlPrefix:</dt>
    <dd>
    This field will contain the initial part of the URLs that should be used
    to make requests to Evernote's thin client "web API", which provide
    optimized operations for clients that aren't capable of manipulating
    the full contents of accounts via the full Thrift data model. Clients
    should concatenate the relative path for the various servlets onto the
    end of this string to construct the full URL, as documented on our
    developer web site.
    </dd>
  
  <dt>stack</dt>
    <dd>If this is set, then the notebook is visually contained within a stack
    of notebooks with this name.  All notebooks in the same account with the
    same 'stack' field are considered to be in the same stack.
    Notebooks with no stack set are "top level" and not contained within a
    stack.  The link owner can change this and this field is for the benefit
    of the link owner.
    </dd>
  
  <dt>businessId</dt>
    <dd>If set, this will be the unique identifier for the business that owns
    the notebook to which the linked notebook refers.
  
  </dl>
  
  Attributes:
   - shareName
   - username
   - shardId
   - shareKey
   - uri
   - guid
   - updateSequenceNum
   - noteStoreUrl
   - webApiUrlPrefix
   - stack
   - businessId
  """

  thrift_spec = (
    None, # 0
    None, # 1
    (2, TType.STRING, 'shareName', None, None, ), # 2
    (3, TType.STRING, 'username', None, None, ), # 3
    (4, TType.STRING, 'shardId', None, None, ), # 4
    (5, TType.STRING, 'shareKey', None, None, ), # 5
    (6, TType.STRING, 'uri', None, None, ), # 6
    (7, TType.STRING, 'guid', None, None, ), # 7
    (8, TType.I32, 'updateSequenceNum', None, None, ), # 8
    (9, TType.STRING, 'noteStoreUrl', None, None, ), # 9
    (10, TType.STRING, 'webApiUrlPrefix', None, None, ), # 10
    (11, TType.STRING, 'stack', None, None, ), # 11
    (12, TType.I32, 'businessId', None, None, ), # 12
  )

  def __init__(self, shareName=None, username=None, shardId=None, shareKey=None, uri=None, guid=None, updateSequenceNum=None, noteStoreUrl=None, webApiUrlPrefix=None, stack=None, businessId=None,):
    self.shareName = shareName
    self.username = username
    self.shardId = shardId
    self.shareKey = shareKey
    self.uri = uri
    self.guid = guid
    self.updateSequenceNum = updateSequenceNum
    self.noteStoreUrl = noteStoreUrl
    self.webApiUrlPrefix = webApiUrlPrefix
    self.stack = stack
    self.businessId = businessId

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 2:
        if ftype == TType.STRING:
          self.shareName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.username = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.shardId = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.shareKey = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.uri = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRING:
          self.noteStoreUrl = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.STRING:
          self.webApiUrlPrefix = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.stack = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.I32:
          self.businessId = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LinkedNotebook')
    if self.shareName is not None:
      oprot.writeFieldBegin('shareName', TType.STRING, 2)
      oprot.writeString(self.shareName)
      oprot.writeFieldEnd()
    if self.username is not None:
      oprot.writeFieldBegin('username', TType.STRING, 3)
      oprot.writeString(self.username)
      oprot.writeFieldEnd()
    if self.shardId is not None:
      oprot.writeFieldBegin('shardId', TType.STRING, 4)
      oprot.writeString(self.shardId)
      oprot.writeFieldEnd()
    if self.shareKey is not None:
      oprot.writeFieldBegin('shareKey', TType.STRING, 5)
      oprot.writeString(self.shareKey)
      oprot.writeFieldEnd()
    if self.uri is not None:
      oprot.writeFieldBegin('uri', TType.STRING, 6)
      oprot.writeString(self.uri)
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 7)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 8)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.noteStoreUrl is not None:
      oprot.writeFieldBegin('noteStoreUrl', TType.STRING, 9)
      oprot.writeString(self.noteStoreUrl)
      oprot.writeFieldEnd()
    if self.webApiUrlPrefix is not None:
      oprot.writeFieldBegin('webApiUrlPrefix', TType.STRING, 10)
      oprot.writeString(self.webApiUrlPrefix)
      oprot.writeFieldEnd()
    if self.stack is not None:
      oprot.writeFieldBegin('stack', TType.STRING, 11)
      oprot.writeString(self.stack)
      oprot.writeFieldEnd()
    if self.businessId is not None:
      oprot.writeFieldBegin('businessId', TType.I32, 12)
      oprot.writeI32(self.businessId)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NotebookDescriptor(object):
  """
  A structure that describes a notebook or a user's relationship with
  a notebook. NotebookDescriptor is expected to remain a lighter-weight
  structure when compared to Notebook.
  <dl>
  <dt>guid</dt>
    <dd>The unique identifier of the notebook.
    </dd>
  
  <dt>notebookDisplayName</dt>
    <dd>A sequence of characters representing the name of the
    notebook.
    </dd>
  
  <dt>contactName</dt>
    <dd>The User.name value of the notebook's "contact".
    </dd>
  
  <dt>hasSharedNotebook</dt>
    <dd>Whether a SharedNotebook record exists between the calling user and this
    notebook.
    </dd>
  
  <dt>joinedUserCount</dt>
    <dd>The number of users who have joined this notebook.
    </dd>
  
  </dl>
  
  Attributes:
   - guid
   - notebookDisplayName
   - contactName
   - hasSharedNotebook
   - joinedUserCount
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'notebookDisplayName', None, None, ), # 2
    (3, TType.STRING, 'contactName', None, None, ), # 3
    (4, TType.BOOL, 'hasSharedNotebook', None, None, ), # 4
    (5, TType.I32, 'joinedUserCount', None, None, ), # 5
  )

  def __init__(self, guid=None, notebookDisplayName=None, contactName=None, hasSharedNotebook=None, joinedUserCount=None,):
    self.guid = guid
    self.notebookDisplayName = notebookDisplayName
    self.contactName = contactName
    self.hasSharedNotebook = hasSharedNotebook
    self.joinedUserCount = joinedUserCount

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.notebookDisplayName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.contactName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.hasSharedNotebook = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.joinedUserCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NotebookDescriptor')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.notebookDisplayName is not None:
      oprot.writeFieldBegin('notebookDisplayName', TType.STRING, 2)
      oprot.writeString(self.notebookDisplayName)
      oprot.writeFieldEnd()
    if self.contactName is not None:
      oprot.writeFieldBegin('contactName', TType.STRING, 3)
      oprot.writeString(self.contactName)
      oprot.writeFieldEnd()
    if self.hasSharedNotebook is not None:
      oprot.writeFieldBegin('hasSharedNotebook', TType.BOOL, 4)
      oprot.writeBool(self.hasSharedNotebook)
      oprot.writeFieldEnd()
    if self.joinedUserCount is not None:
      oprot.writeFieldBegin('joinedUserCount', TType.I32, 5)
      oprot.writeI32(self.joinedUserCount)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
