#
# Autogenerated by Thrift Compiler
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
import evernote.edam.userstore.ttypes
import evernote.edam.type.ttypes
import evernote.edam.error.ttypes
import evernote.edam.limits.ttypes


from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None



class SyncState(object):
  """
   This structure encapsulates the information about the state of the
   user's account for the purpose of "state based" synchronization.
  <dl>
   <dt>currentTime</dt>
     <dd>
     The server's current date and time.
     </dd>
  
   <dt>fullSyncBefore</dt>
     <dd>
     The cutoff date and time for client caches to be
     updated via incremental synchronization.  Any clients that were last
     synched with the server before this date/time must do a full resync of all
     objects.  This cutoff point will change over time as archival data is
     deleted or special circumstances on the service require resynchronization.
     </dd>
  
   <dt>updateCount</dt>
     <dd>
     Indicates the total number of transactions that have
     been committed within the account.  This reflects (for example) the
     number of discrete additions or modifications that have been made to
     the data in this account (tags, notes, resources, etc.).
     This number is the "high water mark" for Update Sequence Numbers (USN)
     within the account.
     </dd>
  
   <dt>uploaded</dt>
     <dd>
     The total number of bytes that have been uploaded to
     this account in the current monthly period.  This can be compared against
     Accounting.uploadLimit (from the UserStore) to determine how close the user
     is to their monthly upload limit.
     This value may not be present if the SyncState has been retrieved by
     a caller that only has read access to the account.
     </dd>
   </dl>
  
  Attributes:
   - currentTime
   - fullSyncBefore
   - updateCount
   - uploaded
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'currentTime', None, None, ), # 1
    (2, TType.I64, 'fullSyncBefore', None, None, ), # 2
    (3, TType.I32, 'updateCount', None, None, ), # 3
    (4, TType.I64, 'uploaded', None, None, ), # 4
  )

  def __init__(self, currentTime=None, fullSyncBefore=None, updateCount=None, uploaded=None,):
    self.currentTime = currentTime
    self.fullSyncBefore = fullSyncBefore
    self.updateCount = updateCount
    self.uploaded = uploaded

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.currentTime = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.fullSyncBefore = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.updateCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.uploaded = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SyncState')
    if self.currentTime is not None:
      oprot.writeFieldBegin('currentTime', TType.I64, 1)
      oprot.writeI64(self.currentTime)
      oprot.writeFieldEnd()
    if self.fullSyncBefore is not None:
      oprot.writeFieldBegin('fullSyncBefore', TType.I64, 2)
      oprot.writeI64(self.fullSyncBefore)
      oprot.writeFieldEnd()
    if self.updateCount is not None:
      oprot.writeFieldBegin('updateCount', TType.I32, 3)
      oprot.writeI32(self.updateCount)
      oprot.writeFieldEnd()
    if self.uploaded is not None:
      oprot.writeFieldBegin('uploaded', TType.I64, 4)
      oprot.writeI64(self.uploaded)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.currentTime is None:
      raise TProtocol.TProtocolException(message='Required field currentTime is unset!')
    if self.fullSyncBefore is None:
      raise TProtocol.TProtocolException(message='Required field fullSyncBefore is unset!')
    if self.updateCount is None:
      raise TProtocol.TProtocolException(message='Required field updateCount is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SyncChunk(object):
  """
   This structure is given out by the NoteStore when a client asks to
   receive the current state of an account.  The client asks for the server's
   state one chunk at a time in order to allow clients to retrieve the state
   of a large account without needing to transfer the entire account in
   a single message.
  
   The server always gives SyncChunks using an ascending series of Update
   Sequence Numbers (USNs).
  
  <dl>
   <dt>currentTime</dt>
     <dd>
     The server's current date and time.
     </dd>
  
   <dt>chunkHighUSN</dt>
     <dd>
     The highest USN for any of the data objects represented
     in this sync chunk.  If there are no objects in the chunk, this will not be
     set.
     </dd>
  
   <dt>updateCount</dt>
     <dd>
     The total number of updates that have been performed in
     the service for this account.  This is equal to the highest USN within the
     account at the point that this SyncChunk was generated.  If updateCount
     and chunkHighUSN are identical, that means that this is the last chunk
     in the account ... there is no more recent information.
     </dd>
  
   <dt>notes</dt>
     <dd>
     If present, this is a list of non-expunged notes that
     have a USN in this chunk.  This will include notes that are "deleted"
     but not expunged (i.e. in the trash).  The notes will include their list
     of tags and resources, but the resource content and recognition data
     will not be supplied.
     </dd>
  
   <dt>notebooks</dt>
     <dd>
     If present, this is a list of non-expunged notebooks that
     have a USN in this chunk.  This will include notebooks that are "deleted"
     but not expunged (i.e. in the trash).
     </dd>
  
   <dt>tags</dt>
     <dd>
     If present, this is a list of the non-expunged tags that have a
     USN in this chunk.
     </dd>
  
   <dt>searches</dt>
     <dd>
     If present, this is a list of non-expunged searches that
     have a USN in this chunk.
     </dd>
  
   <dt>resources</dt>
     <dd>
     If present, this is a list of the non-expunged resources
     that have a USN in this chunk.  This will include the metadata for each
     resource, but not its binary contents or recognition data, which must be
     retrieved separately.
     </dd>
  
   <dt>expungedNotes</dt>
     <dd>
     If present, the GUIDs of all of the notes that were
     permanently expunged in this chunk.
     </dd>
  
   <dt>expungedNotebooks</dt>
     <dd>
     If present, the GUIDs of all of the notebooks that
     were permanently expunged in this chunk.  When a notebook is expunged,
     this implies that all of its child notes (and their resources) were
     also expunged.
     </dd>
  
   <dt>expungedTags</dt>
     <dd>
     If present, the GUIDs of all of the tags that were
     permanently expunged in this chunk.
     </dd>
  
   <dt>expungedSearches</dt>
     <dd>
     If present, the GUIDs of all of the saved searches
     that were permanently expunged in this chunk.
     </dd>
  
   <dt>linkedNotebooks</dt>
     <dd>
     If present, this is a list of non-expunged LinkedNotebooks that
     have a USN in this chunk.
     </dd>
  
   <dt>expungedLinkedNotebooks</dt>
     <dd>
     If present, the GUIDs of all of the LinkedNotebooks
     that were permanently expunged in this chunk.
     </dd>
   </dl>
  
  Attributes:
   - currentTime
   - chunkHighUSN
   - updateCount
   - notes
   - notebooks
   - tags
   - searches
   - resources
   - expungedNotes
   - expungedNotebooks
   - expungedTags
   - expungedSearches
   - linkedNotebooks
   - expungedLinkedNotebooks
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'currentTime', None, None, ), # 1
    (2, TType.I32, 'chunkHighUSN', None, None, ), # 2
    (3, TType.I32, 'updateCount', None, None, ), # 3
    (4, TType.LIST, 'notes', (TType.STRUCT,(evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec)), None, ), # 4
    (5, TType.LIST, 'notebooks', (TType.STRUCT,(evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec)), None, ), # 5
    (6, TType.LIST, 'tags', (TType.STRUCT,(evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec)), None, ), # 6
    (7, TType.LIST, 'searches', (TType.STRUCT,(evernote.edam.type.ttypes.SavedSearch, evernote.edam.type.ttypes.SavedSearch.thrift_spec)), None, ), # 7
    (8, TType.LIST, 'resources', (TType.STRUCT,(evernote.edam.type.ttypes.Resource, evernote.edam.type.ttypes.Resource.thrift_spec)), None, ), # 8
    (9, TType.LIST, 'expungedNotes', (TType.STRING,None), None, ), # 9
    (10, TType.LIST, 'expungedNotebooks', (TType.STRING,None), None, ), # 10
    (11, TType.LIST, 'expungedTags', (TType.STRING,None), None, ), # 11
    (12, TType.LIST, 'expungedSearches', (TType.STRING,None), None, ), # 12
    (13, TType.LIST, 'linkedNotebooks', (TType.STRUCT,(evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec)), None, ), # 13
    (14, TType.LIST, 'expungedLinkedNotebooks', (TType.STRING,None), None, ), # 14
  )

  def __init__(self, currentTime=None, chunkHighUSN=None, updateCount=None, notes=None, notebooks=None, tags=None, searches=None, resources=None, expungedNotes=None, expungedNotebooks=None, expungedTags=None, expungedSearches=None, linkedNotebooks=None, expungedLinkedNotebooks=None,):
    self.currentTime = currentTime
    self.chunkHighUSN = chunkHighUSN
    self.updateCount = updateCount
    self.notes = notes
    self.notebooks = notebooks
    self.tags = tags
    self.searches = searches
    self.resources = resources
    self.expungedNotes = expungedNotes
    self.expungedNotebooks = expungedNotebooks
    self.expungedTags = expungedTags
    self.expungedSearches = expungedSearches
    self.linkedNotebooks = linkedNotebooks
    self.expungedLinkedNotebooks = expungedLinkedNotebooks

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.currentTime = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.chunkHighUSN = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.updateCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.notes = []
          (_etype3, _size0) = iprot.readListBegin()
          for _i4 in xrange(_size0):
            _elem5 = evernote.edam.type.ttypes.Note()
            _elem5.read(iprot)
            self.notes.append(_elem5)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.notebooks = []
          (_etype9, _size6) = iprot.readListBegin()
          for _i10 in xrange(_size6):
            _elem11 = evernote.edam.type.ttypes.Notebook()
            _elem11.read(iprot)
            self.notebooks.append(_elem11)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.LIST:
          self.tags = []
          (_etype15, _size12) = iprot.readListBegin()
          for _i16 in xrange(_size12):
            _elem17 = evernote.edam.type.ttypes.Tag()
            _elem17.read(iprot)
            self.tags.append(_elem17)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.LIST:
          self.searches = []
          (_etype21, _size18) = iprot.readListBegin()
          for _i22 in xrange(_size18):
            _elem23 = evernote.edam.type.ttypes.SavedSearch()
            _elem23.read(iprot)
            self.searches.append(_elem23)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.LIST:
          self.resources = []
          (_etype27, _size24) = iprot.readListBegin()
          for _i28 in xrange(_size24):
            _elem29 = evernote.edam.type.ttypes.Resource()
            _elem29.read(iprot)
            self.resources.append(_elem29)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.LIST:
          self.expungedNotes = []
          (_etype33, _size30) = iprot.readListBegin()
          for _i34 in xrange(_size30):
            _elem35 = iprot.readString();
            self.expungedNotes.append(_elem35)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.LIST:
          self.expungedNotebooks = []
          (_etype39, _size36) = iprot.readListBegin()
          for _i40 in xrange(_size36):
            _elem41 = iprot.readString();
            self.expungedNotebooks.append(_elem41)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.LIST:
          self.expungedTags = []
          (_etype45, _size42) = iprot.readListBegin()
          for _i46 in xrange(_size42):
            _elem47 = iprot.readString();
            self.expungedTags.append(_elem47)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.LIST:
          self.expungedSearches = []
          (_etype51, _size48) = iprot.readListBegin()
          for _i52 in xrange(_size48):
            _elem53 = iprot.readString();
            self.expungedSearches.append(_elem53)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.LIST:
          self.linkedNotebooks = []
          (_etype57, _size54) = iprot.readListBegin()
          for _i58 in xrange(_size54):
            _elem59 = evernote.edam.type.ttypes.LinkedNotebook()
            _elem59.read(iprot)
            self.linkedNotebooks.append(_elem59)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.LIST:
          self.expungedLinkedNotebooks = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = iprot.readString();
            self.expungedLinkedNotebooks.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SyncChunk')
    if self.currentTime is not None:
      oprot.writeFieldBegin('currentTime', TType.I64, 1)
      oprot.writeI64(self.currentTime)
      oprot.writeFieldEnd()
    if self.chunkHighUSN is not None:
      oprot.writeFieldBegin('chunkHighUSN', TType.I32, 2)
      oprot.writeI32(self.chunkHighUSN)
      oprot.writeFieldEnd()
    if self.updateCount is not None:
      oprot.writeFieldBegin('updateCount', TType.I32, 3)
      oprot.writeI32(self.updateCount)
      oprot.writeFieldEnd()
    if self.notes is not None:
      oprot.writeFieldBegin('notes', TType.LIST, 4)
      oprot.writeListBegin(TType.STRUCT, len(self.notes))
      for iter66 in self.notes:
        iter66.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.notebooks is not None:
      oprot.writeFieldBegin('notebooks', TType.LIST, 5)
      oprot.writeListBegin(TType.STRUCT, len(self.notebooks))
      for iter67 in self.notebooks:
        iter67.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.tags is not None:
      oprot.writeFieldBegin('tags', TType.LIST, 6)
      oprot.writeListBegin(TType.STRUCT, len(self.tags))
      for iter68 in self.tags:
        iter68.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.searches is not None:
      oprot.writeFieldBegin('searches', TType.LIST, 7)
      oprot.writeListBegin(TType.STRUCT, len(self.searches))
      for iter69 in self.searches:
        iter69.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.resources is not None:
      oprot.writeFieldBegin('resources', TType.LIST, 8)
      oprot.writeListBegin(TType.STRUCT, len(self.resources))
      for iter70 in self.resources:
        iter70.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.expungedNotes is not None:
      oprot.writeFieldBegin('expungedNotes', TType.LIST, 9)
      oprot.writeListBegin(TType.STRING, len(self.expungedNotes))
      for iter71 in self.expungedNotes:
        oprot.writeString(iter71)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.expungedNotebooks is not None:
      oprot.writeFieldBegin('expungedNotebooks', TType.LIST, 10)
      oprot.writeListBegin(TType.STRING, len(self.expungedNotebooks))
      for iter72 in self.expungedNotebooks:
        oprot.writeString(iter72)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.expungedTags is not None:
      oprot.writeFieldBegin('expungedTags', TType.LIST, 11)
      oprot.writeListBegin(TType.STRING, len(self.expungedTags))
      for iter73 in self.expungedTags:
        oprot.writeString(iter73)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.expungedSearches is not None:
      oprot.writeFieldBegin('expungedSearches', TType.LIST, 12)
      oprot.writeListBegin(TType.STRING, len(self.expungedSearches))
      for iter74 in self.expungedSearches:
        oprot.writeString(iter74)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.linkedNotebooks is not None:
      oprot.writeFieldBegin('linkedNotebooks', TType.LIST, 13)
      oprot.writeListBegin(TType.STRUCT, len(self.linkedNotebooks))
      for iter75 in self.linkedNotebooks:
        iter75.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.expungedLinkedNotebooks is not None:
      oprot.writeFieldBegin('expungedLinkedNotebooks', TType.LIST, 14)
      oprot.writeListBegin(TType.STRING, len(self.expungedLinkedNotebooks))
      for iter76 in self.expungedLinkedNotebooks:
        oprot.writeString(iter76)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.currentTime is None:
      raise TProtocol.TProtocolException(message='Required field currentTime is unset!')
    if self.updateCount is None:
      raise TProtocol.TProtocolException(message='Required field updateCount is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SyncChunkFilter(object):
  """
   This structure is used with the 'getFilteredSyncChunk' call to provide
   fine-grained control over the data that's returned when a client needs
   to synchronize with the service. Each flag in this structure specifies
   whether to include one class of data in the results of that call.
  
  <dl>
   <dt>includeNotes</dt>
     <dd>
     If true, then the server will include the SyncChunks.notes field
     </dd>
  
   <dt>includeNoteResources</dt>
     <dd>
     If true, then the server will include the 'resources' field on all of
     the Notes that are in SyncChunk.notes.
     If 'includeNotes' is false, then this will have no effect.
     </dd>
  
   <dt>includeNoteAttributes</dt>
     <dd>
     If true, then the server will include the 'attributes' field on all of
     the Notes that are in SyncChunks.notes.
     If 'includeNotes' is false, then this will have no effect.
     </dd>
  
   <dt>includeNotebooks</dt>
     <dd>
     If true, then the server will include the SyncChunks.notebooks field
     </dd>
  
   <dt>includeTags</dt>
     <dd>
     If true, then the server will include the SyncChunks.tags field
     </dd>
  
   <dt>includeSearches</dt>
     <dd>
     If true, then the server will include the SyncChunks.searches field
     </dd>
  
   <dt>includeResources</dt>
     <dd>
     If true, then the server will include the SyncChunks.resources field.
     Since the Resources are also provided with their Note
     (in the Notes.resources list), this is primarily useful for clients that
     want to watch for changes to individual Resources due to recognition data
     being added.
     </dd>
  
   <dt>includeLinkedNotebooks</dt>
     <dd>
     If true, then the server will include the SyncChunks.linkedNotebooks field.
     </dd>
  
   <dt>includeExpunged</dt>
     <dd>
     If true, then the server will include the 'expunged' data for any type
     of included data.  For example, if 'includeTags' and 'includeExpunged'
     are both true, then the SyncChunks.expungedTags field will be set with
     the GUIDs of tags that have been expunged from the server.
     </dd>
  
   <dt>includeNoteApplicationDataFullMap</dt>
     <dd>
     If true, then the values for the applicationData map will be filled
     in, assuming notes and note attributes are being returned.  Otherwise,
     only the keysOnly field will be filled in.
     </dd>
  
   <dt>includeResourceApplicationDataFullMap</dt>
     <dd>
     If true, then the fullMap values for the applicationData map will be
     filled in, assuming resources and resource attributes are being returned
     (includeResources is true).  Otherwise, only the keysOnly field will be
     filled in.
     </dd>
  
   <dt>includeNoteResourceApplicationDataFullMap</dt>
     <dd>
     If true, then the fullMap values for the applicationData map will be
     filled in for resources found inside of notes, assuming resources are
     being returned in notes (includeNoteResources is true).  Otherwise,
     only the keysOnly field will be filled in.
     </dd>
  
   <dt>requireNoteContentClass</dt>
     <dd>
     If set, then only send notes whose content class matches this value.
     The value can be a literal match or, if the last character is an
     asterisk, a prefix match.
     </dd>
   </dl>
  
  Attributes:
   - includeNotes
   - includeNoteResources
   - includeNoteAttributes
   - includeNotebooks
   - includeTags
   - includeSearches
   - includeResources
   - includeLinkedNotebooks
   - includeExpunged
   - includeNoteApplicationDataFullMap
   - includeResourceApplicationDataFullMap
   - includeNoteResourceApplicationDataFullMap
   - requireNoteContentClass
  """

  thrift_spec = (
    None, # 0
    (1, TType.BOOL, 'includeNotes', None, None, ), # 1
    (2, TType.BOOL, 'includeNoteResources', None, None, ), # 2
    (3, TType.BOOL, 'includeNoteAttributes', None, None, ), # 3
    (4, TType.BOOL, 'includeNotebooks', None, None, ), # 4
    (5, TType.BOOL, 'includeTags', None, None, ), # 5
    (6, TType.BOOL, 'includeSearches', None, None, ), # 6
    (7, TType.BOOL, 'includeResources', None, None, ), # 7
    (8, TType.BOOL, 'includeLinkedNotebooks', None, None, ), # 8
    (9, TType.BOOL, 'includeExpunged', None, None, ), # 9
    (10, TType.BOOL, 'includeNoteApplicationDataFullMap', None, None, ), # 10
    (11, TType.STRING, 'requireNoteContentClass', None, None, ), # 11
    (12, TType.BOOL, 'includeResourceApplicationDataFullMap', None, None, ), # 12
    (13, TType.BOOL, 'includeNoteResourceApplicationDataFullMap', None, None, ), # 13
  )

  def __init__(self, includeNotes=None, includeNoteResources=None, includeNoteAttributes=None, includeNotebooks=None, includeTags=None, includeSearches=None, includeResources=None, includeLinkedNotebooks=None, includeExpunged=None, includeNoteApplicationDataFullMap=None, includeResourceApplicationDataFullMap=None, includeNoteResourceApplicationDataFullMap=None, requireNoteContentClass=None,):
    self.includeNotes = includeNotes
    self.includeNoteResources = includeNoteResources
    self.includeNoteAttributes = includeNoteAttributes
    self.includeNotebooks = includeNotebooks
    self.includeTags = includeTags
    self.includeSearches = includeSearches
    self.includeResources = includeResources
    self.includeLinkedNotebooks = includeLinkedNotebooks
    self.includeExpunged = includeExpunged
    self.includeNoteApplicationDataFullMap = includeNoteApplicationDataFullMap
    self.includeResourceApplicationDataFullMap = includeResourceApplicationDataFullMap
    self.includeNoteResourceApplicationDataFullMap = includeNoteResourceApplicationDataFullMap
    self.requireNoteContentClass = requireNoteContentClass

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.BOOL:
          self.includeNotes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.BOOL:
          self.includeNoteResources = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.includeNoteAttributes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.includeNotebooks = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.includeTags = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.includeSearches = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.BOOL:
          self.includeResources = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.BOOL:
          self.includeLinkedNotebooks = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.BOOL:
          self.includeExpunged = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.BOOL:
          self.includeNoteApplicationDataFullMap = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.BOOL:
          self.includeResourceApplicationDataFullMap = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.BOOL:
          self.includeNoteResourceApplicationDataFullMap = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.requireNoteContentClass = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SyncChunkFilter')
    if self.includeNotes is not None:
      oprot.writeFieldBegin('includeNotes', TType.BOOL, 1)
      oprot.writeBool(self.includeNotes)
      oprot.writeFieldEnd()
    if self.includeNoteResources is not None:
      oprot.writeFieldBegin('includeNoteResources', TType.BOOL, 2)
      oprot.writeBool(self.includeNoteResources)
      oprot.writeFieldEnd()
    if self.includeNoteAttributes is not None:
      oprot.writeFieldBegin('includeNoteAttributes', TType.BOOL, 3)
      oprot.writeBool(self.includeNoteAttributes)
      oprot.writeFieldEnd()
    if self.includeNotebooks is not None:
      oprot.writeFieldBegin('includeNotebooks', TType.BOOL, 4)
      oprot.writeBool(self.includeNotebooks)
      oprot.writeFieldEnd()
    if self.includeTags is not None:
      oprot.writeFieldBegin('includeTags', TType.BOOL, 5)
      oprot.writeBool(self.includeTags)
      oprot.writeFieldEnd()
    if self.includeSearches is not None:
      oprot.writeFieldBegin('includeSearches', TType.BOOL, 6)
      oprot.writeBool(self.includeSearches)
      oprot.writeFieldEnd()
    if self.includeResources is not None:
      oprot.writeFieldBegin('includeResources', TType.BOOL, 7)
      oprot.writeBool(self.includeResources)
      oprot.writeFieldEnd()
    if self.includeLinkedNotebooks is not None:
      oprot.writeFieldBegin('includeLinkedNotebooks', TType.BOOL, 8)
      oprot.writeBool(self.includeLinkedNotebooks)
      oprot.writeFieldEnd()
    if self.includeExpunged is not None:
      oprot.writeFieldBegin('includeExpunged', TType.BOOL, 9)
      oprot.writeBool(self.includeExpunged)
      oprot.writeFieldEnd()
    if self.includeNoteApplicationDataFullMap is not None:
      oprot.writeFieldBegin('includeNoteApplicationDataFullMap', TType.BOOL, 10)
      oprot.writeBool(self.includeNoteApplicationDataFullMap)
      oprot.writeFieldEnd()
    if self.requireNoteContentClass is not None:
      oprot.writeFieldBegin('requireNoteContentClass', TType.STRING, 11)
      oprot.writeString(self.requireNoteContentClass)
      oprot.writeFieldEnd()
    if self.includeResourceApplicationDataFullMap is not None:
      oprot.writeFieldBegin('includeResourceApplicationDataFullMap', TType.BOOL, 12)
      oprot.writeBool(self.includeResourceApplicationDataFullMap)
      oprot.writeFieldEnd()
    if self.includeNoteResourceApplicationDataFullMap is not None:
      oprot.writeFieldBegin('includeNoteResourceApplicationDataFullMap', TType.BOOL, 13)
      oprot.writeBool(self.includeNoteResourceApplicationDataFullMap)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteFilter(object):
  """
   A list of criteria that are used to indicate which notes are desired from
   the account.  This is used in queries to the NoteStore to determine
   which notes should be retrieved.
  
  <dl>
   <dt>order</dt>
     <dd>
     The NoteSortOrder value indicating what criterion should be
     used to sort the results of the filter.
     </dd>
  
   <dt>ascending</dt>
     <dd>
     If true, the results will be ascending in the requested
     sort order.  If false, the results will be descending.
     </dd>
  
   <dt>words</dt>
     <dd>
     If present, a search query string that will filter the set of notes to be returned.
     Accepts the full search grammar documented in the Evernote API Overview.
     </dd>
  
   <dt>notebookGuid</dt>
     <dd>
     If present, the Guid of the notebook that must contain
     the notes.
     </dd>
  
   <dt>tagGuids</dt>
     <dd>
     If present, the list of tags (by GUID) that must be present
     on the notes.
     </dd>
  
   <dt>timeZone</dt>
     <dd>
     The zone ID for the user, which will be used to interpret
     any dates or times in the queries that do not include their desired zone
     information.
     For example, if a query requests notes created "yesterday", this
     will be evaluated from the provided time zone, if provided.
     The format must be encoded as a standard zone ID such as
     "America/Los_Angeles".
     </dd>
  
   <dt>inactive</dt>
     <dd>
     If true, then only notes that are not active (i.e. notes in
     the Trash) will be returned. Otherwise, only active notes will be returned.
     There is no way to find both active and inactive notes in a single query.
     </dd>
  
   <dt>emphasized</dt>
     <dd>
     If present, a search query string that may or may not influence the notes
     to be returned, both in terms of coverage as well as of order. Think of it
     as a wish list, not a requirement.
     Accepts the full search grammar documented in the Evernote API Overview.
     </dd>
   </dl>
  
  Attributes:
   - order
   - ascending
   - words
   - notebookGuid
   - tagGuids
   - timeZone
   - inactive
   - emphasized
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'order', None, None, ), # 1
    (2, TType.BOOL, 'ascending', None, None, ), # 2
    (3, TType.STRING, 'words', None, None, ), # 3
    (4, TType.STRING, 'notebookGuid', None, None, ), # 4
    (5, TType.LIST, 'tagGuids', (TType.STRING,None), None, ), # 5
    (6, TType.STRING, 'timeZone', None, None, ), # 6
    (7, TType.BOOL, 'inactive', None, None, ), # 7
    (8, TType.STRING, 'emphasized', None, None, ), # 8
  )

  def __init__(self, order=None, ascending=None, words=None, notebookGuid=None, tagGuids=None, timeZone=None, inactive=None, emphasized=None,):
    self.order = order
    self.ascending = ascending
    self.words = words
    self.notebookGuid = notebookGuid
    self.tagGuids = tagGuids
    self.timeZone = timeZone
    self.inactive = inactive
    self.emphasized = emphasized

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.order = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.BOOL:
          self.ascending = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.words = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.notebookGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.tagGuids = []
          (_etype80, _size77) = iprot.readListBegin()
          for _i81 in xrange(_size77):
            _elem82 = iprot.readString();
            self.tagGuids.append(_elem82)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.timeZone = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.BOOL:
          self.inactive = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.emphasized = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteFilter')
    if self.order is not None:
      oprot.writeFieldBegin('order', TType.I32, 1)
      oprot.writeI32(self.order)
      oprot.writeFieldEnd()
    if self.ascending is not None:
      oprot.writeFieldBegin('ascending', TType.BOOL, 2)
      oprot.writeBool(self.ascending)
      oprot.writeFieldEnd()
    if self.words is not None:
      oprot.writeFieldBegin('words', TType.STRING, 3)
      oprot.writeString(self.words)
      oprot.writeFieldEnd()
    if self.notebookGuid is not None:
      oprot.writeFieldBegin('notebookGuid', TType.STRING, 4)
      oprot.writeString(self.notebookGuid)
      oprot.writeFieldEnd()
    if self.tagGuids is not None:
      oprot.writeFieldBegin('tagGuids', TType.LIST, 5)
      oprot.writeListBegin(TType.STRING, len(self.tagGuids))
      for iter83 in self.tagGuids:
        oprot.writeString(iter83)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timeZone is not None:
      oprot.writeFieldBegin('timeZone', TType.STRING, 6)
      oprot.writeString(self.timeZone)
      oprot.writeFieldEnd()
    if self.inactive is not None:
      oprot.writeFieldBegin('inactive', TType.BOOL, 7)
      oprot.writeBool(self.inactive)
      oprot.writeFieldEnd()
    if self.emphasized is not None:
      oprot.writeFieldBegin('emphasized', TType.STRING, 8)
      oprot.writeString(self.emphasized)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteList(object):
  """
   A small structure for returning a list of notes out of a larger set.
  
  <dl>
   <dt>startIndex</dt>
     <dd>
     The starting index within the overall set of notes.  This
     is also the number of notes that are "before" this list in the set.
     </dd>
  
   <dt>totalNotes</dt>
     <dd>
     The number of notes in the larger set.  This can be used
     to calculate how many notes are "after" this note in the set.
     (I.e.  remaining = totalNotes - (startIndex + notes.length)  )
     </dd>
  
   <dt>notes</dt>
     <dd>
     The list of notes from this range.  The Notes will include all
     metadata (attributes, resources, etc.), but will not include the ENML
     content of the note or the binary contents of any resources.
     </dd>
  
   <dt>stoppedWords</dt>
     <dd>
     If the NoteList was produced using a text based search
     query that included words that are not indexed or searched by the service,
     this will include a list of those ignored words.
     </dd>
  
   <dt>searchedWords</dt>
     <dd>
     If the NoteList was produced using a text based search
     query that included viable search words or quoted expressions, this will
     include a list of those words.  Any stopped words will not be included
     in this list.
     </dd>
  
   <dt>updateCount</dt>
     <dd>
     Indicates the total number of transactions that have
     been committed within the account.  This reflects (for example) the
     number of discrete additions or modifications that have been made to
     the data in this account (tags, notes, resources, etc.).
     This number is the "high water mark" for Update Sequence Numbers (USN)
     within the account.
     </dd>
   </dl>
  
  Attributes:
   - startIndex
   - totalNotes
   - notes
   - stoppedWords
   - searchedWords
   - updateCount
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'startIndex', None, None, ), # 1
    (2, TType.I32, 'totalNotes', None, None, ), # 2
    (3, TType.LIST, 'notes', (TType.STRUCT,(evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec)), None, ), # 3
    (4, TType.LIST, 'stoppedWords', (TType.STRING,None), None, ), # 4
    (5, TType.LIST, 'searchedWords', (TType.STRING,None), None, ), # 5
    (6, TType.I32, 'updateCount', None, None, ), # 6
  )

  def __init__(self, startIndex=None, totalNotes=None, notes=None, stoppedWords=None, searchedWords=None, updateCount=None,):
    self.startIndex = startIndex
    self.totalNotes = totalNotes
    self.notes = notes
    self.stoppedWords = stoppedWords
    self.searchedWords = searchedWords
    self.updateCount = updateCount

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.startIndex = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.totalNotes = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.notes = []
          (_etype87, _size84) = iprot.readListBegin()
          for _i88 in xrange(_size84):
            _elem89 = evernote.edam.type.ttypes.Note()
            _elem89.read(iprot)
            self.notes.append(_elem89)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.stoppedWords = []
          (_etype93, _size90) = iprot.readListBegin()
          for _i94 in xrange(_size90):
            _elem95 = iprot.readString();
            self.stoppedWords.append(_elem95)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.searchedWords = []
          (_etype99, _size96) = iprot.readListBegin()
          for _i100 in xrange(_size96):
            _elem101 = iprot.readString();
            self.searchedWords.append(_elem101)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.updateCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteList')
    if self.startIndex is not None:
      oprot.writeFieldBegin('startIndex', TType.I32, 1)
      oprot.writeI32(self.startIndex)
      oprot.writeFieldEnd()
    if self.totalNotes is not None:
      oprot.writeFieldBegin('totalNotes', TType.I32, 2)
      oprot.writeI32(self.totalNotes)
      oprot.writeFieldEnd()
    if self.notes is not None:
      oprot.writeFieldBegin('notes', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.notes))
      for iter102 in self.notes:
        iter102.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.stoppedWords is not None:
      oprot.writeFieldBegin('stoppedWords', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.stoppedWords))
      for iter103 in self.stoppedWords:
        oprot.writeString(iter103)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.searchedWords is not None:
      oprot.writeFieldBegin('searchedWords', TType.LIST, 5)
      oprot.writeListBegin(TType.STRING, len(self.searchedWords))
      for iter104 in self.searchedWords:
        oprot.writeString(iter104)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.updateCount is not None:
      oprot.writeFieldBegin('updateCount', TType.I32, 6)
      oprot.writeI32(self.updateCount)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.startIndex is None:
      raise TProtocol.TProtocolException(message='Required field startIndex is unset!')
    if self.totalNotes is None:
      raise TProtocol.TProtocolException(message='Required field totalNotes is unset!')
    if self.notes is None:
      raise TProtocol.TProtocolException(message='Required field notes is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteMetadata(object):
  """
  This structure is used in the set of results returned by the
  findNotesMetadata function.  It represents the high-level information about
  a single Note, without some of the larger deep structure.  This allows
  for the information about a list of Notes to be returned relatively quickly
  with less marshalling and data transfer to remote clients.
  Most fields in this structure are identical to the corresponding field in
  the Note structure, with the exception of:
  
  <dl>
  <dt>largestResourceMime</dt>
    <dd>If set, then this will contain the MIME type of the largest Resource
    (in bytes) within the Note.  This may be useful, for example, to choose
    an appropriate icon or thumbnail to represent the Note.
    </dd>
  
  <dt>largestResourceSize</dt>
   <dd>If set, this will contain the size of the largest Resource file, in
   bytes, within the Note.  This may be useful, for example, to decide whether
   to ask the server for a thumbnail to represent the Note.
   </dd>
  </dl>
  
  Attributes:
   - guid
   - title
   - contentLength
   - created
   - updated
   - updateSequenceNum
   - notebookGuid
   - tagGuids
   - attributes
   - largestResourceMime
   - largestResourceSize
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'title', None, None, ), # 2
    None, # 3
    None, # 4
    (5, TType.I32, 'contentLength', None, None, ), # 5
    (6, TType.I64, 'created', None, None, ), # 6
    (7, TType.I64, 'updated', None, None, ), # 7
    None, # 8
    None, # 9
    (10, TType.I32, 'updateSequenceNum', None, None, ), # 10
    (11, TType.STRING, 'notebookGuid', None, None, ), # 11
    (12, TType.LIST, 'tagGuids', (TType.STRING,None), None, ), # 12
    None, # 13
    (14, TType.STRUCT, 'attributes', (evernote.edam.type.ttypes.NoteAttributes, evernote.edam.type.ttypes.NoteAttributes.thrift_spec), None, ), # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    (20, TType.STRING, 'largestResourceMime', None, None, ), # 20
    (21, TType.I32, 'largestResourceSize', None, None, ), # 21
  )

  def __init__(self, guid=None, title=None, contentLength=None, created=None, updated=None, updateSequenceNum=None, notebookGuid=None, tagGuids=None, attributes=None, largestResourceMime=None, largestResourceSize=None,):
    self.guid = guid
    self.title = title
    self.contentLength = contentLength
    self.created = created
    self.updated = updated
    self.updateSequenceNum = updateSequenceNum
    self.notebookGuid = notebookGuid
    self.tagGuids = tagGuids
    self.attributes = attributes
    self.largestResourceMime = largestResourceMime
    self.largestResourceSize = largestResourceSize

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.title = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.contentLength = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I64:
          self.created = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.updated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.notebookGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.LIST:
          self.tagGuids = []
          (_etype108, _size105) = iprot.readListBegin()
          for _i109 in xrange(_size105):
            _elem110 = iprot.readString();
            self.tagGuids.append(_elem110)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRUCT:
          self.attributes = evernote.edam.type.ttypes.NoteAttributes()
          self.attributes.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 20:
        if ftype == TType.STRING:
          self.largestResourceMime = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 21:
        if ftype == TType.I32:
          self.largestResourceSize = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteMetadata')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.title is not None:
      oprot.writeFieldBegin('title', TType.STRING, 2)
      oprot.writeString(self.title)
      oprot.writeFieldEnd()
    if self.contentLength is not None:
      oprot.writeFieldBegin('contentLength', TType.I32, 5)
      oprot.writeI32(self.contentLength)
      oprot.writeFieldEnd()
    if self.created is not None:
      oprot.writeFieldBegin('created', TType.I64, 6)
      oprot.writeI64(self.created)
      oprot.writeFieldEnd()
    if self.updated is not None:
      oprot.writeFieldBegin('updated', TType.I64, 7)
      oprot.writeI64(self.updated)
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 10)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.notebookGuid is not None:
      oprot.writeFieldBegin('notebookGuid', TType.STRING, 11)
      oprot.writeString(self.notebookGuid)
      oprot.writeFieldEnd()
    if self.tagGuids is not None:
      oprot.writeFieldBegin('tagGuids', TType.LIST, 12)
      oprot.writeListBegin(TType.STRING, len(self.tagGuids))
      for iter111 in self.tagGuids:
        oprot.writeString(iter111)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.STRUCT, 14)
      self.attributes.write(oprot)
      oprot.writeFieldEnd()
    if self.largestResourceMime is not None:
      oprot.writeFieldBegin('largestResourceMime', TType.STRING, 20)
      oprot.writeString(self.largestResourceMime)
      oprot.writeFieldEnd()
    if self.largestResourceSize is not None:
      oprot.writeFieldBegin('largestResourceSize', TType.I32, 21)
      oprot.writeI32(self.largestResourceSize)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.guid is None:
      raise TProtocol.TProtocolException(message='Required field guid is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NotesMetadataList(object):
  """
   This structure is returned from calls to the findNotesMetadata function to
   give the high-level metadata about a subset of Notes that are found to
   match a specified NoteFilter in a search.
  
  <dl>
   <dt>startIndex</dt>
     <dd>
     The starting index within the overall set of notes.  This
     is also the number of notes that are "before" this list in the set.
     </dd>
  
   <dt>totalNotes</dt>
     <dd>
     The number of notes in the larger set.  This can be used
     to calculate how many notes are "after" this note in the set.
     (I.e.  remaining = totalNotes - (startIndex + notes.length)  )
     </dd>
  
   <dt>notes</dt>
     <dd>
     The list of metadata for Notes in this range.  The set of optional fields
     that are set in each metadata structure will depend on the
     NotesMetadataResultSpec provided by the caller when the search was
     performed.  Only the 'guid' field will be guaranteed to be set in each
     Note.
     </dd>
  
   <dt>stoppedWords</dt>
     <dd>
     If the NoteList was produced using a text based search
     query that included words that are not indexed or searched by the service,
     this will include a list of those ignored words.
     </dd>
  
   <dt>searchedWords</dt>
     <dd>
     If the NoteList was produced using a text based search
     query that included viable search words or quoted expressions, this will
     include a list of those words.  Any stopped words will not be included
     in this list.
     </dd>
  
   <dt>updateCount</dt>
     <dd>
     Indicates the total number of transactions that have
     been committed within the account.  This reflects (for example) the
     number of discrete additions or modifications that have been made to
     the data in this account (tags, notes, resources, etc.).
     This number is the "high water mark" for Update Sequence Numbers (USN)
     within the account.
     </dd>
   </dl>
  
  Attributes:
   - startIndex
   - totalNotes
   - notes
   - stoppedWords
   - searchedWords
   - updateCount
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'startIndex', None, None, ), # 1
    (2, TType.I32, 'totalNotes', None, None, ), # 2
    (3, TType.LIST, 'notes', (TType.STRUCT,(NoteMetadata, NoteMetadata.thrift_spec)), None, ), # 3
    (4, TType.LIST, 'stoppedWords', (TType.STRING,None), None, ), # 4
    (5, TType.LIST, 'searchedWords', (TType.STRING,None), None, ), # 5
    (6, TType.I32, 'updateCount', None, None, ), # 6
  )

  def __init__(self, startIndex=None, totalNotes=None, notes=None, stoppedWords=None, searchedWords=None, updateCount=None,):
    self.startIndex = startIndex
    self.totalNotes = totalNotes
    self.notes = notes
    self.stoppedWords = stoppedWords
    self.searchedWords = searchedWords
    self.updateCount = updateCount

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.startIndex = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.totalNotes = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.notes = []
          (_etype115, _size112) = iprot.readListBegin()
          for _i116 in xrange(_size112):
            _elem117 = NoteMetadata()
            _elem117.read(iprot)
            self.notes.append(_elem117)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.stoppedWords = []
          (_etype121, _size118) = iprot.readListBegin()
          for _i122 in xrange(_size118):
            _elem123 = iprot.readString();
            self.stoppedWords.append(_elem123)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.searchedWords = []
          (_etype127, _size124) = iprot.readListBegin()
          for _i128 in xrange(_size124):
            _elem129 = iprot.readString();
            self.searchedWords.append(_elem129)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.updateCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NotesMetadataList')
    if self.startIndex is not None:
      oprot.writeFieldBegin('startIndex', TType.I32, 1)
      oprot.writeI32(self.startIndex)
      oprot.writeFieldEnd()
    if self.totalNotes is not None:
      oprot.writeFieldBegin('totalNotes', TType.I32, 2)
      oprot.writeI32(self.totalNotes)
      oprot.writeFieldEnd()
    if self.notes is not None:
      oprot.writeFieldBegin('notes', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.notes))
      for iter130 in self.notes:
        iter130.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.stoppedWords is not None:
      oprot.writeFieldBegin('stoppedWords', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.stoppedWords))
      for iter131 in self.stoppedWords:
        oprot.writeString(iter131)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.searchedWords is not None:
      oprot.writeFieldBegin('searchedWords', TType.LIST, 5)
      oprot.writeListBegin(TType.STRING, len(self.searchedWords))
      for iter132 in self.searchedWords:
        oprot.writeString(iter132)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.updateCount is not None:
      oprot.writeFieldBegin('updateCount', TType.I32, 6)
      oprot.writeI32(self.updateCount)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.startIndex is None:
      raise TProtocol.TProtocolException(message='Required field startIndex is unset!')
    if self.totalNotes is None:
      raise TProtocol.TProtocolException(message='Required field totalNotes is unset!')
    if self.notes is None:
      raise TProtocol.TProtocolException(message='Required field notes is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NotesMetadataResultSpec(object):
  """
  This structure is provided to the findNotesMetadata function to specify
  the subset of fields that should be included in each NoteMetadata element
  that is returned in the NotesMetadataList.
  Each field on this structure is a boolean flag that indicates whether the
  corresponding field should be included in the NoteMetadata structure when
  it is returned.  For example, if the 'includeTitle' field is set on this
  structure when calling findNotesMetadata, then each NoteMetadata in the
  list should have its 'title' field set.
  If one of the fields in this spec is not set, then it will be treated as
  'false' by the server, so the default behavior is to include nothing in
  replies (but the mandatory GUID)
  
  Attributes:
   - includeTitle
   - includeContentLength
   - includeCreated
   - includeUpdated
   - includeUpdateSequenceNum
   - includeNotebookGuid
   - includeTagGuids
   - includeAttributes
   - includeLargestResourceMime
   - includeLargestResourceSize
  """

  thrift_spec = (
    None, # 0
    None, # 1
    (2, TType.BOOL, 'includeTitle', None, None, ), # 2
    None, # 3
    None, # 4
    (5, TType.BOOL, 'includeContentLength', None, None, ), # 5
    (6, TType.BOOL, 'includeCreated', None, None, ), # 6
    (7, TType.BOOL, 'includeUpdated', None, None, ), # 7
    None, # 8
    None, # 9
    (10, TType.BOOL, 'includeUpdateSequenceNum', None, None, ), # 10
    (11, TType.BOOL, 'includeNotebookGuid', None, None, ), # 11
    (12, TType.BOOL, 'includeTagGuids', None, None, ), # 12
    None, # 13
    (14, TType.BOOL, 'includeAttributes', None, None, ), # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    (20, TType.BOOL, 'includeLargestResourceMime', None, None, ), # 20
    (21, TType.BOOL, 'includeLargestResourceSize', None, None, ), # 21
  )

  def __init__(self, includeTitle=None, includeContentLength=None, includeCreated=None, includeUpdated=None, includeUpdateSequenceNum=None, includeNotebookGuid=None, includeTagGuids=None, includeAttributes=None, includeLargestResourceMime=None, includeLargestResourceSize=None,):
    self.includeTitle = includeTitle
    self.includeContentLength = includeContentLength
    self.includeCreated = includeCreated
    self.includeUpdated = includeUpdated
    self.includeUpdateSequenceNum = includeUpdateSequenceNum
    self.includeNotebookGuid = includeNotebookGuid
    self.includeTagGuids = includeTagGuids
    self.includeAttributes = includeAttributes
    self.includeLargestResourceMime = includeLargestResourceMime
    self.includeLargestResourceSize = includeLargestResourceSize

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 2:
        if ftype == TType.BOOL:
          self.includeTitle = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.includeContentLength = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.includeCreated = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.BOOL:
          self.includeUpdated = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.BOOL:
          self.includeUpdateSequenceNum = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.BOOL:
          self.includeNotebookGuid = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.BOOL:
          self.includeTagGuids = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.BOOL:
          self.includeAttributes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 20:
        if ftype == TType.BOOL:
          self.includeLargestResourceMime = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 21:
        if ftype == TType.BOOL:
          self.includeLargestResourceSize = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NotesMetadataResultSpec')
    if self.includeTitle is not None:
      oprot.writeFieldBegin('includeTitle', TType.BOOL, 2)
      oprot.writeBool(self.includeTitle)
      oprot.writeFieldEnd()
    if self.includeContentLength is not None:
      oprot.writeFieldBegin('includeContentLength', TType.BOOL, 5)
      oprot.writeBool(self.includeContentLength)
      oprot.writeFieldEnd()
    if self.includeCreated is not None:
      oprot.writeFieldBegin('includeCreated', TType.BOOL, 6)
      oprot.writeBool(self.includeCreated)
      oprot.writeFieldEnd()
    if self.includeUpdated is not None:
      oprot.writeFieldBegin('includeUpdated', TType.BOOL, 7)
      oprot.writeBool(self.includeUpdated)
      oprot.writeFieldEnd()
    if self.includeUpdateSequenceNum is not None:
      oprot.writeFieldBegin('includeUpdateSequenceNum', TType.BOOL, 10)
      oprot.writeBool(self.includeUpdateSequenceNum)
      oprot.writeFieldEnd()
    if self.includeNotebookGuid is not None:
      oprot.writeFieldBegin('includeNotebookGuid', TType.BOOL, 11)
      oprot.writeBool(self.includeNotebookGuid)
      oprot.writeFieldEnd()
    if self.includeTagGuids is not None:
      oprot.writeFieldBegin('includeTagGuids', TType.BOOL, 12)
      oprot.writeBool(self.includeTagGuids)
      oprot.writeFieldEnd()
    if self.includeAttributes is not None:
      oprot.writeFieldBegin('includeAttributes', TType.BOOL, 14)
      oprot.writeBool(self.includeAttributes)
      oprot.writeFieldEnd()
    if self.includeLargestResourceMime is not None:
      oprot.writeFieldBegin('includeLargestResourceMime', TType.BOOL, 20)
      oprot.writeBool(self.includeLargestResourceMime)
      oprot.writeFieldEnd()
    if self.includeLargestResourceSize is not None:
      oprot.writeFieldBegin('includeLargestResourceSize', TType.BOOL, 21)
      oprot.writeBool(self.includeLargestResourceSize)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteCollectionCounts(object):
  """
   A data structure representing the number of notes for each notebook
   and tag with a non-zero set of applicable notes.
  
  <dl>
   <dt>notebookCounts</dt>
     <dd>
     A mapping from the Notebook GUID to the number of
     notes (from some selection) that are in the corresponding notebook.
     </dd>
  
   <dt>tagCounts</dt>
     <dd>
     A mapping from the Tag GUID to the number of notes (from some
     selection) that have the corresponding tag.
     </dd>
  
   <dt>trashCount</dt>
     <dd>
     If this is set, then this is the number of notes that are in the trash.
     If this is not set, then the number of notes in the trash hasn't been
     reported.  (I.e. if there are no notes in the trash, this will be set
     to 0.)
     </dd>
   </dl>
  
  Attributes:
   - notebookCounts
   - tagCounts
   - trashCount
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'notebookCounts', (TType.STRING,None,TType.I32,None), None, ), # 1
    (2, TType.MAP, 'tagCounts', (TType.STRING,None,TType.I32,None), None, ), # 2
    (3, TType.I32, 'trashCount', None, None, ), # 3
  )

  def __init__(self, notebookCounts=None, tagCounts=None, trashCount=None,):
    self.notebookCounts = notebookCounts
    self.tagCounts = tagCounts
    self.trashCount = trashCount

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.notebookCounts = {}
          (_ktype134, _vtype135, _size133 ) = iprot.readMapBegin() 
          for _i137 in xrange(_size133):
            _key138 = iprot.readString();
            _val139 = iprot.readI32();
            self.notebookCounts[_key138] = _val139
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.tagCounts = {}
          (_ktype141, _vtype142, _size140 ) = iprot.readMapBegin() 
          for _i144 in xrange(_size140):
            _key145 = iprot.readString();
            _val146 = iprot.readI32();
            self.tagCounts[_key145] = _val146
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.trashCount = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteCollectionCounts')
    if self.notebookCounts is not None:
      oprot.writeFieldBegin('notebookCounts', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.I32, len(self.notebookCounts))
      for kiter147,viter148 in self.notebookCounts.items():
        oprot.writeString(kiter147)
        oprot.writeI32(viter148)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.tagCounts is not None:
      oprot.writeFieldBegin('tagCounts', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.I32, len(self.tagCounts))
      for kiter149,viter150 in self.tagCounts.items():
        oprot.writeString(kiter149)
        oprot.writeI32(viter150)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.trashCount is not None:
      oprot.writeFieldBegin('trashCount', TType.I32, 3)
      oprot.writeI32(self.trashCount)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteEmailParameters(object):
  """
  Parameters that must be given to the NoteStore emailNote call. These allow
  the caller to specify the note to send, the recipient addresses, etc.
  
  <dl>
   <dt>guid</dt>
     <dd>
       If set, this must be the GUID of a note within the user's account that
       should be retrieved from the service and sent as email.  If not set,
       the 'note' field must be provided instead.
     </dd>
  
   <dt>note</dt>
     <dd>
       If the 'guid' field is not set, this field must be provided, including
       the full contents of the note note (and all of its Resources) to send.
       This can be used for a Note that as not been created in the service,
       for example by a local client with local notes.
     </dd>
  
   <dt>toAddresses</dt>
     <dd>
       If provided, this should contain a list of the SMTP email addresses
       that should be included in the "To:" line of the email.
       Callers must specify at least one "to" or "cc" email address.
     </dd>
  
   <dt>ccAddresses</dt>
     <dd>
       If provided, this should contain a list of the SMTP email addresses
       that should be included in the "Cc:" line of the email.
       Callers must specify at least one "to" or "cc" email address.
     </dd>
  
   <dt>subject</dt>
     <dd>
       If provided, this should contain the subject line of the email that
       will be sent.  If not provided, the title of the note will be used
       as the subject of the email.
     </dd>
  
   <dt>message</dt>
     <dd>
       If provided, this is additional personal text that should be included
       into the email as a message from the owner to the recipient(s).
     </dd>
  </dl>
  
  Attributes:
   - guid
   - note
   - toAddresses
   - ccAddresses
   - subject
   - message
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRUCT, 'note', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 2
    (3, TType.LIST, 'toAddresses', (TType.STRING,None), None, ), # 3
    (4, TType.LIST, 'ccAddresses', (TType.STRING,None), None, ), # 4
    (5, TType.STRING, 'subject', None, None, ), # 5
    (6, TType.STRING, 'message', None, None, ), # 6
  )

  def __init__(self, guid=None, note=None, toAddresses=None, ccAddresses=None, subject=None, message=None,):
    self.guid = guid
    self.note = note
    self.toAddresses = toAddresses
    self.ccAddresses = ccAddresses
    self.subject = subject
    self.message = message

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.note = evernote.edam.type.ttypes.Note()
          self.note.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.toAddresses = []
          (_etype154, _size151) = iprot.readListBegin()
          for _i155 in xrange(_size151):
            _elem156 = iprot.readString();
            self.toAddresses.append(_elem156)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.ccAddresses = []
          (_etype160, _size157) = iprot.readListBegin()
          for _i161 in xrange(_size157):
            _elem162 = iprot.readString();
            self.ccAddresses.append(_elem162)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.subject = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.message = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteEmailParameters')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid)
      oprot.writeFieldEnd()
    if self.note is not None:
      oprot.writeFieldBegin('note', TType.STRUCT, 2)
      self.note.write(oprot)
      oprot.writeFieldEnd()
    if self.toAddresses is not None:
      oprot.writeFieldBegin('toAddresses', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.toAddresses))
      for iter163 in self.toAddresses:
        oprot.writeString(iter163)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.ccAddresses is not None:
      oprot.writeFieldBegin('ccAddresses', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.ccAddresses))
      for iter164 in self.ccAddresses:
        oprot.writeString(iter164)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.subject is not None:
      oprot.writeFieldBegin('subject', TType.STRING, 5)
      oprot.writeString(self.subject)
      oprot.writeFieldEnd()
    if self.message is not None:
      oprot.writeFieldBegin('message', TType.STRING, 6)
      oprot.writeString(self.message)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NoteVersionId(object):
  """
  Identifying information about previous versions of a note that are backed up
  within Evernote's servers.  Used in the return value of the listNoteVersions
  call.
  
  <dl>
   <dt>updateSequenceNum</dt>
   <dd>
     The update sequence number for the Note when it last had this content.
     This serves to uniquely identify each version of the note, since USN
     values are unique within an account for each update.
   </dd>
   <dt>updated</dt>
   <dd>
     The 'updated' time that was set on the Note when it had this version
     of the content.  This is the user-modifiable modification time on the
     note, so it's not reliable for guaranteeing the order of various
     versions.  (E.g. if someone modifies the note, then changes this time
     manually into the past and then updates the note again.)
   </dd>
   <dt>saved</dt>
   <dd>
     A timestamp that holds the date and time when this version of the note
     was backed up by Evernote's servers.  This
   </dd>
   <dt>title</dt>
   <dd>
     The title of the note when this particular version was saved.  (The
     current title of the note may differ from this value.)
   </dd>
  </dl>
  
  Attributes:
   - updateSequenceNum
   - updated
   - saved
   - title
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'updateSequenceNum', None, None, ), # 1
    (2, TType.I64, 'updated', None, None, ), # 2
    (3, TType.I64, 'saved', None, None, ), # 3
    (4, TType.STRING, 'title', None, None, ), # 4
  )

  def __init__(self, updateSequenceNum=None, updated=None, saved=None, title=None,):
    self.updateSequenceNum = updateSequenceNum
    self.updated = updated
    self.saved = saved
    self.title = title

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.updated = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.saved = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.title = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NoteVersionId')
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 1)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.updated is not None:
      oprot.writeFieldBegin('updated', TType.I64, 2)
      oprot.writeI64(self.updated)
      oprot.writeFieldEnd()
    if self.saved is not None:
      oprot.writeFieldBegin('saved', TType.I64, 3)
      oprot.writeI64(self.saved)
      oprot.writeFieldEnd()
    if self.title is not None:
      oprot.writeFieldBegin('title', TType.STRING, 4)
      oprot.writeString(self.title)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.updateSequenceNum is None:
      raise TProtocol.TProtocolException(message='Required field updateSequenceNum is unset!')
    if self.updated is None:
      raise TProtocol.TProtocolException(message='Required field updated is unset!')
    if self.saved is None:
      raise TProtocol.TProtocolException(message='Required field saved is unset!')
    if self.title is None:
      raise TProtocol.TProtocolException(message='Required field title is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ClientUsageMetrics(object):
  """
  This structure is passed from clients to the Evernote service when they wish
  to relay coarse-grained usage metrics to the service to help improve
  products.
  
  <dl>
   <dt>sessions</dt>
   <dd>
     This field contains a count of the number of usage "sessions" that have
     occurred with this client which have not previously been reported to
     the service.
     A "session" is defined as one of the 96 fifteen-minute intervals of the
     day when someone used Evernote's interface at least once.
     So if a user interacts with an Evernote client at 12:18, 12:24, and 12:36,
     and then the client synchronizes at 12:39, it would report that there were
     two previously-unreported sessions (one session for the 12:15-12:30 time
     period, and one for the 12:30-12:45 period).
     If the user used Evernote again at 12:41 and synchronized at 12:43, it
     would not report any new sessions, because the 12:30-12:45 session had
     already been reported.
   </dd>
  </dl>
  
  Attributes:
   - sessions
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'sessions', None, None, ), # 1
  )

  def __init__(self, sessions=None,):
    self.sessions = sessions

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.sessions = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ClientUsageMetrics')
    if self.sessions is not None:
      oprot.writeFieldBegin('sessions', TType.I32, 1)
      oprot.writeI32(self.sessions)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class RelatedQuery(object):
  """
  A description of the thing for which we are searching for related
  entities.
  
  You must specify either <em>noteGuid</em> or <em>plainText</em>, but
  not both. <em>filter</em> is optional.
  
  <dl>
  <dt>noteGuid</dt>
  <dd>The GUID of an existing note in your account for which related
      entities will be found.</dd>
  
  <dt>plainText</dt>
  <dd>A string of plain text for which to find related entities.
      You should provide a text block with a number of characters between
      EDAM_RELATED_PLAINTEXT_LEN_MIN and EDAM_RELATED_PLAINTEXT_LEN_MAX.
      </dd>
  
  <dt>filter</dt>
  <dd>The list of criteria that will constrain the notes being considered
      related.
      Please note that some of the parameters may be ignored, such as
      <em>order</em> and <em>ascending</em>.
  </dd>
  </dl>
  
  Attributes:
   - noteGuid
   - plainText
   - filter
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'noteGuid', None, None, ), # 1
    (2, TType.STRING, 'plainText', None, None, ), # 2
    (3, TType.STRUCT, 'filter', (NoteFilter, NoteFilter.thrift_spec), None, ), # 3
  )

  def __init__(self, noteGuid=None, plainText=None, filter=None,):
    self.noteGuid = noteGuid
    self.plainText = plainText
    self.filter = filter

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.noteGuid = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.plainText = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.filter = NoteFilter()
          self.filter.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('RelatedQuery')
    if self.noteGuid is not None:
      oprot.writeFieldBegin('noteGuid', TType.STRING, 1)
      oprot.writeString(self.noteGuid)
      oprot.writeFieldEnd()
    if self.plainText is not None:
      oprot.writeFieldBegin('plainText', TType.STRING, 2)
      oprot.writeString(self.plainText)
      oprot.writeFieldEnd()
    if self.filter is not None:
      oprot.writeFieldBegin('filter', TType.STRUCT, 3)
      self.filter.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class RelatedResult(object):
  """
  The result of calling findRelated().  The contents of the notes,
  notebooks, and tags fields will be in decreasing order of expected
  relevance.  It is possible that fewer results than requested will be
  returned even if there are enough distinct entities in the account
  in cases where the relevance is estimated to be low.
  
  <dl>
  <dt>notes</dt>
  <dd>If notes have been requested to be included, this will be the
      list of notes.</dd>
  
  <dt>notebooks</dt>
  <dd>If notebooks have been requested to be included, this will be the
      list of notebooks.</dd>
  
  <dt>tags</dt>
  <dd>If tags have been requested to be included, this will be the list
      of tags.</dd>
  </dl>
  
  <dt>containingNotebooks</dt>
  <dd>If <code>includeContainingNotebooks</code> is set to <code>true</code>
      in the RelatedResultSpec, return the list of notebooks to
      to which the returned related notes belong. The notebooks in this
      list will occur once per notebook GUID and are represented as
      NotebookDescriptor objects.</dd>
  </dl>
  
  <dt>debugInfo</dt>
  <dd>NOTE: This should be excluded from the public API.<br /><br />
      If <code>includeDebugInfo</code> in RelatedResultSpec is set to
      <code>true</code>, this field may contain debug information
      if the service decides to do so.</dd>
  </dl>
  
  Attributes:
   - notes
   - notebooks
   - tags
   - containingNotebooks
   - debugInfo
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'notes', (TType.STRUCT,(evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec)), None, ), # 1
    (2, TType.LIST, 'notebooks', (TType.STRUCT,(evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec)), None, ), # 2
    (3, TType.LIST, 'tags', (TType.STRUCT,(evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec)), None, ), # 3
    (4, TType.LIST, 'containingNotebooks', (TType.STRUCT,(evernote.edam.type.ttypes.NotebookDescriptor, evernote.edam.type.ttypes.NotebookDescriptor.thrift_spec)), None, ), # 4
    (5, TType.STRING, 'debugInfo', None, None, ), # 5
  )

  def __init__(self, notes=None, notebooks=None, tags=None, containingNotebooks=None, debugInfo=None,):
    self.notes = notes
    self.notebooks = notebooks
    self.tags = tags
    self.containingNotebooks = containingNotebooks
    self.debugInfo = debugInfo

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.notes = []
          (_etype168, _size165) = iprot.readListBegin()
          for _i169 in xrange(_size165):
            _elem170 = evernote.edam.type.ttypes.Note()
            _elem170.read(iprot)
            self.notes.append(_elem170)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.notebooks = []
          (_etype174, _size171) = iprot.readListBegin()
          for _i175 in xrange(_size171):
            _elem176 = evernote.edam.type.ttypes.Notebook()
            _elem176.read(iprot)
            self.notebooks.append(_elem176)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.tags = []
          (_etype180, _size177) = iprot.readListBegin()
          for _i181 in xrange(_size177):
            _elem182 = evernote.edam.type.ttypes.Tag()
            _elem182.read(iprot)
            self.tags.append(_elem182)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.containingNotebooks = []
          (_etype186, _size183) = iprot.readListBegin()
          for _i187 in xrange(_size183):
            _elem188 = evernote.edam.type.ttypes.NotebookDescriptor()
            _elem188.read(iprot)
            self.containingNotebooks.append(_elem188)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.debugInfo = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('RelatedResult')
    if self.notes is not None:
      oprot.writeFieldBegin('notes', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.notes))
      for iter189 in self.notes:
        iter189.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.notebooks is not None:
      oprot.writeFieldBegin('notebooks', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.notebooks))
      for iter190 in self.notebooks:
        iter190.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.tags is not None:
      oprot.writeFieldBegin('tags', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.tags))
      for iter191 in self.tags:
        iter191.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.containingNotebooks is not None:
      oprot.writeFieldBegin('containingNotebooks', TType.LIST, 4)
      oprot.writeListBegin(TType.STRUCT, len(self.containingNotebooks))
      for iter192 in self.containingNotebooks:
        iter192.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.debugInfo is not None:
      oprot.writeFieldBegin('debugInfo', TType.STRING, 5)
      oprot.writeString(self.debugInfo)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class RelatedResultSpec(object):
  """
  A description of the thing for which the service will find related
  entities, via findRelated(), together with a description of what
  type of entities and how many you are seeking in the
  RelatedResult.
  
  <dl>
  <dt>maxNotes</dt>
  <dd>Return notes that are related to the query, but no more than
      this many.  Any value greater than EDAM_RELATED_MAX_NOTES
      will be silently capped.  If you do not set this field, then
      no notes will be returned.</dd>
  
  <dt>maxNotebooks</dt>
  <dd>Return notebooks that are related to the query, but no more than
      this many.  Any value greater than EDAM_RELATED_MAX_NOTEBOOKS
      will be silently capped.  If you do not set this field, then
      no notebooks will be returned.</dd>
  
  <dt>maxTags</dt>
  <dd>Return tags that are related to the query, but no more than
      this many.  Any value greater than EDAM_RELATED_MAX_TAGS
      will be silently capped.  If you do not set this field, then
      no tags will be returned.</dd>
  </dl>
  
  <dt>writableNotebooksOnly</dt>
  <dd>Require that all returned related notebooks are writable.
      The user will be able to create notes in all returned notebooks.
      However, individual notes returned may still belong to notebooks
      in which the user lacks the ability to create notes.</dd>
  </dl>
  
  <dt>includeContainingNotebooks</dt>
  <dd>If set to <code>true</code>, return the containingNotebooks field
      in the RelatedResult, which will contain the list of notebooks to
      to which the returned related notes belong.</dd>
  </dl>
  
  <dt>includeDebugInfo</dt>
  <dd>NOTE: This should be excluded from the public API.<br /><br />
      If set to <code>true</code>, indicate that debug information should
      be returned in the 'debugInfo' field of RelatedResult.</dd>
  </dl>
  
  Attributes:
   - maxNotes
   - maxNotebooks
   - maxTags
   - writableNotebooksOnly
   - includeContainingNotebooks
   - includeDebugInfo
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'maxNotes', None, None, ), # 1
    (2, TType.I32, 'maxNotebooks', None, None, ), # 2
    (3, TType.I32, 'maxTags', None, None, ), # 3
    (4, TType.BOOL, 'writableNotebooksOnly', None, None, ), # 4
    (5, TType.BOOL, 'includeContainingNotebooks', None, None, ), # 5
    (6, TType.BOOL, 'includeDebugInfo', None, None, ), # 6
  )

  def __init__(self, maxNotes=None, maxNotebooks=None, maxTags=None, writableNotebooksOnly=None, includeContainingNotebooks=None, includeDebugInfo=None,):
    self.maxNotes = maxNotes
    self.maxNotebooks = maxNotebooks
    self.maxTags = maxTags
    self.writableNotebooksOnly = writableNotebooksOnly
    self.includeContainingNotebooks = includeContainingNotebooks
    self.includeDebugInfo = includeDebugInfo

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.maxNotes = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.maxNotebooks = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.maxTags = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.writableNotebooksOnly = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.includeContainingNotebooks = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.includeDebugInfo = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('RelatedResultSpec')
    if self.maxNotes is not None:
      oprot.writeFieldBegin('maxNotes', TType.I32, 1)
      oprot.writeI32(self.maxNotes)
      oprot.writeFieldEnd()
    if self.maxNotebooks is not None:
      oprot.writeFieldBegin('maxNotebooks', TType.I32, 2)
      oprot.writeI32(self.maxNotebooks)
      oprot.writeFieldEnd()
    if self.maxTags is not None:
      oprot.writeFieldBegin('maxTags', TType.I32, 3)
      oprot.writeI32(self.maxTags)
      oprot.writeFieldEnd()
    if self.writableNotebooksOnly is not None:
      oprot.writeFieldBegin('writableNotebooksOnly', TType.BOOL, 4)
      oprot.writeBool(self.writableNotebooksOnly)
      oprot.writeFieldEnd()
    if self.includeContainingNotebooks is not None:
      oprot.writeFieldBegin('includeContainingNotebooks', TType.BOOL, 5)
      oprot.writeBool(self.includeContainingNotebooks)
      oprot.writeFieldEnd()
    if self.includeDebugInfo is not None:
      oprot.writeFieldBegin('includeDebugInfo', TType.BOOL, 6)
      oprot.writeBool(self.includeDebugInfo)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
