#
# To run (Unix):
#   export PYTHONPATH=../../lib; python converter.py
#
from lxml import etree
import hashlib
import binascii
import evernote.edam.userstore.constants as UserStoreConstants
from evernote.edam.notestore import NoteStore
from evernote.api.client import EvernoteClient

xhtml_temp = '''<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>{title}</title>
</head>
{body}
</html>'''

#In order to run the client client sample code, you need a developer token. Get one at https://sandbox.evernote.com/api/DeveloperToken.action
auth_token = ""


client = EvernoteClient(token=auth_token, sandbox=True) 

user_store = client.get_user_store()

note_store = client.get_note_store()

#search is done here, words is most important attribute, in this example findNotesMetadata will return first 10 notes with tag 'epub'
noteFilter = NoteStore.NoteFilter()
noteFilter.ascending = False
noteFilter.words = "tag:epub"
spec = NoteStore.NotesMetadataResultSpec()
spec.includeTitle = True
notes = note_store.findNotesMetadata(noteFilter, 0, 10, spec)

img_nr = 0
xhtml_nr = 0
r = {}
for note in notes.notes:
    mynote = note_store.getNote(note.guid, True, True, False, False)
    for res in mynote.resources:
        filename = 'img'+str(img_nr).zfill(3)+'.'+res.mime.rpartition('/')[2]
        img_nr += 1
        h = binascii.hexlify(res.data.bodyHash)
        r[h] = filename
        f = open(filename, 'wb')
        f.write(res.data.body)
        f.close()
    p = etree.fromstring(mynote.content)
    for i in p.xpath('.//en-media'):
        img_hash = i.attrib.pop('hash')
        try:
            del i.attrib['media']
        except:
            pass
        i.tag = 'img'
        i.attrib['src'] = r[img_hash]
    p.tag = 'body'
    xhtml_name = 'file{0}.xhtml'.format(str(xhtml_nr).zfill(3))
    f = open(xhtml_name, 'w')
    f.write(xhtml_temp.format(title=mynote.title, body=etree.tostring(p).decode('utf-8')))
    f.close()
    