﻿using System;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using System.Xml.Linq;

namespace CalibreGoogleDriveFixer
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
        }

        private void btnGo_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(txtLibrary.Text))
            {
                MessageBox.Show("You must choose the Calibre library directory", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!Directory.Exists(txtLibrary.Text))
            {
                MessageBox.Show("The directory chosen does not exist", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            TextWriter log = new StreamWriter(Path.Combine(txtLibrary.Text, "CalibreGoogleDriveFixer.log"), true, System.Text.Encoding.UTF8);
            log.WriteLine(DateTime.Now.ToString());
            log.WriteLine("=======");
            log.WriteLine();

            var authorsDirectories = new DirectoryInfo(txtLibrary.Text).GetDirectories();

            var booksDirectories = authorsDirectories
                .SelectMany(x => x.GetDirectories())
                .Where(x => File.Exists(Path.Combine(x.FullName, "metadata.opf")))
                .ToDictionary(x => x, x => new FileInfo(Path.Combine(x.FullName, "metadata.opf")));

            var booksProcessed = 0;

            foreach (var book in booksDirectories)
            {
                var metadata = XDocument.Load(book.Value.FullName);

                var calibreId = metadata.Descendants()
                    .Where(x => x.HasAttributes && x.Attribute("id") != null && x.Attribute("id").Value == "calibre_id")
                    .Select(x => x.Value)
                    .FirstOrDefault();

                if (string.IsNullOrEmpty(calibreId))
                    continue;

                var directoryID = string.Format(" ({0})", calibreId);

                if (book.Key.FullName.EndsWith(directoryID))
                    continue;

                book.Key.MoveTo(book.Key.FullName.Trim() + directoryID);
                log.WriteLine(string.Format("{0} -> {1}", book.Key.FullName.Remove(book.Key.FullName.LastIndexOf(directoryID), directoryID.Length), book.Key.FullName));
                log.Flush();

                booksProcessed++;
            }

            log.WriteLine();
            log.Close();

            MessageBox.Show(string.Format("Fix done, {0} books have been processed.", booksProcessed), "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);

            Dispose();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (fbd.ShowDialog() == DialogResult.OK)
            {
                txtLibrary.Text = fbd.SelectedPath;
            }
        }
    }
}
