﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Xml;
using System.IO;

namespace DB2XML
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            DateTime dtStart = DateTime.Now;

            XmlTextWriter writer = new XmlTextWriter("dict.xml", Encoding.UTF8);
            writer.WriteStartDocument(true);
            writer.Formatting = Formatting.Indented;
            writer.Indentation = 4;

            //<body>
            writer.WriteStartElement("body");

            #region Start Getting Headwords
            SqlConnection sqlConnectionHeadword = new SqlConnection("Data Source=.\\SQLEXPRESS;Initial Catalog=Sozlukler;Integrated Security=True");
            sqlConnectionHeadword.Open();

            String strSelectHeadwords = "SELECT LOWER(headword) AS headword, LOWER(definition) AS definition FROM [X.headwordDefinitionMap] ORDER BY headword;";
            SqlCommand commandSelectHeadwords = new SqlCommand(strSelectHeadwords, sqlConnectionHeadword);
            SqlDataReader drHeadwords;
            drHeadwords = commandSelectHeadwords.ExecuteReader();

            while (drHeadwords.Read())
            {
                //<idx:entry name="word" scriptable= "yes">
                writer.WriteStartElement("idx", "entry", "delete");
                writer.WriteAttributeString("name", "word");
                writer.WriteAttributeString("scriptable", "yes");

                //<idx:orth>
                writer.WriteStartElement("idx", "orth", "delete");

                //Here is the headword.
                writer.WriteStartElement("b"); //<b>
                writer.WriteString(drHeadwords["headword"].ToString());
                writer.WriteEndElement(); //</b>

                #region Start Getting Inflections
                SqlConnection sqlConnectionInflection = new SqlConnection("Data Source=.\\SQLEXPRESS;Initial Catalog=Sozlukler;Integrated Security=True");
                sqlConnectionInflection.Open();

                String strSelectInflections = "SELECT inflection FROM [X.inflectionHeadwordMap] WHERE headword = @headword AND inflection != headword;";
                SqlCommand commandSelectInflections = new SqlCommand(strSelectInflections, sqlConnectionInflection);
                commandSelectInflections.Parameters.AddWithValue("@headword", drHeadwords["headword"].ToString());
                SqlDataReader drInflections;
                drInflections = commandSelectInflections.ExecuteReader();

                //<idx:infl>
                writer.WriteStartElement("idx", "infl", "delete");
                while (drInflections.Read())
                {
                    //<idx:iform value="inflection" />
                    writer.WriteStartElement("idx", "iform", "delete");
                    writer.WriteAttributeString("value", drInflections["inflection"].ToString());
                    writer.WriteEndElement();
                }
                //</idx:infl>
                writer.WriteEndElement();

                drInflections.Close();
                sqlConnectionInflection.Close();
                #endregion

                //</idx:orth>
                writer.WriteEndElement();

                #region Start Getting Ottoman
                SqlConnection sqlConnectionOttoman = new SqlConnection("Data Source=.\\SQLEXPRESS;Initial Catalog=Sozlukler;Integrated Security=True");
                sqlConnectionOttoman.Open();

                String strSelectOttoman = "SELECT ottoman FROM [X.headwordOttomanMap] where headword = @headword;";
                SqlCommand commandSelectOttoman = new SqlCommand(strSelectOttoman, sqlConnectionOttoman);
                commandSelectOttoman.Parameters.AddWithValue("@headword", drHeadwords["headword"].ToString());
                SqlDataReader drOttoman;
                drOttoman = commandSelectOttoman.ExecuteReader();

                while (drOttoman.Read())
                {
                    //We should reverse the order of words for mobi7
                    string ottoman = drOttoman["ottoman"].ToString();
                    if (ottoman.Contains(' '))
                    {
                        string reversed = "";
                        string[] ottowords = drOttoman["ottoman"].ToString().Split(' ');
                        for (int i = 0; i < ottowords.Length; i++)
                            reversed += ottowords[ottowords.Length - 1 - i] + " ";
                        ottoman = reversed;
                    }

                    //Remove fetha, damme, kesra, cezm which occurs in tblAltinbasak.
                    if (ottoman.Contains((char)1614) || //fetha
                        ottoman.Contains((char)1615) || //damme
                        ottoman.Contains((char)1616) || //kesra
                        //ottoman.Contains((char)1617) || //şedde
                        ottoman.Contains((char)1618) || //cezm
                        ottoman.Contains((char)1770)) //diamond sign used in place of kesra
                    {
                        string simplified = "";
                        for (int i = 0; i < ottoman.Length; i++)
                        {
                            int intValue = Convert.ToInt32(ottoman[i]);
                            if (intValue != 1614 && intValue != 1615 && intValue != 1616 && intValue != 1618 && intValue != 1770)
                            {
                                simplified += (char)intValue;
                            }
                        }
                        ottoman = simplified;
                    }

                    //<span>ottoman</span>
                    writer.WriteStartElement("span"); //<span>
                    writer.WriteString(" " + ottoman);
                    writer.WriteEndElement(); //</span>
                }

                drOttoman.Close();
                sqlConnectionOttoman.Close();
                #endregion

                //<blockquote>definition</blockquote>
                writer.WriteStartElement("blockquote"); //<blockquote>
                writer.WriteString(drHeadwords["definition"].ToString());
                writer.WriteEndElement(); //</blockquote>

                //</idx:entry>
                writer.WriteEndElement();

                //<hr />
                writer.WriteStartElement("hr"); //hr
                writer.WriteEndElement(); //hr                

            }

            drHeadwords.Close();
            sqlConnectionHeadword.Close();
            #endregion

            //</body>
            writer.WriteEndElement();
            writer.WriteEndDocument();
            writer.Close();

            DateTime dtEnd = DateTime.Now;
            MessageBox.Show("XML File created in "
                + (dtEnd - dtStart).Minutes.ToString() + " minutes and "
                + (dtEnd - dtStart).Seconds.ToString() + " seconds."
                );
        }

        //Analyse & Discard some Arabic characters.
        private void btnOttoOutput_Click(object sender, EventArgs e)
        {
            string newOtto = "";
            for (int i = 0; i < txtOttoInput.Text.Length; i++)
            {
                int intValue = Convert.ToInt32(txtOttoInput.Text[i]);
                if (intValue != 1614 && intValue != 1615 && intValue != 1616 && intValue != 1618 && intValue != 1770)
                {
                    //1614: fetha
                    //1615: damme
                    //1616: kesra
                    //1617: şedde
                    //1618: cezm
                    //1770: diamond sign used in place of kesra
                    newOtto += (char)intValue;
                }
                MessageBox.Show(txtOttoInput.Text[i].ToString() + " - " + intValue);
            }
            btnOttoOutput.Text = newOtto;
        }

        //Merge secondary definitions (better than deleting definitions of secondary meanings).
        private void btnMergeDefinitions_Click(object sender, EventArgs e)
        {
            List<row> rowList = new List<row>();

            SqlConnection sqlConnection = new SqlConnection("Data Source=.\\SQLEXPRESS;Initial Catalog=Sozlukler;Integrated Security=True");
            sqlConnection.Open();

            //Get duplicates
            String strSelect =
                  "SELECT [ID], [headword], [dictname], [definition] FROM [X.headwordDefinitionMap] "
                + "WHERE headword IN (SELECT headword FROM [X.headwordDefinitionMap] GROUP BY headword HAVING COUNT([headword]) > 1);";
            SqlCommand commandSelect = new SqlCommand(strSelect, sqlConnection);

            SqlDataReader dr = commandSelect.ExecuteReader();
            while (dr.Read())
            {
                rowList.Add(new row(dr["ID"], dr["headword"], dr["dictname"], dr["definition"]));
            }
            dr.Close();

            //Delete duplicates
            String strDelete = "DELETE FROM [X.headwordDefinitionMap]"
                    + "WHERE headword IN (SELECT headword FROM [X.headwordDefinitionMap] GROUP BY headword HAVING COUNT([headword]) > 1)";
            SqlCommand commandDelete = new SqlCommand(strDelete, sqlConnection);
            commandDelete.ExecuteNonQuery();

            //Merge definitions
            for (int i = 0; i < rowList.Count; i++)
            {
                string newDefinition = "<ul class=\"alttanim\"><li>"
                            + "<b>" + rowList[i].Headword + ":</b> "
                            + rowList[i].Definition //Liste veya düz metin olması farketmez.
                            + "</li></ul>";

                for (int j = i + 1; j < rowList.Count; j++)
                {
                    if (rowList[i].Headword == rowList[j].Headword)
                    {
                        newDefinition += "<ul class=\"alttanim\"><li>"
                            + "<b>" + rowList[j].Headword + ":</b> "
                            + rowList[j].Definition //Liste veya düz metin olması farketmez.
                            + "</li></ul>";
                        rowList.RemoveAt(j);
                        j--;
                    }
                }

                rowList[i].Definition = newDefinition;

            }

            //Insert combined definitions
            for (int i = 0; i < rowList.Count; i++)
            {
                String strInsert =
                      "INSERT INTO [X.headwordDefinitionMap] (headword, dictname, definition) "
                    + "VALUES (@headword, @dictname, @definition)";
                SqlCommand commandInsert = new SqlCommand(strInsert, sqlConnection);
                commandInsert.Parameters.AddWithValue("@headword", rowList[i].Headword);
                commandInsert.Parameters.AddWithValue("@dictname", rowList[i].Dictname);
                commandInsert.Parameters.AddWithValue("@definition", rowList[i].Definition);
                commandInsert.ExecuteNonQuery();
            }

            sqlConnection.Close();

            MessageBox.Show("Finished.");
        }
        
    }

    //This class will be used in btnMergeDefinitions_Click()
    public class row
    {
        public string ID;
        public string Headword;
        public string Dictname;
        public string Definition;

        public row(object id, object headword, object dictname, object definition)
        {
            ID = id.ToString();
            Headword = headword.ToString();
            Dictname = dictname.ToString();
            Definition = definition.ToString();
        }

    }
}
