/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import iliadpdfscribblemerger.ScribblePage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScribbleMerger {
    String strPdfSource;
    String strScribbleXmlPath;
    HashMap mapColors;
    ArrayList arrScribblePages;
    HashMap mapScribblePages;

    public ScribbleMerger(String strPdfSource, String strScribbleXmlPath) {
        this.strPdfSource = strPdfSource;
        this.strScribbleXmlPath = strScribbleXmlPath;
        this.arrScribblePages = new ArrayList();
        this.mapScribblePages = new HashMap();
        this.mapColors = null;
    }

    public boolean Merge(String strOutput, HashMap mapColors, boolean bScribblePagesOnly) {
        if (strOutput == null) {
            return false;
        }
        this.mapColors = mapColors;
        if (!strOutput.toLowerCase().endsWith(".pdf")) {
            strOutput = strOutput + ".pdf";
        }
        if (strOutput.equals(this.strPdfSource)) {
            return false;
        }
        if (!this.ParseXml()) {
            return false;
        }
        return this.MergeScribbles(strOutput, bScribblePagesOnly);
    }

    protected boolean ParseXml() {
        this.arrScribblePages.clear();
        this.mapScribblePages.clear();
        try {
            File file = new File(this.strScribbleXmlPath);
            if (!file.exists()) {
                return false;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodePages = doc.getElementsByTagName("page");
            int nPageCount = nodePages.getLength();
            this.arrScribblePages.ensureCapacity(nPageCount);
            for (int nScribblePage = 0; nScribblePage < nPageCount; ++nScribblePage) {
                Node nodePage = nodePages.item(nScribblePage);
                if (nodePage == null || nodePage.getNodeType() != 1) continue;
                Element elPage = (Element)nodePage;
                ScribblePage sp = new ScribblePage(elPage);
                this.arrScribblePages.add(sp);
                this.mapScribblePages.put(new Integer(sp.nPageId), sp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean MergeScribbles(String strPdfDestination, boolean bScribblePagesOnly) {
        try {
            PdfReader reader = new PdfReader(this.strPdfSource);
            if (bScribblePagesOnly) {
                int nPageCount = reader.getNumberOfPages();
                Rectangle rSize = reader.getPageSizeWithRotation(1);
                float fTextPosX = rSize.width() / 2.0f;
                Document document = new Document(rSize, 0.0f, 0.0f, 0.0f, 0.0f);
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(strPdfDestination));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                for (int nPage = 0; nPage < this.arrScribblePages.size(); ++nPage) {
                    ScribblePage spPage = (ScribblePage)this.arrScribblePages.get(nPage);
                    document.newPage();
                    PdfImportedPage pageOrg = writer.getImportedPage(reader, spPage.nPageId);
                    cb.addTemplate(pageOrg, 0.0f, 0.0f);
                    Rectangle rectPage = reader.getPageSizeWithRotation(nPage);
                    Rectangle rectCropBox = reader.getCropBox(nPage);
                    for (int nRotation = reader.getPageRotation(nPage); nRotation > 0; nRotation -= 90) {
                        rectCropBox = rectCropBox.rotate();
                    }
                    spPage.AddScribbles(cb, rectPage.top() - rectCropBox.bottom(), rectCropBox.left(), this.mapColors);
                    BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    cb.beginText();
                    cb.setFontAndSize(bf, 11.0f);
                    cb.showTextAligned(1, spPage.nPageId + " / " + nPageCount, fTextPosX, 10.0f, 0.0f);
                    cb.endText();
                }
                document.close();
            } else {
                PdfStamper stamp = new PdfStamper(reader, new FileOutputStream(strPdfDestination));
                PdfContentByte cbOver = null;
                for (int nPage = 1; nPage <= reader.getNumberOfPages(); ++nPage) {
                    ScribblePage spPage = (ScribblePage)this.mapScribblePages.get(new Integer(nPage));
                    cbOver = stamp.getOverContent(nPage);
                    Rectangle rectPage = reader.getPageSizeWithRotation(nPage);
                    Rectangle rectCropBox = reader.getCropBox(nPage);
                    for (int nRotation = reader.getPageRotation(nPage); nRotation > 0; nRotation -= 90) {
                        rectCropBox = rectCropBox.rotate();
                    }
                    if (spPage == null) continue;
                    spPage.AddScribbles(cbOver, rectPage.top() - rectCropBox.bottom(), rectCropBox.left(), this.mapColors);
                }
                stamp.close();
            }
        }
        catch (Exception de) {
            de.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean Merge(String strInputPath, String strOutputPath, char cMergeType, HashMap mapColors) {
        File fileInput = new File(strInputPath);
        if (!(fileInput != null && fileInput.exists() && fileInput.isDirectory() && new File(fileInput.getAbsoluteFile() + File.separator + "manifest.xml").exists() && new File(fileInput.getAbsoluteFile() + File.separator + "scribble.irx").exists())) {
            System.err.println("Invalid input path: " + strInputPath);
            return false;
        }
        String strSourceDir = fileInput.getAbsolutePath() + File.separator;
        String strPdfSource = ScribbleMerger.getPdfFromIRexFolder(strSourceDir);
        if (strPdfSource == null || !new File(strPdfSource).exists()) {
            System.err.println("error: input pdf-file not found");
            return false;
        }
        String strXmlSource = strSourceDir + "scribble.irx";
        if (!new File(strXmlSource).exists()) {
            System.err.println("error: no scribble file found");
            return false;
        }
        ScribbleMerger merger = new ScribbleMerger(strPdfSource, strXmlSource);
        boolean bMergeResult = false;
        if (cMergeType == 'n' || cMergeType == 'm' || cMergeType == 's') {
            File fileDestination = new File(strOutputPath);
            if (fileDestination == null || fileDestination.equals(fileInput)) {
                System.err.println("error: invalid output");
                return false;
            }
            String strDestination = fileDestination.getAbsolutePath();
            if (cMergeType == 'm') {
                strDestination = strDestination + File.separator;
                if (!fileDestination.mkdirs()) {
                    System.err.println("error: creating output dir failed");
                    return false;
                }
                ScribbleMerger.copyFile(strSourceDir + "manifest.xml", strDestination + "manifest.xml");
                String strOutputFile = strDestination + fileDestination.getName();
                bMergeResult = merger.Merge(strOutputFile, mapColors, false);
            } else {
                bMergeResult = merger.Merge(strDestination, mapColors, cMergeType == 's');
            }
        } else if (cMergeType == 'e') {
            try {
                File tempFile = File.createTempFile("merge", ".pdf");
                bMergeResult = merger.Merge(tempFile.getAbsolutePath(), mapColors, false);
                new File(strSourceDir + "scribble.irx").delete();
                new File(strSourceDir + "scribble.xml").delete();
                ScribbleMerger.copyFile(tempFile.getAbsolutePath(), strPdfSource);
                tempFile.delete();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (cMergeType == 'r') {
            try {
                File tempFile = File.createTempFile("merge", ".pdf");
                bMergeResult = merger.Merge(tempFile.getAbsolutePath(), mapColors, false);
                ScribbleMerger.deleteDirectory(fileInput);
                ScribbleMerger.copyFile(tempFile.getAbsolutePath(), fileInput.getAbsolutePath());
                tempFile.delete();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return bMergeResult;
    }

    protected static boolean copyFile(String strSource, String strDest) {
        try {
            FileChannel srcChannel = new FileInputStream(strSource).getChannel();
            FileChannel dstChannel = new FileOutputStream(strDest).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ScribbleMerger.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    protected static String getPdfFromIRexFolder(String strSourceDir) {
        String strManifestSource = strSourceDir + "manifest.xml";
        String strXmlSource = strSourceDir + "scribble.irx";
        String strPdfSource = null;
        try {
            File fileManifest = new File(strManifestSource);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document doc = db.parse(fileManifest);
            doc.getDocumentElement().normalize();
            NodeList nlstStartPage = doc.getElementsByTagName("startpage");
            if (nlstStartPage.getLength() != 1) {
                return null;
            }
            Element nodeStartPage = (Element)nlstStartPage.item(0);
            if (nodeStartPage.getFirstChild() != null) {
                strPdfSource = nodeStartPage.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        strPdfSource = strSourceDir + strPdfSource;
        if (!new File(strPdfSource).exists()) {
            return null;
        }
        return strPdfSource;
    }
}

