#!/bin/sh
HFCONF=/etc/fonts/conf.d/99-hide-fonts.conf
FONTS=/mnt/us/extensions/fontconfig/fontlist/fonts.txt

# Writes to ram are much faster than writes to flash. Yeah. :P
CONF=/var/tmp/hidefonts.conf
: >$CONF

mntroot rw


# Remove old conf file from previous versions
if [ -e $HFCONF ]
  then
    rm $HFCONF
fi


# Enable use of custom fonts and create fonts directory w/ alternate.conf
touch /mnt/us/USE_ALT_FONTS
mkdir -p /mnt/us/fonts

if [ ! -e  /mnt/us/fonts/alternate.conf ]
  then
    cp /mnt/us/extensions/fontconfig/bin/alternate.conf /mnt/us/fonts/
fi


# Enable user conf files
cp /mnt/us/extensions/fontconfig/bin/99-use-alt-config.conf /etc/fonts/conf.d/


# Generate hidefonts.conf based on fonts.txt
echo '<?xml version="1.0"?>' >> $CONF
echo '<!DOCTYPE fontconfig SYSTEM "fonts.dtd">' >> $CONF
echo '<!-- This file is overwritten when Hide Fonts is executed- place other user configurations in alternate.conf -->' >> $CONF
echo '<fontconfig>' >> $CONF
echo '  <selectfont>' >> $CONF
echo '    <rejectfont>' >> $CONF

cat $FONTS | while read LINE
  do
    echo '      <pattern>' >> $CONF
    echo '        <patelt name="family">' >> $CONF
    echo '          <string>'$LINE'</string>' >> $CONF
    echo '        </patelt>' >> $CONF
    echo '      </pattern>' >> $CONF
  done

echo '    </rejectfont>' >> $CONF
echo '  </selectfont>' >> $CONF
echo '</fontconfig>' >> $CONF

mv $CONF /mnt/us/fonts/

eips 1 38 " Fonts hidden. Please restart Kindle."

mntroot ro
