#!/bin/sh
# Load the base BBB (and kWall) firewall structure.

# Writes to ram are much faster than writes to flash.  ;)
LOG=/var/tmp/bbb-last.log
: >$LOG

WHEN=`date -u -Iseconds`
echo 'Packet counts taken at: '$WHEN >>$LOG
echo >>$LOG

# The default (no param #1) is to report all filter chains.
iptables -vnL $1 >>$LOG 2>&1

mv $LOG /mnt/us/documents/BBB-LastAction.txt
dbus-send --system /default com.lab126.powerd.resuming int32:1

exit 0

