/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class main
extends JFrame {
    private static JButton bConvert;
    private static JButton bChoosePath;
    private static JButton bChoosePathOut;
    private static JButton bClear;
    private static JButton bAddAll;
    private static JButton bConvertGroups;
    private static JTextField tfInputPath;
    private static JTextField tfOutputPath;
    private static JTextField tfFileName;
    private static JTextField tfGroupSize;
    private static JTextField tfHeight;
    private static JCheckBox cbScale;
    private static JList lDirectoryList;
    private static JComboBox cbTrim;
    private static JComboBox cbFolderSorting;
    private static JComboBox cbFileSorting;
    public static JProgressBar pgProgress;
    public static JLabel lFreeze;
    static String path;
    private static String inputPath;
    private static String outputPath;
    public static MakeStuff ms;
    private static Vector<String> inputDirectories;
    private static int height;

    static {
        lFreeze = new JLabel("Pogramm freezes until the 'Done' popup apears");
        path = String.valueOf(new File(main.class.getProtectionDomain().getCodeSource().getLocation().getPath()).toString().replaceAll("%20", " ")) + "\\";
        ms = new MakeStuff();
        inputDirectories = new Vector();
        height = -1;
    }

    public static void main(String[] args) throws IOException {
        int width = 860;
        int height = 210;
        JFrame f = new JFrame("Manga To Kindle");
        f.setSize(width, height);
        f.setResizable(false);
        f.setDefaultCloseOperation(3);
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(3);
        f.setLayout(fl);
        bConvert = new JButton("Create Single File");
        bChoosePath = new JButton("Add New Input Directory");
        bChoosePathOut = new JButton("Choose Output Directory");
        bClear = new JButton("Clear");
        bAddAll = new JButton("Add All Directories");
        bConvertGroups = new JButton("Create Multiple Files");
        JButton bContact = new JButton("Contact");
        tfInputPath = new JTextField(40);
        tfOutputPath = new JTextField(53);
        tfFileName = new JTextField(10);
        tfGroupSize = new JTextField(2);
        tfHeight = new JTextField(4);
        tfInputPath.setEditable(false);
        tfOutputPath.setEditable(false);
        tfFileName.setText("Title");
        tfGroupSize.setText("5");
        tfHeight.setText("800");
        tfHeight.setEditable(false);
        cbScale = new JCheckBox();
        cbScale.setSelected(false);
        cbScale.setName("cbScale");
        cbTrim = new JComboBox();
        cbTrim.addItem("None");
        cbTrim.addItem("Low");
        cbTrim.addItem("Medium");
        cbTrim.addItem("High");
        cbTrim.addItem("Max");
        cbTrim.setSelectedIndex(2);
        cbFolderSorting = new JComboBox();
        cbFolderSorting.addItem("Normal");
        cbFolderSorting.addItem("Natural(bta)");
        cbFileSorting = new JComboBox();
        cbFileSorting.addItem("Normal");
        cbFileSorting.addItem("Natural(bta)");
        JPanel pSorting = new JPanel();
        GridLayout glSorting = new GridLayout(0, 2);
        pSorting.setLayout(glSorting);
        pSorting.add(new JLabel("FolderSorting"));
        pSorting.add(cbFolderSorting);
        pSorting.add(new JLabel("FileSorting"));
        pSorting.add(cbFileSorting);
        lDirectoryList = new JList<String>(inputDirectories);
        JScrollPane sp = new JScrollPane(lDirectoryList);
        sp.setPreferredSize(new Dimension(400, 70));
        pgProgress = new JProgressBar();
        JPanel inputSelecter = new JPanel();
        inputSelecter.setLayout(new GridLayout(0, 1));
        inputSelecter.add(bChoosePath);
        inputSelecter.add(bAddAll);
        JPanel createFiles = new JPanel();
        GridLayout gl = new GridLayout(1, 0);
        gl.setHgap(30);
        createFiles.setLayout(gl);
        createFiles.add(bConvert);
        createFiles.add(bConvertGroups);
        createFiles.add(bContact);
        f.add(inputSelecter);
        f.add(sp);
        f.add(bClear);
        f.add(pSorting);
        f.add(bChoosePathOut);
        f.add(tfOutputPath);
        f.add(new JLabel("Output File Name"));
        f.add(tfFileName);
        f.add(new JLabel("Max. Folders Per File"));
        f.add(tfGroupSize);
        f.add(cbScale);
        f.add(new JLabel("Height In Pixel"));
        f.add(tfHeight);
        f.add(new JLabel("Trim Level"));
        f.add(cbTrim);
        f.add(createFiles);
        lFreeze.setVisible(false);
        f.add(lFreeze);
        HandlerClass handler = new HandlerClass();
        bConvert.addActionListener(handler);
        bChoosePath.addActionListener(handler);
        bChoosePathOut.addActionListener(handler);
        bClear.addActionListener(handler);
        bAddAll.addActionListener(handler);
        bConvertGroups.addActionListener(handler);
        tfInputPath.addActionListener(handler);
        tfOutputPath.addActionListener(handler);
        tfGroupSize.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                main.checkButton(tfGroupSize.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                main.checkButton(tfGroupSize.getText());
            }
        });
        tfFileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                main.checkButton(tfGroupSize.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                main.checkButton(tfGroupSize.getText());
            }
        });
        cbScale.addActionListener(handler);
        cbTrim.addActionListener(handler);
        cbFolderSorting.addActionListener(handler);
        cbFileSorting.addActionListener(handler);
        lDirectoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting() && lDirectoryList.getSelectedIndex() >= 0) {
                    System.out.println(lDirectoryList.getSelectedIndex());
                    inputDirectories.remove(lDirectoryList.getSelectedIndex());
                    lDirectoryList.setListData(inputDirectories);
                }
            }
        });
        main.checkButton(tfGroupSize.getText());
        bContact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(null, "cyrill.kuenzi@gmx.ch");
            }
        });
        f.setVisible(true);
    }

    private static void checkButton(String in) {
        int num = 0;
        if (!in.equals("")) {
            num = Integer.valueOf(in);
        }
        if (num >= inputDirectories.size()) {
            bConvert.setEnabled(true);
            bConvertGroups.setEnabled(false);
        } else {
            bConvert.setEnabled(false);
            bConvertGroups.setEnabled(true);
        }
        if (num <= 0 || inputDirectories.size() <= 0 || tfFileName.getText().equals("")) {
            bConvert.setEnabled(false);
            bConvertGroups.setEnabled(false);
        }
    }

    public static void createSingleFile() {
        try {
            main.ms.filname = tfFileName.getText();
            ms.convertMultipleFolders(inputDirectories, String.valueOf(outputPath) + "tmp\\", height);
            ms.createZip(String.valueOf(outputPath) + "tmp\\", String.valueOf(outputPath) + tfFileName.getText() + ".cbz");
            ms.deleteFolder(String.valueOf(outputPath) + "tmp\\");
            JOptionPane.showMessageDialog(null, "Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class HandlerClass
    implements ActionListener {
        HandlerClass() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String startPath = path;
            if (inputDirectories.size() > 0) {
                startPath = (String)inputDirectories.get(inputDirectories.size() - 1);
                startPath = startPath.substring(0, this.getLastSlash(startPath) + 1);
            }
            if (cbScale.isSelected()) {
                height = Integer.valueOf(tfHeight.getText());
            }
            JFileChooser chooser = new JFileChooser(startPath);
            if (event.getActionCommand().equals("Add New Input Directory")) {
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    inputPath = String.valueOf(chooser.getSelectedFile().getPath()) + "\\";
                    tfInputPath.setText(inputPath);
                    inputDirectories.add(inputPath);
                    lDirectoryList.setListData(inputDirectories);
                    outputPath = String.valueOf(chooser.getSelectedFile().getPath()) + "\\";
                    tfOutputPath.setText(outputPath);
                }
            } else if (event.getActionCommand().equals("Add All Directories")) {
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    Vector<String> directories = ms.getFolders(String.valueOf(chooser.getSelectedFile().getPath()) + "\\");
                    inputDirectories.addAll(directories);
                    lDirectoryList.setListData(inputDirectories);
                    outputPath = String.valueOf(chooser.getSelectedFile().getPath()) + "\\";
                    tfOutputPath.setText(outputPath);
                }
            } else if (event.getActionCommand().equals("Choose Output Directory")) {
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    outputPath = String.valueOf(chooser.getSelectedFile().getPath()) + "\\";
                    tfOutputPath.setText(outputPath);
                }
            } else if (event.getActionCommand().equals("Create Single File")) {
                JOptionPane.showMessageDialog(null, "Pogramm freezes until the 'Done' popup apears. \n Click OK to start");
                try {
                    main.ms.filname = tfFileName.getText();
                    ms.convertMultipleFolders(inputDirectories, String.valueOf(outputPath) + "tmp\\", height);
                    ms.createZip(String.valueOf(outputPath) + "tmp\\", String.valueOf(outputPath) + tfFileName.getText() + ".cbz");
                    ms.deleteFolder(String.valueOf(outputPath) + "tmp\\");
                    JOptionPane.showMessageDialog(null, "Done");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (event.getActionCommand().equals("Clear")) {
                inputDirectories.removeAllElements();
                lDirectoryList.setListData(inputDirectories);
            } else if (event.getActionCommand().equals("Create Multiple Files")) {
                JOptionPane.showMessageDialog(null, "Pogramm freezes until the 'Done' popup apears. \n Click OK to start");
                int groupSize = Integer.valueOf(tfGroupSize.getText());
                LinkedList folders = new LinkedList();
                folders.addAll(inputDirectories);
                int counter = 0;
                while (!folders.isEmpty()) {
                    Vector<String> group = new Vector<String>();
                    int i = 0;
                    while (i < groupSize) {
                        if (!folders.isEmpty()) {
                            group.add((String)folders.poll());
                        }
                        ++i;
                    }
                    try {
                        main.ms.filname = tfFileName.getText();
                        ms.convertMultipleFolders(group, String.valueOf(outputPath) + "tmp\\", height);
                        ms.createZip(String.valueOf(outputPath) + "tmp\\", String.valueOf(outputPath) + tfFileName.getText() + "_" + String.valueOf(counter) + ".cbz");
                        ms.deleteFolder(String.valueOf(outputPath) + "tmp\\");
                        System.out.println("Group number " + counter + " created");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++counter;
                }
                JOptionPane.showMessageDialog(null, "Done");
            } else if (event.getActionCommand().equals("comboBoxChanged")) {
                if (event.getSource() == cbTrim) {
                    int trimLevel = 15;
                    String text = cbTrim.getSelectedItem().toString();
                    if (text.equals("Low")) {
                        trimLevel = 2;
                    } else if (text.equals("Medium")) {
                        trimLevel = 10;
                    } else if (text.equals("High")) {
                        trimLevel = 20;
                    } else if (text.equals("None")) {
                        trimLevel = 0;
                    } else if (text.equals("Max")) {
                        trimLevel = 50;
                    }
                    ms.setTrimLevel(trimLevel);
                }
                if (event.getSource() == cbFolderSorting) {
                    if (cbFolderSorting.getSelectedItem() == "Normal") {
                        main.ms.naturalFolderSort = false;
                    } else if (cbFolderSorting.getSelectedItem() == "Natural(bta)") {
                        main.ms.naturalFolderSort = true;
                    }
                    this.sortFolders();
                }
                if (event.getSource() == cbFileSorting) {
                    if (cbFileSorting.getSelectedItem() == "Normal") {
                        main.ms.naturalFileSort = false;
                    } else if (cbFileSorting.getSelectedItem() == "Natural(bta)") {
                        main.ms.naturalFileSort = true;
                    }
                }
            }
            if (event.getSource() == cbScale) {
                if (cbScale.isSelected()) {
                    tfHeight.setEditable(true);
                    height = Integer.valueOf(tfHeight.getText());
                } else {
                    tfHeight.setEditable(false);
                    height = -1;
                }
            }
            main.checkButton(tfGroupSize.getText());
            lFreeze.setVisible(false);
        }

        void sortFolders() {
            if (main.ms.naturalFolderSort) {
                Collections.sort(inputDirectories, new MakeStuff.naturalComparator());
            } else {
                Collections.sort(inputDirectories);
            }
        }

        int getLastSlash(String in) {
            int last = in.length();
            int i = 0;
            while (i < in.length() - 1) {
                if (in.charAt(i) == '\\') {
                    last = i;
                }
                ++i;
            }
            return last;
        }
    }
}

