/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public class MakeStuff {
    public String filname;
    int trimLevel = 10;
    boolean naturalFileSort = false;
    boolean naturalFolderSort = false;

    BufferedImage getGrayScale(BufferedImage inputImage) {
        BufferedImage img = new BufferedImage(inputImage.getWidth(), inputImage.getHeight(), 10);
        Graphics g = img.getGraphics();
        g.drawImage(inputImage, 0, 0, null);
        g.dispose();
        return img;
    }

    BufferedImage loadImage2(String path) throws IOException {
        return this.getGrayScale(ImageIO.read(this.getClass().getResourceAsStream(path)));
    }

    BufferedImage loadImage(String path) throws IOException {
        BufferedImage buffer = ImageIO.read(new File(path));
        if (buffer == null) {
            return new BufferedImage(10, 10, 10);
        }
        return this.getGrayScale(buffer);
    }

    BufferedImage cutImage(int top, int right, int bottom, int left, BufferedImage in) {
        int width = in.getWidth() - (left + right);
        int height = in.getHeight() - (top + bottom);
        BufferedImage out = new BufferedImage(width, height, 10);
        int i = left;
        while (i < left + width) {
            int j = top;
            while (j < top + height) {
                out.setRGB(i - left, j - top, in.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        return out;
    }

    public void setTrimLevel(int in) {
        this.trimLevel = in;
    }

    BufferedImage autoCropImage(BufferedImage in) {
        int i;
        int top = -1;
        int right = 0;
        int bottom = 0;
        int left = -1;
        int avg = 255;
        int minVal = 255 - this.trimLevel;
        int maxVal = this.trimLevel + 5;
        while ((avg > minVal || avg < maxVal) && top < in.getHeight() / 2 - 1) {
            ++top;
            avg = 0;
            i = 0;
            while (i < in.getWidth()) {
                avg += in.getRGB(i, top) & 0xFF;
                ++i;
            }
            avg /= in.getWidth();
        }
        avg = 255;
        while ((avg > minVal - 10 || avg < maxVal) && bottom < in.getHeight() / 2 - 1) {
            ++bottom;
            avg = 0;
            i = 0;
            while (i < in.getWidth()) {
                avg += in.getRGB(i, in.getHeight() - bottom) & 0xFF;
                ++i;
            }
            avg /= in.getWidth();
        }
        avg = 255;
        while ((avg > minVal || avg < maxVal) && left < in.getWidth() / 2 - 1) {
            ++left;
            avg = 0;
            i = 0;
            while (i < in.getHeight()) {
                avg += in.getRGB(left, i) & 0xFF;
                ++i;
            }
            avg /= in.getHeight();
        }
        avg = 255;
        while ((avg > minVal || avg < maxVal) && right < in.getWidth() / 2 - 1) {
            ++right;
            avg = 0;
            i = 0;
            while (i < in.getHeight()) {
                avg += in.getRGB(in.getWidth() - right, i) & 0xFF;
                ++i;
            }
            avg /= in.getHeight();
        }
        return this.cutImage(top, right, bottom, left, in);
    }

    BufferedImage scaleImage(int height, BufferedImage in) {
        double factor = (double)in.getHeight() / (double)height;
        return this.bufferImage(in.getScaledInstance((int)((double)in.getWidth() / factor), height, 16), 10);
    }

    public BufferedImage bufferImage(Image image, int type) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, null, null);
        return bufferedImage;
    }

    void saveImage(String path, String name, BufferedImage in) throws IOException {
        File f = new File(String.valueOf(path) + name + ".png");
        ImageIO.write((RenderedImage)in, "PNG", f);
    }

    boolean createFolder(String name) {
        File f = new File(name);
        return f.mkdir();
    }

    Vector<String> getFileNames(String path) {
        Vector<String> out = new Vector<String>();
        File f = new File(path);
        String[] names = f.list();
        int i = 0;
        while (i < names.length) {
            if (this.isPicture(names[i])) {
                out.add(names[i]);
            }
            ++i;
        }
        if (this.naturalFileSort) {
            Collections.sort(out, new naturalComparator());
        } else {
            Collections.sort(out);
        }
        return out;
    }

    Vector<String> getFolders(String path) {
        Vector<String> out = new Vector<String>();
        File f = new File(path);
        String[] names = f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        });
        int i = 0;
        while (i < names.length) {
            out.add(String.valueOf(path) + names[i] + "\\");
            ++i;
        }
        if (this.naturalFolderSort) {
            Collections.sort(out, new naturalComparator());
        } else {
            Collections.sort(out);
        }
        return out;
    }

    boolean isPicture(String name) {
        String[] valid = new String[]{"jpg", "png", "JPG", "PNG"};
        int i = 0;
        while (i < valid.length) {
            if (name.endsWith(valid[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 10 : 10;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if ((higherQuality || w > targetWidth) && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if ((higherQuality || h > targetHeight) && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    void convertImage(String inPath, String inName, String outPath, String outName, int height) throws IOException {
        System.out.println(String.valueOf(inPath) + inName);
        BufferedImage tmp = this.loadImage(String.valueOf(inPath) + inName);
        if (this.trimLevel > 0) {
            tmp = this.autoCropImage(tmp);
        }
        if (height > 1) {
            double factor = (double)tmp.getHeight() / (double)height;
            int width = (int)((double)tmp.getWidth() / factor);
            tmp = this.getScaledInstance(tmp, width, height, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        }
        this.saveImage(outPath, outName, tmp);
    }

    void deleteFolder(String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                File tmp = new File(dir, children[i]);
                tmp.delete();
                ++i;
            }
            dir.delete();
        }
    }

    int convertFolder(String path, String outPath, int startNumber, int height) throws IOException {
        this.createFolder(outPath);
        Vector<String> files = this.getFileNames(path);
        int counter = 0;
        int i = 0;
        while (i < files.size()) {
            ++counter;
            this.convertImage(path, files.get(i), outPath, String.format("%04d", ++startNumber), height);
            ++i;
        }
        return counter;
    }

    void createZip(String inPath, String outPath) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outPath));
        Vector<String> files = this.getFileNames(inPath);
        int i = 0;
        while (i < files.size()) {
            int count;
            FileInputStream in = new FileInputStream(String.valueOf(inPath) + files.get(i));
            out.putNextEntry(new ZipEntry(String.valueOf(String.format("%04d", i)) + ".jpg"));
            byte[] b = new byte[1024];
            while ((count = in.read(b)) > 0) {
                out.write(b, 0, count);
            }
            in.close();
            ++i;
        }
        out.close();
    }

    void convertMultipleFolders(Vector<String> inputFolders, String outputFolder, int height) throws IOException {
        int counter = 0;
        main.pgProgress.setMaximum(inputFolders.size());
        int i = 0;
        while (i < inputFolders.size()) {
            main.pgProgress.setValue(i + 1);
            counter += this.convertFolder(inputFolders.get(i), outputFolder, counter, height);
            ++i;
        }
    }

    public static class naturalComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            double b;
            String s1 = arg0.replaceAll("[^0-9]", "");
            String s2 = arg1.replaceAll("[^0-9]", "");
            if (s1.equals("") || s2.equals("")) {
                return 0;
            }
            double a = Double.valueOf(s1);
            if (a < (b = Double.valueOf(s2).doubleValue())) {
                return -1;
            }
            if (a == b) {
                return 0;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }
}

