#!/bin/ash -
# compat-K5.sh - last update 20130127,a,stepk
# Compatibility layer for busybox ash version
#   BusyBox v1.17.1 (2012-07-17 16:29:54 PDT) multi-call binary

# json_var creates sh variable json_NAME from $1
json_var () {
  local IFS=${NO_WSP} s x=$*
#echo "json_var_1($#)($x)"
  x=json_${x#?}
  x=${x/$'"'/}
  until [[ "$s" = "$x" ]]; do
    s=$x
    x=${s/[ $'\t']:/:}
    x=${x/:[ $'\t']/:}
  done
  x=${x/:/=}
#echo "json_var_2 x($x)"
  eval $x
}

# sanitize and shorten labels, improve readability
sanitize() {
  local s r=$*
  until [[ "$s" = "$r" ]]; do
    s=$r
    r=${s//[\|$SEPARATOR]/} # delete some characters
    r=${r//[:\;]/ } # replace some characters
    r=${r/[ $'\t'][ $'\t']/ } # squeeze spaces
  done
  echo -n "$r"
}