#!/bin/ash -
# compat-K3.sh - last update 20130127,a,stepk
# Compatibility layer for busybox ash version
#   BusyBox v1.7.2 (2012-09-01 14:15:22 PDT) multi-call binary.

# json_var creates sh variable json_NAME from $1
json_var () {
  local IFS=${NO_WSP} x=$*
#echo "json_var_1($#)($x)"
  x=json_${x#?}
  x=`echo -n "$x" | sed "s/${QUOTE}//; s/[${WSP}]\+:/:/; s/:[${WSP}]\+/:/; s/:/=/;"`
#echo "json_var_2 x($x)"
  eval $x
}

# sanitize and shorten labels, improve readability
sanitize() {
  local r=$*
  r=`echo -n "$r" | sed "s/[\|${SEPARATOR}]//g; s/[:;]/ /g; s/[${WSP}]+/ /;"`
  echo -n "$r"
}