import os, sys    
from libprs500.ebooks.lrf.meta import *

def process_lrf(root, file):
    dash = file.find(' - ')
    if dash != -1:
        fileAuthor = file[:dash]
        dash = file.rfind(' - ')  # Search back to allow for series seperators
        fileTitle  = file[dash+3:-4]
        if fileTitle[-5:] == ", The":
            fileTitle = "The " + fileTitle[:-5]
        f = open(os.path.join(root, file), "r+b")
        lrf = LRFMetaFile(f)
        if (lrf.author != fileAuthor) or (lrf.title != fileTitle):
            print "File=%s \t => (%s:%s)" % (file, fileAuthor, fileTitle)
            lrf.author = fileAuthor
            lrf.title = fileTitle
        lrf = None
        f.close()
        
def main(args=sys.argv):
    for root, dirs, files in os.walk(args[1]):
        for file in files:
            if file[-4:] == ".lrf":
                process_lrf(root, file)
    return 0
    
if __name__ == '__main__':
    sys.exit(main())
