/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.idpf.epubcheck.util.css.CssInputStream;

public class CssSource {
    private final String systemID;
    private final CssInputStream stream;

    public CssSource(String systemID, InputStream input) throws IOException {
        this.systemID = (String)Preconditions.checkNotNull((Object)systemID);
        this.stream = Preconditions.checkNotNull((Object)input) instanceof CssInputStream ? (CssInputStream)input : new CssInputStream(input);
    }

    public CssSource(String systemID, CharSequence input) throws IOException {
        this.systemID = (String)Preconditions.checkNotNull((Object)systemID);
        this.stream = new CssInputStream(new ByteArrayInputStream(((Object)input).toString().getBytes()));
    }

    public String getSystemID() {
        return this.systemID;
    }

    public CssInputStream getInputStream() {
        return this.stream;
    }

    public Reader newReader() {
        return new BufferedReader(new InputStreamReader(this.stream));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.systemID).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssSource) {
            CssSource cs = (CssSource)obj;
            return cs.systemID.equals(this.systemID);
        }
        return false;
    }
}

