/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.idpf.epubcheck.util.css.CssScanner;

public class CssInputStream
extends PushbackInputStream {
    Optional<String> bom = Optional.absent();
    Optional<String> charset = Optional.absent();
    static final int MAX_PUSHBACK = 256;
    static final Map<String, byte[]> boms = new ImmutableMap.Builder().put((Object)"UTF-32BE", (Object)new byte[]{0, 0, -2, -1}).put((Object)"UTF-32LE", (Object)new byte[]{-2, -1, 0, 0}).put((Object)"UTF-8", (Object)new byte[]{-17, -69, -65}).put((Object)"UTF-16BE", (Object)new byte[]{-2, -1}).put((Object)"UTF-16LE", (Object)new byte[]{-1, -2}).build();

    public CssInputStream(InputStream in) throws IOException {
        super(in instanceof BufferedInputStream ? in : new BufferedInputStream(in), 256);
        String enc = this.getBOM();
        if (!Strings.isNullOrEmpty((String)enc)) {
            this.bom = Optional.of((Object)enc);
        }
        if (!Strings.isNullOrEmpty((String)(enc = this.getCssCharset(enc)))) {
            this.charset = Optional.of((Object)enc);
        }
    }

    private final String getBOM() throws IOException {
        int unread;
        byte[] data = new byte[4];
        int read = ByteStreams.read((InputStream)this, (byte[])data, (int)0, (int)data.length);
        String key = CssInputStream.map(data);
        int n = unread = key == null ? read : data.length - boms.get(key).length;
        if (unread > 0) {
            this.unread(data, read - unread, unread);
        }
        return key;
    }

    private final String getCssCharset(String bom) throws IOException {
        ArrayList unread;
        String value;
        block10: {
            char cur;
            String enc = bom != null ? bom : "UTF-8";
            int len = 1;
            if (enc.startsWith("UTF-16")) {
                len = 2;
            } else if (enc.startsWith("UTF-32")) {
                len = 4;
            }
            Endian endian = null;
            if (len != 1) {
                endian = enc.endsWith("BE") ? Endian.BIG : Endian.LITTLE;
            }
            value = null;
            unread = Lists.newArrayList();
            StringBuilder sbuf = new StringBuilder();
            char openQuote = '\u0000';
            int openQuotePos = -1;
            while (true) {
                int b;
                byte[] bbuf = new byte[len];
                for (int i = 0; i < len && (b = this.read()) != -1; ++i) {
                    unread.add((byte)b);
                    bbuf[i] = (byte)b;
                }
                if (unread.size() == 256) break block10;
                if (len == 1 || endian == Endian.LITTLE) {
                    sbuf.append((char)bbuf[0]);
                } else {
                    sbuf.append((char)bbuf[len - 1]);
                }
                cur = sbuf.charAt(sbuf.length() - 1);
                if (sbuf.length() == 1 && cur != '@' || CssScanner.TERMINATOR.matches(cur) || sbuf.length() == 8 && !sbuf.toString().equals("@charset")) break block10;
                if (openQuote == '\u0000' && CssScanner.QUOTES.matches(cur)) {
                    openQuote = cur;
                    openQuotePos = sbuf.length();
                    continue;
                }
                if (openQuote == cur) break;
            }
            if (CssScanner.QUOTES.matches(cur)) {
                value = sbuf.substring(openQuotePos, sbuf.length() - 1);
            }
        }
        this.unread(Bytes.toArray((Collection)unread));
        return value;
    }

    private static String map(byte[] data) {
        for (String name : boms.keySet()) {
            byte[] bom = boms.get(name);
            boolean match = true;
            for (int i = 0; i < bom.length; ++i) {
                if (data[i] == bom[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return name;
        }
        return null;
    }

    public final Optional<String> getBomCharset() {
        return this.bom;
    }

    public final Optional<String> getCssCharset() {
        return this.charset;
    }

    private static enum Endian {
        LITTLE,
        BIG;

    }
}

