/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class Archive {
    ArrayList<String> paths;
    ArrayList<String> names;
    File baseDir;
    File epubFile;
    String epubName;
    boolean deleteOnExit = true;

    public Archive(String base, boolean save) {
        this.deleteOnExit = !save;
        this.baseDir = new File(base);
        if (!this.baseDir.exists() || !this.baseDir.isDirectory()) {
            throw new RuntimeException("The path specified for the archive is invalid");
        }
        this.epubName = this.baseDir.getName() + ".epub";
        this.epubFile = new File(this.epubName);
        if (this.deleteOnExit) {
            this.epubFile.deleteOnExit();
        }
        this.paths = new ArrayList();
        this.names = new ArrayList();
    }

    public Archive(String base) {
        this(base, false);
    }

    public String getEpubName() {
        return this.epubName;
    }

    public File getEpubFile() {
        return this.epubFile;
    }

    public void deleteEpubFile() {
        this.epubFile.delete();
    }

    public void createArchive() {
        ZipArchiveOutputStream out = null;
        try {
            this.collectFiles(this.baseDir, "");
            int mimetype = this.names.indexOf("mimetype");
            if (mimetype > -1) {
                String name = this.names.remove(mimetype);
                String path = this.paths.remove(mimetype);
                this.names.add(0, name);
                this.paths.add(0, path);
            } else {
                System.err.println("No mimetype file found in expanded publication, output archive will be invalid");
            }
            out = new ZipArchiveOutputStream(this.epubFile);
            out.setEncoding("UTF-8");
            for (int i = 0; i < this.paths.size(); ++i) {
                ZipArchiveEntry entry = new ZipArchiveEntry(new File(this.paths.get(i)), this.names.get(i));
                if (i == 0) {
                    entry.setMethod(0);
                    entry.setSize(this.getSize(this.paths.get(i)));
                    entry.setCrc(this.getCRC(this.paths.get(i)));
                } else {
                    entry.setMethod(8);
                }
                out.putArchiveEntry(entry);
                FileInputStream in = new FileInputStream(this.paths.get(i));
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeArchiveEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                out.flush();
                out.finish();
                out.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSize(String path) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            byte[] buf = new byte[1024];
            int len = 0;
            int size = 0;
            while ((len = in.read(buf)) > 0) {
                size += len;
            }
            long l = size;
            return l;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCRC(String path) throws IOException {
        FilterInputStream cis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            cis = new CheckedInputStream(fis, new CRC32());
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
        }
        finally {
            fis.close();
            cis.close();
        }
        return ((CheckedInputStream)cis).getChecksum().getValue();
    }

    private void collectFiles(File dir, String dirName) {
        if (!dirName.equals("") && !dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                this.names.add(dirName + files[i].getName());
                this.paths.add(files[i].getAbsolutePath());
                continue;
            }
            if (files[i].getName().equals(".svn")) continue;
            this.collectFiles(files[i], dirName + files[i].getName() + "/");
        }
    }

    public void listFiles() {
        for (int i = 0; i < this.names.size(); ++i) {
            System.out.println(this.names.get(i));
        }
    }
}

