/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;

public class OPSHandler
implements XMLHandler {
    String path;
    protected String base;
    XRefChecker xrefChecker;
    static HashSet<String> regURISchemes = OPSHandler.fillRegURISchemes();
    XMLParser parser;
    OCFPackage ocf;
    Report report;
    EPUBVersion version;
    long openElements;
    long charsCount;
    StringBuilder textNode;

    public OPSHandler(OCFPackage ocf, String path, XRefChecker xrefChecker, XMLParser parser, Report report, EPUBVersion version) {
        this.ocf = ocf;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.parser = parser;
        this.version = version;
    }

    private void checkPaint(XMLElement e, String attr) {
        String paint = e.getAttribute(attr);
        if (this.xrefChecker != null && paint != null && paint.startsWith("url(") && paint.endsWith(")")) {
            String href = paint.substring(4, paint.length() - 1);
            href = PathUtil.resolveRelativeReference(this.path, href, this.base);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 16);
        }
    }

    private void checkClip(XMLElement e, String attr) {
    }

    private void checkImage(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker != null && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 2);
        }
    }

    private void checkObject(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker != null && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 3);
        }
    }

    private void checkLink(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        String rel = e.getAttributeNS(attrNS, "rel");
        if (this.xrefChecker != null && href != null && rel != null && rel.indexOf("stylesheet") >= 0) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 4);
        }
    }

    private void checkSymbol(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker != null && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 18);
        }
    }

    private void checkHRef(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href == null) {
            return;
        }
        if (href.contains("#epubcfi")) {
            return;
        }
        if ((href = href.trim()).length() < 1) {
            return;
        }
        if (".".equals(href)) {
            // empty if block
        }
        if (href.startsWith("http")) {
            this.report.info(this.path, FeatureEnum.REFERENCE, href);
        }
        if (OPSHandler.isRegisteredSchemeType(href) || null != this.base && OPSHandler.isRegisteredSchemeType(this.base)) {
            return;
        }
        if (href.indexOf(58) > 0) {
            this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "use of non-registered URI scheme type in href: " + href);
            return;
        }
        try {
            href = PathUtil.resolveRelativeReference(this.path, href, this.base);
        }
        catch (IllegalArgumentException err) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), err.getMessage());
            return;
        }
        if (this.xrefChecker != null) {
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 1);
        }
    }

    public static boolean isRegisteredSchemeType(String href) {
        int colonIndex = href.indexOf(58);
        if (colonIndex < 0) {
            return false;
        }
        if (regURISchemes.contains(href.substring(0, colonIndex + 1))) {
            return true;
        }
        if (href.length() > colonIndex + 2) {
            return href.substring(colonIndex + 1, colonIndex + 3).equals("//") && regURISchemes.contains(href.substring(0, colonIndex + 3));
        }
        return false;
    }

    @Override
    public void startElement() {
        ++this.openElements;
        XMLElement e = this.parser.getCurrentElement();
        String id = e.getAttribute("id");
        String baseTest = e.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (baseTest != null) {
            this.base = baseTest;
        }
        String ns = e.getNamespace();
        String name = e.getName();
        int resourceType = 0;
        if (ns != null) {
            if (ns.equals("http://www.w3.org/2000/svg")) {
                if (name.equals("linearGradient") || name.equals("radialGradient") || name.equals("pattern")) {
                    resourceType = 16;
                } else if (name.equals("clipPath")) {
                    resourceType = 17;
                } else if (name.equals("symbol")) {
                    resourceType = 18;
                } else if (name.equals("a")) {
                    this.checkHRef(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("use")) {
                    this.checkSymbol(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("image")) {
                    this.checkImage(e, "http://www.w3.org/1999/xlink", "href");
                }
                this.checkPaint(e, "fill");
                this.checkPaint(e, "stroke");
                this.checkClip(e, "clip");
            } else if (ns.equals("http://www.w3.org/1999/xhtml")) {
                if (name.equals("a")) {
                    this.checkHRef(e, null, "href");
                } else if (name.equals("img")) {
                    this.checkImage(e, null, "src");
                } else if (name.equals("object")) {
                    this.checkObject(e, null, "data");
                } else if (name.equals("link")) {
                    this.checkLink(e, null, "href");
                } else if (name.equals("base")) {
                    this.base = e.getAttribute("href");
                } else if (name.equals("style")) {
                    this.textNode = new StringBuilder();
                }
                resourceType = 1;
                String style = e.getAttribute("style");
                if (style != null && style.length() > 0) {
                    CSSCheckerFactory.getInstance().newInstance(this.ocf, this.report, style, true, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.xrefChecker, this.version).runChecks();
                }
            }
        }
        if (this.xrefChecker != null && id != null) {
            this.xrefChecker.registerAnchor(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), id, resourceType);
        }
    }

    @Override
    public void endElement() {
        --this.openElements;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (this.openElements == 0L) {
            this.report.info(this.path, FeatureEnum.CHARS_COUNT, Long.toString(this.charsCount));
        }
        if ("http://www.w3.org/1999/xhtml".equals(ns) && "script".equals(name)) {
            String attr = e.getAttribute("type");
            this.report.info(this.path, FeatureEnum.HAS_SCRIPTS, attr == null ? "" : attr);
        }
        if ("http://www.w3.org/1999/xhtml".equals(ns) && "style".equals(name)) {
            String style = this.textNode.toString();
            if (style.length() > 0) {
                CSSCheckerFactory.getInstance().newInstance(this.ocf, this.report, style, false, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.xrefChecker, this.version).runChecks();
            }
            this.textNode = null;
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.charsCount += (long)length;
        if (this.textNode != null) {
            this.textNode.append(chars, start, length);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<String> fillRegURISchemes() {
        InputStream schemaStream = null;
        BufferedReader schemaReader = null;
        try {
            HashSet<String> set = new HashSet<String>();
            schemaStream = OPSHandler.class.getResourceAsStream("registeredSchemas.txt");
            schemaReader = new BufferedReader(new InputStreamReader(schemaStream));
            String schema = schemaReader.readLine();
            while (schema != null) {
                set.add(schema);
                schema = schemaReader.readLine();
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                schemaReader.close();
                schemaStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

