/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.bitmap.BitmapCheckerFactory;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.dtbook.DTBookCheckerFactory;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFHandler30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.overlay.OverlayCheckerFactory;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.Hashtable;
import java.util.Set;

public class OPFChecker30
extends OPFChecker
implements DocumentValidator {
    private void initContentCheckerFactoryMap() {
        Hashtable map = this.contentCheckerFactoryMap;
        map.clear();
        map.put("application/xhtml+xml", OPSCheckerFactory.getInstance());
        map.put("application/x-dtbook+xml", DTBookCheckerFactory.getInstance());
        map.put("image/jpeg", BitmapCheckerFactory.getInstance());
        map.put("image/gif", BitmapCheckerFactory.getInstance());
        map.put("image/png", BitmapCheckerFactory.getInstance());
        map.put("image/svg+xml", OPSCheckerFactory.getInstance());
        map.put("text/css", CSSCheckerFactory.getInstance());
        map.put("application/smil+xml", OverlayCheckerFactory.getInstance());
        this.contentCheckerFactoryMap = map;
    }

    public OPFChecker30(OCFPackage ocf, Report report, String path, EPUBVersion version) {
        super(ocf, report, path, version);
        this.ocf = ocf;
        this.resourceProvider = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = new XRefChecker(ocf, report, version);
        this.version = version;
        this.initValidators();
        this.initContentCheckerFactoryMap();
    }

    public OPFChecker30(String path, GenericResourceProvider resourceProvider, Report report) {
        super(path, resourceProvider, report);
        this.resourceProvider = resourceProvider;
        this.report = report;
        this.path = path;
        this.version = EPUBVersion.VERSION_3;
        this.initValidators();
        this.initContentCheckerFactoryMap();
    }

    private void initValidators() {
        this.opfValidator = new XMLValidator("schema/30/package-30.rnc");
        this.opfSchematronValidator = new XMLValidator("schema/30/package-30.sch");
    }

    @Override
    public void initHandler() {
        this.opfHandler = new OPFHandler30(this.ocf, this.path, this.report, this.xrefChecker, this.opfParser, this.version);
    }

    @Override
    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        OPFItem fallbackItem;
        String mimeType = item.getMimeType();
        String fallback = item.getFallback();
        if (mimeType == null || mimeType.equals("")) {
            return;
        }
        if (!mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+")) {
            return;
        }
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) == null) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "fallback item could not be found");
        }
    }

    @Override
    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (mimeType == null) {
            return;
        }
        if (OPFChecker30.isBlessedItemType(mimeType, this.version)) {
            return;
        }
        if (item.getFallback() == null) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "Spine item with non-standard media-type '" + mimeType + "' with no fallback");
        } else if (!new OPFChecker.FallbackChecker().checkItemFallbacks(item, opfHandler, false)) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), "Spine item with non-standard media-type '" + mimeType + "' with fallback to non-spine-allowed media-type");
        }
    }

    @Override
    protected void checkBindings() {
        Set<String> mimeTypes = this.xrefChecker.getBindingsMimeTypes();
        for (String mimeType : mimeTypes) {
            String handlerSrc = this.xrefChecker.getBindingHandlerSrc(mimeType);
            OPFItem handler = this.opfHandler.getItemByPath(handlerSrc);
            if (handler.isScripted()) continue;
            this.report.error(handlerSrc, handler.lineNumber, handler.columnNumber, "Item should have the scripted property set in order to be a valid mediaType handler.");
        }
    }

    public static boolean isBlessedAudioType(String type) {
        return type.equals("audio/mpeg") || type.equals("audio/mp4");
    }

    public static boolean isBlessedFontType(String type) {
        return type.equals("application/vnd.ms-opentype") || type.equals("application/font-woff") || type.equals("image/svg+xml");
    }

    public static boolean isCoreMediaType(String type) {
        return OPFChecker30.isBlessedAudioType(type) || OPFChecker30.isBlessedFontType(type) || OPFChecker30.isBlessedItemType(type, EPUBVersion.VERSION_3) || OPFChecker30.isBlessedImageType(type) || type.equals("text/javascript") || type.equals("application/pls+xml") || type.equals("application/smil+xml");
    }
}

