/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.opf.OPFDataImpl;
import com.adobe.epubcheck.opf.VersionRetriever;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.xml.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

public abstract class OCFPackage
implements GenericResourceProvider {
    Hashtable<String, EncryptionFilter> enc = new Hashtable();
    String uniqueIdentifier;

    public void setEncryption(String name, EncryptionFilter encryptionFilter) {
        this.enc.put(name, encryptionFilter);
    }

    public abstract boolean hasEntry(String var1);

    public abstract long getTimeEntry(String var1);

    @Override
    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract HashSet<String> getFileEntries() throws IOException;

    public abstract HashSet<String> getDirectoryEntries() throws IOException;

    public boolean canDecrypt(String fileName) {
        EncryptionFilter filter = this.enc.get(fileName);
        if (filter == null) {
            return true;
        }
        return filter.canDecrypt();
    }

    public OCFData getOcfData(Report reporter) {
        XMLParser containerParser = null;
        InputStream in = null;
        try {
            in = this.getInputStream("META-INF/container.xml");
            containerParser = new XMLParser(in, "META-INF/container.xml", "xml", reporter, null);
            OCFHandler containerHandler = new OCFHandler(containerParser);
            containerParser.addXMLHandler(containerHandler);
            containerParser.process();
            OCFHandler oCFHandler = containerHandler;
            return oCFHandler;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OPFData> getOpfData(OCFData container, Report reporter) throws InvalidVersionException, IOException {
        HashMap<String, OPFDataImpl> result = new HashMap<String, OPFDataImpl>();
        for (String opfPath : container.getEntries("application/oebps-package+xml")) {
            InputStream inv = null;
            EPUBVersion version = null;
            try {
                inv = this.getInputStream(opfPath);
                version = new VersionRetriever(opfPath, reporter).retrieveOpfVersion(inv);
                result.put(opfPath, new OPFDataImpl(version));
            }
            finally {
                try {
                    inv.close();
                }
                catch (Exception e) {}
            }
        }
        return Collections.unmodifiableMap(result);
    }
}

