/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import java.util.HashSet;

public final class OCFFilenameChecker {
    public static HashSet<String> restricted30CharacterSet;

    private OCFFilenameChecker() {
    }

    public static String checkCompatiblyEscaped(String str, Report report, EPUBVersion version) {
        if (str.startsWith("http://")) {
            return "";
        }
        String test = OCFFilenameChecker.checkNonAsciiFilename(str, report);
        if (str.endsWith(".")) {
            report.error(str, 0, 0, Messages.FILENAME_ENDS_IN_DOT);
            test = test + ".";
        }
        boolean spaces = false;
        char[] ascciGraphic = new char[]{'<', '>', '\"', '{', '}', '|', '^', '`', '*', '?'};
        String result = "";
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            for (char a : ascciGraphic) {
                if (c != a) continue;
                result = result + "\"" + Character.toString(c) + "\",";
                test = test + Character.toString(c);
            }
            if (!Character.isSpaceChar(c)) continue;
            spaces = true;
            test = test + Character.toString(c);
        }
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 1);
            report.error(str, 0, 0, Messages.FILENAME_DISALLOWED_CHARACTERS + result);
        }
        if (spaces) {
            report.warning(str, 0, 0, Messages.SPACES_IN_FILENAME);
        }
        if (version == EPUBVersion.VERSION_3) {
            OCFFilenameChecker.checkCompatiblyEscaped30(str, test, report);
        }
        return test;
    }

    private static String checkNonAsciiFilename(String str, Report report) {
        String nonAscii = str.replaceAll("[\\p{ASCII}]", "");
        if (nonAscii.length() > 0) {
            report.warning(str, 0, 0, String.format(Messages.FILENAME_NON_ASCII, nonAscii));
        }
        return nonAscii;
    }

    private static String checkCompatiblyEscaped30(String str, String test, Report report) {
        String result = "";
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            String unicodeType;
            char c = chars[i];
            if (Character.isISOControl(c)) {
                result = result + "\"" + Character.toString(c) + "\",";
                test = test + Character.toString(c);
            }
            if (c == '\u007f') {
                result = result + "\"" + Character.toString(c) + "\",";
                test = test + Character.toString(c);
            }
            if (!restricted30CharacterSet.contains(unicodeType = Character.UnicodeBlock.of(c).toString())) continue;
            result = result + "\"" + Character.toString(c) + "\",";
        }
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 1);
            report.error(str, 0, 0, Messages.FILENAME_DISALLOWED_CHARACTERS + result);
        }
        return test;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("PRIVATE_USE_AREA");
        set.add("ARABIC_PRESENTATION_FORMS_A");
        set.add("SPECIALS");
        set.add("SUPPLEMENTARY_PRIVATE_USE_AREA_A");
        set.add("SUPPLEMENTARY_PRIVATE_USE_AREA_B");
        set.add("VARIATION_SELECTORS_SUPPLEMENT");
        set.add("TAGS");
        restricted30CharacterSet = set;
    }
}

