/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.EncryptionHandler;
import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.ocf.OCFFilenameChecker;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class OCFChecker {
    private OCFPackage ocf;
    private Report report;
    private EPUBVersion version;
    static XMLValidator containerValidator = new XMLValidator("schema/20/rng/container.rng");
    static XMLValidator encryptionValidator = new XMLValidator("schema/20/rng/encryption.rng");
    static XMLValidator signatureValidator = new XMLValidator("schema/20/rng/signatures.rng");
    static XMLValidator containerValidator30 = new XMLValidator("schema/30/ocf-container-30.rnc");
    static XMLValidator encryptionValidator30 = new XMLValidator("schema/30/ocf-encryption-30.rnc");
    static XMLValidator signatureValidator30 = new XMLValidator("schema/30/ocf-signatures-30.rnc");
    private static HashMap<OPSType, XMLValidator> xmlValidatorMap;

    public OCFChecker(OCFPackage ocf, Report report, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChecks() {
        EPUBVersion validationVersion;
        OCFData containerHandler;
        List<String> opfPaths;
        if (!this.ocf.hasEntry("META-INF/container.xml")) {
            this.report.error(null, 0, 0, "Required META-INF/container.xml resource is missing");
            return;
        }
        long l = this.ocf.getTimeEntry("META-INF/container.xml");
        if (l > 0L) {
            Date d = new Date(l);
            String formattedDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(d);
            this.report.info("META-INF/container.xml", FeatureEnum.CREATION_DATE, formattedDate);
        }
        if ((opfPaths = (containerHandler = this.ocf.getOcfData(this.report)).getEntries("application/oebps-package+xml")) == null || opfPaths.isEmpty()) {
            this.report.error("META-INF/container.xml", -1, -1, "No rootfile with media type 'application/oebps-package+xml'");
            return;
        }
        if (opfPaths.size() > 1) {
            this.report.info(null, FeatureEnum.EPUB_RENDITIONS_COUNT, Integer.toString(opfPaths.size()));
        }
        EPUBVersion detectedVersion = null;
        try {
            OPFData opfData = this.ocf.getOpfData(containerHandler, this.report).get(opfPaths.get(0));
            detectedVersion = opfData.getVersion();
        }
        catch (InvalidVersionException e) {
            this.report.error(opfPaths.get(0), -1, -1, e.getMessage());
            return;
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (this.version == null && detectedVersion == null) {
            this.report.warning(opfPaths.get(0), -1, -1, String.format(Messages.VERSION_NOT_FOUND, new Object[]{EPUBVersion.VERSION_3}));
            validationVersion = EPUBVersion.VERSION_3;
        } else if (this.version != null && this.version != detectedVersion) {
            this.report.warning(opfPaths.get(0), -1, -1, String.format(Messages.VERSION_MISMATCH, new Object[]{this.version, detectedVersion}));
            validationVersion = this.version;
        } else {
            validationVersion = detectedVersion;
        }
        if (validationVersion == EPUBVersion.VERSION_2 && opfPaths.size() > 1) {
            this.report.warning(null, -1, -1, Messages.MULTIPLE_OPS_RENDITIONS);
        }
        InputStream mimetype = null;
        try {
            mimetype = this.ocf.getInputStream("mimetype");
            StringBuilder sb = new StringBuilder(2048);
            if (this.ocf.hasEntry("mimetype") && !CheckUtil.checkTrailingSpaces(mimetype, validationVersion, sb)) {
                this.report.error("mimetype", 0, 0, "Mimetype file should contain only the string \"application/epub+zip\".");
            }
            if (sb.length() != 0) {
                this.report.info(null, FeatureEnum.FORMAT_NAME, sb.toString().trim());
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (mimetype != null) {
                    mimetype.close();
                }
            }
            catch (Exception e) {}
        }
        this.validate(validationVersion);
        LinkedList<OPFHandler> opfHandlers = new LinkedList<OPFHandler>();
        for (String opfPath : opfPaths) {
            if (!this.ocf.hasEntry(opfPath)) {
                this.report.error("META-INF/container.xml", -1, -1, "Entry '" + opfPath + "' not found in the container.");
                continue;
            }
            OPFChecker opfChecker = validationVersion == EPUBVersion.VERSION_2 ? new OPFChecker(this.ocf, this.report, opfPath, validationVersion) : new OPFChecker30(this.ocf, this.report, opfPath, validationVersion);
            opfChecker.runChecks();
            opfHandlers.add(opfChecker.getOPFHandler());
        }
        try {
            for (String entry : this.ocf.getFileEntries()) {
                if (!(entry.startsWith("META-INF/") || entry.startsWith("META-INF\\") || entry.equals("mimetype") || containerHandler.getEntries().contains(entry))) {
                    boolean isDeclared = false;
                    for (OPFHandler opfHandler : opfHandlers) {
                        if (opfHandler.getItemByPath(entry) == null) continue;
                        isDeclared = true;
                        break;
                    }
                    if (!isDeclared) {
                        this.report.warning(null, -1, -1, "item (" + entry + ") exists in the zip file, but is not declared in the OPF file");
                    }
                }
                OCFFilenameChecker.checkCompatiblyEscaped(entry, this.report, validationVersion);
            }
            for (String directory : this.ocf.getDirectoryEntries()) {
                boolean hasContents = false;
                for (String file : this.ocf.getFileEntries()) {
                    if (!file.startsWith(directory)) continue;
                    hasContents = true;
                    break;
                }
                if (hasContents) continue;
                this.report.warning(null, -1, -1, "zip file contains empty directory " + directory);
            }
        }
        catch (IOException e) {
            this.report.error(null, -1, -1, "Unable to read zip file entries.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(EPUBVersion version) {
        block18: {
            XMLParser parser = null;
            InputStream in = null;
            try {
                in = this.ocf.getInputStream("META-INF/container.xml");
                parser = new XMLParser(in, "META-INF/container.xml", "xml", this.report, version);
                XMLHandler handler = new OCFHandler(parser);
                parser.addXMLHandler(handler);
                parser.addValidator(xmlValidatorMap.get(new OPSType("META-INF/container.xml", version)));
                parser.process();
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.ocf.hasEntry("META-INF/encryption.xml")) {
                    in = this.ocf.getInputStream("META-INF/encryption.xml");
                    parser = new XMLParser(in, "META-INF/encryption.xml", "xml", this.report, version);
                    handler = new EncryptionHandler(this.ocf, parser);
                    parser.addXMLHandler(handler);
                    parser.addValidator(xmlValidatorMap.get(new OPSType("META-INF/encryption.xml", version)));
                    parser.process();
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.report.info(null, FeatureEnum.HAS_ENCRYPTION, "META-INF/encryption.xml");
                }
                if (!this.ocf.hasEntry("META-INF/signatures.xml")) break block18;
                in = this.ocf.getInputStream("META-INF/signatures.xml");
                parser = new XMLParser(in, "META-INF/signatures.xml", "xml", this.report, version);
                handler = new OCFHandler(parser);
                parser.addXMLHandler(handler);
                parser.addValidator(xmlValidatorMap.get(new OPSType("META-INF/signatures.xml", version)));
                parser.process();
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.report.info(null, FeatureEnum.HAS_SIGNATURES, "META-INF/signatures.xml");
            }
            catch (Exception ignore) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public String processRootPath(String rootPath) {
        String rootBase = rootPath;
        if (rootPath.endsWith(".opf")) {
            int slash = rootPath.lastIndexOf("/");
            if (slash < rootPath.lastIndexOf("\\")) {
                slash = rootPath.lastIndexOf("\\");
            }
            rootBase = slash >= 0 && slash + 1 < rootPath.length() ? rootPath.substring(0, slash + 1) : rootPath;
            return rootBase;
        }
        this.report.error(null, 0, 0, "RootPath is not an OPF file");
        return null;
    }

    static {
        HashMap<OPSType, XMLValidator> map = new HashMap<OPSType, XMLValidator>();
        map.put(new OPSType("META-INF/container.xml", EPUBVersion.VERSION_2), containerValidator);
        map.put(new OPSType("META-INF/container.xml", EPUBVersion.VERSION_3), containerValidator30);
        map.put(new OPSType("META-INF/encryption.xml", EPUBVersion.VERSION_2), encryptionValidator);
        map.put(new OPSType("META-INF/encryption.xml", EPUBVersion.VERSION_3), encryptionValidator30);
        map.put(new OPSType("META-INF/signatures.xml", EPUBVersion.VERSION_2), signatureValidator);
        map.put(new OPSType("META-INF/signatures.xml", EPUBVersion.VERSION_3), signatureValidator30);
        xmlValidatorMap = map;
    }
}

