/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFChecker;
import com.adobe.epubcheck.ocf.OCFZipPackage;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.util.WriterReportImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.zip.ZipFile;

public class EpubCheck
implements DocumentValidator {
    private static String VERSION = null;
    private File epubFile;
    private Report report;
    private EPUBVersion version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String version() {
        if (VERSION == null) {
            Properties prop = new Properties();
            InputStream in = EpubCheck.class.getResourceAsStream("project.properties");
            try {
                prop.load(in);
            }
            catch (Exception e) {
                System.out.println("Couldn't read project properties");
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            VERSION = prop.getProperty("version");
        }
        return VERSION;
    }

    public EpubCheck(File epubFile) {
        this(epubFile, new DefaultReportImpl(epubFile.getName()));
    }

    public EpubCheck(File epubFile, PrintWriter out) {
        this(epubFile, new WriterReportImpl(out));
    }

    public EpubCheck(File epubFile, Report report) {
        this(epubFile, report, null);
    }

    public EpubCheck(File epubFile, Report report, EPUBVersion version) {
        this.epubFile = epubFile;
        this.report = report;
        this.version = version;
    }

    public EpubCheck(InputStream inputStream, Report report, String uri) {
        this(inputStream, report, uri, null);
    }

    public EpubCheck(InputStream inputStream, Report report, String uri, EPUBVersion version) {
        OutputStream out = null;
        try {
            int read;
            File epubFile = File.createTempFile("epub." + ResourceUtil.getExtension(uri), null);
            epubFile.deleteOnExit();
            out = new FileOutputStream(epubFile);
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            this.epubFile = epubFile;
            this.report = report;
            this.version = version;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
                out.flush();
                out.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        ZipFile zip = null;
        FileInputStream epubIn = null;
        try {
            byte[] header;
            int readCount;
            String extension = ResourceUtil.getExtension(this.epubFile.getName());
            if (extension != null && !extension.equals("epub")) {
                if (extension.matches("[Ee][Pp][Uu][Bb]")) {
                    this.report.warning(this.epubFile.getName(), -1, -1, "Use only lowercase characters for the EPUB file extension for maximum compatibility");
                } else {
                    this.report.warning(this.epubFile.getName(), -1, -1, "Uncommon EPUB file extension'" + extension + "'. For maximum compatibility, use '.epub'");
                }
            }
            if ((readCount = (epubIn = new FileInputStream(this.epubFile)).read(header = new byte[58])) != -1) {
                int read;
                while (readCount < header.length && (read = epubIn.read(header, readCount, header.length - readCount)) != -1) {
                    readCount += read;
                }
            }
            if (readCount != header.length) {
                this.report.error(null, 0, 0, Messages.CANNOT_READ_HEADER);
            } else {
                int fnsize = this.getIntFromBytes(header, 26);
                int extsize = this.getIntFromBytes(header, 28);
                if (header[0] != 80 && header[1] != 75) {
                    this.report.error(null, 0, 0, Messages.CORRUPTED_ZIP_HEADER);
                } else if (fnsize != 8) {
                    this.report.error(null, 0, 0, String.format(Messages.LENGTH_FIRST_FILENAME, fnsize));
                } else if (extsize != 0) {
                    this.report.error(null, 0, 0, String.format(Messages.EXTRA_FIELD_LENGTH, extsize));
                } else if (!CheckUtil.checkString(header, 30, "mimetype")) {
                    this.report.error(null, 0, 0, Messages.MIMETYPE_ENTRY_MISSING);
                } else if (!CheckUtil.checkString(header, 38, "application/epub+zip")) {
                    this.report.error(null, 0, 0, String.format(Messages.MIMETYPE_WRONG_TYPE, "application/epub+zip"));
                }
            }
            zip = new ZipFile(this.epubFile);
            OCFZipPackage ocf = new OCFZipPackage(zip);
            OCFChecker checker = new OCFChecker(ocf, this.report, this.version);
            checker.runChecks();
        }
        catch (IOException e) {
            this.report.error(null, 0, 0, String.format(Messages.IO_ERROR, e.getMessage()));
        }
        finally {
            try {
                epubIn.close();
                zip.close();
            }
            catch (Exception exception) {}
        }
        return this.report.getWarningCount() == 0 && this.report.getErrorCount() == 0;
    }

    private int getIntFromBytes(byte[] bytes, int offset) {
        int hi = 0xFF & bytes[offset + 1];
        int lo = 0xFF & bytes[offset + 0];
        return hi << 8 | lo;
    }
}

