/*
 * Decompiled with CFR 0.152.
 */
package ixtab.jailbreak.backend.commands;

import ixtab.jailbreak.backend.commands.CommandFactory;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

public abstract class JailBreakCommand {
    public static final String KEY_REQUESTTYPE = "command";

    public static Map execute(Object input) {
        final Map request = JailBreakCommand.verifyMap(input);
        String type = JailBreakCommand.verifyType(request);
        JailBreakCommand runner = CommandFactory.find(type);
        try {
            final HashMap response = new HashMap();
            if (runner.needsPrivileges()) {
                return (Map)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return JailBreakCommand.this.doRun(request, response);
                    }
                });
            }
            return runner.run(request, response);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static Map verifyMap(Object input) {
        if (input == null) {
            throw new RuntimeException("NULL request");
        }
        if (!(input instanceof Map)) {
            throw new RuntimeException("request must be a java.util.Map");
        }
        return (Map)input;
    }

    private static String verifyType(Map request) {
        Object type = request.get(KEY_REQUESTTYPE);
        if (type == null || !(type instanceof String)) {
            throw new RuntimeException("NULL or non-String request type");
        }
        return (String)type;
    }

    protected abstract Map run(Map var1, Map var2) throws Throwable;

    private final Map doRun(Map request, Map response) {
        try {
            return this.run(request, response);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean needsPrivileges();
}

