# Evolane add ons:
#  - Get rid of regular expressions. Really not useful.

package require Tk

namespace eval calc {
}

# Append to window path
proc ::calc::wjoin {w child} {
  if {![string compare $w "."]} {
    set result ""
  } else {
    set result $w
  }
  append result "." [string trimleft $child "."]

  return $result
}

# -----------------------------------------------------------------------------
#  DoAppend
# -----------------------------------------------------------------------------
proc ::calc::DoAppend {what} {
  variable state
  
  if {$state(started) == 0} {
    set state(ent)     "0."
    set state(started) 1
  }

  if {$state(op) eq ""} {
    set state(result) "0."
  }

  # if {[string length $state(ent)] > 12} return
  if {$what eq "0" && $state(ent) eq "0."} {
    # Pressed "0" from initial state "0."
    if {$state(dot) == 1} {
      set state(ent) "0.0"
    }
  } else {    
    if {$state(dot) == 1} {
      set state(ent) [format "%s%s" $state(ent) $what]
    } else {
      # regexp {([-0-9]+).} $state(ent) foo integer
      set p [string first "." $state(ent)]
      set integer [string range $state(ent) 0 [expr {$p-1}]]

      if {$integer eq "0"} {
	set state(ent) [format "%s." $what]
      } else {
	set state(ent) [format "%s%s." $integer $what]
      }
    }
  }

  return
}

# -----------------------------------------------------------------------------
#  DoClear
# -----------------------------------------------------------------------------
proc ::calc::DoClear {} {
  variable state

  # Clear current entry
  set state(ent) 0.
  set state(dot) 0

  if {$state(started) == 0} {
    # Pressed twice. Clear register too.
    set state(result)  0.
    set state(fresult) [expr {0.0}]
    set state(op) ""
  }

  set state(started) 0
  return
}

# -----------------------------------------------------------------------------
#  DoDot
# -----------------------------------------------------------------------------
proc ::calc::DoDot {} {
  variable state
  set state(dot) 1
  return
}

# -----------------------------------------------------------------------------
#  DoEqual
# -----------------------------------------------------------------------------
proc ::calc::DoEqual {} {
  variable state
  if {$state(op) != ""} {
    set state(result) \
	[eval expr "$state(result) $state(op) $state(ent)"]
  } else {
    set state(result) $state(ent)
  }

  # Format result
  set result $state(result)
  set ent [format %.12f $result]

  set p [string first "." $ent]
  if {$p<0} {
    set int $ent
    set frac ""
  } else {    
    set int  [string range $ent 0 [expr {$p-1}]]
    set frac [string range $ent [expr {$p+1}] end]
  }
  if {[string index $int 0] eq "-"} {
    set sign "-"
    set int [string range $int 1 end]
  } else {
    set sign ""
  }

  set int  [string trimleft  $int "0"]
  if {[string length $int]==0} {
    set int "0"
  }
  if {[string length $int]>12} {
    # Result is larger than 1e12. Display it in scientific notation.
    set ent [format %12g $result]
  } else {
    set ent "${sign}${int}."

    # Number of digits available for fractional part
    set fraclen [expr {12-2-[string length $ent]}]
    if {$fraclen>0} {
      set fractrunc [string trimright [string range $frac 0 $fraclen] "0"]
      if {[string length $fractrunc]>0} {
	append ent $fractrunc
      }
    }
  }

  set state(ent) $ent
  set state(started) 0
  set state(op) ""
  set state(dot) 0
  return
}

# -----------------------------------------------------------------------------
#  DoFunc
# -----------------------------------------------------------------------------
proc ::calc::DoFunc {func} {
  variable state
  set L "("
  set R ")"
  set state(ent) [eval expr "$func$L$state(ent)$R"]
  DoEqual
  return
}

# -----------------------------------------------------------------------------
#  DoPercent
# -----------------------------------------------------------------------------
proc ::calc::DoPercent {} {
  variable state
  set state(ent) [expr $state(ent)/100.]
  DoEqual
  return
}

# -----------------------------------------------------------------------------
#  DoOpe
# -----------------------------------------------------------------------------
proc ::calc::DoOpe {what} {
  variable state
  if {$state(op) != ""} {
    DoEqual
  }
  set state(op) $what
  set state(result) $state(ent)
  set state(started) 0
  set state(dot) 0
  return
}

# -----------------------------------------------------------------------------
#  DoSign
# -----------------------------------------------------------------------------
proc ::calc::DoSign {} {
  variable state
  set sign [string index $state(ent) 0]
  if {$sign eq "-"} {
    set state(ent) [string range $state(ent) 1 end]
  } else {
    set state(ent) "-$state(ent)"
  }
  # set state(started) 0
  return
}

# -----------------------------------------------------------------------------
# Handle keypress events
# -----------------------------------------------------------------------------
proc ::calc::KeyPressed {top key} {
  switch -exact -- $key {
    0 -
    1 -
    2 -
    3 -
    4 -
    5 -
    6 -
    7 -
    8 -
    9 {
      DoAppend $key
    }
    KP_0 -
    KP_1 -
    KP_2 -
    KP_3 -
    KP_4 -
    KP_5 -
    KP_6 -
    KP_7 -
    KP_8 -
    KP_9 {
      DoAppend [string index $key 3]
    }
    KP_Add -
    plus -
    + {
      DoOpe +
    }
    KP_Subtract -
    minus -
    - {
      DoOpe -
    }
    KP_Multiply -
    asterisk -
    * {
      DoOpe *
    }
    KP_Divide -
    slash - 
    / {
      DoOpe /
    }
    = -
    equal -
    Return -
    Enter -
    KP_Enter {
      DoEqual
    }
    Delete -
    Escape {
      DoClear
    }
    period -
    KP_Decimal -
    . {
      DoDot
    }
    Tab {
      DoSign
    }
  }
}

proc ::calc::Quit {top} {
  catch {destroy $top}
}

# -----------------------------------------------------------------------------
#  Main
# -----------------------------------------------------------------------------
proc ::calc::GuessFontSize {maxwidth maxheight} {
  if {$maxheight<$maxwidth} {
    set maxsize $maxheight
  } else {
    set maxsize $maxwidth
  }

  if {$maxsize<0} {
    set maxsize 4
  }

  if {0} {
    set fsize 1
    while {1} {
      set ftry [expr {$fsize+1}]
      set fontname "$family $ftry"
      
      set ascent [font metrics $fontname -displayof $toplevel -ascent]
      set descent [font metrics $fontname -displayof $toplevel -descent]
      if {$ascent+$descent>=$maxsize} {
	# Too large
	break
      }
      
      set fsize $ftry
    }
  } else {
    set fsize [expr {($maxsize*7)/10}]
  }


  return $fsize
}

proc ::calc::AutoFont {toplevel w fnt1 fnt2} {
  variable state

  if {$w ne $toplevel} {
    return
  }

  # Widget height
  set width [winfo width $toplevel]
  set height [winfo height $toplevel]

  if {$width==$state(width) && $height==$state(height)} {
    return
  }

  set state(width) $width
  set state(height) $height

  set fsize1 [GuessFontSize [expr {$height/4}] [expr {$width/8}]]
  # set font1 "$family $fsize1 bold"
  font configure $fnt1 -size $fsize1

  set fsize2 [GuessFontSize [expr {$height/8}] [expr {$width/11}]]
  font configure $fnt2 -size $fsize2

  return	      
}

proc ::calc::AddMenu {toplevel} {
  if {[catch {set os [set ::tcl_platform(os)]}]} {
    set os "unknown"
  }

  set addmenu 1
  if {[string match "Windows CE" $os]} {
    set addmenu 1
  }
  if {[llength [info command ::menu]]<=0} {
    set addmenu 0
  }

  set menuargs [list]
  lappend menuargs -tearoff 0

  if {$addmenu} {
    # Force menu theme on PocketPC
    if {[string match "Windows CE" $os]} {
      lappend menuargs -borderwidth 0
      lappend menuargs -background "white"
      lappend menuargs -foreground "black"
      lappend menuargs -activebackground "#000080"
      lappend menuargs -activeforeground "white"
      lappend menuargs -relief flat
    }
    
    # Default menu options on X11 are just ugly...
    if {![string compare "x11" [tk windowingsystem]]} {
      lappend menuargs -borderwidth 1
      lappend menuargs -relief raised
      lappend menuargs -activeborderwidth 1
      lappend menuargs -activeforeground "\#000000"
      lappend menuargs -activebackground "\#e0e0e0"
      # lappend menuargs -font $S(font)
    }
    
    set mb [eval [list menu $toplevel.mb] $menuargs]

    set m [eval [list menu $mb.file] $menuargs]
    
    $m add command -label "Exit" \
	-command [namespace code [list Quit $toplevel]]
    
    $mb add cascade -label "File" \
	-menu $m -underline 0
    
    $toplevel configure -menu $mb
  }

  return
}

proc ::calc::calc {toplevel args} {
  variable state

  # Result of last operation, as displayed on screen
  set state(result)  0.
  # Result of last operation as float
  set state(fresult) [expr {0.0}]
  # Current edition
  set state(ent)     0.
  # Operator
  set state(op)      {}
  set state(dot)     0
  set state(started) 0

  # Geometry of toplevel, saved to not recompute
  # best font size on <Configure> if unmodified
  set state(width)   0
  set state(height)  0

  if {0} {
    set keytop {
      {\uff17 {DoAppend 7} }
      {\uff18 {DoAppend 8} }
      {\uff19 {DoAppend 9} }
      {\u00f7 {DoOpe /}    }
      {\uff23  DoClear     }
      {\uff14 {DoAppend 4} }
      {\uff15 {DoAppend 5} }
      {\uff16 {DoAppend 6} }
      {\u00d7 {DoOpe *}    }
      {\u221a {DoFunc sqrt}}
      {\uff11 {DoAppend 1} }
      {\uff12 {DoAppend 2} }
      {\uff13 {DoAppend 3} }
      {\uff0d {DoOpe -}    }
      {\uff05  DoPercent   }
      {\uff10 {DoAppend 0} }
      {\u00b1  DoSign      }
      {\u30fb  DoDot       }
      {\uff0b {DoOpe +}    }
      {\uff1d  DoEqual     }
    }
  } else {
    set keytop {
      {7 {DoAppend 7}}
      {8 {DoAppend 8} }
      {9 {DoAppend 9} }
      {/ {DoOpe /}    }
      {CE  DoClear     }
      {4 {DoAppend 4} }
      {5 {DoAppend 5} }
      {6 {DoAppend 6} }
      {* {DoOpe *}    }
      {\u221a {DoFunc sqrt}}
      {1 {DoAppend 1} }
      {2 {DoAppend 2} }
      {3 {DoAppend 3} }
      {- {DoOpe -}    }
      {%  DoPercent   }
      {0 {DoAppend 0} }
      {\u00b1  DoSign      }
      {.  DoDot       }
      {+ {DoOpe +}    }
      {=  DoEqual     }
    }
  }
  
  set bodycolor "#0050a0"
  $toplevel configure \
      -bg     $bodycolor \
      -bd     2 \
      -highlightthickness 0 \
      -relief ridge
    
  set f [frame [wjoin $toplevel f] -bd 0 -highlightthickness 0 -bg $bodycolor]
  pack $f -fill both -expand true

  pack propagate $toplevel false
  pack propagate $f false

  if {[catch {set os [set ::tcl_platform(os)]}]} {
    set os "unknown"
  }
  if {[string match "Windows CE" $os]} {
    set family "Tahoma"
  } else {
    set family "Arial"
  }
  set autofont1 [font create -family $family -weight bold]
  set autofont2 [font create -family $family -weight normal]

  set w [label [wjoin $f disp] \
	     -font $autofont1 \
	     -textvariable [namespace current]::state(ent) \
	     -anchor       e \
	     -fg           "#004020" \
	     -bg           "#d0e0d0" \
	     -bd           1 \
	     -relief       ridge \
	     -padx         2 \
	     -pady         2]
  grid $w -row 0 -column 0 -columnspan 5 -sticky "news"

  set w [frame [wjoin $f pad] \
	     -bg     $bodycolor \
	     -width  2 \
	     -height 3 \
	     -bd     3 \
	     -relief raised]
  grid $w -row 1 -column 0 -columnspan 5 -sticky "news"
  
  set fgcolor1 "#0060f0"
  set fgcolor2 "#806000"
  set fgcolor3 "#f03000"

  set bgcolor1 "#90c0ff"
  set bgcolor2 "#ffc0c0"

  set padx 3
  set pady 3

  for {set y 2} {$y < 6} {incr y} {
    for {set x 0} {$x < 5} {incr x} {
      set idx [expr $x + ($y - 2) * 5]
      set key [lindex [lindex $keytop $idx] 0]
      set cmd [lindex [lindex $keytop $idx] 1]
      if {$x < 3} {
	set fgcolor $fgcolor1
	set bgcolor $bgcolor1
      } elseif {($x == 4) && ($y == 2)} {
	set fgcolor $fgcolor3
	set bgcolor $bgcolor2
      } else {
	set fgcolor $fgcolor2
	set bgcolor $bgcolor2
      }

      if {0} {
	set activefgcolor $bgcolor
	set activebgcolor $fgcolor
      } else {
	set activefgcolor $fgcolor
	set activebgcolor $bgcolor
      }

      set w [button [wjoin $f b$idx] \
		 -font                $autofont2 \
		 -text                $key \
		 -foreground          $fgcolor \
		 -background          $bgcolor \
		 -activeforeground    $activefgcolor \
		 -activebackground    $activebgcolor \
		 -borderwidth         1 \
		 -highlightthickness  0 \
		 -padx                $padx \
		 -pady                $pady \
		 -cursor              hand2 \
		 -command [namespace code $cmd]]
      grid $w -row $y -column $x -sticky news
    }
  }
  
  bind $toplevel <KeyPress> [list [namespace code KeyPressed] $toplevel %K]
  bind $toplevel <Configure> [list [namespace code AutoFont] $toplevel %W $autofont1 $autofont2]

  grid rowconfigure $f {0} -weight 3 -uniform 1
  grid rowconfigure $f {1} -weight 1 -uniform 1
  grid rowconfigure $f {2 3 4 5} -weight 2 -uniform 1

  grid columnconfigure $f {0 1 2 3} -weight 2 -uniform 1
  grid columnconfigure $f {4} -weight 2 -uniform 1

  # Add menu
  AddMenu $toplevel

  # adjust geometry dynamically
  if {[llength [info command ::wm]]>0} {
    wm geometry $toplevel 240x320
  }
  if {[llength [info command ::etcl::automanage]]>0} {
    catch {::etcl::automanage $toplevel}
  }

  tkwait window $toplevel
  return
}

::calc::calc .
exit
