#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Example code taken directly from "SBPubX.doc" (installed by the eBook Publisher software).
# Currently "hard-coded" input file assume existence of 'Crsto.htm'. 
# Creates 'MonteCristo.opf' for later use as well as 'MonteCristo.imp' for REB 1200;
# can change the latter to GEB/EBW 1150 or REB 1100 by uncommenting the {BuildTarget} line below.
#
use Win32::OLE;
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

# get the interfaces, complain and quit if we cannot
#
$project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface\n";

$builder = Win32::OLE->new("SBPublisher.Builder") or
	die "Unable to get IBuilder interface\n";

# Create a new project and add our document file.
#
$project->ClearAll();
$project->AddSourceFile("Crsto.htm");

# Set the various "metadata" items for the publication
#
$project->{AuthorFirstName} = "Alexandre Dumas";
$project->{AuthorFileAs} = "Dumas, Alexandre";
$project->{BookTitle} = "Count of Monte Cristo";
$project->{ISBN} = $project->CanonicalizeISBN("0448163004 ");
$project->{BISAC} = "FIC004000";
$project->{Category} = "Classics";

# Now build the OEBFF output
#
$project->{BookFileName} = "MonteCristo";
$project->{OutputDirectory} = "";
$project->{Compress}        = 1;   #True
$project->{Encrypt}         = 0;   #False
$project->{KeepAnchors}     = 1;   #True
$project->{Language}        = "en";
$project->{RequireISBN}     = 0;   #False
$project->{Zoom}            = 2;

$project->Save("MonteCristo.opf");

# Now build the REB 1200 (color FullVga) .IMP output
#
$project->{BuildTarget} = 1;

# Now build the REB 1150 (gray HalfVga) .IMP output
#
#$project->{BuildTarget} = 2;

# Now build the REB 1100 (mono HalfVGA) .RB output
#
#$project->{BuildTarget} = 3;

# Now generate the OEBFF or .IMP output
#
$builder->Build($project);
#$builder->GenerateOEBFF($project, 1);
if (Win32::OLE->LastError() != 0) {
	print "ERROR: GenerateOEBFF method failed.\n";
} else {
	print "Done!\n";
}

Win32::OLE->Uninitialize();