

//import javax.swing.UIManager;
import javax.imageio.*; // for ImageIO
import java.io.*; // for File
import java.awt.image.*; // for BufferedImage
//import javax.swing.*; // for JFrame
import java.awt.event.*; //for ActionListener
import java.awt.*; // for FileDialog
import java.lang.Integer;
public class CropDilation{
   static boolean error=false;
	static int width;
	static int height;
	static int[][] src ;
	static int[][] pixel;
	static int FileCnt=0;
	static int top=0,bottom=0,left=0,right=0;
	static double contrast=1.0D;
	static int  brightness=0,DC=0;
	static String InputPrefix,OutputPrefix;
	//static int[][] tmp;
   /**
      CropDilation FileInputPrefix OutputPrefix PicCount [top down [contrast brightness]]
      When document print out with PDFCreate and output with A4, 300DPI, BW JPG file,
      1. the page is to be processed for fitting full screen with DR1000s ,and also
      2. enhence Font contrast by Dilation Image Processing
      3. if not enough contrast can be applied.
      4. batch filename auto counting
   */
	public static void main(String[] args){
	   /* argument process */
      String InName,OutName;
	   if (args.length<=2) error=true;
	   if (!error){
	     FileCnt=Integer.parseInt(args[2]);
	     InputPrefix=args[0];
	     OutputPrefix=args[1];
	   }
	   if (args.length>=5){  // cropping
	       top=Integer.parseInt(args[3]);
	       bottom=3508-Integer.parseInt(args[4]);  //
	       System.out.printf("top=%d, bottom=%d\n",left,right);
	       int w=(int)((double)(3508-top-bottom)* 2479.0/3000.0);
	       if (w>=2479) w=2479;
	       if (w<0) error=true;
	       if (w<2479) {  // need to crop left and right
	       	      // paper to long not cut left/right
	       	      left=(2479-w)/2;
	       	      right=left;
	       System.out.printf("left=%d, right=%d\n",left,right);
	       }
	   }
	   if (args.length>=8){  // Contrast & brightness
	       DC=Integer.parseInt(args[5]);
	       contrast=Double.parseDouble(args[6]);
	       brightness=Integer.parseInt(args[7]);
	       System.out.printf("DC=%d Contrast=%f, Brightness=%d\n",DC,contrast,brightness);
	   }
		if(error){
			// JOptionPane.showMessageDialog(null,"Less Argument\n Please use InPreFix OutPreFix Cnt\n");
			System.out.println("Argument error!");
			System.out.println("CropDilation FileInputPrefix OutputPrefix PicCount [topY downY [contrast brightness]]");
			System.exit(0);
		}
            	src = new int[3508][2479];
   	      //tmp = new int[height][width];
   	      pixel = new int[3508-top-bottom][2479-left-right];
      	   BufferedImage dst=new BufferedImage(2479-left-right,3508-top-bottom,BufferedImage.TYPE_INT_RGB);
	   for (int fidx=1; fidx<=FileCnt;fidx++){
	      // input file name
	      InName= InputPrefix+Integer.toString(fidx)+".jpg";
	      String fmt = String.format("%04d", fidx);
	      OutName=OutputPrefix+fmt+".jpg";
   		File file = new File(InName);
   		if(!file.exists()){
   			System.out.printf("File(%s) does not Exists!\n",InName);
   			System.exit(0);
   		}
   		try {
   			BufferedImage image1 = ImageIO.read(file);
            width = image1.getWidth();
            height = image1.getHeight();
            if (width!=2479&&height!=3508) {
      			System.out.println("File is not A4 size!");
     			   System.exit(0);         	
            }
            // convert to Gray byte              
   			int rgb = 0;
   			for (int y = top; y < height-bottom; y++){
   				for (int x = left; x < width-right; x++) {
   					rgb = image1.getRGB(x, y);
   					rgb = (((rgb>>16)&0xff)+((rgb>>8)&0xff)+(rgb&0xff))/3;
   					rgb &= 0xff;
   					if (args.length>=8) {
   						rgb+=DC;  						
      						rgb*=contrast; // contrast
      						rgb+=brightness; // brightness
      						if (rgb<0) rgb=0;
      						if (rgb>255) rgb=255;
   					}
   					src[y][x]=rgb;  // read lunimance
   				}
   			}
            // Cropping & Dilation
   			for (int y = top; y < height-bottom; y++){
   				for (int x = left; x < width-right; x++) {
   					pixel[y-top][x-left] =  Dilation(x,y);
   				}
   			}
   			File newfile = new File(OutName);
             // convert to Image for saving
  			   for (int y = 0; y < height-top-bottom; y++){
   				for (int x = 0; x < width-left-right; x++) {
   					dst.setRGB(x,y, pixel[y][x]);
   				}
   			}
   			ImageIO.write(dst, "jpg", newfile);
   			System.out.printf("%s,%s, (w,h)=(%d,%d) croping (%d,%d)-(%d,%d)\n",InName,OutName,width,height,top,bottom,left,right);

   		} catch (IOException e) {
   			System.out.printf("IO Error, check disk space or Media not exist!\n");
   		}
	   }


	}
   public static int Dilation(int x,int y) {
 	  int miny=src[y][x];
 	  if (src[y][x]<64) {
 	  	  //        System.out.printf("(%d,%d)=%d\n",x,y,src[y][x]);
 	  	  //        System.out.printf("(%d,%d)=%d\n",x+1,y+1,src[y][x]);
 	  	  //        System.out.printf("(%d,%d)=%d\n",x,y,src[y][x]);
 	  	  //        System.out.printf("(%d,%d)=%d\n",x,y,src[y][x]);
 	  }
 	  if (x-1>=left) miny=(src[y][x-1]<miny)? src[y][x-1]:miny;
 	  if (y-1>=top) miny=(src[y-1][x]<miny)? src[y-1][x]:miny;
 	  if (x+1<width-right) miny=(src[y][x+1]<miny)? src[y][x+1]:miny;
 	  if (y+1<height-bottom) miny=(src[y+1][x]<miny)? src[y+1][x]:miny;
 	  miny&=0xff;
 	  return miny|(miny<<8)|(miny<<16);
 }
}