/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.appletviewer;

import com.acunia.wonka.appletviewer.AppletClassLoader;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class AppletViewer
extends Frame
implements ActionListener,
AppletStub,
AppletContext,
AudioClip {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static Hashtable applets = new Hashtable(17);
    private static String encoding = "8859_1";
    private static int counter = 1;
    private URL codebase;
    private URL documentbase;
    private Class appletClass;
    private Properties parameters;
    private boolean active;
    private String align = null;
    Applet applet;
    int hspace;
    int vspace;
    int appletH = 234;
    int appletW = 400;
    private Label status;
    private Button start;
    private Button stop;
    private Button destroy;
    private Panel buttons;

    private AppletViewer(String location) throws Exception {
        super("AppletViewer");
        this.setupAppletData(location);
        this.start = new Button("start");
        this.start.addActionListener(this);
        this.stop = new Button("stop");
        this.stop.addActionListener(this);
        this.destroy = new Button("destroy");
        this.destroy.addActionListener(this);
        this.buttons = new Panel(new GridLayout(3, 1));
        this.buttons.add(this.start);
        this.buttons.add(this.stop);
        this.buttons.add(this.destroy);
        this.add((Component)this.buttons, "East");
        this.status = new Label(this.applet.getName());
        this.add((Component)this.status, "South");
        this.setTitle("AppletViewer: '" + this.applet.getName() + "'");
        this.add((Component)new WrapperPanel(this), "Center");
        this.setFrameSize();
    }

    public void actionPerformed(ActionEvent event) {
        Object button = event.getSource();
        if (button == this.start) {
            this.active = true;
            this.applet.start();
        } else if (button == this.stop) {
            this.active = false;
            this.applet.stop();
        } else if (button == this.destroy) {
            this.active = false;
            this.applet.stop();
            this.applet.destroy();
            this.dispose();
        }
    }

    public Applet getApplet(String name) {
        return (Applet)applets.get(name);
    }

    public Enumeration getApplets() {
        return applets.elements();
    }

    public AudioClip getAudioClip(URL url) {
        return this;
    }

    public Image getImage(URL url) {
        return toolkit.createImage(url);
    }

    public void showDocument(URL url) {
        System.err.println("showDocument is called " + url);
        throw new UnsupportedOperationException("'showDocument(URL url)' is not supported");
    }

    public void showDocument(URL url, String frame) {
        try {
            this.showDocument(new URL(url, frame));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void showStatus(String msg) {
        System.out.println("showStatus: " + msg);
        this.status.setText(msg);
    }

    public void appletResize(int width, int height) {
        if (width > 0 && height > 0) {
            this.appletW = width;
            this.appletH = height;
            this.setFrameSize();
        }
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public URL getDocumentBase() {
        return this.documentbase;
    }

    public String getParameter(String name) {
        return this.parameters.getProperty(name);
    }

    public boolean isActive() {
        return this.active;
    }

    public void play() {
    }

    public void stop() {
    }

    public void loop() {
    }

    private void readParams(String page) {
        String lowerCasePage = page.toLowerCase();
        this.parameters = new Properties();
        try {
            int i = lowerCasePage.indexOf("param name=");
            while (i != -1) {
                int j = lowerCasePage.indexOf("value=", i += 11);
                String name = this.unquoteString(page.substring(i, j).trim());
                i = lowerCasePage.indexOf(62, j += 6);
                this.parameters.setProperty(name, this.unquoteString(page.substring(j, i).trim()));
                i = lowerCasePage.indexOf("param name=", i);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void setFrameSize() {
        int width = this.appletW + this.buttons.getPreferredSize().width + 2 * this.hspace;
        int height = this.appletH + this.status.getPreferredSize().height + 2 * this.vspace;
        this.setSize(width, height);
    }

    private void setupAppletData(String location) throws Exception {
        try {
            this.documentbase = new URL(location);
        }
        catch (MalformedURLException mue) {
            this.documentbase = new URL(new File("").toURL(), location);
        }
        InputStream in = this.documentbase.openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        int len = in.read(bytes);
        while (len != -1) {
            out.write(bytes, 0, len);
            len = in.read(bytes);
        }
        String content = new String(out.toByteArray(), encoding);
        String base = this.documentbase.getFile();
        int index = base.lastIndexOf(47);
        if (index != -1) {
            base = base.substring(0, index + 1);
        }
        this.documentbase = new URL(this.documentbase.getProtocol(), this.documentbase.getHost(), base);
        index = content.indexOf("<applet");
        int end = -1;
        int close = -1;
        if (index != -1) {
            end = content.indexOf("</applet>", index);
            close = content.indexOf(">", index);
        } else {
            index = content.indexOf("<APPLET");
            if (index != -1) {
                end = content.indexOf("</APPLET>", index);
                close = content.indexOf(">", index);
            } else {
                throw new IllegalArgumentException("no applet specified in html code");
            }
        }
        if (end < close || close == -1 || end == -1) {
            throw new IllegalArgumentException("bad html syntax encountered");
        }
        String code = null;
        String archive = null;
        String cb = null;
        String name = null;
        StringTokenizer st = new StringTokenizer(content.substring(index + 7, close));
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            index = token.indexOf(61);
            if (index == -1) {
                System.err.println("AppletViewer: bad token encountered '" + token + "'");
                continue;
            }
            String option = token.substring(0, index);
            if (option.equalsIgnoreCase("code")) {
                code = this.unquoteString(token.substring(index + 1));
                if (!code.endsWith(".class")) continue;
                code = code.substring(0, code.length() - 6);
                continue;
            }
            if (option.equalsIgnoreCase("archive")) {
                archive = this.unquoteString(token.substring(index + 1));
                while (archive.endsWith(",") && st.hasMoreTokens()) {
                    archive = archive + st.nextToken();
                }
                continue;
            }
            if (option.equalsIgnoreCase("name")) {
                name = this.unquoteString(token.substring(index + 1));
                continue;
            }
            if (option.equalsIgnoreCase("codebase")) {
                cb = this.unquoteString(token.substring(index + 1));
                continue;
            }
            if (option.equalsIgnoreCase("width")) {
                try {
                    int value = Integer.parseInt(this.unquoteString(token.substring(index + 1)));
                    if (value <= 0) continue;
                    this.appletW = value;
                }
                catch (RuntimeException rt) {}
                continue;
            }
            if (option.equalsIgnoreCase("height")) {
                try {
                    int value = Integer.parseInt(this.unquoteString(token.substring(index + 1)));
                    if (value <= 0) continue;
                    this.appletH = value;
                }
                catch (RuntimeException rt) {}
                continue;
            }
            if (option.equalsIgnoreCase("vspace")) {
                try {
                    int value = Integer.parseInt(this.unquoteString(token.substring(index + 1)));
                    if (value <= 0) continue;
                    this.vspace = value;
                }
                catch (RuntimeException rt) {}
                continue;
            }
            if (option.equalsIgnoreCase("hspace")) {
                try {
                    int value = Integer.parseInt(this.unquoteString(token.substring(index + 1)));
                    if (value <= 0) continue;
                    this.hspace = value;
                }
                catch (RuntimeException rt) {}
                continue;
            }
            if (!option.equalsIgnoreCase("align")) continue;
            this.align = this.unquoteString(token.substring(index + 1));
        }
        this.readParams(content.substring(close, end));
        this.codebase = cb != null ? new URL(this.documentbase, cb) : this.documentbase;
        AppletClassLoader loader = AppletClassLoader.createAppletClassLoader(this.codebase, this.documentbase, archive);
        this.appletClass = Class.forName(code, true, loader);
        this.applet = (Applet)this.appletClass.newInstance();
        this.applet.setVisible(false);
        this.applet.setStub(this);
        if (name == null) {
            name = "applet nr " + counter + " of type " + this.appletClass;
            ++counter;
        }
        this.applet.setName(name);
        applets.put(this.applet.getName(), this.applet);
    }

    private String unquoteString(String quoted) {
        if (quoted.startsWith("\"")) {
            quoted = quoted.substring(1);
        }
        if (quoted.endsWith("\"")) {
            quoted = quoted.substring(0, quoted.length() - 1);
        }
        return quoted;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                AppletViewer view = new AppletViewer(args[i]);
                view.applet.init();
                view.applet.setVisible(true);
                view.active = true;
                view.applet.start();
                view.setVisible(true);
                view.validate();
                continue;
            }
            catch (Exception e) {
                System.err.println("failed to load '" + args[i] + "' due to " + e);
                e.printStackTrace();
            }
        }
    }

    protected static class WrapperPanel
    extends Panel {
        private AppletViewer view;

        WrapperPanel(AppletViewer view) {
            super(null);
            this.setBackground(Color.white);
            this.view = view;
            this.add(view.applet);
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.view.applet.setBounds(this.view.hspace, this.view.vspace, this.view.appletW, this.view.appletH);
        }
    }
}

