/*
 * Decompiled with CFR 0.152.
 */
package wonka.vm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import wonka.vm.Etc;

public final class SystemClassLoader
extends ClassLoader {
    private static Object[] bootclasspath;
    private static SystemClassLoader theSystemClassLoader;
    private static ProtectionDomain systemProtectionDomain;

    private static native void setSystemClassLoader(SystemClassLoader var0);

    public static synchronized SystemClassLoader getInstance() {
        if (theSystemClassLoader == null) {
            theSystemClassLoader = new SystemClassLoader();
            SystemClassLoader.setSystemClassLoader(theSystemClassLoader);
        }
        return theSystemClassLoader;
    }

    private SystemClassLoader() {
        super(null);
        Vector v = new Vector();
        String bcp = SystemClassLoader.getBootclasspath();
        while (true) {
            int colon;
            String s;
            String string = s = (colon = bcp.indexOf(58)) < 0 ? bcp : bcp.substring(0, colon);
            if (s.endsWith("/")) {
                v.addElement(new File(s));
            } else {
                try {
                    v.addElement(new JarFile(s));
                }
                catch (IOException ioe) {
                    Etc.woempa(9, "BLARB SystemClassLoader/<init>: " + ioe);
                }
            }
            if (colon < 0) break;
            bcp = bcp.substring(colon + 1);
        }
        bootclasspath = new Object[v.size()];
        Enumeration e = v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            SystemClassLoader.bootclasspath[i] = e.nextElement();
            Etc.woempa(9, "SystemClassLoader/<init>: bootclasspath[" + i + "]: " + bootclasspath[i]);
            ++i;
        }
    }

    protected Class findClass(String dotname) throws ClassNotFoundException {
        Etc.woempa(7, "System Class Loader: findClass(" + dotname + ")");
        String filename = dotname.replace('.', '/') + ".class";
        byte[] bytes = null;
        int length = 0;
        InputStream in = null;
        for (int i = 0; i < bootclasspath.length; ++i) {
            try {
                JarFile jf = (JarFile)bootclasspath[i];
                try {
                    JarEntry je = jf.getJarEntry(filename);
                    if (je == null) continue;
                    length = (int)je.getSize();
                    in = jf.getInputStream(je);
                    break;
                }
                catch (IOException e) {
                    length = 0;
                    e.printStackTrace();
                    continue;
                }
            }
            catch (ClassCastException cce) {
                File f = new File(bootclasspath[i] + filename);
                if (!f.isFile()) continue;
                try {
                    length = (int)f.length();
                    in = new FileInputStream(f);
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
            }
        }
        if (length > 0) {
            try {
                String packagename;
                bytes = new byte[length];
                length = in.read(bytes);
                int j = filename.lastIndexOf(47);
                if (j > 0 && this.getPackage(packagename = dotname.substring(0, j)) == null) {
                    this.definePackage(packagename, "", "", "", "", "", "", null);
                }
                return this.defineClass(dotname, bytes, 0, length, systemProtectionDomain);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("SystemClassLoader couldn't find " + dotname);
    }

    private URL tryResource(String name, Object bcpelem) {
        URL url;
        block7: {
            url = null;
            try {
                JarFile jf = (JarFile)bcpelem;
                JarEntry je = jf.getJarEntry(name);
                if (je != null) {
                    try {
                        url = new URL("jar:" + jf + "!/" + name);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ClassCastException cce) {
                File f = new File(bcpelem + name);
                if (!f.isFile()) break block7;
                try {
                    url = new URL("file:" + f);
                }
                catch (MalformedURLException e) {
                    Etc.woempa(10, "SystemClassLoader: exception = " + e + ", file = " + f);
                }
            }
        }
        return url;
    }

    protected URL findResource(String name) {
        URL url = null;
        for (int i = 0; i < bootclasspath.length && (url = this.tryResource(name, bootclasspath[i])) == null; ++i) {
        }
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        for (int i = 0; i < bootclasspath.length; ++i) {
            try {
                JarFile jf = (JarFile)bootclasspath[i];
                try {
                    JarEntry je = jf.getJarEntry(name);
                    if (je == null) continue;
                    return jf.getInputStream(je);
                }
                catch (IOException e) {}
                continue;
            }
            catch (ClassCastException cce) {
                File f = new File(bootclasspath[i] + name);
                if (!f.isFile()) continue;
                try {
                    return new FileInputStream(f);
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        URL url = null;
        Vector v = new Vector();
        for (int i = 0; i < bootclasspath.length; ++i) {
            url = this.tryResource(name, bootclasspath[i]);
            if (url == null) continue;
            v.addElement(url);
        }
        return v.elements();
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class loaded = this.findLoadedClass(name);
        if (loaded == null) {
            loaded = this.findClass(name);
        }
        if (resolve) {
            try {
                this.resolveClass(loaded);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return loaded;
    }

    public String toString() {
        return "System Class Loader";
    }

    private static native String getBootclasspath();

    private void defineStandardPackages() {
        this.definePackage("com.acunia.device", "", "", "", "", "", "", null);
        this.definePackage("com.acunia.device.uart", "", "", "", "", "", "", null);
        this.definePackage("com.acunia.device.serial", "", "", "", "", "", "", null);
        this.definePackage("com.acunia.resource", "", "", "", "", "", "", null);
        this.definePackage("com.acunia.wonka.security", "", "", "", "", "", "", null);
        this.definePackage("java.lang", "", "", "", "", "", "", null);
        this.definePackage("java.lang.ref", "", "", "", "", "", "", null);
        this.definePackage("java.lang.reflect", "", "", "", "", "", "", null);
        this.definePackage("java.io", "", "", "", "", "", "", null);
        this.definePackage("java.util", "", "", "", "", "", "", null);
        this.definePackage("java.net", "", "", "", "", "", "", null);
        this.definePackage("java.awt.event", "", "", "", "", "", "", null);
        this.definePackage("java.awt", "", "", "", "", "", "", null);
        this.definePackage("java.security", "", "", "", "", "", "", null);
        this.definePackage("java.security.cert", "", "", "", "", "", "", null);
        this.definePackage("java.math", "", "", "", "", "", "", null);
        this.definePackage("java.text", "", "", "", "", "", "", null);
        this.definePackage("java.rmi", "", "", "", "", "", "", null);
        this.definePackage("javax.comm", "", "", "", "", "", "", null);
        this.definePackage("wonka.vm", "", "", "", "", "", "", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        SystemClassLoader systemClassLoader = this;
        synchronized (systemClassLoader) {
            if (this.packages.size() == 0) {
                this.defineStandardPackages();
            }
        }
        Enumeration ownpackages = this.packages.keys();
        Package[] package_array = new Package[this.packages.size()];
        int i = 0;
        while (ownpackages.hasMoreElements()) {
            package_array[i++] = (Package)ownpackages.nextElement();
        }
        return package_array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String pkgname) {
        SystemClassLoader systemClassLoader = this;
        synchronized (systemClassLoader) {
            if (this.packages.size() == 0) {
                this.defineStandardPackages();
            }
        }
        return (Package)this.packages.get(pkgname);
    }
}

