/*
 * Decompiled with CFR 0.152.
 */
package wonka.decoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import wonka.decoders.Decoder;

public class UTF8Decoder
extends Decoder {
    private int available;
    private byte[] buf;
    private int pos;

    public static native byte[] stringToB(String var0);

    public static native String bToString(byte[] var0, int var1, int var2);

    public int getChar(InputStream in) throws IOException {
        int c = this.readIn(in);
        if (c < 128) {
            return c;
        }
        if (c >= 224) {
            int utf8_top_4 = c & 0xF;
            c = this.readIn(in);
            if (c < 0) {
                return -1;
            }
            if (c >= 192 || c < 128) {
                throw new UTFDataFormatException("bad second of triple: " + c);
            }
            int utf8_middle_6 = c & 0x3F;
            c = this.readIn(in);
            if (c < 0) {
                return -1;
            }
            if (c >= 192 || c < 128) {
                throw new UTFDataFormatException("bad third of triple: " + c);
            }
            int utf8_bottom_6 = c & 0x3F;
            return (utf8_top_4 << 6 | utf8_middle_6) << 6 | utf8_bottom_6;
        }
        if (c >= 192) {
            int utf8_middle_6 = c & 0x3F;
            c = this.readIn(in);
            if (c < 0) {
                return -1;
            }
            if (c >= 192 || c < 128) {
                throw new UTFDataFormatException("bad second of duple: " + c);
            }
            int utf8_bottom_6 = c & 0x3F;
            c = utf8_middle_6 << 6 | utf8_bottom_6;
        }
        throw new UTFDataFormatException("bad start of sequence: " + c);
    }

    public native byte[] cToB(char[] var1, int var2, int var3);

    public native char[] bToC(byte[] var1, int var2, int var3);

    public int cFromStream(InputStream in, char[] chars, int off, int len) throws IOException {
        byte[] oldbuf = this.buf;
        int avail = this.available;
        byte[] buffer = oldbuf;
        if (len < 1) {
            if (len == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len * 3 > avail) {
            int readlen;
            buffer = new byte[len * 3];
            if (avail > 0) {
                System.arraycopy(oldbuf, this.pos, buffer, 0, avail);
            }
            if ((readlen = in.read(buffer, avail, len * 3 - avail)) > 0) {
                avail += readlen;
            }
        }
        int nread = 0;
        int used = 0;
        while (nread < len) {
            int c;
            if (used >= avail) break;
            if ((c = buffer[used++] & 0xFF) >= 128) {
                if (c >= 224) {
                    int utf8_top_4 = c & 0xF;
                    if (used >= avail) {
                        --used;
                        break;
                    }
                    if ((c = buffer[used++] & 0xFF) >= 192 || c < 128) {
                        throw new UTFDataFormatException("bad second of triple: " + c);
                    }
                    int utf8_middle_6 = c & 0x3F;
                    if (used >= avail) {
                        used -= 2;
                        break;
                    }
                    if ((c = buffer[used++] & 0xFF) >= 192 || c < 128) {
                        throw new UTFDataFormatException("bad third of triple: " + c);
                    }
                    int utf8_bottom_6 = c & 0x3F;
                    c = (utf8_top_4 << 6 | utf8_middle_6) << 6 | utf8_bottom_6;
                } else if (c >= 192) {
                    int utf8_middle_6 = c & 0x3F;
                    if (used >= avail) {
                        --used;
                        break;
                    }
                    if ((c = buffer[used++] & 0xFF) >= 192 || c < 128) {
                        throw new UTFDataFormatException("bad second of duple: " + c);
                    }
                    int utf8_bottom_6 = c & 0x3F;
                    c = utf8_middle_6 << 6 | utf8_bottom_6;
                } else {
                    throw new UTFDataFormatException("bad start of sequence: " + c);
                }
            }
            chars[off++] = (char)c;
            ++nread;
        }
        this.buf = buffer;
        this.pos = used;
        this.available = avail - used;
        if (nread == 0) {
            return -1;
        }
        return nread;
    }

    public String getEncoding() {
        return "UTF8";
    }

    protected Decoder getInstance() {
        return new UTF8Decoder();
    }

    private final int readIn(InputStream in) throws IOException {
        if (this.available > 0) {
            --this.available;
            return this.buf[this.pos++] & 0xFF;
        }
        return in.read();
    }
}

